/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.cv;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.basicdataset.cv.ImageDataset;
import ai.djl.basicdataset.cv.ObjectDetectionDataset;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.Point;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.Resource;
import ai.djl.training.dataset.Dataset;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.TranslateException;
import ai.djl.util.JsonUtils;
import ai.djl.util.PairList;
import ai.djl.util.Progress;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BananaDetection
extends ObjectDetectionDataset {
    private static final String VERSION = "1.0";
    private static final String ARTIFACT_ID = "banana";
    private final Dataset.Usage usage;
    private final List<Path> imagePaths;
    private final PairList<Long, Rectangle> labels;
    private final Resource resource;
    private boolean prepared;

    public BananaDetection(Builder builder) {
        super(builder);
        this.usage = builder.usage;
        this.imagePaths = new ArrayList<Path>();
        this.labels = new PairList();
        MRL mrl = MRL.dataset((Application)Application.CV.ANY, (String)builder.groupId, (String)builder.artifactId);
        this.resource = new Resource(builder.repository, mrl, VERSION);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PairList<Long, Rectangle> getObjects(long index) {
        return new PairList(Collections.singletonList(this.labels.get((int)index)));
    }

    protected long availableSize() {
        return this.imagePaths.size();
    }

    public void prepare(Progress progress) throws IOException, TranslateException {
        Path usagePath;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.resource.getDefaultArtifact();
        this.resource.prepare(artifact, progress);
        Path root = this.resource.getRepository().getResourceDirectory(artifact);
        switch (this.usage) {
            case TRAIN: {
                usagePath = Paths.get("train", new String[0]);
                break;
            }
            case TEST: {
                usagePath = Paths.get("test", new String[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        usagePath = root.resolve(usagePath);
        Path indexFile = usagePath.resolve("index.file");
        try (BufferedReader reader = Files.newBufferedReader(indexFile);){
            Type mapType = new TypeToken<Map<String, List<Float>>>(){}.getType();
            Map metadata = (Map)JsonUtils.GSON.fromJson((Reader)reader, mapType);
            for (Map.Entry entry : metadata.entrySet()) {
                String imgName = (String)entry.getKey();
                this.imagePaths.add(usagePath.resolve(imgName));
                List label = (List)entry.getValue();
                long objectClass = ((Float)label.get(0)).longValue();
                Rectangle objectLocation = new Rectangle(new Point((double)((Float)label.get(1)).floatValue(), (double)((Float)label.get(2)).floatValue()), (double)((Float)label.get(3)).floatValue(), (double)((Float)label.get(4)).floatValue());
                this.labels.add((Object)objectClass, (Object)objectLocation);
            }
        }
        this.prepared = true;
    }

    @Override
    protected Image getImage(long index) throws IOException {
        int idx = Math.toIntExact(index);
        return ImageFactory.getInstance().fromFile(this.imagePaths.get(idx));
    }

    @Override
    public Optional<Integer> getImageWidth() {
        return Optional.of(256);
    }

    @Override
    public Optional<Integer> getImageHeight() {
        return Optional.of(256);
    }

    public static final class Builder
    extends ImageDataset.BaseBuilder<Builder> {
        Repository repository = BasicDatasets.REPOSITORY;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "banana";
        Dataset.Usage usage = Dataset.Usage.TRAIN;

        Builder() {
        }

        public Builder self() {
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this.self();
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this.self();
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public BananaDetection build() {
            if (this.pipeline == null) {
                this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
            }
            return new BananaDetection(this);
        }
    }
}

