/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.metric;

import ai.djl.metric.Metric;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Metrics {
    private static final MetricValueComparator VALUE_COMPARATOR = new MetricValueComparator();
    private Map<String, List<Metric>> metrics = new ConcurrentHashMap<String, List<Metric>>();

    public void addMetric(Metric metric) {
        List list = this.metrics.computeIfAbsent(metric.getMetricName(), v -> Collections.synchronizedList(new ArrayList()));
        list.add(metric);
    }

    public void addMetric(String name, Number value) {
        this.addMetric(new Metric(name, value));
    }

    public void addMetric(String name, Number value, String unit) {
        this.addMetric(new Metric(name, value, unit));
    }

    public boolean hasMetric(String name) {
        return this.metrics.containsKey(name);
    }

    public List<Metric> getMetric(String name) {
        List<Metric> list = this.metrics.get(name);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public Set<String> getMetricNames() {
        return this.metrics.keySet();
    }

    public Metric latestMetric(String name) {
        List<Metric> list = this.metrics.get(name);
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Could not find metric: " + name);
        }
        return list.get(list.size() - 1);
    }

    public Metric percentile(String metricName, int percentile) {
        List<Metric> metric = this.metrics.get(metricName);
        if (metric == null || this.metrics.isEmpty()) {
            throw new IllegalArgumentException("Metric name not found: " + metricName);
        }
        ArrayList<Metric> list = new ArrayList<Metric>(metric);
        list.sort(VALUE_COMPARATOR);
        int index = metric.size() * percentile / 100;
        return (Metric)list.get(index);
    }

    public double mean(String metricName) {
        List<Metric> metric = this.metrics.get(metricName);
        if (metric == null || this.metrics.isEmpty()) {
            throw new IllegalArgumentException("Metric name not found: " + metricName);
        }
        return metric.stream().collect(Collectors.averagingDouble(m -> m.getValue().doubleValue()));
    }

    private static final class MetricValueComparator
    implements Comparator<Metric>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private MetricValueComparator() {
        }

        @Override
        public int compare(Metric o1, Metric o2) {
            Number n1 = o1.getValue();
            Number n2 = o2.getValue();
            if (n1 instanceof Double || n1 instanceof Float) {
                return Double.compare(n1.doubleValue(), n2.doubleValue());
            }
            return Long.compare(n1.longValue(), n2.longValue());
        }
    }
}

