/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.nn.norm;

import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.AbstractBlock;
import ai.djl.nn.Parameter;
import ai.djl.nn.ParameterType;
import ai.djl.training.ParameterStore;
import ai.djl.util.PairList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BatchNorm
extends AbstractBlock {
    private static final byte VERSION = 2;
    private int axis;
    private float epsilon;
    private float momentum;
    private long inChannels;
    private boolean center;
    private boolean scale;
    private Parameter gamma;
    private Parameter beta;
    private Parameter runningMean;
    private Parameter runningVar;

    BatchNorm(Builder builder) {
        super((byte)2);
        this.axis = builder.axis;
        this.epsilon = builder.epsilon;
        this.momentum = builder.momentum;
        this.center = builder.center;
        this.scale = builder.scale;
        this.gamma = this.addParameter(new Parameter("gamma", this, ParameterType.GAMMA, this.scale), (Shape[] inputShapes) -> new Shape(this.inChannels));
        this.beta = this.addParameter(new Parameter("beta", this, ParameterType.BETA, this.center), (Shape[] inputShapes) -> new Shape(this.inChannels));
        this.runningMean = this.addParameter(new Parameter("runningMean", this, ParameterType.RUNNING_MEAN, false), (Shape[] inputShapes) -> new Shape(this.inChannels));
        this.runningVar = this.addParameter(new Parameter("runningVar", this, ParameterType.RUNNING_VAR, false), (Shape[] inputShapes) -> new Shape(this.inChannels));
    }

    @Override
    public NDList forward(ParameterStore parameterStore, NDList inputs, boolean training, PairList<String, Object> params) {
        NDArray input = inputs.singletonOrThrow();
        Device device = input.getDevice();
        NDArray gammaArr = parameterStore.getValue(this.gamma, device, training);
        NDArray betaArr = parameterStore.getValue(this.beta, device, training);
        NDArray runningMeanArr = parameterStore.getValue(this.runningMean, device, training);
        NDArray runningVarArr = parameterStore.getValue(this.runningVar, device, training);
        return BatchNorm.batchNorm(input, runningMeanArr, runningVarArr, gammaArr, betaArr, this.axis, this.momentum, this.epsilon, training);
    }

    @Override
    public Shape[] getOutputShapes(NDManager manager, Shape[] inputShapes) {
        return new Shape[]{inputShapes[0]};
    }

    @Override
    public void beforeInitialize(Shape[] inputShapes) {
        this.inputShapes = inputShapes;
        this.inChannels = inputShapes[0].size(this.axis);
    }

    @Override
    protected void saveMetadata(DataOutputStream os) throws IOException {
        this.saveInputShapes(os);
        os.writeLong(this.inChannels);
    }

    @Override
    public void loadMetadata(byte version, DataInputStream is) throws IOException, MalformedModelException {
        if (version == 2) {
            this.readInputShapes(is);
        } else if (version != 1) {
            throw new MalformedModelException("Unsupported encoding version: " + version);
        }
        this.inChannels = is.readLong();
    }

    public static NDList batchNorm(NDArray input, NDArray runningMean, NDArray runningVar) {
        NDArrayEx ex = input.getNDArrayInternal();
        return ex.batchNorm(input, runningMean, runningVar, null, null, 1, 0.9f, 1.0E-5f, true);
    }

    public static NDList batchNorm(NDArray input, NDArray runningMean, NDArray runningVar, NDArray gamma, NDArray beta) {
        NDArrayEx ex = input.getNDArrayInternal();
        return ex.batchNorm(input, runningMean, runningVar, gamma, beta, 1, 0.9f, 1.0E-5f, true);
    }

    public static NDList batchNorm(NDArray input, NDArray runningMean, NDArray runningVar, NDArray gamma, NDArray beta, int axis) {
        NDArrayEx ex = input.getNDArrayInternal();
        return ex.batchNorm(input, runningMean, runningVar, gamma, beta, axis, 0.9f, 1.0E-5f, true);
    }

    public static NDList batchNorm(NDArray input, NDArray runningMean, NDArray runningVar, NDArray gamma, NDArray beta, int axis, float momentum, float eps, boolean training) {
        NDArrayEx ex = input.getNDArrayInternal();
        return ex.batchNorm(input, runningMean, runningVar, gamma, beta, axis, momentum, eps, training);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int axis = 1;
        private float epsilon = 1.0E-5f;
        private float momentum = 0.9f;
        private boolean center = true;
        private boolean scale = true;

        Builder() {
        }

        public Builder optAxis(int axis) {
            this.axis = axis;
            return this;
        }

        public Builder optCenter(boolean val) {
            this.center = val;
            return this;
        }

        public Builder optScale(boolean val) {
            this.scale = val;
            return this;
        }

        public Builder optEpsilon(float val) {
            this.epsilon = val;
            return this;
        }

        public Builder optMomentum(float val) {
            this.momentum = val;
            return this;
        }

        public BatchNorm build() {
            return new BatchNorm(this);
        }
    }
}

