/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.Application;
import ai.djl.repository.Artifact;
import ai.djl.repository.License;
import ai.djl.repository.VersionRange;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Metadata {
    private String metadataVersion;
    protected String groupId;
    protected String artifactId;
    private String name;
    private String description;
    private String website;
    private String application;
    protected Map<String, License> licenses;
    protected List<Artifact> artifacts;
    private Date lastUpdated;
    private transient Application applicationClass;
    private transient URI repositoryUri;

    public List<Artifact> search(VersionRange versionRange, Map<String, String> filter) {
        List<Artifact> results = versionRange.matches(this.artifacts);
        if (filter == null) {
            return results;
        }
        return results.stream().filter(a -> a.hasProperties(filter)).collect(Collectors.toList());
    }

    public String getMetadataVersion() {
        return this.metadataVersion;
    }

    public void setMetadataVersion(String metadataVersion) {
        this.metadataVersion = metadataVersion;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public Application getApplication() {
        return this.applicationClass;
    }

    public String getApplicatrionName() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.applicationClass = application;
        this.application = application.getPath();
    }

    public Map<String, License> getLicenses() {
        return this.licenses;
    }

    public void setLicense(Map<String, License> licenses) {
        this.licenses = licenses;
    }

    public void addLicense(License license) {
        if (this.licenses == null) {
            this.licenses = new ConcurrentHashMap<String, License>();
        }
        this.licenses.put(license.getId(), license);
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<Artifact> artifacts) {
        this.artifacts = artifacts;
        for (Artifact artifact : artifacts) {
            artifact.setMetadata(this);
        }
    }

    public void addArtifact(Artifact artifact) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<Artifact>();
        }
        this.artifacts.add(artifact);
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public URI getRepositoryUri() {
        return this.repositoryUri;
    }

    public void setRepositoryUri(URI repositoryUri) {
        this.repositoryUri = repositoryUri;
    }

    public final void init() {
        if (this.artifacts != null) {
            for (Artifact artifact : this.artifacts) {
                artifact.setMetadata(this);
            }
        }
    }

    public static final class MatchAllMetadata
    extends Metadata {
        public MatchAllMetadata() {
            this.groupId = "ai.djl.localmodelzoo";
            this.artifacts = Collections.emptyList();
        }

        @Override
        public List<Artifact> search(VersionRange versionRange, Map<String, String> filter) {
            return this.getArtifacts();
        }
    }
}

