/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.Model;
import ai.djl.modality.cv.Image;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public abstract class BaseImageTranslator<T>
implements Translator<Image, T> {
    private Image.Flag flag;
    private Pipeline pipeline;
    private Batchifier batchifier;

    public BaseImageTranslator(BaseBuilder<?> builder) {
        this.flag = builder.flag;
        this.pipeline = builder.pipeline;
        this.batchifier = builder.batchifier;
    }

    @Override
    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Image input) {
        NDArray array = input.toNDArray(ctx.getNDManager(), this.flag);
        return this.pipeline.transform(new NDList(array));
    }

    protected static final class SynsetLoader {
        private String synsetFileName;
        private URL synsetUrl;
        private List<String> synset;

        public SynsetLoader(List<String> synset) {
            this.synset = synset;
        }

        public SynsetLoader(URL synsetUrl) {
            this.synsetUrl = synsetUrl;
        }

        public SynsetLoader(String synsetFileName) {
            this.synsetFileName = synsetFileName;
        }

        public List<String> load(Model model) throws IOException {
            if (this.synset != null) {
                return this.synset;
            }
            if (this.synsetUrl != null) {
                try (InputStream is = this.synsetUrl.openStream();){
                    List<String> list = Utils.readLines(is);
                    return list;
                }
            }
            return model.getArtifact(this.synsetFileName, Utils::readLines);
        }
    }

    public static abstract class ClassificationBuilder<T extends BaseBuilder>
    extends BaseBuilder<T> {
        protected SynsetLoader synsetLoader;

        public T optSynsetArtifactName(String synsetArtifactName) {
            this.synsetLoader = new SynsetLoader(synsetArtifactName);
            return this.self();
        }

        public T optSynsetUrl(URL synsetUrl) {
            this.synsetLoader = new SynsetLoader(synsetUrl);
            return this.self();
        }

        public T optSynset(List<String> synset) {
            this.synsetLoader = new SynsetLoader(synset);
            return this.self();
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.synsetLoader == null) {
                this.synsetLoader = new SynsetLoader("synset.txt");
            }
        }
    }

    public static abstract class BaseBuilder<T extends BaseBuilder> {
        protected Image.Flag flag = Image.Flag.COLOR;
        protected Pipeline pipeline;
        protected Batchifier batchifier = Batchifier.STACK;

        public T optFlag(Image.Flag flag) {
            this.flag = flag;
            return this.self();
        }

        public T setPipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this.self();
        }

        public T addTransform(Transform transform) {
            if (this.pipeline == null) {
                this.pipeline = new Pipeline();
            }
            this.pipeline.add(transform);
            return this.self();
        }

        public T optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this.self();
        }

        protected abstract T self();

        protected void validate() {
            if (this.pipeline == null) {
                throw new IllegalArgumentException("pipeline is required.");
            }
        }
    }
}

