/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.listener;

import ai.djl.metric.Metrics;
import ai.djl.training.Trainer;
import ai.djl.training.listener.TrainingListener;

public class EpochTrainingListener
implements TrainingListener {
    private long epochTime;
    private int numEpochs;

    @Override
    public void onEpoch(Trainer trainer) {
        Metrics metrics = trainer.getMetrics();
        if (metrics != null) {
            metrics.addMetric("epoch", System.nanoTime() - this.epochTime);
        }
        this.epochTime = System.nanoTime();
        ++this.numEpochs;
    }

    @Override
    public void onTrainingBatch(Trainer trainer, TrainingListener.BatchData batchData) {
    }

    @Override
    public void onValidationBatch(Trainer trainer, TrainingListener.BatchData batchData) {
    }

    @Override
    public void onTrainingBegin(Trainer trainer) {
        this.epochTime = System.nanoTime();
    }

    @Override
    public void onTrainingEnd(Trainer trainer) {
        trainer.getModel().setProperty("Epoch", Integer.toString(this.numEpochs));
    }

    public int getNumEpochs() {
        return this.numEpochs;
    }
}

