/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.engine.Engine;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.DefaultModelLoader;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelZoo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DefaultModelZoo
implements ModelZoo {
    public static final String GROUP_ID = "ai.djl.localmodelzoo";
    private List<ModelLoader<?, ?>> modelLoaders;

    public DefaultModelZoo(String locations) {
        String[] urls = locations.split("\\s*,\\s*");
        this.modelLoaders = new ArrayList(urls.length);
        for (String url : urls) {
            if (url.isEmpty()) continue;
            Repository repo = Repository.newInstance(url, url);
            List<MRL> mrls = repo.getResources();
            for (MRL mrl : mrls) {
                this.modelLoaders.add(new DefaultModelLoader(repo, mrl));
            }
        }
    }

    @Override
    public List<ModelLoader<?, ?>> getModelLoaders() {
        return this.modelLoaders;
    }

    @Override
    public String getGroupId() {
        return GROUP_ID;
    }

    @Override
    public Set<String> getSupportedEngines() {
        return Collections.singleton(Engine.getInstance().getEngineName());
    }
}

