/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Vocabulary {
    private Map<String, TokenInfo> tokens = new ConcurrentHashMap<String, TokenInfo>();
    private List<String> indexToToken = new ArrayList<String>();
    private Set<String> reservedTokens;
    private int minFrequency;
    private String unknownToken;

    public Vocabulary(VocabularyBuilder builder) {
        this.reservedTokens = builder.reservedTokens;
        this.minFrequency = builder.minFrequency;
        this.unknownToken = builder.unknownToken;
        this.reservedTokens.add(this.unknownToken);
        for (String string : this.reservedTokens) {
            this.tokens.put(string, new TokenInfo(Integer.MAX_VALUE));
        }
        for (List list : builder.sentences) {
            this.addAllTokens(list);
        }
    }

    private void addToken(String token) {
        if (this.reservedTokens.contains(token)) {
            return;
        }
        TokenInfo tokenInfo = this.tokens.getOrDefault(token, new TokenInfo());
        if (++tokenInfo.frequency >= this.minFrequency) {
            tokenInfo.index = this.indexToToken.size();
            this.indexToToken.add(token);
        }
        this.tokens.put(token, tokenInfo);
    }

    private void addAllTokens(Collection<String> tokens) {
        for (String token : tokens) {
            this.addToken(token);
        }
    }

    public boolean isKnownToken(String token) {
        return this.tokens.containsKey(token);
    }

    public String getUnknownToken() {
        return this.unknownToken;
    }

    public String getToken(int index) {
        if (index < 0 || index >= this.indexToToken.size()) {
            return this.unknownToken;
        }
        return this.indexToToken.get(index);
    }

    public long getIndex(String token) {
        if (this.tokens.containsKey(token)) {
            return this.tokens.get((Object)token).index;
        }
        return 0L;
    }

    public int size() {
        return this.tokens.size();
    }

    private static final class TokenInfo {
        int frequency;
        long index = -1L;

        public TokenInfo() {
        }

        public TokenInfo(int index) {
            this.index = index;
        }
    }

    public static class VocabularyBuilder {
        protected List<List<String>> sentences = new LinkedList<List<String>>();
        protected Set<String> reservedTokens = new HashSet<String>();
        protected int minFrequency = 10;
        protected String unknownToken = "<unk>";

        public VocabularyBuilder optMinFrequency(int minFrequency) {
            this.minFrequency = minFrequency;
            return this;
        }

        public VocabularyBuilder optUnknownToken(String unknownToken) {
            this.unknownToken = unknownToken;
            return this;
        }

        public VocabularyBuilder optReservedTokens(Collection<String> reservedTokens) {
            this.reservedTokens.addAll(reservedTokens);
            return this;
        }

        public VocabularyBuilder add(List<String> sentence) {
            this.sentences.add(sentence);
            return this;
        }

        public VocabularyBuilder addAll(List<List<String>> sentences) {
            this.sentences.addAll(sentences);
            return this;
        }

        public Vocabulary build() {
            return new Vocabulary(this);
        }
    }
}

