/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv;

import ai.djl.modality.Input;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.translate.TranslateException;
import ai.djl.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;

public class VisionLanguageInput {
    private Image image;
    private String text;
    @SerializedName(value="candidate_labels")
    private String[] candidates;
    @SerializedName(value="hypothesis_template")
    private String hypothesisTemplate;

    public VisionLanguageInput(Image image, String text) {
        this(image, text, null, null);
    }

    public VisionLanguageInput(Image image, String[] candidates) {
        this(image, null, candidates, null);
    }

    public VisionLanguageInput(Image image, String text, String[] candidates, String hypothesisTemplate) {
        this.image = image;
        this.text = text;
        this.candidates = candidates;
        this.hypothesisTemplate = hypothesisTemplate;
    }

    public static VisionLanguageInput parseInput(Input input) throws TranslateException, IOException {
        String data = input.getData().getAsString();
        try {
            JsonObject obj = (JsonObject)JsonUtils.GSON.fromJson(data, JsonObject.class);
            JsonElement url = obj.get("image");
            if (url == null) {
                url = obj.get("image_url");
            }
            if (url == null) {
                throw new TranslateException("Missing \"image\" parameter in input.");
            }
            Image img = ImageFactory.getInstance().fromUrl(url.getAsString());
            String text = (String)JsonUtils.GSON.fromJson(obj.get("text"), String.class);
            String[] candidates = (String[])JsonUtils.GSON.fromJson(obj.get("candidate_labels"), String[].class);
            String hypothesisTemplate = (String)JsonUtils.GSON.fromJson(obj.get("hypothesis_template"), String.class);
            return new VisionLanguageInput(img, text, candidates, hypothesisTemplate);
        }
        catch (JsonParseException e) {
            throw new TranslateException("Input is not a valid json.", e);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String[] getCandidates() {
        return this.candidates;
    }

    public void setCandidates(String[] candidates) {
        this.candidates = candidates;
    }

    public String getHypothesisTemplate() {
        return this.hypothesisTemplate == null ? "This is a photo of {}." : this.hypothesisTemplate;
    }

    public void setHypothesisTemplate(String hypothesisTemplate) {
        this.hypothesisTemplate = hypothesisTemplate;
    }
}

