/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.translator;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.nlp.EmbeddingOutput;
import ai.djl.modality.nlp.TextPrompt;
import ai.djl.ndarray.BytesSupplier;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.util.ArrayList;
import java.util.List;

public class SparseRetrievalServingTranslator
implements Translator<Input, Output> {
    private Translator<String, EmbeddingOutput> translator;

    public SparseRetrievalServingTranslator(Translator<String, EmbeddingOutput> translator) {
        this.translator = translator;
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        this.translator.prepare(ctx);
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Input input) throws Exception {
        if (input.getContent().isEmpty()) {
            throw new TranslateException("Input data is empty.");
        }
        TextPrompt prompt = TextPrompt.parseInput(input);
        if (prompt.isBatch()) {
            ctx.setAttachment("batch", Boolean.TRUE);
            return this.translator.batchProcessInput(ctx, prompt.getBatch());
        }
        NDList ret = this.translator.processInput(ctx, prompt.getText());
        Batchifier batchifier = this.translator.getBatchifier();
        if (batchifier != null) {
            NDList[] batch = new NDList[]{ret};
            return batchifier.batchify(batch);
        }
        return ret;
    }

    @Override
    public NDList batchProcessInput(TranslatorContext ctx, List<Input> inputs) throws Exception {
        int[] mapping = new int[inputs.size()];
        ArrayList<String> prompts = new ArrayList<String>(mapping.length);
        for (int i = 0; i < mapping.length; ++i) {
            TextPrompt prompt = TextPrompt.parseInput(inputs.get(i));
            if (prompt.isBatch()) {
                List<String> batch = prompt.getBatch();
                mapping[i] = batch.size();
                prompts.addAll(batch);
                continue;
            }
            mapping[i] = -1;
            prompts.add(prompt.getText());
        }
        ctx.setAttachment("mapping", mapping);
        return this.translator.batchProcessInput(ctx, prompts);
    }

    @Override
    public Output processOutput(TranslatorContext ctx, NDList list) throws Exception {
        Output output = new Output();
        output.addProperty("Content-Type", "application/json");
        if (ctx.getAttachment("batch") != null) {
            output.add(BytesSupplier.wrapAsJson(this.translator.batchProcessOutput(ctx, list)));
        } else {
            Batchifier batchifier = this.translator.getBatchifier();
            if (batchifier != null) {
                list = batchifier.unbatchify(list)[0];
            }
            output.add(BytesSupplier.wrapAsJson(this.translator.processOutput(ctx, list)));
        }
        return output;
    }

    @Override
    public List<Output> batchProcessOutput(TranslatorContext ctx, NDList list) throws Exception {
        List<EmbeddingOutput> outputs = this.translator.batchProcessOutput(ctx, list);
        int[] mapping = (int[])ctx.getAttachment("mapping");
        ArrayList<Output> ret = new ArrayList<Output>(mapping.length);
        int index = 0;
        for (int size : mapping) {
            Output output = new Output();
            output.addProperty("Content-Type", "application/json");
            if (size == -1) {
                output.add(BytesSupplier.wrapAsJson(outputs.get(index++)));
            } else {
                ArrayList<EmbeddingOutput> embeddings = new ArrayList<EmbeddingOutput>(size);
                for (int j = 0; j < size; ++j) {
                    embeddings.add(outputs.get(index++));
                }
                output.add(BytesSupplier.wrapAsJson(embeddings));
            }
            ret.add(output);
        }
        return ret;
    }
}

