/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.Application;
import ai.djl.repository.AbstractRepository;
import ai.djl.repository.Artifact;
import ai.djl.repository.FilenameUtils;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.util.Progress;
import ai.djl.util.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRepository
extends AbstractRepository {
    private static final Logger logger = LoggerFactory.getLogger(SimpleRepository.class);
    private Path path;
    private String artifactId;
    private String modelName;
    private boolean isRemote;
    private Metadata metadata;
    private boolean resolved;

    protected SimpleRepository(String name, URI uri, Path path) {
        super(name, uri);
        this.path = path;
        this.isRemote = FilenameUtils.isArchiveFile(path.toString());
        this.modelName = (String)this.arguments.get("model_name");
        this.artifactId = (String)this.arguments.get("artifact_id");
        if (this.artifactId == null) {
            this.artifactId = this.isRemote ? FilenameUtils.getNamePart(path.toFile().getName()) : path.toFile().getName();
        }
        if (this.modelName == null) {
            this.modelName = this.artifactId;
        }
    }

    @Override
    public boolean isRemote() {
        return this.isRemote;
    }

    @Override
    public URI getBaseUri() {
        return this.path.toUri();
    }

    @Override
    public Metadata locate(MRL mrl) throws IOException {
        return this.getMetadata();
    }

    @Override
    public Artifact resolve(MRL mrl, Map<String, String> filter) throws IOException {
        List<Artifact> artifacts = this.locate(mrl).getArtifacts();
        if (artifacts.isEmpty()) {
            return null;
        }
        return artifacts.get(0);
    }

    @Override
    public Path getResourceDirectory(Artifact artifact) throws IOException {
        if (this.isRemote) {
            return super.getResourceDirectory(artifact);
        }
        return this.path;
    }

    @Override
    protected void download(Path tmp, URI baseUri, Artifact.Item item, Progress progress) throws IOException {
        logger.debug("Extracting artifact: {} ...", (Object)this.path);
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(this.path, new OpenOption[0]));){
            this.save(is, tmp, item, progress);
        }
    }

    @Override
    public void prepare(Artifact artifact, Progress progress) throws IOException {
        if (this.isRemote) {
            super.prepare(artifact, progress);
        } else {
            logger.debug("Skip prepare for local repository.");
        }
    }

    @Override
    public Path getCacheDirectory() throws IOException {
        if (this.isRemote) {
            return super.getCacheDirectory();
        }
        return this.path;
    }

    @Override
    protected URI resolvePath(Artifact.Item item, String path) throws IOException {
        if (this.isRemote) {
            return super.resolvePath(item, path);
        }
        return this.path.resolve(item.getName()).toUri();
    }

    @Override
    public List<MRL> getResources() {
        if (!Files.exists(this.path, new LinkOption[0])) {
            logger.debug("Specified path doesn't exists: {}", (Object)this.path.toAbsolutePath());
            return Collections.emptyList();
        }
        MRL mrl = MRL.undefined(this, "ai.djl.localmodelzoo", this.artifactId);
        return Collections.singletonList(mrl);
    }

    private synchronized Metadata getMetadata() throws IOException {
        if (this.resolved) {
            return this.metadata;
        }
        this.resolved = true;
        this.metadata = new Metadata.MatchAllMetadata();
        this.metadata.setRepositoryUri(URI.create(""));
        this.metadata.setArtifactId(this.artifactId);
        if (!Files.exists(this.path, new LinkOption[0])) {
            logger.debug("Specified path doesn't exists: {}", (Object)this.path.toAbsolutePath());
            return this.metadata;
        }
        Artifact artifact = new Artifact();
        artifact.setName(this.modelName);
        artifact.getArguments().putAll(this.arguments);
        ConcurrentHashMap<String, Artifact.Item> files = new ConcurrentHashMap<String, Artifact.Item>();
        if (this.isRemote) {
            Artifact.Item item = new Artifact.Item();
            String uri = this.path.toAbsolutePath().toUri().toString();
            item.setUri(uri);
            item.setName("");
            item.setArtifact(artifact);
            item.setSize(Files.size(this.path));
            files.put(this.artifactId, item);
            artifact.setFiles(files);
            String hash = Utils.hash(uri);
            MRL mrl = this.model(Application.UNDEFINED, "ai.djl.localmodelzoo", hash);
            this.metadata.setRepositoryUri(mrl.toURI());
        } else if (Files.isDirectory(this.path, new LinkOption[0])) {
            File[] fileList = this.path.toFile().listFiles();
            if (fileList != null) {
                for (File f : fileList) {
                    Artifact.Item item = new Artifact.Item();
                    item.setName(f.getName());
                    item.setSize(f.length());
                    item.setArtifact(artifact);
                    files.put(f.getName(), item);
                }
            }
        } else {
            logger.warn("Simple repository pointing to a non-archive file.");
        }
        artifact.setFiles(files);
        this.metadata.setArtifacts(Collections.singletonList(artifact));
        return this.metadata;
    }
}

