/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.modality.cv.translator.YoloV5Translator;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.DataType;
import java.util.ArrayList;
import java.util.Map;

public class YoloV8Translator
extends YoloV5Translator {
    protected YoloV8Translator(Builder builder) {
        super(builder);
    }

    public static Builder builder(Map<String, ?> arguments) {
        Builder builder = new Builder();
        builder.configPreProcess(arguments);
        builder.configPostProcess(arguments);
        return builder;
    }

    @Override
    protected DetectedObjects processFromBoxOutput(NDList list) {
        NDArray features4OneImg = (NDArray)list.get(0);
        int sizeClasses = this.classes.size();
        long sizeBoxes = features4OneImg.size(1);
        ArrayList<YoloV5Translator.IntermediateResult> intermediateResults = new ArrayList<YoloV5Translator.IntermediateResult>();
        for (long b = 0L; b < sizeBoxes; ++b) {
            float maxClass = 0.0f;
            int maxIndex = 0;
            for (int c = 4; c < sizeClasses; ++c) {
                long[] lArray = new long[]{c, b};
                float classProb = features4OneImg.getFloat(lArray);
                if (!(classProb > maxClass)) continue;
                maxClass = classProb;
                maxIndex = c;
            }
            if (!(maxClass > this.threshold)) continue;
            float xPos = features4OneImg.getFloat(0L, b);
            float yPos = features4OneImg.getFloat(1L, b);
            float w = features4OneImg.getFloat(2L, b);
            float h = features4OneImg.getFloat(3L, b);
            Rectangle rect = new Rectangle(Math.max(0.0f, xPos - w / 2.0f), Math.max(0.0f, yPos - h / 2.0f), w, h);
            intermediateResults.add(new YoloV5Translator.IntermediateResult((String)this.classes.get(maxIndex), maxClass, maxIndex, rect));
        }
        return this.nms(intermediateResults);
    }

    public static class Builder
    extends YoloV5Translator.Builder {
        @Override
        public YoloV8Translator build() {
            if (this.pipeline == null) {
                this.addTransform(array -> array.transpose(2, 0, 1).toType(DataType.FLOAT32, false).div(255));
            }
            this.validate();
            return new YoloV8Translator(this);
        }
    }
}

