/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.Utils;
import ai.djl.util.cuda.CudaUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Platform {
    private static final Logger logger = LoggerFactory.getLogger(Platform.class);
    private String version;
    private String apiVersion;
    private String osPrefix;
    private String osArch;
    private String flavor;
    private String cudaArch;
    private String[] libraries;
    private boolean placeholder;

    private Platform() {
    }

    public static Platform detectPlatform(String engine, String overrideVersion) {
        Platform platform = Platform.fromSystem(engine);
        platform.version = overrideVersion;
        return platform;
    }

    public static Platform detectPlatform(String engine) {
        Enumeration<URL> urls;
        String nativeProp = "native/lib/" + engine + ".properties";
        try {
            urls = ClassLoaderUtils.getContextClassLoader().getResources(nativeProp);
        }
        catch (IOException e) {
            throw new AssertionError("Failed to list property files.", e);
        }
        Platform systemPlatform = Platform.fromSystem(engine);
        Platform placeholder = null;
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            Platform platform = Platform.fromUrl(url);
            platform.apiVersion = systemPlatform.apiVersion;
            if (platform.isPlaceholder()) {
                placeholder = platform;
                continue;
            }
            if (!platform.matches(systemPlatform)) continue;
            return platform;
        }
        if (placeholder != null) {
            return placeholder;
        }
        if (systemPlatform.version == null) {
            throw new AssertionError((Object)("No " + engine + " version found in property file."));
        }
        if (systemPlatform.apiVersion == null) {
            throw new AssertionError((Object)("No " + engine + " djl_version found in property file."));
        }
        return systemPlatform;
    }

    static Platform fromUrl(URL url) {
        Platform platform = Platform.fromSystem();
        try (InputStream conf = url.openStream();){
            Properties prop = new Properties();
            prop.load(conf);
            platform.version = prop.getProperty("version");
            if (platform.version == null) {
                throw new IllegalArgumentException("version key is required in <engine>.properties file.");
            }
            platform.placeholder = prop.getProperty("placeholder") != null;
            String flavor = prop.getProperty("flavor");
            if (flavor != null) {
                platform.flavor = flavor;
            }
            String flavorPrefixedClassifier = prop.getProperty("classifier", "");
            String libraryList = prop.getProperty("libraries", "");
            platform.libraries = libraryList.isEmpty() ? Utils.EMPTY_ARRAY : libraryList.split(",");
            if (!flavorPrefixedClassifier.isEmpty()) {
                String[] tokens = flavorPrefixedClassifier.split("-");
                if (flavor != null) {
                    platform.osPrefix = tokens[0];
                    platform.osArch = tokens[1];
                } else {
                    platform.flavor = tokens[0];
                    platform.osPrefix = tokens[1];
                    platform.osArch = tokens[2];
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read property file: " + url, e);
        }
        return platform;
    }

    public static Platform fromSystem(String engine) {
        Platform platform;
        block8: {
            String engineProp = engine + "-engine.properties";
            String versionKey = engine + "_version";
            platform = Platform.fromSystem();
            platform.placeholder = true;
            try {
                URL url = ClassLoaderUtils.getResource(engineProp);
                if (url == null) break block8;
                try (InputStream is = url.openStream();){
                    Properties prop = new Properties();
                    prop.load(is);
                    platform.version = prop.getProperty(versionKey);
                    platform.apiVersion = prop.getProperty("djl_version");
                }
            }
            catch (IOException e) {
                throw new AssertionError("Failed to read property file: " + engineProp, e);
            }
        }
        return platform;
    }

    static Platform fromSystem() {
        Platform platform = new Platform();
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Win")) {
            platform.osPrefix = "win";
        } else if (osName.startsWith("Mac")) {
            platform.osPrefix = "osx";
        } else if (osName.startsWith("Linux")) {
            platform.osPrefix = "linux";
        } else {
            throw new AssertionError((Object)("Unsupported platform: " + osName));
        }
        platform.osArch = System.getProperty("os.arch");
        if ("amd64".equals(platform.osArch)) {
            platform.osArch = "x86_64";
        }
        if (CudaUtils.getGpuCount() > 0) {
            platform.flavor = "cu" + CudaUtils.getCudaVersionString();
            platform.cudaArch = CudaUtils.getComputeCapability(0);
        } else {
            platform.flavor = "cpu";
        }
        return platform;
    }

    public String getVersion() {
        return this.version;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getOsPrefix() {
        return this.osPrefix;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public String getClassifier() {
        return this.osPrefix + '-' + this.osArch;
    }

    public String getCudaArch() {
        return this.cudaArch;
    }

    public String[] getLibraries() {
        return this.libraries;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public boolean matches(Platform system) {
        if (!this.osPrefix.equals(system.osPrefix) || !this.osArch.equals(system.osArch)) {
            return false;
        }
        if (this.flavor.startsWith("cpu") || "mkl".equals(this.flavor)) {
            return true;
        }
        if (system.flavor.startsWith("cu") && Integer.parseInt(this.flavor.substring(2, 5)) <= Integer.parseInt(system.flavor.substring(2, 5))) {
            return true;
        }
        logger.warn("The bundled library: " + this + " doesn't match system: " + system);
        return false;
    }

    public String toString() {
        return this.flavor + '-' + this.getClassifier() + ':' + this.version;
    }
}

