/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.audio;

import ai.djl.modality.audio.Audio;
import ai.djl.ndarray.NDArray;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AudioFactory {
    private static final Logger logger = LoggerFactory.getLogger(AudioFactory.class);
    private static final String[] FACTORIES = new String[]{"ai.djl.audio.FFmpegAudioFactory", "ai.djl.modality.audio.SampledAudioFactory"};
    private static AudioFactory factory = AudioFactory.newInstance();

    private static AudioFactory newInstance() {
        for (String f : FACTORIES) {
            try {
                Class<AudioFactory> clazz = Class.forName(f).asSubclass(AudioFactory.class);
                return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                logger.trace("", (Throwable)e);
            }
        }
        throw new IllegalStateException("Failed to create AudioFactory!");
    }

    public static AudioFactory getInstance() {
        return factory;
    }

    public abstract Audio fromFile(Path var1) throws IOException;

    public Audio fromUrl(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            Audio audio = this.fromInputStream(is);
            return audio;
        }
    }

    public Audio fromUrl(String url) throws IOException {
        URI uri = URI.create(url);
        if (uri.isAbsolute()) {
            return this.fromUrl(uri.toURL());
        }
        return this.fromFile(Paths.get(url, new String[0]));
    }

    public abstract Audio fromInputStream(InputStream var1) throws IOException;

    public abstract Audio fromData(float[] var1);

    public abstract Audio fromNDArray(NDArray var1);
}

