/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.metrics;

import ai.djl.modality.cv.MultiBoxTarget;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.DataType;
import ai.djl.training.metrics.Accuracy;

public class SingleShotDetectionAccuracy
extends Accuracy {
    private MultiBoxTarget multiBoxTarget = new MultiBoxTarget.Builder().build();

    public SingleShotDetectionAccuracy(String name) {
        super(name, 0);
    }

    @Override
    public void update(NDList labels, NDList predictions) {
        NDArray anchors = (NDArray)predictions.get(0);
        NDArray classPredictions = (NDArray)predictions.get(1);
        NDList targets = this.multiBoxTarget.target(new NDList(anchors, labels.head(), classPredictions.transpose(0, 2, 1)));
        NDArray classLabels = (NDArray)targets.get(2);
        this.checkLabelShapes(classLabels, classPredictions);
        NDArray predictionReduced = classPredictions.argMax(-1);
        long numCorrect = classLabels.asType(DataType.INT64, false).eq(predictionReduced.asType(DataType.INT64, false)).countNonzero().getLong(new long[0]);
        this.addCorrectInstances(numCorrect);
        this.addTotalInstances(classLabels.size());
    }
}

