/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv;

import ai.djl.ndarray.NDArray;
import java.util.Arrays;
import java.util.List;

public class MultiBoxPrior {
    private List<Float> sizes;
    private List<Float> ratios;
    private List<Float> steps;
    private List<Float> offsets;
    private boolean clip;

    public MultiBoxPrior(Builder builder) {
        this.sizes = builder.sizes;
        this.ratios = builder.ratios;
        this.steps = builder.steps;
        this.ratios = builder.ratios;
        this.offsets = builder.offsets;
        this.clip = builder.clip;
    }

    public NDArray generateAnchorBoxes(NDArray input) {
        return input.getNDArrayInternal().multiBoxPrior(this.sizes, this.ratios, this.steps, this.offsets, this.clip).head();
    }

    public static final class Builder {
        List<Float> sizes = Arrays.asList(Float.valueOf(1.0f));
        List<Float> ratios = Arrays.asList(Float.valueOf(1.0f));
        List<Float> steps = Arrays.asList(Float.valueOf(-1.0f), Float.valueOf(-1.0f));
        List<Float> offsets = Arrays.asList(Float.valueOf(0.5f), Float.valueOf(0.5f));
        boolean clip;

        public Builder setSizes(List<Float> sizes) {
            this.sizes = sizes;
            return this;
        }

        public Builder setRatios(List<Float> ratios) {
            this.ratios = ratios;
            return this;
        }

        public Builder optSteps(List<Float> steps) {
            this.steps = steps;
            return this;
        }

        public Builder optOffsets(List<Float> offsets) {
            this.offsets = offsets;
            return this;
        }

        public Builder optClip(boolean clip) {
            this.clip = clip;
            return this;
        }

        public MultiBoxPrior build() {
            return new MultiBoxPrior(this);
        }
    }
}

