/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv;

import ai.djl.modality.Classifications;
import ai.djl.modality.cv.BoundingBox;
import java.util.List;

public class DetectedObjects
extends Classifications {
    private List<BoundingBox> boundingBoxes;

    public DetectedObjects(List<String> classNames, List<Double> probabilities, List<BoundingBox> boundingBoxes) {
        super(classNames, probabilities);
        this.boundingBoxes = boundingBoxes;
    }

    @Override
    public <T extends Classifications.Classification> T item(int index) {
        return (T)new DetectedObject((String)this.classNames.get(index), (Double)this.probabilities.get(index), this.boundingBoxes.get(index));
    }

    public int getNumberOfObjects() {
        return this.boundingBoxes.size();
    }

    public static final class DetectedObject
    extends Classifications.Classification {
        private BoundingBox boundingBox;

        public DetectedObject(String className, double probability, BoundingBox boundingBox) {
            super(className, probability);
            this.boundingBox = boundingBox;
        }

        public BoundingBox getBoundingBox() {
            return this.boundingBox;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (this.getBoundingBox() != null) {
                sb.append(", bounds: ").append(this.getBoundingBox());
            }
            return sb.toString();
        }
    }
}

