/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.nn.pooling;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.pooling.PoolingConvention;

public final class Pool {
    private Pool() {
    }

    public static NDArray maxPool(NDArray data, Shape kernel, Shape stride, Shape pad, PoolingConvention poolingConvention) {
        return data.getNDArrayInternal().maxPool(kernel, stride, pad, poolingConvention);
    }

    public static NDArray maxPool(NDArray data, Shape kernel, Shape stride, Shape pad) {
        return Pool.maxPool(data, kernel, stride, pad, PoolingConvention.VALID);
    }

    public static NDArray globalMaxPool(NDArray data) {
        return data.getNDArrayInternal().globalMaxPool();
    }

    public static NDArray sumPool(NDArray data, Shape kernel, Shape stride, Shape pad, PoolingConvention poolingConvention) {
        return data.getNDArrayInternal().sumPool(kernel, stride, pad, poolingConvention);
    }

    public static NDArray sumPool(NDArray data, Shape kernel, Shape stride, Shape pad) {
        return Pool.sumPool(data, kernel, stride, pad, PoolingConvention.VALID);
    }

    public static NDArray globalSumPool(NDArray data) {
        return data.getNDArrayInternal().globalSumPool();
    }

    public static NDArray avgPool(NDArray data, Shape kernel, Shape stride, Shape pad, PoolingConvention poolingConvention, boolean countIncludePad) {
        return data.getNDArrayInternal().avgPool(kernel, stride, pad, poolingConvention, countIncludePad);
    }

    public static NDArray avgPool(NDArray data, Shape kernel, Shape stride, Shape pad) {
        return Pool.avgPool(data, kernel, stride, pad, PoolingConvention.VALID, true);
    }

    public static NDArray globalAvgPool(NDArray data) {
        return data.getNDArrayInternal().globalAvgPool();
    }

    public static NDArray lpPool(NDArray data, Shape kernel, Shape stride, Shape pad, PoolingConvention poolingConvention, int pValue) {
        return data.getNDArrayInternal().lpPool(kernel, stride, pad, poolingConvention, pValue);
    }

    public static NDArray lpPool(NDArray data, Shape kernel, Shape stride, Shape pad, int pValue) {
        return data.getNDArrayInternal().lpPool(kernel, stride, pad, PoolingConvention.VALID, pValue);
    }

    public static NDArray globalLpPool(NDArray data, int pValue) {
        return data.getNDArrayInternal().globalLpPool(pValue);
    }
}

