/*
 * Decompiled with CFR 0.152.
 */
package ai.djl;

import ai.djl.engine.Engine;
import java.util.Objects;

public class Device {
    private static final Device CPU = new Device("cpu", 0);
    private static final Device GPU = new Device("gpu", 0);
    private String deviceType;
    private int deviceId;

    public Device(String deviceType, int deviceId) {
        this.deviceType = deviceType;
        this.deviceId = deviceId;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public String toString() {
        return this.deviceType + '(' + this.deviceId + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return this.deviceId == device.deviceId && Objects.equals(this.deviceType, device.deviceType);
    }

    public int hashCode() {
        return Objects.hash(this.deviceType, this.deviceId);
    }

    public static Device cpu() {
        return CPU;
    }

    public static Device cpu(int deviceId) {
        return new Device("cpu", deviceId);
    }

    public static Device gpu() {
        return GPU;
    }

    public static Device gpu(int deviceId) {
        return new Device("gpu", deviceId);
    }

    public static Device[] getDevices(int maxGpus) {
        int count = Engine.getInstance().getGpuCount();
        if (maxGpus <= 0 || count <= 0) {
            return new Device[]{CPU};
        }
        count = Math.min(maxGpus, count);
        Device[] devices = new Device[count];
        for (int i = 0; i < count; ++i) {
            devices[i] = new Device("gpu", i);
        }
        return devices;
    }

    public static Device defaultDevice() {
        return Engine.getInstance().defaultDevice();
    }

    public static Device defaultIfNull(Device device) {
        if (device != null) {
            return device;
        }
        return Engine.getInstance().defaultDevice();
    }

    public static Device defaultIfNull(Device device, Device def) {
        if (device != null) {
            return device;
        }
        return Device.defaultIfNull(def);
    }
}

