/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.output;

import ai.djl.modality.cv.output.Point;
import java.io.Serializable;
import java.util.List;

public class Joints
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Joint> joints;

    public Joints(List<Joint> joints) {
        this.joints = joints;
    }

    public List<Joint> getJoints() {
        return this.joints;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(4000);
        sb.append("\n[\t");
        boolean first = true;
        for (Joint joint : this.joints) {
            if (first) {
                first = false;
            } else {
                sb.append(",\n\t");
            }
            sb.append(joint);
        }
        sb.append("\n]");
        return sb.toString();
    }

    public static class Joint
    extends Point {
        private static final long serialVersionUID = 1L;
        private double confidence;

        public Joint(double x, double y, double confidence) {
            super(x, y);
            this.confidence = confidence;
        }

        public double getConfidence() {
            return this.confidence;
        }

        public String toString() {
            return String.format("Joint [x=%.3f, y=%.3f], confidence: %.4f", this.getX(), this.getY(), this.getConfidence());
        }
    }
}

