/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static void unzip(InputStream is, Path dest) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            if (name.contains("..")) {
                throw new IOException("Malicious zip entry: " + name);
            }
            Path file = dest.resolve(name).toAbsolutePath();
            if (entry.isDirectory()) {
                Files.createDirectories(file, new FileAttribute[0]);
                continue;
            }
            Path parentFile = file.getParent();
            if (parentFile == null) {
                throw new AssertionError((Object)("Parent path should never be null: " + file.toString()));
            }
            Files.createDirectories(parentFile, new FileAttribute[0]);
            Files.copy(zis, file, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void zip(Path src, Path dest, boolean includeFolderName) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(dest, new OpenOption[0]));){
            Path root;
            Path path = root = includeFolderName ? src.getParent() : src;
            if (root == null) {
                throw new AssertionError((Object)"Parent folder should not be null.");
            }
            ZipUtils.addToZip(root, src, zos);
        }
    }

    private static void addToZip(Path root, Path file, ZipOutputStream zos) throws IOException {
        Path relative = root.relativize(file);
        String name = relative.toString();
        if (Files.isDirectory(file, new LinkOption[0])) {
            File[] files;
            if (!name.isEmpty()) {
                ZipEntry entry = new ZipEntry(name + '/');
                zos.putNextEntry(entry);
            }
            if ((files = file.toFile().listFiles()) != null) {
                for (File f : files) {
                    ZipUtils.addToZip(root, f.toPath(), zos);
                }
            }
        } else if (Files.isRegularFile(file, new LinkOption[0])) {
            if (name.isEmpty()) {
                name = file.toFile().getName();
            }
            ZipEntry entry = new ZipEntry(name);
            zos.putNextEntry(entry);
            Files.copy(file, zos);
        }
    }
}

