/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.repository.Repository;
import ai.djl.repository.VersionRange;
import ai.djl.util.Progress;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource {
    private static final Logger logger = LoggerFactory.getLogger(Resource.class);
    private Repository repository;
    private MRL mrl;
    private String version;
    private Metadata metadata;

    public Resource(Repository repository, MRL mrl, String version) {
        this.repository = repository;
        this.mrl = mrl;
        this.version = version;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public MRL getMrl() {
        return this.mrl;
    }

    public String getVersion() {
        return this.version;
    }

    public Artifact getDefaultArtifact() throws IOException {
        return this.repository.resolve(this.mrl, this.version, null);
    }

    public Artifact match(Map<String, String> criteria) throws IOException {
        List<Artifact> list = this.search(criteria);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<Artifact> listArtifacts() throws IOException {
        return this.getMetadata().getArtifacts();
    }

    public void prepare(Artifact artifact) throws IOException {
        this.prepare(artifact, null);
    }

    public void prepare(Artifact artifact, Progress progress) throws IOException {
        if (artifact != null) {
            logger.debug("Preparing artifact: {}, {}", (Object)this.repository.getName(), (Object)artifact);
            this.repository.prepare(artifact, progress);
        }
    }

    private List<Artifact> search(Map<String, String> criteria) throws IOException {
        return this.getMetadata().search(VersionRange.parse(this.version), criteria);
    }

    private Metadata getMetadata() throws IOException {
        if (this.metadata == null) {
            this.metadata = this.repository.locate(this.mrl);
            if (this.metadata == null) {
                throw new IOException("MRL: " + this.mrl + " resource not found.");
            }
        }
        return this.metadata;
    }
}

