/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.nn.transformer;

import ai.djl.ndarray.LazyNDArray;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;

public final class MemoryScope
implements AutoCloseable {
    private final NDManager parentManager;
    private final NDManager subManager;

    private MemoryScope(NDManager parentManager, NDManager subManager) {
        this.parentManager = parentManager;
        this.subManager = subManager;
    }

    public MemoryScope add(NDList ... lists) {
        for (NDList list : lists) {
            list.attach(this.subManager);
        }
        return this;
    }

    public MemoryScope add(NDArray ... arrays) {
        for (NDArray array : arrays) {
            array.attach(this.subManager);
        }
        return this;
    }

    public MemoryScope remove(NDList ... lists) {
        for (NDList list : lists) {
            list.attach(this.parentManager);
        }
        return this;
    }

    public MemoryScope remove(NDArray ... arrays) {
        for (NDArray array : arrays) {
            array.attach(this.parentManager);
        }
        return this;
    }

    public NDManager getScopeManager() {
        return this.subManager;
    }

    public MemoryScope waitToRead(NDArray ... arrays) {
        for (NDArray array : arrays) {
            if (array instanceof LazyNDArray) {
                LazyNDArray lazyNDArray = (LazyNDArray)array;
                lazyNDArray.waitToRead();
            }
            this.remove(array);
        }
        return this;
    }

    public MemoryScope waitToRead(NDList ... lists) {
        for (NDList list : lists) {
            if (list == null) continue;
            for (NDArray array : list) {
                this.waitToRead(array);
            }
        }
        return this;
    }

    @Override
    public void close() {
        this.subManager.close();
    }

    public static MemoryScope from(NDArray ndArray) {
        return new MemoryScope(ndArray.getManager(), ndArray.getManager().newSubManager(ndArray.getDevice())).add(ndArray);
    }

    public static MemoryScope from(NDList list) {
        NDArray ndArray = list.head();
        return new MemoryScope(ndArray.getManager(), ndArray.getManager().newSubManager(ndArray.getDevice())).add(list);
    }
}

