/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray.types;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public enum DataType {
    FLOAT32(Format.FLOATING, 4),
    FLOAT64(Format.FLOATING, 8),
    FLOAT16(Format.FLOATING, 2),
    UINT8(Format.UINT, 1),
    INT32(Format.INT, 4),
    INT8(Format.INT, 1),
    INT64(Format.INT, 8),
    BOOLEAN(Format.BOOLEAN, 1),
    UNKNOWN(Format.UNKNOWN, 0),
    STRING(Format.STRING, -1);

    private Format format;
    private int numOfBytes;

    private DataType(Format format, int numOfBytes) {
        this.format = format;
        this.numOfBytes = numOfBytes;
    }

    public int getNumOfBytes() {
        return this.numOfBytes;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean isFloating() {
        return this.format == Format.FLOATING;
    }

    public boolean isInteger() {
        return this.format == Format.UINT || this.format == Format.INT;
    }

    public static DataType fromBuffer(Buffer data) {
        if (data instanceof FloatBuffer) {
            return FLOAT32;
        }
        if (data instanceof DoubleBuffer) {
            return FLOAT64;
        }
        if (data instanceof IntBuffer) {
            return INT32;
        }
        if (data instanceof LongBuffer) {
            return INT64;
        }
        if (data instanceof ByteBuffer) {
            return INT8;
        }
        throw new IllegalArgumentException("Unsupported buffer type: " + data.getClass().getSimpleName());
    }

    public Buffer asDataType(ByteBuffer data) {
        switch (this) {
            case FLOAT32: {
                return data.asFloatBuffer();
            }
            case FLOAT64: {
                return data.asDoubleBuffer();
            }
            case INT32: {
                return data.asIntBuffer();
            }
            case INT64: {
                return data.asLongBuffer();
            }
        }
        return data;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static enum Format {
        FLOATING,
        UINT,
        INT,
        BOOLEAN,
        STRING,
        UNKNOWN;

    }
}

