package debug;

import a.yumi.lib.base.ui.simple.BaseMenuActivity;
import a.yumi.lib.base.ui.simple.BaseMenuItem;
import a.yumi.lib.base.util.ResUtil;
import a.yumi.lib.router.RouterConfig;
import a.yumi.lib.router.RouterUtil;
import a.yumi.module.wandroid.R;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

/**
 * PS: 模块运行时的启动页，aar 打包不输出，开发时快速入口
 * 不要 转成 kotlin ，不然 release 无法排除
 *
 * @author sdx
 * @date 2019-06-20
 */
public class RunAppMenuActivity extends BaseMenuActivity {

    @NotNull
    @Override
    protected String getToolBarTitle() {
        return ResUtil.getResString(R.string.app_name);
    }

    @NotNull
    @Override
    protected List<BaseMenuItem> getMenuData() {
        ArrayList<BaseMenuItem> list = new ArrayList<>();
        list.add(new BaseMenuItem("主页"));
        return list;
    }

    @Override
    protected void onClickMenu(@NotNull String menu) {
        switch (menu) {
            case "主页":
                RouterUtil.navigation(RouterConfig.Wandroid.Main2);
                break;
            default:
                break;
        }

    }
}
