package a.yumi.module.wandroid.ui.home.article.adapter

import a.yumi.lib.base.util.log.logJson
import a.yumi.module.wandroid.R
import a.yumi.module.wandroid.bean.biz.home.WAArticleItem
import a.yumi.module.wandroid.bean.biz.home.formatType
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder

/**
 * PS:
 */
class WAHomeArticleAdapter : BaseQuickAdapter<WAArticleItem, BaseViewHolder>
    (R.layout.module_wa_home_article_item) {

    override fun convert(helper: BaseViewHolder, item: WAArticleItem) {
        if (item.tags.size > 1) {
            logJson(item)
        }
        helper
            // 标题
            .setText(R.id.tv_title, item.title)
            // 作者
            .setText(R.id.tv_author, "作者：${item.author}")
            // 分类
            .setText(R.id.tv_chapter, "分类：${item.superChapterName} / ${item.chapterName}")
            // 时间
            .setText(R.id.tv_publish_time, item.niceDate)
            // 置顶
            .setGone(R.id.tag_top, item.type == 1)
            // 最新
            .setGone(R.id.tag_new, item.fresh)

        // 公众号
        // 项目
        val tvTag = helper.getView<TextView>(R.id.tag_tag)
        if (item.tags.isNotEmpty()) {
            tvTag.visibility = View.VISIBLE
            tvTag.text = item.tags[0].name
        } else {
            tvTag.visibility = View.GONE
        }
        // 收藏
        val imgCollect = helper.getView<ImageView>(R.id.img_collect)
        imgCollect.isSelected = item.collect
        helper.addOnClickListener(R.id.img_collect)
    }
}