package a.yumi.module.wandroid.ui.home.article

import a.yumi.lib.base.frame.mvp.BaseMVPFragment
import a.yumi.lib.base.util.img.loadUrl
import a.yumi.lib.base.util.log.loge
import a.yumi.lib.base.widget.swipetoload.YMSwipeToLoadLayout
import a.yumi.lib.router.IWAService
import a.yumi.lib.router.RouterConfig
import a.yumi.module.wandroid.IWAMain
import a.yumi.module.wandroid.R
import a.yumi.module.wandroid.WAMainPresenter
import a.yumi.module.wandroid.bean.base.WAListData
import a.yumi.module.wandroid.bean.biz.home.WAArticleItem
import a.yumi.module.wandroid.bean.biz.home.WABannerItem
import a.yumi.module.wandroid.ui.home.article.adapter.WAHomeArticleAdapter
import android.content.Context
import android.os.Bundle
import android.view.View
import android.widget.ImageView
import com.alibaba.android.arouter.facade.annotation.Route
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.listener.OnItemClickListener
import com.youth.banner.Banner
import com.youth.banner.BannerConfig
import com.youth.banner.listener.OnBannerListener
import com.youth.banner.loader.ImageLoaderInterface
import kotlinx.android.synthetic.main.module_wa_simple_list.*

/**
 * PS:
 * Created by sdx on 2019-04-29.
 */
@Route(path = RouterConfig.Wandroid.Main3)
class WAHomeArticleFragment
    : BaseMVPFragment<IWAMain, WAMainPresenter>(),
    IWAMain, IWAService.MainFragment {

    val bannerView by lazy {
        val view = layoutInflater.inflate(R.layout.module_wa_simple_header_list_activity, swipe_to_load, false)
        banner = view.findViewById<Banner>(R.id.banner)
        banner?.apply {
            setBannerStyle(BannerConfig.NOT_INDICATOR)
                .isAutoPlay(true)
                .setDelayTime(5000)
                .setImageLoader(ImageLoader())
                .setOnBannerListener(onBannerListener)
//                .setOnPageChangeListener(onBannerPageChangeListener)
        }
        view
    }

    var banner: Banner? = null

    private val mAdapter by lazy { WAHomeArticleAdapter() }


    override fun initPresenter(): WAMainPresenter = WAMainPresenter(this)

    override fun getLayoutId(): Int = R.layout.module_wa_simple_list

    override fun bindView(view: View, bundle: Bundle?) {
        swipe_to_load.apply {
            setListener(object : YMSwipeToLoadLayout.Listener {
                override fun getDataByPage(page0: Int, page1: Int) {
                    mPresenter.queryList(page0)
                }
            })
            addOnItemListener(object : OnItemClickListener() {
                override fun onSimpleItemClick(adapter: BaseQuickAdapter<*, *>, view: View, position: Int) {
                }

                override fun onItemChildClick(adapter: BaseQuickAdapter<*, *>, view: View, position: Int) {
                    super.onItemChildClick(adapter, view, position)
                    val item = adapter.getItem(position)
                    if (item is WAArticleItem) {
                        when (view.id) {
                            R.id.img_collect -> {
                                loge("img_collect")
                            }
                        }
                    }
                }
            })
            setAdapter(mAdapter)
            mAdapter.addHeaderView(bannerView)
        }
    }

    override fun initData() {
        swipe_to_load.autoRefresh()
    }

    override fun articleList(data: WAListData<WAArticleItem>?) {
        swipe_to_load.setListData(data = data)
    }

    override fun bannerList(data: List<WABannerItem>?) {

        banner?.update(data)
    }

    override fun refresh() {
        initData()
    }

    private val onBannerListener = OnBannerListener { position ->
        try {
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    private class ImageLoader : ImageLoaderInterface<ImageView> {
        override fun displayImage(context: Context, path: Any, imageView: ImageView) {
            val item = path as? WABannerItem ?: WABannerItem()
            imageView.loadUrl(item.imagePath)
        }

        //提供createImageView 方法，如果不用可以不重写这个方法，主要是方便自定义ImageView的创建
        override fun createImageView(context: Context): ImageView {
            return ImageView(context)
        }
    }
}
