package a.yumi.module.wandroid.api

import a.yumi.lib.base.http.RetrofitUtil
import a.yumi.module.wandroid.bean.base.WAListData
import a.yumi.module.wandroid.bean.base.WAResponse
import a.yumi.module.wandroid.bean.biz.home.WAArticleItem
import a.yumi.module.wandroid.bean.biz.home.WABannerItem
import io.reactivex.Observable
import retrofit2.http.GET
import retrofit2.http.Path

/**
 * PS:
 * Created by sdx on 2019-04-28.
 */
interface WAndroidApi {

    companion object {
        private const val URL = "https://www.wanandroid.com/"

        val instance: WAndroidApi by lazy { RetrofitUtil.get(URL).create(WAndroidApi::class.java) }
    }

    @GET("article/chapters/json")
    fun getwx(): Observable<WAResponse<WAListData<WAArticleItem>>>

    /**
     * 1.1 首页文章列表
     * https://www.wanandroid.com/article/list/0/json
     * 方法：GET
     * 参数：页码，拼接在连接中，从0开始。
     */
    @GET("article/list/{id}/json")
    fun articleList(@Path("id") id: Int): Observable<WAResponse<WAListData<WAArticleItem>>>

    /**
     * 1.2 首页banner
     * https://www.wanandroid.com/banner/json
     * 方法：GET
     * 参数：无
     */
    @GET("banner/json")
    fun banner(): Observable<WAResponse<List<WABannerItem>>>

    /**
     * 1.5 置顶文章
     * https://www.wanandroid.com/article/top/json
     */
    @GET("article/top/json")
    fun articleTopList(): Observable<WAResponse<List<WAArticleItem>>>

}