package a.yumi.module.wandroid

import a.yumi.lib.base.frame.mvp.BaseMVPPresenter
import a.yumi.module.wandroid.api.WAndroidApi
import a.yumi.module.wandroid.bean.base.WAListData
import a.yumi.module.wandroid.bean.base.WAResponse
import a.yumi.module.wandroid.bean.biz.home.WAArticleItem
import a.yumi.module.wandroid.bean.biz.home.WABannerItem
import io.reactivex.Observable
import io.reactivex.Observer
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import io.reactivex.functions.BiFunction
import io.reactivex.functions.Function3
import io.reactivex.schedulers.Schedulers

/**
 * PS:
 */
class WAMainPresenter(v: IWAMain) : BaseMVPPresenter<IWAMain>(v) {
    fun queryList(pageStart0: Int) {
        when (pageStart0) {
            0 -> {
                getDataTop(pageStart0)
            }
            else -> {
                getDataList(pageStart0)
            }
        }
    }

    private fun getDataList(pageStart0: Int) {
        WAndroidApi.instance
            .articleList(pageStart0)
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(object : Observer<WAResponse<WAListData<WAArticleItem>>> {
                override fun onComplete() {
                }

                override fun onSubscribe(d: Disposable) {
                }

                override fun onNext(t: WAResponse<WAListData<WAArticleItem>>) {
                    mView?.articleList(t.data)
                }

                override fun onError(e: Throwable) {
                    mView?.articleList(null)
                }
            })
    }

    private fun getDataTop(pageStart0: Int) {
        val banner = WAndroidApi.instance.banner()
        val articleTopList = WAndroidApi.instance
            .articleTopList()
        val articleList = WAndroidApi.instance
            .articleList(pageStart0)
        Observable.zip(
            banner,
            articleTopList,
            articleList,
            Function3<WAResponse<List<WABannerItem>>,
                    WAResponse<List<WAArticleItem>>,
                    WAResponse<WAListData<WAArticleItem>>,
                    DataTop> { t0, t1, t2 ->
                val list = mutableListOf<WAArticleItem>()
                list.addAll(t1.data ?: emptyList())
                list.addAll(t2.data?.datas ?: emptyList())
                t2.data?.datas = list
                DataTop(t0.data, t2.data)
            })
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(object : Observer<DataTop> {
                override fun onComplete() {
                }

                override fun onSubscribe(d: Disposable) {
                }

                override fun onNext(t: DataTop) {
                    mView?.bannerList(t.banner)

                    mView?.articleList(t.article)
                }

                override fun onError(e: Throwable) {
                    mView?.articleList(null)
                }
            })
    }

    private data class DataTop(
        var banner: List<WABannerItem>? = null,
        var article: WAListData<WAArticleItem>? = null
    )
}