package a.yumi.module.wandroid

import a.yumi.lib.base.frame.mvp.BaseMVPActivity
import a.yumi.lib.base.util.log.loge
import a.yumi.lib.router.IWAService
import a.yumi.lib.router.RouterConfig
import a.yumi.lib.router.RouterUtil
import android.os.Bundle
import com.alibaba.android.arouter.facade.annotation.Route
import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import java.util.*
import java.util.concurrent.TimeUnit


/**
 * PS:
 * Created by sdx on 2019-04-23.
 */
@Route(path = RouterConfig.Wandroid.Main2)
class WAMainActivity2 : BaseMVPActivity<Nothing, Nothing>() {
    override fun initPresenter(): Nothing? = null

    override fun getLayout(): Int = R.layout.module_wa_simple_list_activity

    override fun bindView(bundle: Bundle?) {
    }

    override fun initData() {

        val fragment = RouterUtil.navigationFragment(RouterConfig.Wandroid.Main3)
        fragment?:return
        val supportFragmentManager = supportFragmentManager
        val fragmentTransaction = supportFragmentManager.beginTransaction()
        fragmentTransaction.add(R.id.fragment, fragment)
        fragmentTransaction.hide(fragment)
        fragmentTransaction.show(fragment)
        fragmentTransaction.commit()

        val subscribe = Observable.interval(5, TimeUnit.SECONDS)
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .compose(bindToLifecycle())
            .subscribe {
                loge("mainFragment.refresh")
                val mainFragment = fragment as IWAService.MainFragment
                mainFragment.refresh()
            }
    }
}