package a.yumi.lib.base.ui.simple

import a.yumi.lib.base.R
import a.yumi.lib.base.frame.mvp.BaseMVPActivity
import a.yumi.lib.base.ui.BaseActivity
import a.yumi.lib.base.util.dp2px
import a.yumi.lib.base.util.img.loadRes
import a.yumi.lib.base.widget.swipetoload.decoration.CommItemGirdDecoration
import android.graphics.Color
import android.os.Bundle
import android.support.annotation.DrawableRes
import android.support.v7.widget.GridLayoutManager
import android.view.View
import android.widget.ImageView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.chad.library.adapter.base.listener.OnItemClickListener
import kotlinx.android.synthetic.main.ym_simple_menu_activity.*

/**
 * PS:
 * Created by sdx on 2019-06-17.
 */
abstract class BaseMenuActivity : BaseMVPActivity<Nothing, Nothing>() {
    private val mAdapter = MyAdapter()

    override fun getLayout(): Int = R.layout.ym_simple_menu_activity

    override fun initPresenter(): Nothing?  = null

    override fun bindView(bundle: Bundle?) {
        recycler_view.apply {
            layoutManager = GridLayoutManager(this@BaseMenuActivity, 4)
            addItemDecoration(CommItemGirdDecoration(verticalSpace = dp2px(5F)))
            addOnItemTouchListener(menuTouchListener)
            adapter = mAdapter
        }
    }

    override fun initData() {
        toolbar.setTitle(getToolBarTitle())
        mAdapter.setNewData(getMenuData())
    }

    /**
     * 菜单 点击
     */
    private val menuTouchListener = object : OnItemClickListener() {
        override fun onSimpleItemClick(adapter: BaseQuickAdapter<*, *>, view: View, position: Int) {
            val item = adapter.getItem(position)
            if (item is BaseMenuItem) {
                onClickMenu(item.name)
            }
        }
    }

    private inner class MyAdapter :
        BaseQuickAdapter<BaseMenuItem, BaseViewHolder>(R.layout.ym_simple_menu_item) {

        override fun convert(helper: BaseViewHolder, item: BaseMenuItem) {
            val view = helper.getView<ImageView>(R.id.ic_menu)
            view.loadRes(item.iconResId)
            helper.setText(R.id.name_menu, item.name)
        }
    }

    protected abstract fun getToolBarTitle(): String
    protected abstract fun getMenuData(): MutableList<BaseMenuItem>
    protected abstract fun onClickMenu(menu: String)
}

data class BaseMenuItem
@JvmOverloads constructor(
    var name: String = "",
    @DrawableRes
    var iconResId: Int = R.mipmap.ic_launcher
)