if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/aui-widget-responsive/aui-widget-responsive.js']) {
   __coverage__['build/aui-widget-responsive/aui-widget-responsive.js'] = {"path":"build/aui-widget-responsive/aui-widget-responsive.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":33},"end":{"line":1,"column":52}}},"2":{"name":"WidgetResponsive","line":24,"loc":{"start":{"line":24,"column":0},"end":{"line":24,"column":28}}},"3":{"name":"(anonymous_3)","line":34,"loc":{"start":{"line":34,"column":17},"end":{"line":34,"column":28}}},"4":{"name":"(anonymous_4)","line":63,"loc":{"start":{"line":63,"column":16},"end":{"line":63,"column":27}}},"5":{"name":"(anonymous_5)","line":72,"loc":{"start":{"line":72,"column":22},"end":{"line":72,"column":33}}},"6":{"name":"(anonymous_6)","line":83,"loc":{"start":{"line":83,"column":34},"end":{"line":83,"column":45}}},"7":{"name":"(anonymous_7)","line":96,"loc":{"start":{"line":96,"column":34},"end":{"line":96,"column":45}}},"8":{"name":"(anonymous_8)","line":124,"loc":{"start":{"line":124,"column":22},"end":{"line":124,"column":33}}},"9":{"name":"(anonymous_9)","line":134,"loc":{"start":{"line":134,"column":21},"end":{"line":134,"column":32}}},"10":{"name":"(anonymous_10)","line":147,"loc":{"start":{"line":147,"column":22},"end":{"line":147,"column":38}}},"11":{"name":"(anonymous_11)","line":203,"loc":{"start":{"line":203,"column":23},"end":{"line":203,"column":34}}},"12":{"name":"(anonymous_12)","line":225,"loc":{"start":{"line":225,"column":19},"end":{"line":225,"column":35}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":270,"column":73}},"2":{"start":{"line":24,"column":0},"end":{"line":24,"column":30}},"3":{"start":{"line":26,"column":0},"end":{"line":212,"column":2}},"4":{"start":{"line":35,"column":8},"end":{"line":47,"column":10}},"5":{"start":{"line":49,"column":8},"end":{"line":53,"column":11}},"6":{"start":{"line":64,"column":8},"end":{"line":64,"column":67}},"7":{"start":{"line":73,"column":8},"end":{"line":73,"column":33}},"8":{"start":{"line":84,"column":8},"end":{"line":84,"column":40}},"9":{"start":{"line":85,"column":8},"end":{"line":85,"column":32}},"10":{"start":{"line":97,"column":8},"end":{"line":98,"column":40}},"11":{"start":{"line":100,"column":8},"end":{"line":113,"column":9}},"12":{"start":{"line":101,"column":12},"end":{"line":103,"column":15}},"13":{"start":{"line":105,"column":12},"end":{"line":108,"column":14}},"14":{"start":{"line":110,"column":12},"end":{"line":112,"column":15}},"15":{"start":{"line":115,"column":8},"end":{"line":115,"column":40}},"16":{"start":{"line":125,"column":8},"end":{"line":125,"column":74}},"17":{"start":{"line":135,"column":8},"end":{"line":135,"column":72}},"18":{"start":{"line":148,"column":8},"end":{"line":150,"column":9}},"19":{"start":{"line":149,"column":12},"end":{"line":149,"column":19}},"20":{"start":{"line":152,"column":8},"end":{"line":160,"column":52}},"21":{"start":{"line":162,"column":8},"end":{"line":162,"column":51}},"22":{"start":{"line":163,"column":8},"end":{"line":163,"column":53}},"23":{"start":{"line":165,"column":8},"end":{"line":165,"column":64}},"24":{"start":{"line":166,"column":8},"end":{"line":166,"column":62}},"25":{"start":{"line":168,"column":8},"end":{"line":171,"column":9}},"26":{"start":{"line":169,"column":12},"end":{"line":169,"column":69}},"27":{"start":{"line":170,"column":12},"end":{"line":170,"column":90}},"28":{"start":{"line":173,"column":8},"end":{"line":175,"column":9}},"29":{"start":{"line":174,"column":12},"end":{"line":174,"column":79}},"30":{"start":{"line":176,"column":8},"end":{"line":178,"column":9}},"31":{"start":{"line":177,"column":12},"end":{"line":177,"column":76}},"32":{"start":{"line":180,"column":8},"end":{"line":185,"column":9}},"33":{"start":{"line":181,"column":12},"end":{"line":184,"column":14}},"34":{"start":{"line":187,"column":8},"end":{"line":187,"column":50}},"35":{"start":{"line":188,"column":8},"end":{"line":188,"column":48}},"36":{"start":{"line":190,"column":8},"end":{"line":190,"column":63}},"37":{"start":{"line":191,"column":8},"end":{"line":191,"column":61}},"38":{"start":{"line":193,"column":8},"end":{"line":193,"column":33}},"39":{"start":{"line":194,"column":8},"end":{"line":194,"column":31}},"40":{"start":{"line":204,"column":8},"end":{"line":205,"column":40}},"41":{"start":{"line":207,"column":8},"end":{"line":210,"column":11}},"42":{"start":{"line":214,"column":0},"end":{"line":265,"column":2}},"43":{"start":{"line":226,"column":12},"end":{"line":226,"column":63}},"44":{"start":{"line":267,"column":0},"end":{"line":267,"column":38}}},"branchMap":{"1":{"line":100,"type":"if","locations":[{"start":{"line":100,"column":8},"end":{"line":100,"column":8}},{"start":{"line":100,"column":8},"end":{"line":100,"column":8}}]},"2":{"line":125,"type":"binary-expr","locations":[{"start":{"line":125,"column":15},"end":{"line":125,"column":44}},{"start":{"line":125,"column":48},"end":{"line":125,"column":73}}]},"3":{"line":135,"type":"binary-expr","locations":[{"start":{"line":135,"column":15},"end":{"line":135,"column":43}},{"start":{"line":135,"column":47},"end":{"line":135,"column":71}}]},"4":{"line":148,"type":"if","locations":[{"start":{"line":148,"column":8},"end":{"line":148,"column":8}},{"start":{"line":148,"column":8},"end":{"line":148,"column":8}}]},"5":{"line":168,"type":"if","locations":[{"start":{"line":168,"column":8},"end":{"line":168,"column":8}},{"start":{"line":168,"column":8},"end":{"line":168,"column":8}}]},"6":{"line":168,"type":"binary-expr","locations":[{"start":{"line":168,"column":12},"end":{"line":168,"column":35}},{"start":{"line":168,"column":39},"end":{"line":168,"column":64}}]},"7":{"line":173,"type":"if","locations":[{"start":{"line":173,"column":8},"end":{"line":173,"column":8}},{"start":{"line":173,"column":8},"end":{"line":173,"column":8}}]},"8":{"line":176,"type":"if","locations":[{"start":{"line":176,"column":8},"end":{"line":176,"column":8}},{"start":{"line":176,"column":8},"end":{"line":176,"column":8}}]},"9":{"line":180,"type":"if","locations":[{"start":{"line":180,"column":8},"end":{"line":180,"column":8}},{"start":{"line":180,"column":8},"end":{"line":180,"column":8}}]},"10":{"line":180,"type":"binary-expr","locations":[{"start":{"line":180,"column":12},"end":{"line":180,"column":31}},{"start":{"line":180,"column":35},"end":{"line":180,"column":56}}]},"11":{"line":226,"type":"binary-expr","locations":[{"start":{"line":226,"column":19},"end":{"line":226,"column":40}},{"start":{"line":226,"column":44},"end":{"line":226,"column":62}}]}},"code":["(function () { YUI.add('aui-widget-responsive', function (A, NAME) {","","/**"," * Provides support for making a widget responsive. This is specially"," * useful when the width/height ratio should be preserved, which happens"," * when dealing with images for example."," *"," * @module aui-widget-responsive"," */","","/**"," * Fired when the widget will be updated to be responsive."," *"," * @event responsive"," */","","/**"," * Widget extension, which can be used to add responsive support to the base"," * Widget class, through the [Base.build](Base.html#method_build) method."," *"," * @class A.WidgetResponsive"," * @param {Object} The user configuration object"," */","function WidgetResponsive() {}","","WidgetResponsive.prototype = {","    /**","     * Construction logic executed during instantiation.","     * Lifecycle.","     *","     * @method initializer","     * @protected","     */","    initializer: function() {","        this._responsiveEventHandles = [","            A.after(this._handleResponsive, this, '_uiSetHeight'),","            A.after(this._handleResponsive, this, '_uiSetVisible'),","            A.after(this._handleResponsive, this, '_uiSetWidth'),","            this.after({","                gutterChange: this._handleResponsive,","                maxHeightChange: this._handleResponsive,","                maxWidthChange: this._handleResponsive,","                preserveRatioChange: this._handleResponsive,","                render: this._handleResponsive","            }),","            A.after('windowresize', A.bind(this._handleResponsive, this))","        ];","","        this.publish({","            responsive: {","                defaultFn: this._defResponsiveFn","            }","        });","    },","","    /**","     * Destructor implementation.","     * Lifecycle.","     *","     * @method destructor","     * @protected","     */","    destructor: function() {","        (new A.EventHandle(this._responsiveEventHandles)).detach();","    },","","    /**","     * Updates the widget's dimensions so that it will fit the page better.","     *","     * @method updateDimensions","     */","    updateDimensions: function() {","        this._handleResponsive();","    },","","    /**","     * Updates the widget's dimensions like the `updateDimensions` method, but","     * also recalculates the ratio to be preserved. Useful if the visible content","     * of the widget has changed causing the ratio to change as well.","     *","     * @method updateDimensionsWithNewRatio","     */","    updateDimensionsWithNewRatio: function() {","        this._originalDimensions = null;","        this.updateDimensions();","    },","","    /**","     * Calculates the original width and height of the widget, which will be","     * used when changing its dimensions to preserve its ratio.","     *","     * @method _calculateOriginalDimensions","     * @return {Object} An object with the original dimensions","     * @protected","     */","    _calculateOriginalDimensions: function() {","        var boundingBox = this.get('boundingBox'),","            gutter = this.get('gutter');","","        if (!this._originalDimensions) {","            boundingBox.setStyles({","                display: 'inline-block'","            });","","            this._originalDimensions = {","                height: boundingBox.get('offsetHeight') - gutter[1],","                width: boundingBox.get('offsetWidth') - gutter[0]","            };","","            boundingBox.setStyles({","                display: ''","            });","        }","","        return this._originalDimensions;","    },","","    /**","     * Checks if the height can be manually changed.","     *","     * @method _canChangeHeight","     * @return {Boolean}","     */","    _canChangeHeight: function() {","        return this.get('height') === 'auto' || this.get('height') === '';","    },","","    /**","     * Checks if the width can be manually changed.","     *","     * @method _canChangeWidth","     * @return {Boolean}","     */","    _canChangeWidth: function() {","        return this.get('width') === 'auto' || this.get('width') === '';","    },","","    /**","     * Default behavior for the `responsive` event. It updates the dimensions of","     * the widget so it will respect the `preserveRatio`, `maxHeight` and `maxWidth`","     * attributes.","     *","     * @method _defResponsiveFn","     * @param {EventFacade} event","     * @protected","     */","    _defResponsiveFn: function(event) {","        if (!this.get('visible')) {","            return;","        }","","        var boundingBox = this.get('boundingBox'),","            gutter = this.get('gutter'),","            maxHeight = this.get('maxHeight'),","            maxWidth = this.get('maxWidth'),","            newHeight,","            newWidth,","            originalDimensions,","            ratio = 1,","            viewportRegion = A.DOM.viewportRegion();","","        this._uiSetDim('width', this.get('width'));","        this._uiSetDim('height', this.get('height'));","","        newHeight = boundingBox.get('offsetHeight') - gutter[1];","        newWidth = boundingBox.get('offsetWidth') - gutter[0];","","        if (this._canChangeHeight() && this.get('preserveRatio')) {","            originalDimensions = this._calculateOriginalDimensions();","            newHeight = (originalDimensions.height * newWidth) / originalDimensions.width;","        }","","        if (this._canChangeHeight()) {","            maxHeight = Math.min(maxHeight, viewportRegion.height) - gutter[1];","        }","        if (this._canChangeWidth()) {","            maxWidth = Math.min(maxWidth, viewportRegion.width) - gutter[0];","        }","","        if (newWidth > maxWidth || newHeight > maxHeight) {","            ratio = Math.min(","                maxHeight / newHeight,","                maxWidth / newWidth","            );","        }","","        newHeight = Math.floor(newHeight * ratio);","        newWidth = Math.floor(newWidth * ratio);","","        boundingBox.set('offsetHeight', newHeight + gutter[1]);","        boundingBox.set('offsetWidth', newWidth + gutter[0]);","","        event.height = newHeight;","        event.width = newWidth;","    },","","    /**","     * Fires the `responsive` event.","     *","     * @method _handleResponsive","     * @protected","     */","    _handleResponsive: function() {","        var boundingBox = this.get('boundingBox'),","            gutter = this.get('gutter');","","        this.fire('responsive', {","            height: boundingBox.get('offsetHeight') - gutter[1],","            width: boundingBox.get('offsetWidth') - gutter[0]","        });","    }","};","","WidgetResponsive.ATTRS = {","    /**","     * Vertical and horizontal values in pixels that should not be counted","     * when preserving the widget's ratio. widget.","     *","     * @attribute gutter","     * @default [0, 0]","     * @type Array","     */","    gutter: {","        value: [0, 0],","        validator: function(value) {","            return A.Lang.isArray(value) && value.length === 2;","        }","    },","","    /**","     * The maximum height of the widget.","     *","     * @attribute maxHeight","     * @default Infinity","     * @type Number","     */","    maxHeight: {","        value: Infinity,","        validator: A.Lang.isNumber","    },","","    /**","     * The maximum width of the widget.","     *","     * @attribute maxWidth","     * @default Infinity","     * @type Number","     */","    maxWidth: {","        value: Infinity,","        validator: A.Lang.isNumber","    },","","    /**","     * Flag to indicate if the width/height ratio should be preserved.","     *","     * @attribute preserveRatio","     * @default true","     * @type Boolean","     */","    preserveRatio: {","        value: true,","        validator: A.Lang.isBoolean","    }","};","","A.WidgetResponsive = WidgetResponsive;","","","}, '3.1.0-deprecated.94', {\"requires\": [\"event-resize\", \"widget-base\"]});","","}());"]};
}
var __cov_jhDkA6_B2VBNxI2oKdzwLg = __coverage__['build/aui-widget-responsive/aui-widget-responsive.js'];
__cov_jhDkA6_B2VBNxI2oKdzwLg.s['1']++;YUI.add('aui-widget-responsive',function(A,NAME){__cov_jhDkA6_B2VBNxI2oKdzwLg.f['1']++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['2']++;function WidgetResponsive(){__cov_jhDkA6_B2VBNxI2oKdzwLg.f['2']++;}__cov_jhDkA6_B2VBNxI2oKdzwLg.s['3']++;WidgetResponsive.prototype={initializer:function(){__cov_jhDkA6_B2VBNxI2oKdzwLg.f['3']++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['4']++;this._responsiveEventHandles=[A.after(this._handleResponsive,this,'_uiSetHeight'),A.after(this._handleResponsive,this,'_uiSetVisible'),A.after(this._handleResponsive,this,'_uiSetWidth'),this.after({gutterChange:this._handleResponsive,maxHeightChange:this._handleResponsive,maxWidthChange:this._handleResponsive,preserveRatioChange:this._handleResponsive,render:this._handleResponsive}),A.after('windowresize',A.bind(this._handleResponsive,this))];__cov_jhDkA6_B2VBNxI2oKdzwLg.s['5']++;this.publish({responsive:{defaultFn:this._defResponsiveFn}});},destructor:function(){__cov_jhDkA6_B2VBNxI2oKdzwLg.f['4']++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['6']++;new A.EventHandle(this._responsiveEventHandles).detach();},updateDimensions:function(){__cov_jhDkA6_B2VBNxI2oKdzwLg.f['5']++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['7']++;this._handleResponsive();},updateDimensionsWithNewRatio:function(){__cov_jhDkA6_B2VBNxI2oKdzwLg.f['6']++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['8']++;this._originalDimensions=null;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['9']++;this.updateDimensions();},_calculateOriginalDimensions:function(){__cov_jhDkA6_B2VBNxI2oKdzwLg.f['7']++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['10']++;var boundingBox=this.get('boundingBox'),gutter=this.get('gutter');__cov_jhDkA6_B2VBNxI2oKdzwLg.s['11']++;if(!this._originalDimensions){__cov_jhDkA6_B2VBNxI2oKdzwLg.b['1'][0]++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['12']++;boundingBox.setStyles({display:'inline-block'});__cov_jhDkA6_B2VBNxI2oKdzwLg.s['13']++;this._originalDimensions={height:boundingBox.get('offsetHeight')-gutter[1],width:boundingBox.get('offsetWidth')-gutter[0]};__cov_jhDkA6_B2VBNxI2oKdzwLg.s['14']++;boundingBox.setStyles({display:''});}else{__cov_jhDkA6_B2VBNxI2oKdzwLg.b['1'][1]++;}__cov_jhDkA6_B2VBNxI2oKdzwLg.s['15']++;return this._originalDimensions;},_canChangeHeight:function(){__cov_jhDkA6_B2VBNxI2oKdzwLg.f['8']++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['16']++;return(__cov_jhDkA6_B2VBNxI2oKdzwLg.b['2'][0]++,this.get('height')==='auto')||(__cov_jhDkA6_B2VBNxI2oKdzwLg.b['2'][1]++,this.get('height')==='');},_canChangeWidth:function(){__cov_jhDkA6_B2VBNxI2oKdzwLg.f['9']++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['17']++;return(__cov_jhDkA6_B2VBNxI2oKdzwLg.b['3'][0]++,this.get('width')==='auto')||(__cov_jhDkA6_B2VBNxI2oKdzwLg.b['3'][1]++,this.get('width')==='');},_defResponsiveFn:function(event){__cov_jhDkA6_B2VBNxI2oKdzwLg.f['10']++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['18']++;if(!this.get('visible')){__cov_jhDkA6_B2VBNxI2oKdzwLg.b['4'][0]++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['19']++;return;}else{__cov_jhDkA6_B2VBNxI2oKdzwLg.b['4'][1]++;}__cov_jhDkA6_B2VBNxI2oKdzwLg.s['20']++;var boundingBox=this.get('boundingBox'),gutter=this.get('gutter'),maxHeight=this.get('maxHeight'),maxWidth=this.get('maxWidth'),newHeight,newWidth,originalDimensions,ratio=1,viewportRegion=A.DOM.viewportRegion();__cov_jhDkA6_B2VBNxI2oKdzwLg.s['21']++;this._uiSetDim('width',this.get('width'));__cov_jhDkA6_B2VBNxI2oKdzwLg.s['22']++;this._uiSetDim('height',this.get('height'));__cov_jhDkA6_B2VBNxI2oKdzwLg.s['23']++;newHeight=boundingBox.get('offsetHeight')-gutter[1];__cov_jhDkA6_B2VBNxI2oKdzwLg.s['24']++;newWidth=boundingBox.get('offsetWidth')-gutter[0];__cov_jhDkA6_B2VBNxI2oKdzwLg.s['25']++;if((__cov_jhDkA6_B2VBNxI2oKdzwLg.b['6'][0]++,this._canChangeHeight())&&(__cov_jhDkA6_B2VBNxI2oKdzwLg.b['6'][1]++,this.get('preserveRatio'))){__cov_jhDkA6_B2VBNxI2oKdzwLg.b['5'][0]++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['26']++;originalDimensions=this._calculateOriginalDimensions();__cov_jhDkA6_B2VBNxI2oKdzwLg.s['27']++;newHeight=originalDimensions.height*newWidth/originalDimensions.width;}else{__cov_jhDkA6_B2VBNxI2oKdzwLg.b['5'][1]++;}__cov_jhDkA6_B2VBNxI2oKdzwLg.s['28']++;if(this._canChangeHeight()){__cov_jhDkA6_B2VBNxI2oKdzwLg.b['7'][0]++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['29']++;maxHeight=Math.min(maxHeight,viewportRegion.height)-gutter[1];}else{__cov_jhDkA6_B2VBNxI2oKdzwLg.b['7'][1]++;}__cov_jhDkA6_B2VBNxI2oKdzwLg.s['30']++;if(this._canChangeWidth()){__cov_jhDkA6_B2VBNxI2oKdzwLg.b['8'][0]++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['31']++;maxWidth=Math.min(maxWidth,viewportRegion.width)-gutter[0];}else{__cov_jhDkA6_B2VBNxI2oKdzwLg.b['8'][1]++;}__cov_jhDkA6_B2VBNxI2oKdzwLg.s['32']++;if((__cov_jhDkA6_B2VBNxI2oKdzwLg.b['10'][0]++,newWidth>maxWidth)||(__cov_jhDkA6_B2VBNxI2oKdzwLg.b['10'][1]++,newHeight>maxHeight)){__cov_jhDkA6_B2VBNxI2oKdzwLg.b['9'][0]++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['33']++;ratio=Math.min(maxHeight/newHeight,maxWidth/newWidth);}else{__cov_jhDkA6_B2VBNxI2oKdzwLg.b['9'][1]++;}__cov_jhDkA6_B2VBNxI2oKdzwLg.s['34']++;newHeight=Math.floor(newHeight*ratio);__cov_jhDkA6_B2VBNxI2oKdzwLg.s['35']++;newWidth=Math.floor(newWidth*ratio);__cov_jhDkA6_B2VBNxI2oKdzwLg.s['36']++;boundingBox.set('offsetHeight',newHeight+gutter[1]);__cov_jhDkA6_B2VBNxI2oKdzwLg.s['37']++;boundingBox.set('offsetWidth',newWidth+gutter[0]);__cov_jhDkA6_B2VBNxI2oKdzwLg.s['38']++;event.height=newHeight;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['39']++;event.width=newWidth;},_handleResponsive:function(){__cov_jhDkA6_B2VBNxI2oKdzwLg.f['11']++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['40']++;var boundingBox=this.get('boundingBox'),gutter=this.get('gutter');__cov_jhDkA6_B2VBNxI2oKdzwLg.s['41']++;this.fire('responsive',{height:boundingBox.get('offsetHeight')-gutter[1],width:boundingBox.get('offsetWidth')-gutter[0]});}};__cov_jhDkA6_B2VBNxI2oKdzwLg.s['42']++;WidgetResponsive.ATTRS={gutter:{value:[0,0],validator:function(value){__cov_jhDkA6_B2VBNxI2oKdzwLg.f['12']++;__cov_jhDkA6_B2VBNxI2oKdzwLg.s['43']++;return(__cov_jhDkA6_B2VBNxI2oKdzwLg.b['11'][0]++,A.Lang.isArray(value))&&(__cov_jhDkA6_B2VBNxI2oKdzwLg.b['11'][1]++,value.length===2);}},maxHeight:{value:Infinity,validator:A.Lang.isNumber},maxWidth:{value:Infinity,validator:A.Lang.isNumber},preserveRatio:{value:true,validator:A.Lang.isBoolean}};__cov_jhDkA6_B2VBNxI2oKdzwLg.s['44']++;A.WidgetResponsive=WidgetResponsive;},'3.1.0-deprecated.94',{'requires':['event-resize','widget-base']});
