if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/recordset-sort/recordset-sort.js']) {
   __coverage__['build/recordset-sort/recordset-sort.js'] = {"path":"build/recordset-sort/recordset-sort.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0},"b":{"1":[0,0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":26},"end":{"line":1,"column":45}}},"2":{"name":"RecordsetSort","line":17,"loc":{"start":{"line":17,"column":0},"end":{"line":17,"column":44}}},"3":{"name":"(anonymous_3)","line":41,"loc":{"start":{"line":41,"column":23},"end":{"line":41,"column":35}}},"4":{"name":"(anonymous_4)","line":56,"loc":{"start":{"line":56,"column":19},"end":{"line":56,"column":53}}},"5":{"name":"(anonymous_5)","line":88,"loc":{"start":{"line":88,"column":17},"end":{"line":88,"column":34}}},"6":{"name":"(anonymous_6)","line":101,"loc":{"start":{"line":101,"column":8},"end":{"line":101,"column":19}}},"7":{"name":"(anonymous_7)","line":106,"loc":{"start":{"line":106,"column":8},"end":{"line":106,"column":19}}},"8":{"name":"(anonymous_8)","line":111,"loc":{"start":{"line":111,"column":8},"end":{"line":111,"column":19}}},"9":{"name":"(anonymous_9)","line":118,"loc":{"start":{"line":118,"column":16},"end":{"line":118,"column":33}}},"10":{"name":"(anonymous_10)","line":129,"loc":{"start":{"line":129,"column":16},"end":{"line":129,"column":28}}},"11":{"name":"(anonymous_11)","line":131,"loc":{"start":{"line":131,"column":37},"end":{"line":131,"column":52}}},"12":{"name":"(anonymous_12)","line":146,"loc":{"start":{"line":146,"column":10},"end":{"line":146,"column":40}}},"13":{"name":"(anonymous_13)","line":160,"loc":{"start":{"line":160,"column":12},"end":{"line":160,"column":23}}},"14":{"name":"(anonymous_14)","line":175,"loc":{"start":{"line":175,"column":13},"end":{"line":175,"column":24}}},"15":{"name":"(anonymous_15)","line":185,"loc":{"start":{"line":185,"column":10},"end":{"line":185,"column":21}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":205,"column":73}},"2":{"start":{"line":9,"column":0},"end":{"line":10,"column":25}},"3":{"start":{"line":17,"column":0},"end":{"line":19,"column":1}},"4":{"start":{"line":18,"column":4},"end":{"line":18,"column":64}},"5":{"start":{"line":21,"column":0},"end":{"line":78,"column":3}},"6":{"start":{"line":42,"column":16},"end":{"line":42,"column":82}},"7":{"start":{"line":57,"column":16},"end":{"line":57,"column":87}},"8":{"start":{"line":58,"column":16},"end":{"line":63,"column":17}},"9":{"start":{"line":59,"column":20},"end":{"line":59,"column":73}},"10":{"start":{"line":62,"column":20},"end":{"line":62,"column":34}},"11":{"start":{"line":80,"column":0},"end":{"line":199,"column":3}},"12":{"start":{"line":90,"column":8},"end":{"line":91,"column":32}},"13":{"start":{"line":94,"column":8},"end":{"line":96,"column":11}},"14":{"start":{"line":100,"column":8},"end":{"line":103,"column":11}},"15":{"start":{"line":102,"column":12},"end":{"line":102,"column":39}},"16":{"start":{"line":105,"column":8},"end":{"line":109,"column":14}},"17":{"start":{"line":107,"column":12},"end":{"line":107,"column":40}},"18":{"start":{"line":110,"column":8},"end":{"line":114,"column":14}},"19":{"start":{"line":112,"column":12},"end":{"line":112,"column":40}},"20":{"start":{"line":131,"column":8},"end":{"line":133,"column":11}},"21":{"start":{"line":132,"column":12},"end":{"line":132,"column":53}},"22":{"start":{"line":135,"column":8},"end":{"line":135,"column":42}},"23":{"start":{"line":147,"column":8},"end":{"line":151,"column":11}},"24":{"start":{"line":161,"column":8},"end":{"line":161,"column":47}},"25":{"start":{"line":162,"column":8},"end":{"line":166,"column":11}},"26":{"start":{"line":176,"column":8},"end":{"line":176,"column":42}},"27":{"start":{"line":186,"column":8},"end":{"line":186,"column":47}},"28":{"start":{"line":189,"column":8},"end":{"line":197,"column":9}},"29":{"start":{"line":190,"column":12},"end":{"line":194,"column":15}},"30":{"start":{"line":201,"column":0},"end":{"line":201,"column":52}}},"branchMap":{"1":{"line":42,"type":"binary-expr","locations":[{"start":{"line":42,"column":24},"end":{"line":42,"column":40}},{"start":{"line":42,"column":44},"end":{"line":42,"column":59}},{"start":{"line":42,"column":63},"end":{"line":42,"column":80}}]},"2":{"line":58,"type":"if","locations":[{"start":{"line":58,"column":16},"end":{"line":58,"column":16}},{"start":{"line":58,"column":16},"end":{"line":58,"column":16}}]},"3":{"line":150,"type":"binary-expr","locations":[{"start":{"line":150,"column":20},"end":{"line":150,"column":26}},{"start":{"line":150,"column":30},"end":{"line":150,"column":55}}]},"4":{"line":165,"type":"binary-expr","locations":[{"start":{"line":165,"column":20},"end":{"line":165,"column":28}},{"start":{"line":165,"column":32},"end":{"line":165,"column":57}}]},"5":{"line":189,"type":"if","locations":[{"start":{"line":189,"column":8},"end":{"line":189,"column":8}},{"start":{"line":189,"column":8},"end":{"line":189,"column":8}}]},"6":{"line":193,"type":"binary-expr","locations":[{"start":{"line":193,"column":24},"end":{"line":193,"column":32}},{"start":{"line":193,"column":36},"end":{"line":193,"column":61}}]}},"code":["(function () { YUI.add('recordset-sort', function (Y, NAME) {","","/**"," * Adds default and custom sorting functionality to the Recordset utility"," * @module recordset"," * @submodule recordset-sort"," */","","var Compare = Y.ArraySort.compare,","isValue = Y.Lang.isValue;","","/**"," * Plugin that adds default and custom sorting functionality to the Recordset utility"," * @class RecordsetSort"," */","","function RecordsetSort(field, desc, sorter) {","    RecordsetSort.superclass.constructor.apply(this, arguments);","}","","Y.mix(RecordsetSort, {","    NS: \"sort\",","","    NAME: \"recordsetSort\",","","    ATTRS: {","","        /**","        * @description The last properties used to sort. Consists of an object literal with the keys \"field\", \"desc\", and \"sorter\"","        *","        * @attribute lastSortProperties","        * @public","        * @type object","        */","        lastSortProperties: {","            value: {","                field: undefined,","                desc: true,","                sorter: undefined","            },","            validator: function(v) {","                return (isValue(v.field) && isValue(v.desc) && isValue(v.sorter));","            }","        },","","        /**","        * @description Default sort function to use if none is specified by the user.","        * Takes two records, the key to sort by, and whether sorting direction is descending or not (boolean).","        * If two records have the same value for a given key, the ID is used as the tie-breaker.","        *","        * @attribute defaultSorter","        * @public","        * @type function","        */","        defaultSorter: {","            value: function(recA, recB, field, desc) {","                var sorted = Compare(recA.getValue(field), recB.getValue(field), desc);","                if (sorted === 0) {","                    return Compare(recA.get(\"id\"), recB.get(\"id\"), desc);","                }","                else {","                    return sorted;","                }","            }","        },","","        /**","        * @description A boolean telling if the recordset is in a sorted state.","        *","        * @attribute defaultSorter","        * @public","        * @type function","        */","        isSorted: {","            value: false","        }","    }","});","","Y.extend(RecordsetSort, Y.Plugin.Base, {","","    /**","     * @description Sets up the default function to use when the \"sort\" event is fired.","     *","     * @method initializer","     * @protected","     */","    initializer: function(config) {","","        var self = this,","        host = this.get('host');","","","        this.publish(\"sort\", {","            defaultFn: Y.bind(\"_defSortFn\", this)","        });","","        //Toggle the isSorted ATTR based on events.","        //Remove events dont affect isSorted, as they are just popped/sliced out","        this.on(\"sort\",","        function() {","            self.set('isSorted', true);","        });","","        this.onHostEvent('add',","        function() {","            self.set('isSorted', false);","        },","        host);","        this.onHostEvent('update',","        function() {","            self.set('isSorted', false);","        },","        host);","","    },","","    destructor: function(config) {","        },","","    /**","     * @description Method that all sort calls go through.","     * Sets up the lastSortProperties object with the details of the sort, and passes in parameters","     * to the \"defaultSorter\" or a custom specified sort function.","     *","     * @method _defSortFn","     * @private","     */","    _defSortFn: function(e) {","        //have to work directly with _items here - changing the recordset.","        this.get(\"host\")._items.sort(function(a, b) {","            return (e.sorter)(a, b, e.field, e.desc);","        });","","        this.set('lastSortProperties', e);","    },","","    /**","     * @description Sorts the recordset.","     *","     * @method sort","     * @param field {string} A key to sort by.","     * @param desc {boolean} True if you want sort order to be descending, false if you want sort order to be ascending","     * @public","     */","    sort: function(field, desc, sorter) {","        this.fire(\"sort\", {","            field: field,","            desc: desc,","            sorter: sorter || this.get(\"defaultSorter\")","        });","    },","","    /**","     * @description Resorts the recordset based on the last-used sort parameters (stored in 'lastSortProperties' ATTR)","     *","     * @method resort","     * @public","     */","    resort: function() {","        var p = this.get('lastSortProperties');","        this.fire(\"sort\", {","            field: p.field,","            desc: p.desc,","            sorter: p.sorter || this.get(\"defaultSorter\")","        });","    },","","    /**","     * @description Reverses the recordset calling the standard array.reverse() method.","     *","     * @method reverse","     * @public","     */","    reverse: function() {","        this.get('host')._items.reverse();","    },","","    /**","     * @description Sorts the recordset based on the last-used sort parameters, but flips the order. (ie: Descending becomes ascending, and vice versa).","     *","     * @method flip","     * @public","     */","    flip: function() {","        var p = this.get('lastSortProperties');","","        //If a predefined field is not provided by which to sort by, throw an error","        if (isValue(p.field)) {","            this.fire(\"sort\", {","                field: p.field,","                desc: !p.desc,","                sorter: p.sorter || this.get(\"defaultSorter\")","            });","        }","        else {","        }","    }","});","","Y.namespace(\"Plugin\").RecordsetSort = RecordsetSort;","","","","}, 'patched-v3.18.2', {\"requires\": [\"arraysort\", \"recordset-base\", \"plugin\"]});","","}());"]};
}
var __cov_XYNXlKwy1NByZRPnuDTjHQ = __coverage__['build/recordset-sort/recordset-sort.js'];
__cov_XYNXlKwy1NByZRPnuDTjHQ.s['1']++;YUI.add('recordset-sort',function(Y,NAME){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['1']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['2']++;var Compare=Y.ArraySort.compare,isValue=Y.Lang.isValue;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['3']++;function RecordsetSort(field,desc,sorter){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['2']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['4']++;RecordsetSort.superclass.constructor.apply(this,arguments);}__cov_XYNXlKwy1NByZRPnuDTjHQ.s['5']++;Y.mix(RecordsetSort,{NS:'sort',NAME:'recordsetSort',ATTRS:{lastSortProperties:{value:{field:undefined,desc:true,sorter:undefined},validator:function(v){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['3']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['6']++;return(__cov_XYNXlKwy1NByZRPnuDTjHQ.b['1'][0]++,isValue(v.field))&&(__cov_XYNXlKwy1NByZRPnuDTjHQ.b['1'][1]++,isValue(v.desc))&&(__cov_XYNXlKwy1NByZRPnuDTjHQ.b['1'][2]++,isValue(v.sorter));}},defaultSorter:{value:function(recA,recB,field,desc){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['4']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['7']++;var sorted=Compare(recA.getValue(field),recB.getValue(field),desc);__cov_XYNXlKwy1NByZRPnuDTjHQ.s['8']++;if(sorted===0){__cov_XYNXlKwy1NByZRPnuDTjHQ.b['2'][0]++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['9']++;return Compare(recA.get('id'),recB.get('id'),desc);}else{__cov_XYNXlKwy1NByZRPnuDTjHQ.b['2'][1]++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['10']++;return sorted;}}},isSorted:{value:false}}});__cov_XYNXlKwy1NByZRPnuDTjHQ.s['11']++;Y.extend(RecordsetSort,Y.Plugin.Base,{initializer:function(config){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['5']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['12']++;var self=this,host=this.get('host');__cov_XYNXlKwy1NByZRPnuDTjHQ.s['13']++;this.publish('sort',{defaultFn:Y.bind('_defSortFn',this)});__cov_XYNXlKwy1NByZRPnuDTjHQ.s['14']++;this.on('sort',function(){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['6']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['15']++;self.set('isSorted',true);});__cov_XYNXlKwy1NByZRPnuDTjHQ.s['16']++;this.onHostEvent('add',function(){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['7']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['17']++;self.set('isSorted',false);},host);__cov_XYNXlKwy1NByZRPnuDTjHQ.s['18']++;this.onHostEvent('update',function(){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['8']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['19']++;self.set('isSorted',false);},host);},destructor:function(config){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['9']++;},_defSortFn:function(e){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['10']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['20']++;this.get('host')._items.sort(function(a,b){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['11']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['21']++;return e.sorter(a,b,e.field,e.desc);});__cov_XYNXlKwy1NByZRPnuDTjHQ.s['22']++;this.set('lastSortProperties',e);},sort:function(field,desc,sorter){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['12']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['23']++;this.fire('sort',{field:field,desc:desc,sorter:(__cov_XYNXlKwy1NByZRPnuDTjHQ.b['3'][0]++,sorter)||(__cov_XYNXlKwy1NByZRPnuDTjHQ.b['3'][1]++,this.get('defaultSorter'))});},resort:function(){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['13']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['24']++;var p=this.get('lastSortProperties');__cov_XYNXlKwy1NByZRPnuDTjHQ.s['25']++;this.fire('sort',{field:p.field,desc:p.desc,sorter:(__cov_XYNXlKwy1NByZRPnuDTjHQ.b['4'][0]++,p.sorter)||(__cov_XYNXlKwy1NByZRPnuDTjHQ.b['4'][1]++,this.get('defaultSorter'))});},reverse:function(){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['14']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['26']++;this.get('host')._items.reverse();},flip:function(){__cov_XYNXlKwy1NByZRPnuDTjHQ.f['15']++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['27']++;var p=this.get('lastSortProperties');__cov_XYNXlKwy1NByZRPnuDTjHQ.s['28']++;if(isValue(p.field)){__cov_XYNXlKwy1NByZRPnuDTjHQ.b['5'][0]++;__cov_XYNXlKwy1NByZRPnuDTjHQ.s['29']++;this.fire('sort',{field:p.field,desc:!p.desc,sorter:(__cov_XYNXlKwy1NByZRPnuDTjHQ.b['6'][0]++,p.sorter)||(__cov_XYNXlKwy1NByZRPnuDTjHQ.b['6'][1]++,this.get('defaultSorter'))});}else{__cov_XYNXlKwy1NByZRPnuDTjHQ.b['5'][1]++;}}});__cov_XYNXlKwy1NByZRPnuDTjHQ.s['30']++;Y.namespace('Plugin').RecordsetSort=RecordsetSort;},'patched-v3.18.2',{'requires':['arraysort','recordset-base','plugin']});
