if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/autocomplete-filters/autocomplete-filters.js']) {
   __coverage__['build/autocomplete-filters/autocomplete-filters.js'] = {"path":"build/autocomplete-filters/autocomplete-filters.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":32},"end":{"line":1,"column":51}}},"2":{"name":"(anonymous_2)","line":29,"loc":{"start":{"line":29,"column":15},"end":{"line":29,"column":56}}},"3":{"name":"(anonymous_3)","line":38,"loc":{"start":{"line":38,"column":38},"end":{"line":38,"column":56}}},"4":{"name":"(anonymous_4)","line":45,"loc":{"start":{"line":45,"column":44},"end":{"line":45,"column":59}}},"5":{"name":"(anonymous_5)","line":60,"loc":{"start":{"line":60,"column":19},"end":{"line":60,"column":45}}},"6":{"name":"(anonymous_6)","line":74,"loc":{"start":{"line":74,"column":17},"end":{"line":74,"column":58}}},"7":{"name":"(anonymous_7)","line":84,"loc":{"start":{"line":84,"column":38},"end":{"line":84,"column":56}}},"8":{"name":"(anonymous_8)","line":98,"loc":{"start":{"line":98,"column":21},"end":{"line":98,"column":47}}},"9":{"name":"(anonymous_9)","line":112,"loc":{"start":{"line":112,"column":16},"end":{"line":112,"column":57}}},"10":{"name":"(anonymous_10)","line":122,"loc":{"start":{"line":122,"column":38},"end":{"line":122,"column":56}}},"11":{"name":"(anonymous_11)","line":136,"loc":{"start":{"line":136,"column":20},"end":{"line":136,"column":46}}},"12":{"name":"(anonymous_12)","line":160,"loc":{"start":{"line":160,"column":18},"end":{"line":160,"column":59}}},"13":{"name":"(anonymous_13)","line":170,"loc":{"start":{"line":170,"column":38},"end":{"line":170,"column":56}}},"14":{"name":"(anonymous_14)","line":174,"loc":{"start":{"line":174,"column":44},"end":{"line":174,"column":65}}},"15":{"name":"(anonymous_15)","line":189,"loc":{"start":{"line":189,"column":22},"end":{"line":189,"column":48}}},"16":{"name":"(anonymous_16)","line":204,"loc":{"start":{"line":204,"column":15},"end":{"line":204,"column":56}}},"17":{"name":"(anonymous_17)","line":213,"loc":{"start":{"line":213,"column":38},"end":{"line":213,"column":56}}},"18":{"name":"(anonymous_18)","line":218,"loc":{"start":{"line":218,"column":44},"end":{"line":218,"column":60}}},"19":{"name":"(anonymous_19)","line":233,"loc":{"start":{"line":233,"column":19},"end":{"line":233,"column":45}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":239,"column":66}},"2":{"start":{"line":12,"column":0},"end":{"line":236,"column":3}},"3":{"start":{"line":33,"column":8},"end":{"line":33,"column":39}},"4":{"start":{"line":33,"column":22},"end":{"line":33,"column":37}},"5":{"start":{"line":35,"column":8},"end":{"line":36,"column":48}},"6":{"start":{"line":38,"column":8},"end":{"line":48,"column":11}},"7":{"start":{"line":39,"column":12},"end":{"line":39,"column":33}},"8":{"start":{"line":41,"column":12},"end":{"line":43,"column":13}},"9":{"start":{"line":42,"column":16},"end":{"line":42,"column":46}},"10":{"start":{"line":45,"column":12},"end":{"line":47,"column":15}},"11":{"start":{"line":46,"column":16},"end":{"line":46,"column":50}},"12":{"start":{"line":61,"column":8},"end":{"line":61,"column":55}},"13":{"start":{"line":78,"column":8},"end":{"line":78,"column":39}},"14":{"start":{"line":78,"column":22},"end":{"line":78,"column":37}},"15":{"start":{"line":80,"column":8},"end":{"line":82,"column":9}},"16":{"start":{"line":81,"column":12},"end":{"line":81,"column":40}},"17":{"start":{"line":84,"column":8},"end":{"line":86,"column":11}},"18":{"start":{"line":85,"column":12},"end":{"line":85,"column":99}},"19":{"start":{"line":99,"column":8},"end":{"line":99,"column":57}},"20":{"start":{"line":116,"column":8},"end":{"line":116,"column":39}},"21":{"start":{"line":116,"column":22},"end":{"line":116,"column":37}},"22":{"start":{"line":118,"column":8},"end":{"line":120,"column":9}},"23":{"start":{"line":119,"column":12},"end":{"line":119,"column":40}},"24":{"start":{"line":122,"column":8},"end":{"line":124,"column":11}},"25":{"start":{"line":123,"column":12},"end":{"line":123,"column":98}},"26":{"start":{"line":137,"column":8},"end":{"line":137,"column":56}},"27":{"start":{"line":164,"column":8},"end":{"line":164,"column":39}},"28":{"start":{"line":164,"column":22},"end":{"line":164,"column":37}},"29":{"start":{"line":166,"column":8},"end":{"line":168,"column":11}},"30":{"start":{"line":170,"column":8},"end":{"line":177,"column":11}},"31":{"start":{"line":171,"column":12},"end":{"line":172,"column":46}},"32":{"start":{"line":174,"column":12},"end":{"line":176,"column":15}},"33":{"start":{"line":175,"column":16},"end":{"line":175,"column":60}},"34":{"start":{"line":190,"column":8},"end":{"line":190,"column":58}},"35":{"start":{"line":208,"column":8},"end":{"line":208,"column":39}},"36":{"start":{"line":208,"column":22},"end":{"line":208,"column":37}},"37":{"start":{"line":210,"column":8},"end":{"line":211,"column":66}},"38":{"start":{"line":213,"column":8},"end":{"line":221,"column":11}},"39":{"start":{"line":215,"column":12},"end":{"line":216,"column":42}},"40":{"start":{"line":218,"column":12},"end":{"line":220,"column":15}},"41":{"start":{"line":219,"column":16},"end":{"line":219,"column":55}},"42":{"start":{"line":234,"column":8},"end":{"line":234,"column":55}}},"branchMap":{"1":{"line":33,"type":"if","locations":[{"start":{"line":33,"column":8},"end":{"line":33,"column":8}},{"start":{"line":33,"column":8},"end":{"line":33,"column":8}}]},"2":{"line":35,"type":"cond-expr","locations":[{"start":{"line":35,"column":56},"end":{"line":35,"column":61}},{"start":{"line":36,"column":16},"end":{"line":36,"column":35}}]},"3":{"line":41,"type":"if","locations":[{"start":{"line":41,"column":12},"end":{"line":41,"column":12}},{"start":{"line":41,"column":12},"end":{"line":41,"column":12}}]},"4":{"line":78,"type":"if","locations":[{"start":{"line":78,"column":8},"end":{"line":78,"column":8}},{"start":{"line":78,"column":8},"end":{"line":78,"column":8}}]},"5":{"line":80,"type":"if","locations":[{"start":{"line":80,"column":8},"end":{"line":80,"column":8}},{"start":{"line":80,"column":8},"end":{"line":80,"column":8}}]},"6":{"line":85,"type":"cond-expr","locations":[{"start":{"line":85,"column":36},"end":{"line":85,"column":47}},{"start":{"line":85,"column":50},"end":{"line":85,"column":75}}]},"7":{"line":116,"type":"if","locations":[{"start":{"line":116,"column":8},"end":{"line":116,"column":8}},{"start":{"line":116,"column":8},"end":{"line":116,"column":8}}]},"8":{"line":118,"type":"if","locations":[{"start":{"line":118,"column":8},"end":{"line":118,"column":8}},{"start":{"line":118,"column":8},"end":{"line":118,"column":8}}]},"9":{"line":123,"type":"cond-expr","locations":[{"start":{"line":123,"column":36},"end":{"line":123,"column":47}},{"start":{"line":123,"column":50},"end":{"line":123,"column":75}}]},"10":{"line":164,"type":"if","locations":[{"start":{"line":164,"column":8},"end":{"line":164,"column":8}},{"start":{"line":164,"column":8},"end":{"line":164,"column":8}}]},"11":{"line":171,"type":"cond-expr","locations":[{"start":{"line":171,"column":45},"end":{"line":171,"column":56}},{"start":{"line":172,"column":20},"end":{"line":172,"column":45}}]},"12":{"line":208,"type":"if","locations":[{"start":{"line":208,"column":8},"end":{"line":208,"column":8}},{"start":{"line":208,"column":8},"end":{"line":208,"column":8}}]}},"code":["(function () { YUI.add('autocomplete-filters', function (Y, NAME) {","","/**","Provides pre-built result matching filters for AutoComplete.","","@module autocomplete","@submodule autocomplete-filters","@class AutoCompleteFilters","@static","**/","","var YArray     = Y.Array,","    YObject    = Y.Object,","    WordBreak  = Y.Text.WordBreak,","","Filters = Y.mix(Y.namespace('AutoCompleteFilters'), {","    // -- Public Methods -------------------------------------------------------","","    /**","    Returns an array of results that contain all of the characters in the query,","    in any order (not necessarily consecutive). Case-insensitive.","","    @method charMatch","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    charMatch: function (query, results, caseSensitive) {","        // The caseSensitive parameter is only intended for use by","        // charMatchCase(). It's intentionally undocumented.","","        if (!query) { return results; }","","        var queryChars = YArray.unique((caseSensitive ? query :","                query.toLowerCase()).split(''));","","        return YArray.filter(results, function (result) {","            result = result.text;","","            if (!caseSensitive) {","                result = result.toLowerCase();","            }","","            return YArray.every(queryChars, function (chr) {","                return result.indexOf(chr) !== -1;","            });","        });","    },","","    /**","    Case-sensitive version of `charMatch()`.","","    @method charMatchCase","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    charMatchCase: function (query, results) {","        return Filters.charMatch(query, results, true);","    },","","    /**","    Returns an array of results that contain the complete query as a phrase.","    Case-insensitive.","","    @method phraseMatch","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    phraseMatch: function (query, results, caseSensitive) {","        // The caseSensitive parameter is only intended for use by","        // phraseMatchCase(). It's intentionally undocumented.","","        if (!query) { return results; }","","        if (!caseSensitive) {","            query = query.toLowerCase();","        }","","        return YArray.filter(results, function (result) {","            return (caseSensitive ? result.text : result.text.toLowerCase()).indexOf(query) !== -1;","        });","    },","","    /**","    Case-sensitive version of `phraseMatch()`.","","    @method phraseMatchCase","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    phraseMatchCase: function (query, results) {","        return Filters.phraseMatch(query, results, true);","    },","","    /**","    Returns an array of results that start with the complete query as a phrase.","    Case-insensitive.","","    @method startsWith","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    startsWith: function (query, results, caseSensitive) {","        // The caseSensitive parameter is only intended for use by","        // startsWithCase(). It's intentionally undocumented.","","        if (!query) { return results; }","","        if (!caseSensitive) {","            query = query.toLowerCase();","        }","","        return YArray.filter(results, function (result) {","            return (caseSensitive ? result.text : result.text.toLowerCase()).indexOf(query) === 0;","        });","    },","","    /**","    Case-sensitive version of `startsWith()`.","","    @method startsWithCase","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    startsWithCase: function (query, results) {","        return Filters.startsWith(query, results, true);","    },","","    /**","    Returns an array of results in which all the words of the query match either","    whole words or parts of words in the result. Non-word characters like","    whitespace and certain punctuation are ignored. Case-insensitive.","","    This is basically a combination of `wordMatch()` (by ignoring whitespace and","    word order) and `phraseMatch()` (by allowing partial matching instead of","    requiring the entire word to match).","","    Example use case: Trying to find personal names independently of name order","    (Western or Eastern order) and supporting immediate feedback by allowing","    partial occurences. So queries like \"J. Doe\", \"Doe, John\", and \"J. D.\" would","    all match \"John Doe\".","","    @method subWordMatch","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    subWordMatch: function (query, results, caseSensitive) {","        // The caseSensitive parameter is only intended for use by","        // subWordMatchCase(). It's intentionally undocumented.","","        if (!query) { return results; }","","        var queryWords = WordBreak.getUniqueWords(query, {","            ignoreCase: !caseSensitive","        });","","        return YArray.filter(results, function (result) {","            var resultText = caseSensitive ? result.text :","                    result.text.toLowerCase();","","            return YArray.every(queryWords, function (queryWord) {","                return resultText.indexOf(queryWord) !== -1;","            });","        });","    },","","    /**","    Case-sensitive version of `subWordMatch()`.","","    @method subWordMatchCase","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    subWordMatchCase: function (query, results) {","        return Filters.subWordMatch(query, results, true);","    },","","    /**","    Returns an array of results that contain all of the words in the query, in","    any order. Non-word characters like whitespace and certain punctuation are","    ignored. Case-insensitive.","","    @method wordMatch","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    wordMatch: function (query, results, caseSensitive) {","        // The caseSensitive parameter is only intended for use by","        // wordMatchCase(). It's intentionally undocumented.","","        if (!query) { return results; }","","        var options    = {ignoreCase: !caseSensitive},","            queryWords = WordBreak.getUniqueWords(query, options);","","        return YArray.filter(results, function (result) {","            // Convert resultWords array to a hash for fast lookup.","            var resultWords = YArray.hash(WordBreak.getUniqueWords(result.text,","                                options));","","            return YArray.every(queryWords, function (word) {","                return YObject.owns(resultWords, word);","            });","        });","    },","","    /**","    Case-sensitive version of `wordMatch()`.","","    @method wordMatchCase","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    wordMatchCase: function (query, results) {","        return Filters.wordMatch(query, results, true);","    }","});","","","}, 'patched-v3.18.2', {\"requires\": [\"array-extras\", \"text-wordbreak\"]});","","}());"]};
}
var __cov_NcisKHhBnj3ORzY64$VGdA = __coverage__['build/autocomplete-filters/autocomplete-filters.js'];
__cov_NcisKHhBnj3ORzY64$VGdA.s['1']++;YUI.add('autocomplete-filters',function(Y,NAME){__cov_NcisKHhBnj3ORzY64$VGdA.f['1']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['2']++;var YArray=Y.Array,YObject=Y.Object,WordBreak=Y.Text.WordBreak,Filters=Y.mix(Y.namespace('AutoCompleteFilters'),{charMatch:function(query,results,caseSensitive){__cov_NcisKHhBnj3ORzY64$VGdA.f['2']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['3']++;if(!query){__cov_NcisKHhBnj3ORzY64$VGdA.b['1'][0]++;__cov_NcisKHhBnj3ORzY64$VGdA.s['4']++;return results;}else{__cov_NcisKHhBnj3ORzY64$VGdA.b['1'][1]++;}__cov_NcisKHhBnj3ORzY64$VGdA.s['5']++;var queryChars=YArray.unique((caseSensitive?(__cov_NcisKHhBnj3ORzY64$VGdA.b['2'][0]++,query):(__cov_NcisKHhBnj3ORzY64$VGdA.b['2'][1]++,query.toLowerCase())).split(''));__cov_NcisKHhBnj3ORzY64$VGdA.s['6']++;return YArray.filter(results,function(result){__cov_NcisKHhBnj3ORzY64$VGdA.f['3']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['7']++;result=result.text;__cov_NcisKHhBnj3ORzY64$VGdA.s['8']++;if(!caseSensitive){__cov_NcisKHhBnj3ORzY64$VGdA.b['3'][0]++;__cov_NcisKHhBnj3ORzY64$VGdA.s['9']++;result=result.toLowerCase();}else{__cov_NcisKHhBnj3ORzY64$VGdA.b['3'][1]++;}__cov_NcisKHhBnj3ORzY64$VGdA.s['10']++;return YArray.every(queryChars,function(chr){__cov_NcisKHhBnj3ORzY64$VGdA.f['4']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['11']++;return result.indexOf(chr)!==-1;});});},charMatchCase:function(query,results){__cov_NcisKHhBnj3ORzY64$VGdA.f['5']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['12']++;return Filters.charMatch(query,results,true);},phraseMatch:function(query,results,caseSensitive){__cov_NcisKHhBnj3ORzY64$VGdA.f['6']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['13']++;if(!query){__cov_NcisKHhBnj3ORzY64$VGdA.b['4'][0]++;__cov_NcisKHhBnj3ORzY64$VGdA.s['14']++;return results;}else{__cov_NcisKHhBnj3ORzY64$VGdA.b['4'][1]++;}__cov_NcisKHhBnj3ORzY64$VGdA.s['15']++;if(!caseSensitive){__cov_NcisKHhBnj3ORzY64$VGdA.b['5'][0]++;__cov_NcisKHhBnj3ORzY64$VGdA.s['16']++;query=query.toLowerCase();}else{__cov_NcisKHhBnj3ORzY64$VGdA.b['5'][1]++;}__cov_NcisKHhBnj3ORzY64$VGdA.s['17']++;return YArray.filter(results,function(result){__cov_NcisKHhBnj3ORzY64$VGdA.f['7']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['18']++;return(caseSensitive?(__cov_NcisKHhBnj3ORzY64$VGdA.b['6'][0]++,result.text):(__cov_NcisKHhBnj3ORzY64$VGdA.b['6'][1]++,result.text.toLowerCase())).indexOf(query)!==-1;});},phraseMatchCase:function(query,results){__cov_NcisKHhBnj3ORzY64$VGdA.f['8']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['19']++;return Filters.phraseMatch(query,results,true);},startsWith:function(query,results,caseSensitive){__cov_NcisKHhBnj3ORzY64$VGdA.f['9']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['20']++;if(!query){__cov_NcisKHhBnj3ORzY64$VGdA.b['7'][0]++;__cov_NcisKHhBnj3ORzY64$VGdA.s['21']++;return results;}else{__cov_NcisKHhBnj3ORzY64$VGdA.b['7'][1]++;}__cov_NcisKHhBnj3ORzY64$VGdA.s['22']++;if(!caseSensitive){__cov_NcisKHhBnj3ORzY64$VGdA.b['8'][0]++;__cov_NcisKHhBnj3ORzY64$VGdA.s['23']++;query=query.toLowerCase();}else{__cov_NcisKHhBnj3ORzY64$VGdA.b['8'][1]++;}__cov_NcisKHhBnj3ORzY64$VGdA.s['24']++;return YArray.filter(results,function(result){__cov_NcisKHhBnj3ORzY64$VGdA.f['10']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['25']++;return(caseSensitive?(__cov_NcisKHhBnj3ORzY64$VGdA.b['9'][0]++,result.text):(__cov_NcisKHhBnj3ORzY64$VGdA.b['9'][1]++,result.text.toLowerCase())).indexOf(query)===0;});},startsWithCase:function(query,results){__cov_NcisKHhBnj3ORzY64$VGdA.f['11']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['26']++;return Filters.startsWith(query,results,true);},subWordMatch:function(query,results,caseSensitive){__cov_NcisKHhBnj3ORzY64$VGdA.f['12']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['27']++;if(!query){__cov_NcisKHhBnj3ORzY64$VGdA.b['10'][0]++;__cov_NcisKHhBnj3ORzY64$VGdA.s['28']++;return results;}else{__cov_NcisKHhBnj3ORzY64$VGdA.b['10'][1]++;}__cov_NcisKHhBnj3ORzY64$VGdA.s['29']++;var queryWords=WordBreak.getUniqueWords(query,{ignoreCase:!caseSensitive});__cov_NcisKHhBnj3ORzY64$VGdA.s['30']++;return YArray.filter(results,function(result){__cov_NcisKHhBnj3ORzY64$VGdA.f['13']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['31']++;var resultText=caseSensitive?(__cov_NcisKHhBnj3ORzY64$VGdA.b['11'][0]++,result.text):(__cov_NcisKHhBnj3ORzY64$VGdA.b['11'][1]++,result.text.toLowerCase());__cov_NcisKHhBnj3ORzY64$VGdA.s['32']++;return YArray.every(queryWords,function(queryWord){__cov_NcisKHhBnj3ORzY64$VGdA.f['14']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['33']++;return resultText.indexOf(queryWord)!==-1;});});},subWordMatchCase:function(query,results){__cov_NcisKHhBnj3ORzY64$VGdA.f['15']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['34']++;return Filters.subWordMatch(query,results,true);},wordMatch:function(query,results,caseSensitive){__cov_NcisKHhBnj3ORzY64$VGdA.f['16']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['35']++;if(!query){__cov_NcisKHhBnj3ORzY64$VGdA.b['12'][0]++;__cov_NcisKHhBnj3ORzY64$VGdA.s['36']++;return results;}else{__cov_NcisKHhBnj3ORzY64$VGdA.b['12'][1]++;}__cov_NcisKHhBnj3ORzY64$VGdA.s['37']++;var options={ignoreCase:!caseSensitive},queryWords=WordBreak.getUniqueWords(query,options);__cov_NcisKHhBnj3ORzY64$VGdA.s['38']++;return YArray.filter(results,function(result){__cov_NcisKHhBnj3ORzY64$VGdA.f['17']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['39']++;var resultWords=YArray.hash(WordBreak.getUniqueWords(result.text,options));__cov_NcisKHhBnj3ORzY64$VGdA.s['40']++;return YArray.every(queryWords,function(word){__cov_NcisKHhBnj3ORzY64$VGdA.f['18']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['41']++;return YObject.owns(resultWords,word);});});},wordMatchCase:function(query,results){__cov_NcisKHhBnj3ORzY64$VGdA.f['19']++;__cov_NcisKHhBnj3ORzY64$VGdA.s['42']++;return Filters.wordMatch(query,results,true);}});},'patched-v3.18.2',{'requires':['array-extras','text-wordbreak']});
