if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/aui-progressbar/aui-progressbar.js']) {
   __coverage__['build/aui-progressbar/aui-progressbar.js'] = {"path":"build/aui-progressbar/aui-progressbar.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0,0],"4":[0,0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":27},"end":{"line":1,"column":46}}},"2":{"name":"(anonymous_2)","line":12,"loc":{"start":{"line":12,"column":15},"end":{"line":12,"column":27}}},"3":{"name":"(anonymous_3)","line":70,"loc":{"start":{"line":70,"column":21},"end":{"line":70,"column":32}}},"4":{"name":"(anonymous_4)","line":125,"loc":{"start":{"line":125,"column":23},"end":{"line":125,"column":37}}},"5":{"name":"(anonymous_5)","line":175,"loc":{"start":{"line":175,"column":21},"end":{"line":175,"column":32}}},"6":{"name":"(anonymous_6)","line":202,"loc":{"start":{"line":202,"column":23},"end":{"line":202,"column":37}}},"7":{"name":"(anonymous_7)","line":218,"loc":{"start":{"line":218,"column":15},"end":{"line":218,"column":37}}},"8":{"name":"(anonymous_8)","line":246,"loc":{"start":{"line":246,"column":18},"end":{"line":246,"column":29}}},"9":{"name":"(anonymous_9)","line":258,"loc":{"start":{"line":258,"column":16},"end":{"line":258,"column":27}}},"10":{"name":"(anonymous_10)","line":282,"loc":{"start":{"line":282,"column":29},"end":{"line":282,"column":40}}},"11":{"name":"(anonymous_11)","line":297,"loc":{"start":{"line":297,"column":19},"end":{"line":297,"column":30}}},"12":{"name":"(anonymous_12)","line":311,"loc":{"start":{"line":311,"column":18},"end":{"line":311,"column":29}}},"13":{"name":"(anonymous_13)","line":321,"loc":{"start":{"line":321,"column":35},"end":{"line":321,"column":46}}},"14":{"name":"(anonymous_14)","line":335,"loc":{"start":{"line":335,"column":21},"end":{"line":335,"column":35}}},"15":{"name":"(anonymous_15)","line":353,"loc":{"start":{"line":353,"column":27},"end":{"line":353,"column":41}}},"16":{"name":"(anonymous_16)","line":371,"loc":{"start":{"line":371,"column":21},"end":{"line":371,"column":32}}},"17":{"name":"(anonymous_17)","line":401,"loc":{"start":{"line":401,"column":25},"end":{"line":401,"column":36}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":410,"column":102}},"2":{"start":{"line":12,"column":0},"end":{"line":20,"column":25}},"3":{"start":{"line":13,"column":8},"end":{"line":13,"column":34}},"4":{"start":{"line":42,"column":0},"end":{"line":405,"column":3}},"5":{"start":{"line":71,"column":16},"end":{"line":71,"column":73}},"6":{"start":{"line":126,"column":16},"end":{"line":126,"column":92}},"7":{"start":{"line":176,"column":16},"end":{"line":176,"column":47}},"8":{"start":{"line":203,"column":16},"end":{"line":203,"column":112}},"9":{"start":{"line":219,"column":12},"end":{"line":219,"column":48}},"10":{"start":{"line":221,"column":12},"end":{"line":223,"column":13}},"11":{"start":{"line":222,"column":16},"end":{"line":222,"column":39}},"12":{"start":{"line":247,"column":12},"end":{"line":247,"column":53}},"13":{"start":{"line":249,"column":12},"end":{"line":249,"column":45}},"14":{"start":{"line":259,"column":12},"end":{"line":269,"column":13}},"15":{"start":{"line":260,"column":16},"end":{"line":268,"column":19}},"16":{"start":{"line":283,"column":12},"end":{"line":287,"column":14}},"17":{"start":{"line":298,"column":12},"end":{"line":299,"column":76}},"18":{"start":{"line":301,"column":12},"end":{"line":301,"column":38}},"19":{"start":{"line":312,"column":12},"end":{"line":312,"column":43}},"20":{"start":{"line":322,"column":12},"end":{"line":324,"column":13}},"21":{"start":{"line":323,"column":16},"end":{"line":323,"column":68}},"22":{"start":{"line":336,"column":12},"end":{"line":336,"column":48}},"23":{"start":{"line":338,"column":12},"end":{"line":340,"column":13}},"24":{"start":{"line":339,"column":16},"end":{"line":339,"column":49}},"25":{"start":{"line":342,"column":12},"end":{"line":342,"column":31}},"26":{"start":{"line":354,"column":12},"end":{"line":355,"column":52}},"27":{"start":{"line":357,"column":12},"end":{"line":357,"column":64}},"28":{"start":{"line":358,"column":12},"end":{"line":358,"column":63}},"29":{"start":{"line":360,"column":12},"end":{"line":360,"column":48}},"30":{"start":{"line":361,"column":12},"end":{"line":361,"column":35}},"31":{"start":{"line":372,"column":12},"end":{"line":373,"column":23}},"32":{"start":{"line":375,"column":12},"end":{"line":386,"column":13}},"33":{"start":{"line":376,"column":16},"end":{"line":379,"column":18}},"34":{"start":{"line":382,"column":16},"end":{"line":385,"column":18}},"35":{"start":{"line":388,"column":12},"end":{"line":390,"column":13}},"36":{"start":{"line":389,"column":16},"end":{"line":389,"column":38}},"37":{"start":{"line":392,"column":12},"end":{"line":392,"column":53}},"38":{"start":{"line":402,"column":12},"end":{"line":402,"column":100}},"39":{"start":{"line":407,"column":0},"end":{"line":407,"column":28}}},"branchMap":{"1":{"line":13,"type":"binary-expr","locations":[{"start":{"line":13,"column":15},"end":{"line":13,"column":28}},{"start":{"line":13,"column":32},"end":{"line":13,"column":33}}]},"2":{"line":71,"type":"binary-expr","locations":[{"start":{"line":71,"column":23},"end":{"line":71,"column":66}},{"start":{"line":71,"column":70},"end":{"line":71,"column":72}}]},"3":{"line":126,"type":"binary-expr","locations":[{"start":{"line":126,"column":23},"end":{"line":126,"column":43}},{"start":{"line":126,"column":48},"end":{"line":126,"column":68}},{"start":{"line":126,"column":72},"end":{"line":126,"column":90}}]},"4":{"line":203,"type":"binary-expr","locations":[{"start":{"line":203,"column":23},"end":{"line":203,"column":53}},{"start":{"line":203,"column":59},"end":{"line":203,"column":81}},{"start":{"line":203,"column":87},"end":{"line":203,"column":109}}]},"5":{"line":221,"type":"if","locations":[{"start":{"line":221,"column":12},"end":{"line":221,"column":12}},{"start":{"line":221,"column":12},"end":{"line":221,"column":12}}]},"6":{"line":259,"type":"if","locations":[{"start":{"line":259,"column":12},"end":{"line":259,"column":12}},{"start":{"line":259,"column":12},"end":{"line":259,"column":12}}]},"7":{"line":285,"type":"cond-expr","locations":[{"start":{"line":285,"column":63},"end":{"line":285,"column":70}},{"start":{"line":285,"column":73},"end":{"line":285,"column":81}}]},"8":{"line":322,"type":"if","locations":[{"start":{"line":322,"column":12},"end":{"line":322,"column":12}},{"start":{"line":322,"column":12},"end":{"line":322,"column":12}}]},"9":{"line":338,"type":"if","locations":[{"start":{"line":338,"column":12},"end":{"line":338,"column":12}},{"start":{"line":338,"column":12},"end":{"line":338,"column":12}}]},"10":{"line":375,"type":"if","locations":[{"start":{"line":375,"column":12},"end":{"line":375,"column":12}},{"start":{"line":375,"column":12},"end":{"line":375,"column":12}}]},"11":{"line":388,"type":"if","locations":[{"start":{"line":388,"column":12},"end":{"line":388,"column":12}},{"start":{"line":388,"column":12},"end":{"line":388,"column":12}}]}},"code":["(function () { YUI.add('aui-progressbar', function (A, NAME) {","","/**"," * The ProgressBar Utility provides a visual means of showing progress of an"," * ongoing operation. The ProgressBar can be enhanced via CSS styles to provide"," * different colors, shapes and textures. The bar can move horizontally or"," * vertically. The movement can be enhanced by using the Animation utility."," *"," * @module aui-progressbar"," */","","var toNumber = function(v) {","        return parseFloat(v) || 0;","    },","","    CSS_BAR = A.getClassName('progress', 'bar'),","    CSS_HORIZONTAL = A.getClassName('horizontal'),","    CSS_VERTICAL = A.getClassName('vertical'),","","    TPL_TEXT = '<p></p>';","","/**"," * A base class for Progressbar, providing:"," *"," * - Widget Lifecycle (initializer, renderUI, bindUI, syncUI, destructor)"," * - A visual means of showing progress of an ongoing operation"," * - Can be enhanced via CSS styles to provide different colors, shapes and"," *   textures"," * - The bar can move horizontally or vertically"," * - The movement can be enhanced by using the Animation utility"," *"," * Check the [live demo](http://alloyui.com/examples/progress-bar/)."," *"," * @class A.ProgressBar"," * @extends A.Component"," * @param {Object} config Object literal specifying widget configuration"," *     properties."," * @constructor"," * @include http://alloyui.com/examples/progress-bar/basic-markup.html"," * @include http://alloyui.com/examples/progress-bar/basic.js"," */","var ProgressBar = A.Component.create({","    /**","     * Static property provides a string to identify the class.","     *","     * @property NAME","     * @type String","     * @static","     */","    NAME: 'progress',","","    /**","     * Static property used to define the default attribute","     * configuration for the ProgressBar.","     *","     * @property ATTRS","     * @type Object","     * @static","     */","    ATTRS: {","","        /**","         * Display height of the progressbar.","         *","         * @attribute height","         * @default 25","         * @type int | String","         */","        height: {","            valueFn: function() {","                return this.get('boundingBox').get('offsetHeight') || 25;","            }","        },","","        /**","         * Display label of the progressbar. If not specified try to query","         * using HTML_PARSER an element inside boundingBox which matches","         * `aui-progressbar-text` and get its innerHTML to be","         * used as label.","         *","         * @attribute label","         * @default undefined","         * @type String","         */","        label: {},","","        /**","         * Represents the top value for the bar. The bar will be fully","         * extended when reaching this value. Values higher than this will","         * be ignored.","         *","         * @attribute max","         * @default 100","         * @type Number","         */","        max: {","            validator: A.Lang.isNumber,","            value: 100","        },","","        /**","         * Represents the lowest value for the bar. The bar will be","         * totally collapsed when reaching this value. Values lower than","         * this will be ignored.","         *","         * @attribute min","         * @default 0","         * @type Number","         */","        min: {","            validator: A.Lang.isNumber,","            value: 0","        },","","        /**","         * Display orientation of the progressbar (i.e. vertical or","         * horizontal).","         *","         * @attribute orientation","         * @default HORIZONTAL","         * @type String","         */","        orientation: {","            value: 'horizontal',","            validator: function(val) {","                return A.Lang.isString(val) && (val === 'horizontal' || val === 'vertical');","            }","        },","","        /**","         * Calculate the ratio based on `max` and `min` values.","         *","         * @attribute ratio","         * @readOnly","         * @type number","         */","        ratio: {","            getter: '_getRatio',","            readOnly: true","        },","","        /**","         * Calculate the progressbar step based on `ratio` value.","         *","         * @attribute step","         * @readOnly","         * @type number","         */","        step: {","            getter: '_getStep',","            readOnly: true","        },","","        /**","         * Specify the tab order of elements.","         *","         * @attribute tabIndex","         * @default 1","         * @type Number","         */","        tabIndex: {","            value: 1","        },","","        /**","         * DOM Node to display the text of the progressbar. If not","         * specified try to query using HTML_PARSER an element inside","         * contentBox which matches `aui-progressbar-text`.","         *","         * @attribute textNode","         * @default Generated div element.","         * @type String","         */","        textNode: {","            valueFn: function() {","                return A.Node.create(TPL_TEXT);","            }","        },","","        /**","         * Boolean indicating if use of the WAI-ARIA Roles and States","         * should be enabled.","         *","         * @attribute useARIA","         * @default true","         * @type Boolean","         */","        useARIA: {","            value: true","        },","","        /**","         * The value for the bar. Valid values are in between the minValue","         * and maxValue attributes.","         *","         * @attribute value","         * @default 0","         * @type Number | String","         */","        value: {","            setter: toNumber,","            validator: function(val) {","                return A.Lang.isNumber(toNumber(val)) && ((val >= this.get('min')) && (val <= this.get('max')));","            },","            value: 0","        }","    },","","    /**","     * Object hash, defining how attribute values are to be parsed from","     * markup contained in the widget's bounding box.","     *","     * @property HTML_PARSER","     * @type Object","     * @static","     */","    HTML_PARSER: {","        label: function(boundingBox) {","            var textNode = boundingBox.one('p');","","            if (textNode) {","                return textNode.html();","            }","        },","","        textNode: 'p'","    },","","    /**","     * Static property used to define the UI attributes.","     *","     * @property UI_ATTRS","     * @type Array","     * @static","     */","    UI_ATTRS: ['label', 'orientation', 'value'],","","    prototype: {","","        /**","         * Create the DOM structure for the ProgressBar. Lifecycle.","         *","         * @method renderUI","         * @protected","         */","        renderUI: function() {","            this.get('contentBox').addClass(CSS_BAR);","","            this._renderTextNodeIfLabelSet();","        },","","        /**","         * Sync the ProgressBar UI. Lifecycle.","         *","         * @method syncUI","         * @protected","         */","        syncUI: function() {","            if (this.get('useARIA')) {","                this.plug(A.Plugin.Aria, {","                    attributes: {","                        value: 'valuenow',","                        max: 'valuemax',","                        min: 'valuemin',","                        orientation: 'orientation'","                    },","                    roleName: 'progressbar'","                });","            }","        },","","        /**","         * Calculate the boundingBox size based on the","         * `orientation` of the progressbar. If the orientation","         * is HORIZONTAL get the width, if the orientation is VERTICAL get","         * the height.","         *","         * @method _getBoundingBoxSize","         * @protected","         * @return {Number}","         */","        _getBoundingBoxSize: function() {","            return toNumber(","                this.get('boundingBox').getStyle(","                    this.get('orientation') === 'horizontal' ? 'width' : 'height'","                )","            );","        },","","        /**","         * Calculate the ratio based on `max` and `min` values.","         *","         * @method _getRatio","         * @protected","         * @return {Number}","         */","        _getRatio: function() {","            var min = this.get('min'),","                ratio = (this.get('value') - min) / (this.get('max') - min);","","            return Math.max(ratio, 0);","        },","","        /**","         * Calculate the progressbar step based on `ratio` value.","         *","         * @method _getStep","         * @protected","         * @return {Number}","         */","        _getStep: function() {","            return this.get('ratio') * 100;","        },","","        /**","         * Render the `textNode` of the progressbar if label is set.","         *","         * @method _renderTextNodeIfLabelSet","         * @protected","         */","        _renderTextNodeIfLabelSet: function() {","            if (!A.Lang.isUndefined(this.get('label'))) {","                this.get('contentBox').append(this.get('textNode'));","            }","        },","","        /**","         * Invoked automatically by the UI_ATTRS Widget API when bind or sync","         * the `label` attribute.","         *","         * @method _uiSetLabel","         * @param {String} val Display label","         * @protected","         */","        _uiSetLabel: function(val) {","            var textNode = this.get('textNode');","","            if (!textNode.inDoc()) {","                this._renderTextNodeIfLabelSet();","            }","","            textNode.html(val);","        },","","        /**","         * Invoked automatically by the UI_ATTRS Widget API when bind or sync","         * the `orientation` attribute.","         *","         * @method _uiSetOrientation","         * @param {String} val Orientation","         * @protected","         */","        _uiSetOrientation: function(val) {","            var boundingBox = this.get('boundingBox'),","                horizontal = (val === 'horizontal');","","            boundingBox.toggleClass(CSS_HORIZONTAL, horizontal);","            boundingBox.toggleClass(CSS_VERTICAL, !horizontal);","","            this._uiSetValue(this.get('value'));","            this._uiSizeTextNode();","        },","","        /**","         * Invoked automatically by the UI_ATTRS Widget API when bind or sync","         * the `value` attribute.","         *","         * @method _uiSetValue","         * @protected","         */","        _uiSetValue: function() {","            var percentStep = this._getStep(),","                styles;","","            if (this.get('orientation') === 'horizontal') {","                styles = {","                    height: '100%',","                    width: percentStep + '%'","                };","            }","            else {","                styles = {","                    height: percentStep + '%',","                    width: '100%'","                };","            }","","            if (this.get('step') >= 100) {","                this.fire('complete');","            }","","            this.get('contentBox').setStyles(styles);","        },","","        /**","         * Sync the size of the ProgressBar when some UI attribute change.","         *","         * @method _uiSizeTextNode","         * @protected","         */","        _uiSizeTextNode: function() {","            this.get('textNode').setStyle('lineHeight', this.get('boundingBox').getStyle('height'));","        }","    }","});","","A.ProgressBar = ProgressBar;","","","}, '3.1.0-deprecated.89', {\"requires\": [\"aui-node\", \"aui-component\", \"aui-aria\"], \"skinnable\": true});","","}());"]};
}
var __cov_zh_sN2iWl$WvlxSUgxUAxA = __coverage__['build/aui-progressbar/aui-progressbar.js'];
__cov_zh_sN2iWl$WvlxSUgxUAxA.s['1']++;YUI.add('aui-progressbar',function(A,NAME){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['1']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['2']++;var toNumber=function(v){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['2']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['3']++;return(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['1'][0]++,parseFloat(v))||(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['1'][1]++,0);},CSS_BAR=A.getClassName('progress','bar'),CSS_HORIZONTAL=A.getClassName('horizontal'),CSS_VERTICAL=A.getClassName('vertical'),TPL_TEXT='<p></p>';__cov_zh_sN2iWl$WvlxSUgxUAxA.s['4']++;var ProgressBar=A.Component.create({NAME:'progress',ATTRS:{height:{valueFn:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['3']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['5']++;return(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['2'][0]++,this.get('boundingBox').get('offsetHeight'))||(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['2'][1]++,25);}},label:{},max:{validator:A.Lang.isNumber,value:100},min:{validator:A.Lang.isNumber,value:0},orientation:{value:'horizontal',validator:function(val){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['4']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['6']++;return(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['3'][0]++,A.Lang.isString(val))&&((__cov_zh_sN2iWl$WvlxSUgxUAxA.b['3'][1]++,val==='horizontal')||(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['3'][2]++,val==='vertical'));}},ratio:{getter:'_getRatio',readOnly:true},step:{getter:'_getStep',readOnly:true},tabIndex:{value:1},textNode:{valueFn:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['5']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['7']++;return A.Node.create(TPL_TEXT);}},useARIA:{value:true},value:{setter:toNumber,validator:function(val){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['6']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['8']++;return(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['4'][0]++,A.Lang.isNumber(toNumber(val)))&&((__cov_zh_sN2iWl$WvlxSUgxUAxA.b['4'][1]++,val>=this.get('min'))&&(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['4'][2]++,val<=this.get('max')));},value:0}},HTML_PARSER:{label:function(boundingBox){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['7']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['9']++;var textNode=boundingBox.one('p');__cov_zh_sN2iWl$WvlxSUgxUAxA.s['10']++;if(textNode){__cov_zh_sN2iWl$WvlxSUgxUAxA.b['5'][0]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['11']++;return textNode.html();}else{__cov_zh_sN2iWl$WvlxSUgxUAxA.b['5'][1]++;}},textNode:'p'},UI_ATTRS:['label','orientation','value'],prototype:{renderUI:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['8']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['12']++;this.get('contentBox').addClass(CSS_BAR);__cov_zh_sN2iWl$WvlxSUgxUAxA.s['13']++;this._renderTextNodeIfLabelSet();},syncUI:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['9']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['14']++;if(this.get('useARIA')){__cov_zh_sN2iWl$WvlxSUgxUAxA.b['6'][0]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['15']++;this.plug(A.Plugin.Aria,{attributes:{value:'valuenow',max:'valuemax',min:'valuemin',orientation:'orientation'},roleName:'progressbar'});}else{__cov_zh_sN2iWl$WvlxSUgxUAxA.b['6'][1]++;}},_getBoundingBoxSize:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['10']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['16']++;return toNumber(this.get('boundingBox').getStyle(this.get('orientation')==='horizontal'?(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['7'][0]++,'width'):(__cov_zh_sN2iWl$WvlxSUgxUAxA.b['7'][1]++,'height')));},_getRatio:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['11']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['17']++;var min=this.get('min'),ratio=(this.get('value')-min)/(this.get('max')-min);__cov_zh_sN2iWl$WvlxSUgxUAxA.s['18']++;return Math.max(ratio,0);},_getStep:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['12']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['19']++;return this.get('ratio')*100;},_renderTextNodeIfLabelSet:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['13']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['20']++;if(!A.Lang.isUndefined(this.get('label'))){__cov_zh_sN2iWl$WvlxSUgxUAxA.b['8'][0]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['21']++;this.get('contentBox').append(this.get('textNode'));}else{__cov_zh_sN2iWl$WvlxSUgxUAxA.b['8'][1]++;}},_uiSetLabel:function(val){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['14']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['22']++;var textNode=this.get('textNode');__cov_zh_sN2iWl$WvlxSUgxUAxA.s['23']++;if(!textNode.inDoc()){__cov_zh_sN2iWl$WvlxSUgxUAxA.b['9'][0]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['24']++;this._renderTextNodeIfLabelSet();}else{__cov_zh_sN2iWl$WvlxSUgxUAxA.b['9'][1]++;}__cov_zh_sN2iWl$WvlxSUgxUAxA.s['25']++;textNode.html(val);},_uiSetOrientation:function(val){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['15']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['26']++;var boundingBox=this.get('boundingBox'),horizontal=val==='horizontal';__cov_zh_sN2iWl$WvlxSUgxUAxA.s['27']++;boundingBox.toggleClass(CSS_HORIZONTAL,horizontal);__cov_zh_sN2iWl$WvlxSUgxUAxA.s['28']++;boundingBox.toggleClass(CSS_VERTICAL,!horizontal);__cov_zh_sN2iWl$WvlxSUgxUAxA.s['29']++;this._uiSetValue(this.get('value'));__cov_zh_sN2iWl$WvlxSUgxUAxA.s['30']++;this._uiSizeTextNode();},_uiSetValue:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['16']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['31']++;var percentStep=this._getStep(),styles;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['32']++;if(this.get('orientation')==='horizontal'){__cov_zh_sN2iWl$WvlxSUgxUAxA.b['10'][0]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['33']++;styles={height:'100%',width:percentStep+'%'};}else{__cov_zh_sN2iWl$WvlxSUgxUAxA.b['10'][1]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['34']++;styles={height:percentStep+'%',width:'100%'};}__cov_zh_sN2iWl$WvlxSUgxUAxA.s['35']++;if(this.get('step')>=100){__cov_zh_sN2iWl$WvlxSUgxUAxA.b['11'][0]++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['36']++;this.fire('complete');}else{__cov_zh_sN2iWl$WvlxSUgxUAxA.b['11'][1]++;}__cov_zh_sN2iWl$WvlxSUgxUAxA.s['37']++;this.get('contentBox').setStyles(styles);},_uiSizeTextNode:function(){__cov_zh_sN2iWl$WvlxSUgxUAxA.f['17']++;__cov_zh_sN2iWl$WvlxSUgxUAxA.s['38']++;this.get('textNode').setStyle('lineHeight',this.get('boundingBox').getStyle('height'));}}});__cov_zh_sN2iWl$WvlxSUgxUAxA.s['39']++;A.ProgressBar=ProgressBar;},'3.1.0-deprecated.89',{'requires':['aui-node','aui-component','aui-aria'],'skinnable':true});
