if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/aui-event-input/aui-event-input.js']) {
   __coverage__['build/aui-event-input/aui-event-input.js'] = {"path":"build/aui-event-input/aui-event-input.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":27},"end":{"line":1,"column":46}}},"2":{"name":"(anonymous_2)","line":52,"loc":{"start":{"line":52,"column":8},"end":{"line":52,"column":47}}},"3":{"name":"(anonymous_3)","line":68,"loc":{"start":{"line":68,"column":14},"end":{"line":68,"column":61}}},"4":{"name":"(anonymous_4)","line":72,"loc":{"start":{"line":72,"column":55},"end":{"line":72,"column":71}}},"5":{"name":"(anonymous_5)","line":95,"loc":{"start":{"line":95,"column":12},"end":{"line":95,"column":41}}},"6":{"name":"(anonymous_6)","line":107,"loc":{"start":{"line":107,"column":20},"end":{"line":107,"column":49}}},"7":{"name":"(anonymous_7)","line":108,"loc":{"start":{"line":108,"column":44},"end":{"line":108,"column":61}}},"8":{"name":"(anonymous_8)","line":127,"loc":{"start":{"line":127,"column":20},"end":{"line":127,"column":60}}},"9":{"name":"(anonymous_9)","line":164,"loc":{"start":{"line":164,"column":16},"end":{"line":164,"column":72}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":176,"column":108}},"2":{"start":{"line":12,"column":0},"end":{"line":12,"column":35}},"3":{"start":{"line":17,"column":0},"end":{"line":21,"column":1}},"4":{"start":{"line":19,"column":4},"end":{"line":19,"column":25}},"5":{"start":{"line":20,"column":4},"end":{"line":20,"column":11}},"6":{"start":{"line":23,"column":0},"end":{"line":23,"column":19}},"7":{"start":{"line":24,"column":0},"end":{"line":24,"column":23}},"8":{"start":{"line":25,"column":0},"end":{"line":25,"column":21}},"9":{"start":{"line":27,"column":0},"end":{"line":35,"column":6}},"10":{"start":{"line":42,"column":0},"end":{"line":173,"column":3}},"11":{"start":{"line":53,"column":8},"end":{"line":53,"column":28}},"12":{"start":{"line":55,"column":8},"end":{"line":56,"column":98}},"13":{"start":{"line":69,"column":8},"end":{"line":69,"column":28}},"14":{"start":{"line":71,"column":8},"end":{"line":71,"column":35}},"15":{"start":{"line":72,"column":8},"end":{"line":84,"column":19}},"16":{"start":{"line":73,"column":12},"end":{"line":74,"column":61}},"17":{"start":{"line":76,"column":12},"end":{"line":83,"column":13}},"18":{"start":{"line":77,"column":16},"end":{"line":79,"column":87}},"19":{"start":{"line":81,"column":16},"end":{"line":81,"column":52}},"20":{"start":{"line":82,"column":16},"end":{"line":82,"column":60}},"21":{"start":{"line":96,"column":8},"end":{"line":96,"column":39}},"22":{"start":{"line":108,"column":8},"end":{"line":114,"column":11}},"23":{"start":{"line":109,"column":12},"end":{"line":109,"column":47}},"24":{"start":{"line":110,"column":12},"end":{"line":112,"column":13}},"25":{"start":{"line":111,"column":16},"end":{"line":111,"column":57}},"26":{"start":{"line":113,"column":12},"end":{"line":113,"column":28}},"27":{"start":{"line":115,"column":8},"end":{"line":115,"column":39}},"28":{"start":{"line":128,"column":8},"end":{"line":130,"column":27}},"29":{"start":{"line":132,"column":8},"end":{"line":132,"column":29}},"30":{"start":{"line":136,"column":8},"end":{"line":151,"column":9}},"31":{"start":{"line":139,"column":12},"end":{"line":150,"column":13}},"32":{"start":{"line":140,"column":16},"end":{"line":143,"column":17}},"33":{"start":{"line":141,"column":20},"end":{"line":141,"column":49}},"34":{"start":{"line":142,"column":20},"end":{"line":142,"column":47}},"35":{"start":{"line":145,"column":16},"end":{"line":145,"column":100}},"36":{"start":{"line":147,"column":16},"end":{"line":149,"column":18}},"37":{"start":{"line":165,"column":8},"end":{"line":165,"column":33}},"38":{"start":{"line":167,"column":8},"end":{"line":167,"column":35}},"39":{"start":{"line":169,"column":8},"end":{"line":171,"column":9}},"40":{"start":{"line":170,"column":12},"end":{"line":170,"column":33}}},"branchMap":{"1":{"line":17,"type":"if","locations":[{"start":{"line":17,"column":0},"end":{"line":17,"column":0}},{"start":{"line":17,"column":0},"end":{"line":17,"column":0}}]},"2":{"line":76,"type":"if","locations":[{"start":{"line":76,"column":12},"end":{"line":76,"column":12}},{"start":{"line":76,"column":12},"end":{"line":76,"column":12}}]},"3":{"line":110,"type":"if","locations":[{"start":{"line":110,"column":12},"end":{"line":110,"column":12}},{"start":{"line":110,"column":12},"end":{"line":110,"column":12}}]},"4":{"line":136,"type":"if","locations":[{"start":{"line":136,"column":8},"end":{"line":136,"column":8}},{"start":{"line":136,"column":8},"end":{"line":136,"column":8}}]},"5":{"line":136,"type":"binary-expr","locations":[{"start":{"line":136,"column":12},"end":{"line":136,"column":45}},{"start":{"line":137,"column":13},"end":{"line":137,"column":70}}]},"6":{"line":139,"type":"if","locations":[{"start":{"line":139,"column":12},"end":{"line":139,"column":12}},{"start":{"line":139,"column":12},"end":{"line":139,"column":12}}]},"7":{"line":140,"type":"if","locations":[{"start":{"line":140,"column":16},"end":{"line":140,"column":16}},{"start":{"line":140,"column":16},"end":{"line":140,"column":16}}]},"8":{"line":145,"type":"cond-expr","locations":[{"start":{"line":145,"column":74},"end":{"line":145,"column":78}},{"start":{"line":145,"column":81},"end":{"line":145,"column":99}}]},"9":{"line":169,"type":"if","locations":[{"start":{"line":169,"column":8},"end":{"line":169,"column":8}},{"start":{"line":169,"column":8},"end":{"line":169,"column":8}}]}},"code":["(function () { YUI.add('aui-event-input', function (A, NAME) {","","/**"," * An object that encapsulates text changed events for textareas and input"," * element of type text and password. This event only occurs when the element"," * is focused."," *"," * @module aui-event"," * @submodule aui-event-input"," */","","var DOM_EVENTS = A.Node.DOM_EVENTS;","","// Input event feature check should be done on textareas. WebKit before","// version 531 (3.0.182.2) did not support input events for textareas.","// See http://dev.chromium.org/developers/webkit-version-table","if (A.Features.test('event', 'input')) {","    // http://yuilibrary.com/projects/yui3/ticket/2533063","    DOM_EVENTS.input = 1;","    return;","}","","DOM_EVENTS.cut = 1;","DOM_EVENTS.dragend = 1;","DOM_EVENTS.paste = 1;","","var KeyMap = A.Event.KeyMap,","","    _HANDLER_DATA_KEY = '~~aui|input|event~~',","    _INPUT_EVENT_TYPE = ['keydown', 'paste', 'drop', 'cut'],","    _SKIP_FOCUS_CHECK_MAP = {","        cut: 1,","        drop: 1,","        paste: 1","    };","","/**"," * Defines a new `input` event in the DOM event system."," *"," * @event input"," */","A.Event.define('input', {","","    /**","     * Implementation logic for event subscription.","     *","     * @method on","     * @param node","     * @param subscription","     * @param notifier","     */","    on: function(node, subscription, notifier) {","        var instance = this;","","        subscription._handler = node.on(","            _INPUT_EVENT_TYPE, A.bind(instance._dispatchEvent, instance, subscription, notifier));","    },","","    /**","     * Implementation logic for subscription via `node.delegate`.","     *","     * @method delegate","     * @param node","     * @param subscription","     * @param notifier","     * @param filter","     */","    delegate: function(node, subscription, notifier, filter) {","        var instance = this;","","        subscription._handles = [];","        subscription._handler = node.delegate('focus', function(event) {","            var element = event.target,","                handler = element.getData(_HANDLER_DATA_KEY);","","            if (!handler) {","                handler = element.on(","                    _INPUT_EVENT_TYPE,","                    A.bind(instance._dispatchEvent, instance, subscription, notifier));","","                subscription._handles.push(handler);","                element.setData(_HANDLER_DATA_KEY, handler);","            }","        }, filter);","    },","","    /**","     * Implementation logic for cleaning up a detached subscription.","     *","     * @method detach","     * @param node","     * @param subscription","     * @param notifier","     */","    detach: function(node, subscription) {","        subscription._handler.detach();","    },","","    /**","     * Implementation logic for cleaning up a detached delegate subscription.","     *","     * @method detachDelegate","     * @param node","     * @param subscription","     * @param notifier","     */","    detachDelegate: function(node, subscription) {","        A.Array.each(subscription._handles, function(handle) {","            var element = A.one(handle.evt.el);","            if (element) {","                element.setData(_HANDLER_DATA_KEY, null);","            }","            handle.detach();","        });","        subscription._handler.detach();","    },","","    /**","     * Dispatches an `input` event.","     *","     * @method _dispatchEvent","     * @param subscription","     * @param notifier","     * @param event","     * @protected","     */","    _dispatchEvent: function(subscription, notifier, event) {","        var instance = this,","            input,","            valueBeforeKey;","","        input = event.target;","","        // Since cut, drop and paste events fires before the element is focused,","        // skip focus checking.","        if (_SKIP_FOCUS_CHECK_MAP[event.type] ||","            (input.get('ownerDocument').get('activeElement') === input)) {","","            if (KeyMap.isModifyingKey(event.keyCode)) {","                if (subscription._timer) {","                    subscription._timer.cancel();","                    subscription._timer = null;","                }","","                valueBeforeKey = KeyMap.isKey(event.keyCode, 'WIN_IME') ? null : input.get('value');","","                subscription._timer = A.soon(","                    A.bind('_fireEvent', instance, subscription, notifier, event, valueBeforeKey)","                );","            }","        }","    },","","    /**","     * Fires an event.","     *","     * @method _fireEvent","     * @param subscription","     * @param notifier","     * @param event","     * @param valueBeforeKey","     * @protected","     */","    _fireEvent: function(subscription, notifier, event, valueBeforeKey) {","        var input = event.target;","","        subscription._timer = null;","","        if (input.get('value') !== valueBeforeKey) {","            notifier.fire(event);","        }","    }","});","","","}, '3.1.0-deprecated.128', {\"requires\": [\"aui-event-base\", \"event-delegate\", \"event-synthetic\", \"timers\"]});","","}());"]};
}
var __cov_q$829IsLyqbPmX23Rfk6oQ = __coverage__['build/aui-event-input/aui-event-input.js'];
__cov_q$829IsLyqbPmX23Rfk6oQ.s['1']++;YUI.add('aui-event-input',function(A,NAME){__cov_q$829IsLyqbPmX23Rfk6oQ.f['1']++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['2']++;var DOM_EVENTS=A.Node.DOM_EVENTS;__cov_q$829IsLyqbPmX23Rfk6oQ.s['3']++;if(A.Features.test('event','input')){__cov_q$829IsLyqbPmX23Rfk6oQ.b['1'][0]++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['4']++;DOM_EVENTS.input=1;__cov_q$829IsLyqbPmX23Rfk6oQ.s['5']++;return;}else{__cov_q$829IsLyqbPmX23Rfk6oQ.b['1'][1]++;}__cov_q$829IsLyqbPmX23Rfk6oQ.s['6']++;DOM_EVENTS.cut=1;__cov_q$829IsLyqbPmX23Rfk6oQ.s['7']++;DOM_EVENTS.dragend=1;__cov_q$829IsLyqbPmX23Rfk6oQ.s['8']++;DOM_EVENTS.paste=1;__cov_q$829IsLyqbPmX23Rfk6oQ.s['9']++;var KeyMap=A.Event.KeyMap,_HANDLER_DATA_KEY='~~aui|input|event~~',_INPUT_EVENT_TYPE=['keydown','paste','drop','cut'],_SKIP_FOCUS_CHECK_MAP={cut:1,drop:1,paste:1};__cov_q$829IsLyqbPmX23Rfk6oQ.s['10']++;A.Event.define('input',{on:function(node,subscription,notifier){__cov_q$829IsLyqbPmX23Rfk6oQ.f['2']++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['11']++;var instance=this;__cov_q$829IsLyqbPmX23Rfk6oQ.s['12']++;subscription._handler=node.on(_INPUT_EVENT_TYPE,A.bind(instance._dispatchEvent,instance,subscription,notifier));},delegate:function(node,subscription,notifier,filter){__cov_q$829IsLyqbPmX23Rfk6oQ.f['3']++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['13']++;var instance=this;__cov_q$829IsLyqbPmX23Rfk6oQ.s['14']++;subscription._handles=[];__cov_q$829IsLyqbPmX23Rfk6oQ.s['15']++;subscription._handler=node.delegate('focus',function(event){__cov_q$829IsLyqbPmX23Rfk6oQ.f['4']++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['16']++;var element=event.target,handler=element.getData(_HANDLER_DATA_KEY);__cov_q$829IsLyqbPmX23Rfk6oQ.s['17']++;if(!handler){__cov_q$829IsLyqbPmX23Rfk6oQ.b['2'][0]++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['18']++;handler=element.on(_INPUT_EVENT_TYPE,A.bind(instance._dispatchEvent,instance,subscription,notifier));__cov_q$829IsLyqbPmX23Rfk6oQ.s['19']++;subscription._handles.push(handler);__cov_q$829IsLyqbPmX23Rfk6oQ.s['20']++;element.setData(_HANDLER_DATA_KEY,handler);}else{__cov_q$829IsLyqbPmX23Rfk6oQ.b['2'][1]++;}},filter);},detach:function(node,subscription){__cov_q$829IsLyqbPmX23Rfk6oQ.f['5']++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['21']++;subscription._handler.detach();},detachDelegate:function(node,subscription){__cov_q$829IsLyqbPmX23Rfk6oQ.f['6']++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['22']++;A.Array.each(subscription._handles,function(handle){__cov_q$829IsLyqbPmX23Rfk6oQ.f['7']++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['23']++;var element=A.one(handle.evt.el);__cov_q$829IsLyqbPmX23Rfk6oQ.s['24']++;if(element){__cov_q$829IsLyqbPmX23Rfk6oQ.b['3'][0]++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['25']++;element.setData(_HANDLER_DATA_KEY,null);}else{__cov_q$829IsLyqbPmX23Rfk6oQ.b['3'][1]++;}__cov_q$829IsLyqbPmX23Rfk6oQ.s['26']++;handle.detach();});__cov_q$829IsLyqbPmX23Rfk6oQ.s['27']++;subscription._handler.detach();},_dispatchEvent:function(subscription,notifier,event){__cov_q$829IsLyqbPmX23Rfk6oQ.f['8']++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['28']++;var instance=this,input,valueBeforeKey;__cov_q$829IsLyqbPmX23Rfk6oQ.s['29']++;input=event.target;__cov_q$829IsLyqbPmX23Rfk6oQ.s['30']++;if((__cov_q$829IsLyqbPmX23Rfk6oQ.b['5'][0]++,_SKIP_FOCUS_CHECK_MAP[event.type])||(__cov_q$829IsLyqbPmX23Rfk6oQ.b['5'][1]++,input.get('ownerDocument').get('activeElement')===input)){__cov_q$829IsLyqbPmX23Rfk6oQ.b['4'][0]++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['31']++;if(KeyMap.isModifyingKey(event.keyCode)){__cov_q$829IsLyqbPmX23Rfk6oQ.b['6'][0]++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['32']++;if(subscription._timer){__cov_q$829IsLyqbPmX23Rfk6oQ.b['7'][0]++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['33']++;subscription._timer.cancel();__cov_q$829IsLyqbPmX23Rfk6oQ.s['34']++;subscription._timer=null;}else{__cov_q$829IsLyqbPmX23Rfk6oQ.b['7'][1]++;}__cov_q$829IsLyqbPmX23Rfk6oQ.s['35']++;valueBeforeKey=KeyMap.isKey(event.keyCode,'WIN_IME')?(__cov_q$829IsLyqbPmX23Rfk6oQ.b['8'][0]++,null):(__cov_q$829IsLyqbPmX23Rfk6oQ.b['8'][1]++,input.get('value'));__cov_q$829IsLyqbPmX23Rfk6oQ.s['36']++;subscription._timer=A.soon(A.bind('_fireEvent',instance,subscription,notifier,event,valueBeforeKey));}else{__cov_q$829IsLyqbPmX23Rfk6oQ.b['6'][1]++;}}else{__cov_q$829IsLyqbPmX23Rfk6oQ.b['4'][1]++;}},_fireEvent:function(subscription,notifier,event,valueBeforeKey){__cov_q$829IsLyqbPmX23Rfk6oQ.f['9']++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['37']++;var input=event.target;__cov_q$829IsLyqbPmX23Rfk6oQ.s['38']++;subscription._timer=null;__cov_q$829IsLyqbPmX23Rfk6oQ.s['39']++;if(input.get('value')!==valueBeforeKey){__cov_q$829IsLyqbPmX23Rfk6oQ.b['9'][0]++;__cov_q$829IsLyqbPmX23Rfk6oQ.s['40']++;notifier.fire(event);}else{__cov_q$829IsLyqbPmX23Rfk6oQ.b['9'][1]++;}}});},'3.1.0-deprecated.128',{'requires':['aui-event-base','event-delegate','event-synthetic','timers']});
