if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/file-flash/file-flash.js']) {
   __coverage__['build/file-flash/file-flash.js'] = {"path":"build/file-flash/file-flash.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0,0,0,0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":22},"end":{"line":1,"column":41}}},"2":{"name":"(anonymous_2)","line":16,"loc":{"start":{"line":16,"column":20},"end":{"line":16,"column":32}}},"3":{"name":"(anonymous_3)","line":28,"loc":{"start":{"line":28,"column":22},"end":{"line":28,"column":37}}},"4":{"name":"(anonymous_4)","line":41,"loc":{"start":{"line":41,"column":26},"end":{"line":41,"column":43}}},"5":{"name":"(anonymous_5)","line":166,"loc":{"start":{"line":166,"column":21},"end":{"line":166,"column":62}}},"6":{"name":"(anonymous_6)","line":193,"loc":{"start":{"line":193,"column":22},"end":{"line":193,"column":34}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":341,"column":40}},"2":{"start":{"line":16,"column":4},"end":{"line":18,"column":6}},"3":{"start":{"line":17,"column":8},"end":{"line":17,"column":64}},"4":{"start":{"line":20,"column":4},"end":{"line":336,"column":7}},"5":{"start":{"line":29,"column":12},"end":{"line":31,"column":13}},"6":{"start":{"line":30,"column":16},"end":{"line":30,"column":48}},"7":{"start":{"line":42,"column":10},"end":{"line":155,"column":9}},"8":{"start":{"line":43,"column":10},"end":{"line":154,"column":11}},"9":{"start":{"line":56,"column":17},"end":{"line":56,"column":76}},"10":{"start":{"line":57,"column":17},"end":{"line":57,"column":23}},"11":{"start":{"line":77,"column":17},"end":{"line":81,"column":48}},"12":{"start":{"line":82,"column":17},"end":{"line":82,"column":63}},"13":{"start":{"line":83,"column":17},"end":{"line":83,"column":23}},"14":{"start":{"line":97,"column":17},"end":{"line":97,"column":67}},"15":{"start":{"line":98,"column":17},"end":{"line":98,"column":23}},"16":{"start":{"line":113,"column":17},"end":{"line":114,"column":65}},"17":{"start":{"line":115,"column":17},"end":{"line":115,"column":23}},"18":{"start":{"line":129,"column":17},"end":{"line":129,"column":65}},"19":{"start":{"line":130,"column":17},"end":{"line":130,"column":23}},"20":{"start":{"line":152,"column":17},"end":{"line":152,"column":135}},"21":{"start":{"line":168,"column":8},"end":{"line":184,"column":10}},"22":{"start":{"line":170,"column":12},"end":{"line":173,"column":44}},"23":{"start":{"line":175,"column":12},"end":{"line":175,"column":42}},"24":{"start":{"line":177,"column":12},"end":{"line":177,"column":70}},"25":{"start":{"line":178,"column":12},"end":{"line":178,"column":73}},"26":{"start":{"line":179,"column":12},"end":{"line":179,"column":73}},"27":{"start":{"line":180,"column":12},"end":{"line":180,"column":77}},"28":{"start":{"line":181,"column":12},"end":{"line":181,"column":70}},"29":{"start":{"line":183,"column":12},"end":{"line":183,"column":71}},"30":{"start":{"line":194,"column":9},"end":{"line":197,"column":10}},"31":{"start":{"line":195,"column":11},"end":{"line":195,"column":68}},"32":{"start":{"line":196,"column":11},"end":{"line":196,"column":37}},"33":{"start":{"line":338,"column":4},"end":{"line":338,"column":28}}},"branchMap":{"1":{"line":29,"type":"if","locations":[{"start":{"line":29,"column":12},"end":{"line":29,"column":12}},{"start":{"line":29,"column":12},"end":{"line":29,"column":12}}]},"2":{"line":42,"type":"if","locations":[{"start":{"line":42,"column":10},"end":{"line":42,"column":10}},{"start":{"line":42,"column":10},"end":{"line":42,"column":10}}]},"3":{"line":43,"type":"switch","locations":[{"start":{"line":55,"column":12},"end":{"line":57,"column":23}},{"start":{"line":58,"column":12},"end":{"line":83,"column":23}},{"start":{"line":84,"column":12},"end":{"line":98,"column":23}},{"start":{"line":99,"column":12},"end":{"line":115,"column":23}},{"start":{"line":116,"column":12},"end":{"line":130,"column":23}},{"start":{"line":131,"column":12},"end":{"line":152,"column":135}}]},"4":{"line":168,"type":"if","locations":[{"start":{"line":168,"column":8},"end":{"line":168,"column":8}},{"start":{"line":168,"column":8},"end":{"line":168,"column":8}}]},"5":{"line":171,"type":"binary-expr","locations":[{"start":{"line":171,"column":28},"end":{"line":171,"column":41}},{"start":{"line":171,"column":45},"end":{"line":171,"column":55}}]},"6":{"line":173,"type":"binary-expr","locations":[{"start":{"line":173,"column":25},"end":{"line":173,"column":35}},{"start":{"line":173,"column":39},"end":{"line":173,"column":43}}]},"7":{"line":194,"type":"if","locations":[{"start":{"line":194,"column":9},"end":{"line":194,"column":9}},{"start":{"line":194,"column":9},"end":{"line":194,"column":9}}]}},"code":["(function () { YUI.add('file-flash', function (Y, NAME) {","","    /**","     * The FileFlash class provides a wrapper for a file pointer stored in Flash. The File wrapper","     * also implements the mechanics for uploading a file and tracking its progress.","     * @module file-flash","     */","    /**","     * The class provides a wrapper for a file pointer in Flash.","     * @class FileFlash","     * @extends Base","     * @constructor","     * @param {Object} config Configuration object.","     */","","    var FileFlash = function(o) {","        FileFlash.superclass.constructor.apply(this, arguments);","    };","","    Y.extend(FileFlash, Y.Base, {","","       /**","        * Construction logic executed during FileFlash instantiation.","        *","        * @method initializer","        * @protected","        */","        initializer : function (cfg) {","            if (!this.get(\"id\")) {","                this._set(\"id\", Y.guid(\"file\"));","            }","        },","","       /**","        * Handler of events dispatched by the Flash player.","        *","        * @method _swfEventHandler","        * @param {Event} event The event object received from the Flash player.","        * @protected","        */","        _swfEventHandler: function (event) {","          if (event.id === this.get(\"id\")) {","          switch (event.type) {","            /**","             * Signals that this file's upload has started.","             *","             * @event uploadstart","             * @param event {Event} The event object for the `uploadstart` with the","             *                      following payload:","             *  <dl>","             *      <dt>uploader</dt>","             *          <dd>The Y.SWF instance of Flash uploader that's handling the upload.</dd>","             *  </dl>","             */","            case \"uploadstart\":","                 this.fire(\"uploadstart\", {uploader: this.get(\"uploader\")});","                 break;","            case \"uploadprogress\":","","                  /**","                   * Signals that progress has been made on the upload of this file.","                   *","                   * @event uploadprogress","                   * @param event {Event} The event object for the `uploadprogress` with the","                   *                      following payload:","                   *  <dl>","                   *      <dt>originEvent</dt>","                   *          <dd>The original event fired by the Flash uploader instance.</dd>","                   *      <dt>bytesLoaded</dt>","                   *          <dd>The number of bytes of the file that has been uploaded.</dd>","                   *      <dt>bytesTotal</dt>","                   *          <dd>The total number of bytes in the file (the file size)</dd>","                   *      <dt>percentLoaded</dt>","                   *          <dd>The fraction of the file that has been uploaded, out of 100.</dd>","                   *  </dl>","                   */","                 this.fire(\"uploadprogress\", {originEvent: event,","                                              bytesLoaded: event.bytesLoaded,","                                              bytesTotal: event.bytesTotal,","                                              percentLoaded: Math.min(100, Math.round(10000*event.bytesLoaded/event.bytesTotal)/100)","                                             });","                 this._set(\"bytesUploaded\", event.bytesLoaded);","                 break;","            case \"uploadcomplete\":","","                  /**","                   * Signals that this file's upload has completed, but data has not yet been received from the server.","                   *","                   * @event uploadfinished","                   * @param event {Event} The event object for the `uploadfinished` with the","                   *                      following payload:","                   *  <dl>","                   *      <dt>originEvent</dt>","                   *          <dd>The original event fired by the Flash player instance.</dd>","                   *  </dl>","                   */","                 this.fire(\"uploadfinished\", {originEvent: event});","                 break;","            case \"uploadcompletedata\":","                /**","                 * Signals that this file's upload has completed and data has been received from the server.","                 *","                 * @event uploadcomplete","                 * @param event {Event} The event object for the `uploadcomplete` with the","                 *                      following payload:","                 *  <dl>","                 *      <dt>originEvent</dt>","                 *          <dd>The original event fired by the Flash player instance.</dd>","                 *      <dt>data</dt>","                 *          <dd>The data returned by the server.</dd>","                 *  </dl>","                 */","                 this.fire(\"uploadcomplete\", {originEvent: event,","                                              data: event.data});","                 break;","            case \"uploadcancel\":","","                /**","                 * Signals that this file's upload has been cancelled.","                 *","                 * @event uploadcancel","                 * @param event {Event} The event object for the `uploadcancel` with the","                 *                      following payload:","                 *  <dl>","                 *      <dt>originEvent</dt>","                 *          <dd>The original event fired by the Flash player instance.</dd>","                 *  </dl>","                 */","                 this.fire(\"uploadcancel\", {originEvent: event});","                 break;","            case \"uploaderror\":","","                /**","                 * Signals that this file's upload has encountered an error.","                 *","                 * @event uploaderror","                 * @param event {Event} The event object for the `uploaderror` with the","                 *                      following payload:","                 *  <dl>","                 *      <dt>originEvent</dt>","                 *          <dd>The original event fired by the Flash player instance.</dd>","                 *      <dt>status</dt>","                 *          <dd>The status code reported by the Flash Player. If it's an HTTP error,","                 *                then this corresponds to the HTTP status code received by the uploader.</dd>","                 *      <dt>statusText</dt>","                 *          <dd>The text of the error event reported by the Flash Player.</dd>","                 *      <dt>source</dt>","                 *          <dd>Either \"http\" (if it's an HTTP error), or \"io\" (if it's a network transmission","                 *              error.)</dd>","                 *  </dl>","                 */","                 this.fire(\"uploaderror\", {originEvent: event, status: event.status, statusText: event.message, source: event.source});","","          }","        }","        },","","       /**","        * Starts the upload of a specific file.","        *","        * @method startUpload","        * @param url {String} The URL to upload the file to.","        * @param parameters {Object} (optional) A set of key-value pairs to send as variables along with the file upload HTTP request.","        * @param fileFieldName {String} (optional) The name of the POST variable that should contain the uploaded file ('Filedata' by default)","        */","        startUpload: function(url, parameters, fileFieldName) {","","        if (this.get(\"uploader\")) {","","            var myUploader = this.get(\"uploader\"),","                fileField = fileFieldName || \"Filedata\",","                id = this.get(\"id\"),","                params = parameters || null;","","            this._set(\"bytesUploaded\", 0);","","            myUploader.on(\"uploadstart\", this._swfEventHandler, this);","            myUploader.on(\"uploadprogress\", this._swfEventHandler, this);","            myUploader.on(\"uploadcomplete\", this._swfEventHandler, this);","            myUploader.on(\"uploadcompletedata\", this._swfEventHandler, this);","            myUploader.on(\"uploaderror\", this._swfEventHandler, this);","","            myUploader.callSWF(\"upload\", [id, url, params, fileField]);","         }","","        },","","       /**","        * Cancels the upload of a specific file, if currently in progress.","        *","        * @method cancelUpload","        */","        cancelUpload: function () {","         if (this.get(\"uploader\")) {","           this.get(\"uploader\").callSWF(\"cancel\", [this.get(\"id\")]);","           this.fire(\"uploadcancel\");","         }","        }","","    }, {","","       /**","        * The identity of the class.","        *","        * @property NAME","        * @type String","        * @default 'file'","        * @readOnly","        * @protected","        * @static","        */","        NAME: 'file',","","       /**","        * The type of transport.","        *","        * @property TYPE","        * @type String","        * @default 'flash'","        * @readOnly","        * @protected","        * @static","        */","        TYPE: \"flash\",","","       /**","        * Static property used to define the default attribute configuration of","        * the File.","        *","        * @property ATTRS","        * @type {Object}","        * @protected","        * @static","        */","        ATTRS: {","","       /**","        * A String containing the unique id of the file wrapped by the FileFlash instance.","        * The id is supplied by the Flash player uploader.","        *","        * @attribute id","        * @type {String}","        * @initOnly","        */","        id: {","            writeOnce: \"initOnly\",","            value: null","        },","","       /**","        * The size of the file wrapped by FileFlash. This value is supplied by the Flash player uploader.","        *","        * @attribute size","        * @type {Number}","        * @initOnly","        */","        size: {","            writeOnce: \"initOnly\",","            value: 0","        },","","       /**","        * The name of the file wrapped by FileFlash. This value is supplied by the Flash player uploader.","        *","        * @attribute name","        * @type {String}","        * @initOnly","        */","        name: {","            writeOnce: \"initOnly\",","            value: null","        },","","       /**","        * The date that the file wrapped by FileFlash was created on. This value is supplied by the Flash player uploader.","        *","        * @attribute dateCreated","        * @type {Date}","        * @initOnly","        */","        dateCreated: {","            writeOnce: \"initOnly\",","            value: null","        },","","       /**","        * The date that the file wrapped by FileFlash was last modified on. This value is supplied by the Flash player uploader.","        *","        * @attribute dateModified","        * @type {Date}","        * @initOnly","        */","        dateModified: {","            writeOnce: \"initOnly\",","            value: null","        },","","       /**","        * The number of bytes of the file that has been uploaded to the server. This value is","        * non-zero only while a file is being uploaded.","        *","        * @attribute bytesUploaded","        * @type {Date}","        * @readOnly","        */","        bytesUploaded: {","            readOnly: true,","            value: 0","        },","","       /**","        * The type of the file wrapped by FileFlash. This value is provided by the Flash player","        * uploader.","        *","        * @attribute type","        * @type {String}","        * @initOnly","        */","        type: {","            writeOnce: \"initOnly\",","            value: null","        },","","       /**","        * The instance of Y.SWF wrapping the Flash player uploader associated with this file.","        *","        * @attribute uploder","        * @type {SWF}","        * @initOnly","        */","        uploader: {","            writeOnce: \"initOnly\",","            value: null","        }","        }","    });","","    Y.FileFlash = FileFlash;","","","}, 'patched-v3.20.6', {\"requires\": [\"base\"]});","","}());"]};
}
var __cov_xw2Hm6m2cM4kRyhZpOm3Vw = __coverage__['build/file-flash/file-flash.js'];
__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['1']++;YUI.add('file-flash',function(Y,NAME){__cov_xw2Hm6m2cM4kRyhZpOm3Vw.f['1']++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['2']++;var FileFlash=function(o){__cov_xw2Hm6m2cM4kRyhZpOm3Vw.f['2']++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['3']++;FileFlash.superclass.constructor.apply(this,arguments);};__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['4']++;Y.extend(FileFlash,Y.Base,{initializer:function(cfg){__cov_xw2Hm6m2cM4kRyhZpOm3Vw.f['3']++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['5']++;if(!this.get('id')){__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['1'][0]++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['6']++;this._set('id',Y.guid('file'));}else{__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['1'][1]++;}},_swfEventHandler:function(event){__cov_xw2Hm6m2cM4kRyhZpOm3Vw.f['4']++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['7']++;if(event.id===this.get('id')){__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['2'][0]++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['8']++;switch(event.type){case'uploadstart':__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['3'][0]++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['9']++;this.fire('uploadstart',{uploader:this.get('uploader')});__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['10']++;break;case'uploadprogress':__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['3'][1]++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['11']++;this.fire('uploadprogress',{originEvent:event,bytesLoaded:event.bytesLoaded,bytesTotal:event.bytesTotal,percentLoaded:Math.min(100,Math.round(10000*event.bytesLoaded/event.bytesTotal)/100)});__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['12']++;this._set('bytesUploaded',event.bytesLoaded);__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['13']++;break;case'uploadcomplete':__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['3'][2]++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['14']++;this.fire('uploadfinished',{originEvent:event});__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['15']++;break;case'uploadcompletedata':__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['3'][3]++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['16']++;this.fire('uploadcomplete',{originEvent:event,data:event.data});__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['17']++;break;case'uploadcancel':__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['3'][4]++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['18']++;this.fire('uploadcancel',{originEvent:event});__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['19']++;break;case'uploaderror':__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['3'][5]++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['20']++;this.fire('uploaderror',{originEvent:event,status:event.status,statusText:event.message,source:event.source});}}else{__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['2'][1]++;}},startUpload:function(url,parameters,fileFieldName){__cov_xw2Hm6m2cM4kRyhZpOm3Vw.f['5']++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['21']++;if(this.get('uploader')){__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['4'][0]++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['22']++;var myUploader=this.get('uploader'),fileField=(__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['5'][0]++,fileFieldName)||(__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['5'][1]++,'Filedata'),id=this.get('id'),params=(__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['6'][0]++,parameters)||(__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['6'][1]++,null);__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['23']++;this._set('bytesUploaded',0);__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['24']++;myUploader.on('uploadstart',this._swfEventHandler,this);__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['25']++;myUploader.on('uploadprogress',this._swfEventHandler,this);__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['26']++;myUploader.on('uploadcomplete',this._swfEventHandler,this);__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['27']++;myUploader.on('uploadcompletedata',this._swfEventHandler,this);__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['28']++;myUploader.on('uploaderror',this._swfEventHandler,this);__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['29']++;myUploader.callSWF('upload',[id,url,params,fileField]);}else{__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['4'][1]++;}},cancelUpload:function(){__cov_xw2Hm6m2cM4kRyhZpOm3Vw.f['6']++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['30']++;if(this.get('uploader')){__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['7'][0]++;__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['31']++;this.get('uploader').callSWF('cancel',[this.get('id')]);__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['32']++;this.fire('uploadcancel');}else{__cov_xw2Hm6m2cM4kRyhZpOm3Vw.b['7'][1]++;}}},{NAME:'file',TYPE:'flash',ATTRS:{id:{writeOnce:'initOnly',value:null},size:{writeOnce:'initOnly',value:0},name:{writeOnce:'initOnly',value:null},dateCreated:{writeOnce:'initOnly',value:null},dateModified:{writeOnce:'initOnly',value:null},bytesUploaded:{readOnly:true,value:0},type:{writeOnce:'initOnly',value:null},uploader:{writeOnce:'initOnly',value:null}}});__cov_xw2Hm6m2cM4kRyhZpOm3Vw.s['33']++;Y.FileFlash=FileFlash;},'patched-v3.20.6',{'requires':['base']});
