if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/widget-position/widget-position.js']) {
   __coverage__['build/widget-position/widget-position.js'] = {"path":"build/widget-position/widget-position.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0,0],"4":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":27},"end":{"line":1,"column":46}}},"2":{"name":"Position","line":33,"loc":{"start":{"line":33,"column":4},"end":{"line":33,"column":30}}},"3":{"name":"(anonymous_3)","line":55,"loc":{"start":{"line":55,"column":20},"end":{"line":55,"column":34}}},"4":{"name":"(anonymous_4)","line":58,"loc":{"start":{"line":58,"column":20},"end":{"line":58,"column":31}}},"5":{"name":"(anonymous_5)","line":73,"loc":{"start":{"line":73,"column":20},"end":{"line":73,"column":34}}},"6":{"name":"(anonymous_6)","line":76,"loc":{"start":{"line":76,"column":20},"end":{"line":76,"column":31}}},"7":{"name":"(anonymous_7)","line":91,"loc":{"start":{"line":91,"column":23},"end":{"line":91,"column":37}}},"8":{"name":"(anonymous_8)","line":109,"loc":{"start":{"line":109,"column":22},"end":{"line":109,"column":33}}},"9":{"name":"(anonymous_9)","line":127,"loc":{"start":{"line":127,"column":28},"end":{"line":127,"column":39}}},"10":{"name":"(anonymous_10)","line":140,"loc":{"start":{"line":140,"column":26},"end":{"line":140,"column":37}}},"11":{"name":"(anonymous_11)","line":158,"loc":{"start":{"line":158,"column":25},"end":{"line":158,"column":36}}},"12":{"name":"(anonymous_12)","line":171,"loc":{"start":{"line":171,"column":14},"end":{"line":171,"column":26}}},"13":{"name":"(anonymous_13)","line":183,"loc":{"start":{"line":183,"column":17},"end":{"line":183,"column":29}}},"14":{"name":"(anonymous_14)","line":195,"loc":{"start":{"line":195,"column":22},"end":{"line":195,"column":36}}},"15":{"name":"(anonymous_15)","line":207,"loc":{"start":{"line":207,"column":16},"end":{"line":207,"column":30}}},"16":{"name":"(anonymous_16)","line":219,"loc":{"start":{"line":219,"column":16},"end":{"line":219,"column":30}}},"17":{"name":"(anonymous_17)","line":231,"loc":{"start":{"line":231,"column":16},"end":{"line":231,"column":27}}},"18":{"name":"(anonymous_18)","line":243,"loc":{"start":{"line":243,"column":16},"end":{"line":243,"column":27}}},"19":{"name":"(anonymous_19)","line":255,"loc":{"start":{"line":255,"column":25},"end":{"line":255,"column":37}}},"20":{"name":"(anonymous_20)","line":268,"loc":{"start":{"line":268,"column":19},"end":{"line":268,"column":33}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":276,"column":71}},"2":{"start":{"line":8,"column":4},"end":{"line":24,"column":30}},"3":{"start":{"line":33,"column":4},"end":{"line":34,"column":5}},"4":{"start":{"line":44,"column":4},"end":{"line":95,"column":6}},"5":{"start":{"line":56,"column":16},"end":{"line":56,"column":32}},"6":{"start":{"line":59,"column":16},"end":{"line":59,"column":36}},"7":{"start":{"line":74,"column":16},"end":{"line":74,"column":32}},"8":{"start":{"line":77,"column":16},"end":{"line":77,"column":36}},"9":{"start":{"line":92,"column":16},"end":{"line":92,"column":45}},"10":{"start":{"line":105,"column":4},"end":{"line":105,"column":69}},"11":{"start":{"line":107,"column":4},"end":{"line":271,"column":6}},"12":{"start":{"line":110,"column":12},"end":{"line":110,"column":51}},"13":{"start":{"line":113,"column":12},"end":{"line":113,"column":60}},"14":{"start":{"line":114,"column":12},"end":{"line":114,"column":56}},"15":{"start":{"line":115,"column":12},"end":{"line":115,"column":56}},"16":{"start":{"line":128,"column":12},"end":{"line":128,"column":67}},"17":{"start":{"line":141,"column":12},"end":{"line":141,"column":40}},"18":{"start":{"line":142,"column":12},"end":{"line":144,"column":13}},"19":{"start":{"line":143,"column":16},"end":{"line":143,"column":30}},"20":{"start":{"line":145,"column":12},"end":{"line":145,"column":46}},"21":{"start":{"line":159,"column":12},"end":{"line":159,"column":54}},"22":{"start":{"line":172,"column":12},"end":{"line":173,"column":79}},"23":{"start":{"line":174,"column":16},"end":{"line":174,"column":42}},"24":{"start":{"line":184,"column":12},"end":{"line":184,"column":65}},"25":{"start":{"line":196,"column":12},"end":{"line":196,"column":89}},"26":{"start":{"line":208,"column":12},"end":{"line":208,"column":61}},"27":{"start":{"line":220,"column":12},"end":{"line":220,"column":61}},"28":{"start":{"line":232,"column":12},"end":{"line":232,"column":41}},"29":{"start":{"line":244,"column":12},"end":{"line":244,"column":41}},"30":{"start":{"line":256,"column":12},"end":{"line":258,"column":13}},"31":{"start":{"line":257,"column":16},"end":{"line":257,"column":40}},"32":{"start":{"line":269,"column":12},"end":{"line":269,"column":37}},"33":{"start":{"line":273,"column":4},"end":{"line":273,"column":32}}},"branchMap":{"1":{"line":142,"type":"if","locations":[{"start":{"line":142,"column":12},"end":{"line":142,"column":12}},{"start":{"line":142,"column":12},"end":{"line":142,"column":12}}]},"2":{"line":173,"type":"cond-expr","locations":[{"start":{"line":173,"column":50},"end":{"line":173,"column":57}},{"start":{"line":173,"column":60},"end":{"line":173,"column":78}}]},"3":{"line":196,"type":"binary-expr","locations":[{"start":{"line":196,"column":20},"end":{"line":196,"column":37}},{"start":{"line":196,"column":41},"end":{"line":196,"column":62}},{"start":{"line":196,"column":66},"end":{"line":196,"column":87}}]},"4":{"line":256,"type":"if","locations":[{"start":{"line":256,"column":12},"end":{"line":256,"column":12}},{"start":{"line":256,"column":12},"end":{"line":256,"column":12}}]}},"code":["(function () { YUI.add('widget-position', function (Y, NAME) {","","/**"," * Provides basic XY positioning support for Widgets, though an extension"," *"," * @module widget-position"," */","    var Lang = Y.Lang,","        Widget = Y.Widget,","","        XY_COORD = \"xy\",","","        POSITION = \"position\",","        POSITIONED = \"positioned\",","        BOUNDING_BOX = \"boundingBox\",","        RELATIVE = \"relative\",","","        RENDERUI = \"renderUI\",","        BINDUI = \"bindUI\",","        SYNCUI = \"syncUI\",","","        UI = Widget.UI_SRC,","","        XYChange = \"xyChange\";","","    /**","     * Widget extension, which can be used to add positioning support to the base Widget class,","     * through the <a href=\"Base.html#method_build\">Base.build</a> method.","     *","     * @class WidgetPosition","     * @param {Object} config User configuration object","     */","    function Position(config) {","    }","","    /**","     * Static property used to define the default attribute","     * configuration introduced by WidgetPosition.","     *","     * @property ATTRS","     * @static","     * @type Object","     */","    Position.ATTRS = {","","        /**","         * @attribute x","         * @type number","         * @default 0","         *","         * @description Page X co-ordinate for the widget. This attribute acts as a facade for the","         * xy attribute. Changes in position can be monitored by listening for xyChange events.","         */","        x: {","            setter: function(val) {","                this._setX(val);","            },","            getter: function() {","                return this._getX();","            },","            lazyAdd:false","        },","","        /**","         * @attribute y","         * @type number","         * @default 0","         *","         * @description Page Y co-ordinate for the widget. This attribute acts as a facade for the","         * xy attribute. Changes in position can be monitored by listening for xyChange events.","         */","        y: {","            setter: function(val) {","                this._setY(val);","            },","            getter: function() {","                return this._getY();","            },","            lazyAdd: false","        },","","        /**","         * @attribute xy","         * @type Array","         * @default [0,0]","         *","         * @description Page XY co-ordinate pair for the widget.","         */","        xy: {","            value:[0,0],","            validator: function(val) {","                return this._validateXY(val);","            }","        }","    };","","    /**","     * Default class used to mark the boundingBox of a positioned widget.","     *","     * @property POSITIONED_CLASS_NAME","     * @type String","     * @default \"yui-widget-positioned\"","     * @static","     */","    Position.POSITIONED_CLASS_NAME = Widget.getClassName(POSITIONED);","","    Position.prototype = {","","        initializer : function() {","            this._posNode = this.get(BOUNDING_BOX);","","            // WIDGET METHOD OVERLAP","            Y.after(this._renderUIPosition, this, RENDERUI);","            Y.after(this._syncUIPosition, this, SYNCUI);","            Y.after(this._bindUIPosition, this, BINDUI);","        },","","        /**","         * Creates/Initializes the DOM to support xy page positioning.","         * <p>","         * This method in invoked after renderUI is invoked for the Widget class","         * using YUI's aop infrastructure.","         * </p>","         * @method _renderUIPosition","         * @protected","         */","        _renderUIPosition : function() {","            this._posNode.addClass(Position.POSITIONED_CLASS_NAME);","        },","","        /**","         * Synchronizes the UI to match the Widgets xy page position state.","         * <p>","         * This method in invoked after syncUI is invoked for the Widget class","         * using YUI's aop infrastructure.","         * </p>","         * @method _syncUIPosition","         * @protected","         */","        _syncUIPosition : function() {","            var posNode = this._posNode;","            if (posNode.getStyle(POSITION) === RELATIVE) {","                this.syncXY();","            }","            this._uiSetXY(this.get(XY_COORD));","        },","","        /**","         * Binds event listeners responsible for updating the UI state in response to","         * Widget position related state changes.","         * <p>","         * This method in invoked after bindUI is invoked for the Widget class","         * using YUI's aop infrastructure.","         * </p>","         * @method _bindUIPosition","         * @protected","         */","        _bindUIPosition :function() {","            this.after(XYChange, this._afterXYChange);","        },","","        /**","         * Moves the Widget to the specified page xy co-ordinate position.","         *","         * @method move","         *","         * @param {Number|Number[]} x The new x position or [x, y] values passed","         * as an array to support simple pass through of Node.getXY results","         * @param {Number} [y] The new y position","         */","        move: function () {","            var args = arguments,","                coord = (Lang.isArray(args[0])) ? args[0] : [args[0], args[1]];","                this.set(XY_COORD, coord);","        },","","        /**","         * Synchronizes the Panel's \"xy\", \"x\", and \"y\" properties with the","         * Widget's position in the DOM.","         *","         * @method syncXY","         */","        syncXY : function () {","            this.set(XY_COORD, this._posNode.getXY(), {src: UI});","        },","","        /**","         * Default validator for the XY attribute","         *","         * @method _validateXY","         * @protected","         * @param {Array} val The XY page co-ordinate value which is being set.","         * @return {boolean} true if valid, false if not.","         */","        _validateXY : function(val) {","            return (Lang.isArray(val) && Lang.isNumber(val[0]) && Lang.isNumber(val[1]));","        },","","        /**","         * Default setter for the X attribute. The setter passes the X value through","         * to the XY attribute, which is the sole store for the XY state.","         *","         * @method _setX","         * @protected","         * @param {Number} val The X page co-ordinate value","         */","        _setX : function(val) {","            this.set(XY_COORD, [val, this.get(XY_COORD)[1]]);","        },","","        /**","         * Default setter for the Y attribute. The setter passes the Y value through","         * to the XY attribute, which is the sole store for the XY state.","         *","         * @method _setY","         * @protected","         * @param {Number} val The Y page co-ordinate value","         */","        _setY : function(val) {","            this.set(XY_COORD, [this.get(XY_COORD)[0], val]);","        },","","        /**","         * Default getter for the X attribute. The value is retrieved from","         * the XY attribute, which is the sole store for the XY state.","         *","         * @method _getX","         * @protected","         * @return {Number} The X page co-ordinate value","         */","        _getX : function() {","            return this.get(XY_COORD)[0];","        },","","        /**","         * Default getter for the Y attribute. The value is retrieved from","         * the XY attribute, which is the sole store for the XY state.","         *","         * @method _getY","         * @protected","         * @return {Number} The Y page co-ordinate value","         */","        _getY : function() {","            return this.get(XY_COORD)[1];","        },","","        /**","         * Default attribute change listener for the xy attribute, responsible","         * for updating the UI, in response to attribute changes.","         *","         * @method _afterXYChange","         * @protected","         * @param {EventFacade} e The event facade for the attribute change","         */","        _afterXYChange : function(e) {","            if (e.src != UI) {","                this._uiSetXY(e.newVal);","            }","        },","","        /**","         * Updates the UI to reflect the XY page co-ordinates passed in.","         *","         * @method _uiSetXY","         * @protected","         * @param {String} val The XY page co-ordinates value to be reflected in the UI","         */","        _uiSetXY : function(val) {","            this._posNode.setXY(val);","        }","    };","","    Y.WidgetPosition = Position;","","","}, 'patched-v3.20.5', {\"requires\": [\"base-build\", \"node-screen\", \"widget\"]});","","}());"]};
}
var __cov_rwEdJ_2e$TkRuEvyx2pkhQ = __coverage__['build/widget-position/widget-position.js'];
__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['1']++;YUI.add('widget-position',function(Y,NAME){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['1']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['2']++;var Lang=Y.Lang,Widget=Y.Widget,XY_COORD='xy',POSITION='position',POSITIONED='positioned',BOUNDING_BOX='boundingBox',RELATIVE='relative',RENDERUI='renderUI',BINDUI='bindUI',SYNCUI='syncUI',UI=Widget.UI_SRC,XYChange='xyChange';__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['3']++;function Position(config){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['2']++;}__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['4']++;Position.ATTRS={x:{setter:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['3']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['5']++;this._setX(val);},getter:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['4']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['6']++;return this._getX();},lazyAdd:false},y:{setter:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['5']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['7']++;this._setY(val);},getter:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['6']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['8']++;return this._getY();},lazyAdd:false},xy:{value:[0,0],validator:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['7']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['9']++;return this._validateXY(val);}}};__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['10']++;Position.POSITIONED_CLASS_NAME=Widget.getClassName(POSITIONED);__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['11']++;Position.prototype={initializer:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['8']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['12']++;this._posNode=this.get(BOUNDING_BOX);__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['13']++;Y.after(this._renderUIPosition,this,RENDERUI);__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['14']++;Y.after(this._syncUIPosition,this,SYNCUI);__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['15']++;Y.after(this._bindUIPosition,this,BINDUI);},_renderUIPosition:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['9']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['16']++;this._posNode.addClass(Position.POSITIONED_CLASS_NAME);},_syncUIPosition:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['10']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['17']++;var posNode=this._posNode;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['18']++;if(posNode.getStyle(POSITION)===RELATIVE){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['1'][0]++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['19']++;this.syncXY();}else{__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['1'][1]++;}__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['20']++;this._uiSetXY(this.get(XY_COORD));},_bindUIPosition:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['11']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['21']++;this.after(XYChange,this._afterXYChange);},move:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['12']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['22']++;var args=arguments,coord=Lang.isArray(args[0])?(__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['2'][0]++,args[0]):(__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['2'][1]++,[args[0],args[1]]);__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['23']++;this.set(XY_COORD,coord);},syncXY:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['13']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['24']++;this.set(XY_COORD,this._posNode.getXY(),{src:UI});},_validateXY:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['14']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['25']++;return(__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['3'][0]++,Lang.isArray(val))&&(__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['3'][1]++,Lang.isNumber(val[0]))&&(__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['3'][2]++,Lang.isNumber(val[1]));},_setX:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['15']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['26']++;this.set(XY_COORD,[val,this.get(XY_COORD)[1]]);},_setY:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['16']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['27']++;this.set(XY_COORD,[this.get(XY_COORD)[0],val]);},_getX:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['17']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['28']++;return this.get(XY_COORD)[0];},_getY:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['18']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['29']++;return this.get(XY_COORD)[1];},_afterXYChange:function(e){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['19']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['30']++;if(e.src!=UI){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['4'][0]++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['31']++;this._uiSetXY(e.newVal);}else{__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['4'][1]++;}},_uiSetXY:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['20']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['32']++;this._posNode.setXY(val);}};__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['33']++;Y.WidgetPosition=Position;},'patched-v3.20.5',{'requires':['base-build','node-screen','widget']});
