if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/graphics/graphics.js']) {
   __coverage__['build/graphics/graphics.js'] = {"path":"build/graphics/graphics.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0,"50":0,"51":0,"52":0,"53":0,"54":0,"55":0,"56":0,"57":0,"58":0,"59":0,"60":0,"61":0,"62":0,"63":0,"64":0,"65":0,"66":0,"67":0,"68":0,"69":0,"70":0,"71":0,"72":0,"73":0,"74":0,"75":0,"76":0,"77":0,"78":0,"79":0,"80":0,"81":0,"82":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0],"13":[0,0],"14":[0,0],"15":[0,0],"16":[0,0],"17":[0,0],"18":[0,0],"19":[0,0],"20":[0,0],"21":[0,0],"22":[0,0],"23":[0,0],"24":[0,0],"25":[0,0],"26":[0,0],"27":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":20},"end":{"line":1,"column":39}}},"2":{"name":"(anonymous_2)","line":50,"loc":{"start":{"line":50,"column":20},"end":{"line":51,"column":4}}},"3":{"name":"(anonymous_3)","line":70,"loc":{"start":{"line":70,"column":12},"end":{"line":71,"column":2}}},"4":{"name":"(anonymous_4)","line":139,"loc":{"start":{"line":139,"column":13},"end":{"line":140,"column":8}}},"5":{"name":"(anonymous_5)","line":170,"loc":{"start":{"line":170,"column":13},"end":{"line":171,"column":8}}},"6":{"name":"(anonymous_6)","line":200,"loc":{"start":{"line":200,"column":8},"end":{"line":201,"column":2}}},"7":{"name":"(anonymous_7)","line":237,"loc":{"start":{"line":237,"column":18},"end":{"line":238,"column":4}}},"8":{"name":"(anonymous_8)","line":267,"loc":{"start":{"line":267,"column":14},"end":{"line":268,"column":8}}},"9":{"name":"(anonymous_9)","line":285,"loc":{"start":{"line":285,"column":26},"end":{"line":286,"column":8}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":1270,"column":100}},"2":{"start":{"line":32,"column":0},"end":{"line":41,"column":18}},"3":{"start":{"line":50,"column":4},"end":{"line":60,"column":6}},"4":{"start":{"line":52,"column":8},"end":{"line":52,"column":24}},"5":{"start":{"line":55,"column":8},"end":{"line":55,"column":33}},"6":{"start":{"line":57,"column":8},"end":{"line":57,"column":52}},"7":{"start":{"line":58,"column":8},"end":{"line":58,"column":25}},"8":{"start":{"line":59,"column":8},"end":{"line":59,"column":72}},"9":{"start":{"line":62,"column":4},"end":{"line":224,"column":3}},"10":{"start":{"line":72,"column":3},"end":{"line":77,"column":24}},"11":{"start":{"line":78,"column":3},"end":{"line":100,"column":13}},"12":{"start":{"line":80,"column":4},"end":{"line":99,"column":17}},"13":{"start":{"line":82,"column":5},"end":{"line":82,"column":26}},"14":{"start":{"line":83,"column":5},"end":{"line":98,"column":6}},"15":{"start":{"line":85,"column":6},"end":{"line":85,"column":28}},"16":{"start":{"line":87,"column":10},"end":{"line":98,"column":6}},"17":{"start":{"line":89,"column":6},"end":{"line":89,"column":24}},"18":{"start":{"line":90,"column":6},"end":{"line":97,"column":7}},"19":{"start":{"line":92,"column":7},"end":{"line":92,"column":39}},"20":{"start":{"line":96,"column":7},"end":{"line":96,"column":33}},"21":{"start":{"line":101,"column":3},"end":{"line":101,"column":23}},"22":{"start":{"line":102,"column":12},"end":{"line":129,"column":4}},"23":{"start":{"line":104,"column":4},"end":{"line":128,"column":5}},"24":{"start":{"line":106,"column":5},"end":{"line":106,"column":26}},"25":{"start":{"line":107,"column":20},"end":{"line":110,"column":6}},"26":{"start":{"line":109,"column":6},"end":{"line":109,"column":15}},"27":{"start":{"line":112,"column":5},"end":{"line":115,"column":6}},"28":{"start":{"line":114,"column":6},"end":{"line":114,"column":27}},"29":{"start":{"line":117,"column":5},"end":{"line":127,"column":6}},"30":{"start":{"line":119,"column":6},"end":{"line":126,"column":7}},"31":{"start":{"line":121,"column":7},"end":{"line":121,"column":58}},"32":{"start":{"line":125,"column":7},"end":{"line":125,"column":31}},"33":{"start":{"line":141,"column":12},"end":{"line":143,"column":52}},"34":{"start":{"line":144,"column":12},"end":{"line":157,"column":13}},"35":{"start":{"line":146,"column":16},"end":{"line":146,"column":49}},"36":{"start":{"line":147,"column":16},"end":{"line":154,"column":17}},"37":{"start":{"line":149,"column":20},"end":{"line":152,"column":21}},"38":{"start":{"line":151,"column":24},"end":{"line":151,"column":56}},"39":{"start":{"line":153,"column":20},"end":{"line":153,"column":63}},"40":{"start":{"line":156,"column":16},"end":{"line":156,"column":41}},"41":{"start":{"line":158,"column":12},"end":{"line":158,"column":24}},"42":{"start":{"line":172,"column":12},"end":{"line":173,"column":18}},"43":{"start":{"line":174,"column":12},"end":{"line":187,"column":13}},"44":{"start":{"line":176,"column":16},"end":{"line":182,"column":17}},"45":{"start":{"line":178,"column":20},"end":{"line":181,"column":21}},"46":{"start":{"line":180,"column":24},"end":{"line":180,"column":46}},"47":{"start":{"line":186,"column":16},"end":{"line":186,"column":49}},"48":{"start":{"line":202,"column":3},"end":{"line":205,"column":40}},"49":{"start":{"line":206,"column":3},"end":{"line":222,"column":4}},"50":{"start":{"line":208,"column":4},"end":{"line":208,"column":37}},"51":{"start":{"line":209,"column":4},"end":{"line":220,"column":5}},"52":{"start":{"line":211,"column":5},"end":{"line":211,"column":18}},"53":{"start":{"line":212,"column":5},"end":{"line":219,"column":21}},"54":{"start":{"line":214,"column":6},"end":{"line":214,"column":43}},"55":{"start":{"line":218,"column":24},"end":{"line":218,"column":72}},"56":{"start":{"line":221,"column":4},"end":{"line":221,"column":28}},"57":{"start":{"line":225,"column":4},"end":{"line":225,"column":56}},"58":{"start":{"line":226,"column":1},"end":{"line":226,"column":33}},"59":{"start":{"line":237,"column":4},"end":{"line":255,"column":6}},"60":{"start":{"line":239,"column":8},"end":{"line":240,"column":51}},"61":{"start":{"line":241,"column":8},"end":{"line":243,"column":9}},"62":{"start":{"line":242,"column":12},"end":{"line":242,"column":34}},"63":{"start":{"line":245,"column":8},"end":{"line":245,"column":42}},"64":{"start":{"line":246,"column":8},"end":{"line":246,"column":83}},"65":{"start":{"line":247,"column":8},"end":{"line":247,"column":33}},"66":{"start":{"line":248,"column":8},"end":{"line":248,"column":27}},"67":{"start":{"line":249,"column":8},"end":{"line":249,"column":41}},"68":{"start":{"line":250,"column":8},"end":{"line":253,"column":9}},"69":{"start":{"line":252,"column":12},"end":{"line":252,"column":35}},"70":{"start":{"line":254,"column":8},"end":{"line":254,"column":32}},"71":{"start":{"line":257,"column":4},"end":{"line":257,"column":37}},"72":{"start":{"line":259,"column":4},"end":{"line":289,"column":6}},"73":{"start":{"line":269,"column":12},"end":{"line":271,"column":15}},"74":{"start":{"line":272,"column":12},"end":{"line":272,"column":52}},"75":{"start":{"line":273,"column":12},"end":{"line":273,"column":51}},"76":{"start":{"line":287,"column":12},"end":{"line":287,"column":73}},"77":{"start":{"line":291,"column":0},"end":{"line":291,"column":52}},"78":{"start":{"line":292,"column":0},"end":{"line":292,"column":47}},"79":{"start":{"line":293,"column":0},"end":{"line":293,"column":48}},"80":{"start":{"line":294,"column":0},"end":{"line":294,"column":35}},"81":{"start":{"line":295,"column":0},"end":{"line":295,"column":39}},"82":{"start":{"line":296,"column":0},"end":{"line":296,"column":28}}},"branchMap":{"1":{"line":80,"type":"if","locations":[{"start":{"line":80,"column":4},"end":{"line":80,"column":4}},{"start":{"line":80,"column":4},"end":{"line":80,"column":4}}]},"2":{"line":83,"type":"if","locations":[{"start":{"line":83,"column":5},"end":{"line":83,"column":5}},{"start":{"line":83,"column":5},"end":{"line":83,"column":5}}]},"3":{"line":87,"type":"if","locations":[{"start":{"line":87,"column":10},"end":{"line":87,"column":10}},{"start":{"line":87,"column":10},"end":{"line":87,"column":10}}]},"4":{"line":90,"type":"if","locations":[{"start":{"line":90,"column":6},"end":{"line":90,"column":6}},{"start":{"line":90,"column":6},"end":{"line":90,"column":6}}]},"5":{"line":104,"type":"if","locations":[{"start":{"line":104,"column":4},"end":{"line":104,"column":4}},{"start":{"line":104,"column":4},"end":{"line":104,"column":4}}]},"6":{"line":107,"type":"if","locations":[{"start":{"line":107,"column":20},"end":{"line":107,"column":20}},{"start":{"line":107,"column":20},"end":{"line":107,"column":20}}]},"7":{"line":107,"type":"binary-expr","locations":[{"start":{"line":107,"column":23},"end":{"line":107,"column":52}},{"start":{"line":107,"column":56},"end":{"line":107,"column":69}}]},"8":{"line":112,"type":"if","locations":[{"start":{"line":112,"column":5},"end":{"line":112,"column":5}},{"start":{"line":112,"column":5},"end":{"line":112,"column":5}}]},"9":{"line":112,"type":"binary-expr","locations":[{"start":{"line":112,"column":8},"end":{"line":112,"column":39}},{"start":{"line":112,"column":43},"end":{"line":112,"column":57}}]},"10":{"line":117,"type":"if","locations":[{"start":{"line":117,"column":5},"end":{"line":117,"column":5}},{"start":{"line":117,"column":5},"end":{"line":117,"column":5}}]},"11":{"line":117,"type":"binary-expr","locations":[{"start":{"line":117,"column":8},"end":{"line":117,"column":11}},{"start":{"line":117,"column":15},"end":{"line":117,"column":36}}]},"12":{"line":119,"type":"if","locations":[{"start":{"line":119,"column":6},"end":{"line":119,"column":6}},{"start":{"line":119,"column":6},"end":{"line":119,"column":6}}]},"13":{"line":144,"type":"if","locations":[{"start":{"line":144,"column":12},"end":{"line":144,"column":12}},{"start":{"line":144,"column":12},"end":{"line":144,"column":12}}]},"14":{"line":144,"type":"binary-expr","locations":[{"start":{"line":144,"column":15},"end":{"line":144,"column":25}},{"start":{"line":144,"column":29},"end":{"line":144,"column":45}}]},"15":{"line":147,"type":"if","locations":[{"start":{"line":147,"column":16},"end":{"line":147,"column":16}},{"start":{"line":147,"column":16},"end":{"line":147,"column":16}}]},"16":{"line":149,"type":"if","locations":[{"start":{"line":149,"column":20},"end":{"line":149,"column":20}},{"start":{"line":149,"column":20},"end":{"line":149,"column":20}}]},"17":{"line":174,"type":"if","locations":[{"start":{"line":174,"column":12},"end":{"line":174,"column":12}},{"start":{"line":174,"column":12},"end":{"line":174,"column":12}}]},"18":{"line":178,"type":"if","locations":[{"start":{"line":178,"column":20},"end":{"line":178,"column":20}},{"start":{"line":178,"column":20},"end":{"line":178,"column":20}}]},"19":{"line":206,"type":"if","locations":[{"start":{"line":206,"column":3},"end":{"line":206,"column":3}},{"start":{"line":206,"column":3},"end":{"line":206,"column":3}}]},"20":{"line":206,"type":"binary-expr","locations":[{"start":{"line":206,"column":6},"end":{"line":206,"column":16}},{"start":{"line":206,"column":20},"end":{"line":206,"column":51}}]},"21":{"line":209,"type":"if","locations":[{"start":{"line":209,"column":4},"end":{"line":209,"column":4}},{"start":{"line":209,"column":4},"end":{"line":209,"column":4}}]},"22":{"line":212,"type":"if","locations":[{"start":{"line":212,"column":5},"end":{"line":212,"column":5}},{"start":{"line":212,"column":5},"end":{"line":212,"column":5}}]},"23":{"line":240,"type":"binary-expr","locations":[{"start":{"line":240,"column":25},"end":{"line":240,"column":33}},{"start":{"line":240,"column":37},"end":{"line":240,"column":50}}]},"24":{"line":241,"type":"if","locations":[{"start":{"line":241,"column":8},"end":{"line":241,"column":8}},{"start":{"line":241,"column":8},"end":{"line":241,"column":8}}]},"25":{"line":241,"type":"binary-expr","locations":[{"start":{"line":241,"column":12},"end":{"line":241,"column":29}},{"start":{"line":241,"column":33},"end":{"line":241,"column":43}}]},"26":{"line":246,"type":"binary-expr","locations":[{"start":{"line":246,"column":28},"end":{"line":246,"column":57}},{"start":{"line":246,"column":61},"end":{"line":246,"column":82}}]},"27":{"line":250,"type":"if","locations":[{"start":{"line":250,"column":8},"end":{"line":250,"column":8}},{"start":{"line":250,"column":8},"end":{"line":250,"column":8}}]}},"code":["(function () { YUI.add('graphics', function (Y, NAME) {","","/**"," *"," * <p>The `Graphics` module provides a JavaScript API for creating shapes in a variety of formats across"," * a <a href=\"http://developer.yahoo.com/yui/articles/gbs\">browser test baseline</a>."," * Based on device and browser capabilities, `Graphics` leverages <a href=\"http://www.w3.org/TR/SVG/\">SVG</a>,"," * <a href=\"http://www.w3.org/TR/html5/the-canvas-element.html\">Canvas</a> and <a href=\"http://www.w3.org/TR/NOTE-VML\">VML</a>"," * to render its graphical elements.</p>"," *"," * <p>The `Graphics` module features a <a href=\"../classes/Graphic.html\">`Graphic`</a> class that allows you to easily create and manage shapes."," * Currently, a <a href=\"../classes/Graphic.html\">`Graphic`</a> instance can be used to create predifined shapes and free-form polygons with fill"," * and stroke properties.</p>"," *"," * <p>The `Graphics` module normalizes an API through the use of alias and implementation classes that share"," * interfaces. Each alias class points to an appropriate implementation class dependent on the browser's"," * capabilities. There should rarely, if ever, be a need to interact directly with an implementation class.</p>"," *"," * <p>Below is a list of available classes."," *     <ul>"," *         <li><a href=\"../classes/Graphic.html\">`Graphic`</a>"," *         <li><a href=\"../classes/Shape.html\">`Shape`</a>"," *         <li><a href=\"../classes/Circle.html\">`Circle`</a>"," *         <li><a href=\"../classes/Ellipse.html\">`Ellipse`</a>"," *         <li><a href=\"../classes/Rect.html\">`Rect`</a>"," *         <li><a href=\"../classes/Path.html\">`Path`</a>"," *     </ul>"," * You can also extend the `Shape` class to create your own custom shape classes.</p>"," * @module graphics"," * @main graphics"," */","var SETTER = \"setter\",","\tPluginHost = Y.Plugin.Host,","    VALUE = \"value\",","    VALUEFN = \"valueFn\",","    READONLY = \"readOnly\",","    Y_LANG = Y.Lang,","    STR = \"string\",","    WRITE_ONCE = \"writeOnce\",","    GraphicBase,","    AttributeLite;","","    /**","\t * AttributeLite provides Attribute-like getters and setters for shape classes in the Graphics module.","     * It provides a get/set API without the event infastructure. This class is temporary and a work in progress.","\t *","\t * @class AttributeLite","\t * @constructor","\t */","    AttributeLite = function()","    {","        var host = this; // help compression","","        // Perf tweak - avoid creating event literals if not required.","        host._ATTR_E_FACADE = {};","","        Y.EventTarget.call(this, {emitFacade:true});","        host._state = {};","        host.prototype = Y.mix(AttributeLite.prototype, host.prototype);","    };","","    AttributeLite.prototype = {","\t\t/**","\t\t * Initializes the attributes for a shape. If an attribute config is passed into the constructor of the host,","\t\t * the initial values will be overwritten.","\t\t *","\t\t * @method addAttrs","\t\t * @param {Object} cfg Optional object containing attributes key value pairs to be set.","\t\t */","\t\taddAttrs: function(cfg)","\t\t{","\t\t\tvar host = this,","\t\t\t\tattrConfig = this.constructor.ATTRS,","\t\t\t\tattr,","\t\t\t\ti,","\t\t\t\tfn,","\t\t\t\tstate = host._state;","\t\t\tfor(i in attrConfig)","\t\t\t{","\t\t\t\tif(attrConfig.hasOwnProperty(i))","\t\t\t\t{","\t\t\t\t\tattr = attrConfig[i];","\t\t\t\t\tif(attr.hasOwnProperty(VALUE))","\t\t\t\t\t{","\t\t\t\t\t\tstate[i] = attr.value;","\t\t\t\t\t}","\t\t\t\t\telse if(attr.hasOwnProperty(VALUEFN))","\t\t\t\t\t{","\t\t\t\t\t\tfn = attr.valueFn;","\t\t\t\t\t\tif(Y_LANG.isString(fn))","\t\t\t\t\t\t{","\t\t\t\t\t\t\tstate[i] = host[fn].apply(host);","\t\t\t\t\t\t}","\t\t\t\t\t\telse","\t\t\t\t\t\t{","\t\t\t\t\t\t\tstate[i] = fn.apply(host);","\t\t\t\t\t\t}","\t\t\t\t\t}","                }","            }","\t\t\thost._state = state;","            for(i in attrConfig)","\t\t\t{","\t\t\t\tif(attrConfig.hasOwnProperty(i))","\t\t\t\t{","\t\t\t\t\tattr = attrConfig[i];","                    if(attr.hasOwnProperty(READONLY) && attr.readOnly)","\t\t\t\t\t{","\t\t\t\t\t\tcontinue;","\t\t\t\t\t}","","\t\t\t\t\tif(attr.hasOwnProperty(WRITE_ONCE) && attr.writeOnce)","\t\t\t\t\t{","\t\t\t\t\t\tattr.readOnly = true;","\t\t\t\t\t}","","\t\t\t\t\tif(cfg && cfg.hasOwnProperty(i))","\t\t\t\t\t{","\t\t\t\t\t\tif(attr.hasOwnProperty(SETTER))","\t\t\t\t\t\t{","\t\t\t\t\t\t\thost._state[i] = attr.setter.apply(host, [cfg[i]]);","\t\t\t\t\t\t}","\t\t\t\t\t\telse","\t\t\t\t\t\t{","\t\t\t\t\t\t\thost._state[i] = cfg[i];","\t\t\t\t\t\t}","\t\t\t\t\t}","\t\t\t\t}","\t\t\t}","\t\t},","","        /**","         * For a given item, returns the value of the property requested, or undefined if not found.","         *","         * @method get","         * @param name {String} The name of the item","         * @return {Any} The value of the supplied property.","         */","        get: function(attr)","        {","            var host = this,","                getter,","                attrConfig = host.constructor.ATTRS;","            if(attrConfig && attrConfig[attr])","            {","                getter = attrConfig[attr].getter;","                if(getter)","                {","                    if(typeof getter === STR)","                    {","                        return host[getter].apply(host);","                    }","                    return attrConfig[attr].getter.apply(host);","                }","","                return host._state[attr];","            }","            return null;","        },","","        /**","         * Sets the value of an attribute.","         *","         * @method set","         * @param {String|Object} name The name of the attribute. Alternatively, an object of key value pairs can","         * be passed in to set multiple attributes at once.","         * @param {Any} value The value to set the attribute to. This value is ignored if an object is received as","         * the name param.","         */","        set: function()","        {","            var attr = arguments[0],","                i;","            if(Y_LANG.isObject(attr))","            {","                for(i in attr)","                {","                    if(attr.hasOwnProperty(i))","                    {","                        this._set(i, attr[i]);","                    }","                }","            }","            else","            {","                this._set.apply(this, arguments);","            }","        },","","\t\t/**","         * Provides setter logic. Used by `set`.","         *","         * @method _set","         * @param {String|Object} name The name of the attribute. Alternatively, an object of key value pairs can","         * be passed in to set multiple attributes at once.","         * @param {Any} value The value to set the attribute to. This value is ignored if an object is received as","         * the name param.","\t\t * @protected","\t\t */","\t\t_set: function(attr, val)","\t\t{","\t\t\tvar host = this,","\t\t\t\tsetter,","\t\t\t\targs,","\t\t\t\tattrConfig = host.constructor.ATTRS;","\t\t\tif(attrConfig && attrConfig.hasOwnProperty(attr))","\t\t\t{","\t\t\t\tsetter = attrConfig[attr].setter;","\t\t\t\tif(setter)","\t\t\t\t{","\t\t\t\t\targs = [val];","\t\t\t\t\tif(typeof setter === STR)","\t\t\t\t\t{","\t\t\t\t\t\tval = host[setter].apply(host, args);","\t\t\t\t\t}","\t\t\t\t\telse","                    {","                        val = attrConfig[attr].setter.apply(host, args);","                    }","\t\t\t\t}","\t\t\t\thost._state[attr] = val;","\t\t\t}","\t\t}","\t};","    Y.mix(AttributeLite, Y.EventTarget, false, null, 1);","\tY.AttributeLite = AttributeLite;","","    /**","     * GraphicBase serves as the base class for the graphic layer. It serves the same purpose as","     * Base but uses a lightweight getter/setter class instead of Attribute.","     * This class is temporary and a work in progress.","     *","     * @class GraphicBase","     * @constructor","     * @param {Object} cfg Key value pairs for attributes","     */","    GraphicBase = function(cfg)","    {","        var host = this,","            PluginHost = Y.Plugin && Y.Plugin.Host;","        if (host._initPlugins && PluginHost) {","            PluginHost.call(host);","        }","","        host.name = host.constructor.NAME;","        host._eventPrefix = host.constructor.EVENT_PREFIX || host.constructor.NAME;","        AttributeLite.call(host);","        host.addAttrs(cfg);","        host.init.apply(this, arguments);","        if (host._initPlugins) {","            // Need to initPlugins manually, to handle constructor parsing, static Plug parsing","            host._initPlugins(cfg);","        }","        host.initialized = true;","    };","","    GraphicBase.NAME = \"baseGraphic\";","","    GraphicBase.prototype = {","        /**","         * Init method, invoked during construction.","         * Fires an init event after calling `initializer` on implementers.","         *","         * @method init","         * @protected","         */","        init: function()","        {","            this.publish(\"init\", {","                fireOnce:true","            });","            this.initializer.apply(this, arguments);","            this.fire(\"init\", {cfg: arguments[0]});","        },","","        /**","         * Camel case concatanates two strings.","         *","         * @method _camelCaseConcat","         * @param {String} prefix The first string","         * @param {String} name The second string","         * @return String","         * @private","         */","        _camelCaseConcat: function(prefix, name)","        {","            return prefix + name.charAt(0).toUpperCase() + name.slice(1);","        }","    };","//Straightup augment, no wrapper functions","Y.mix(GraphicBase, Y.AttributeLite, false, null, 1);","Y.mix(GraphicBase, PluginHost, false, null, 1);","GraphicBase.prototype.constructor = GraphicBase;","GraphicBase.plug = PluginHost.plug;","GraphicBase.unplug = PluginHost.unplug;","Y.GraphicBase = GraphicBase;","","","/**"," * `Drawing` provides a set of drawing methods used by `Path` and custom shape classes."," * `Drawing` has the following implementations based on browser capability."," *  <ul>"," *      <li><a href=\"SVGDrawing.html\">`SVGDrawing`</a></li>"," *      <li><a href=\"VMLDrawing.html\">`VMLDrawing`</a></li>"," *      <li><a href=\"CanvasDrawing.html\">`CanvasDrawing`</a></li>"," *  </ul>"," *"," * @class Drawing"," * @constructor"," */","    /**","     * Draws a bezier curve.","     *","     * @method curveTo","     * @param {Number} cp1x x-coordinate for the first control point.","     * @param {Number} cp1y y-coordinate for the first control point.","     * @param {Number} cp2x x-coordinate for the second control point.","     * @param {Number} cp2y y-coordinate for the second control point.","     * @param {Number} x x-coordinate for the end point.","     * @param {Number} y y-coordinate for the end point.","     * @chainable","     */","    /**","     * Draws a quadratic bezier curve.","     *","     * @method quadraticCurveTo","     * @param {Number} cpx x-coordinate for the control point.","     * @param {Number} cpy y-coordinate for the control point.","     * @param {Number} x x-coordinate for the end point.","     * @param {Number} y y-coordinate for the end point.","     * @chainable","     */","    /**","     * Draws a rectangle.","     *","     * @method drawRect","     * @param {Number} x x-coordinate","     * @param {Number} y y-coordinate","     * @param {Number} w width","     * @param {Number} h height","     * @chainable","     */","    /**","     * Draws a rectangle with rounded corners.","     *","     * @method drawRoundRect","     * @param {Number} x x-coordinate","     * @param {Number} y y-coordinate","     * @param {Number} w width","     * @param {Number} h height","     * @param {Number} ew width of the ellipse used to draw the rounded corners","     * @param {Number} eh height of the ellipse used to draw the rounded corners","     * @chainable","     */","    /**","     * Draws a circle.","     *","     * @method drawCircle","     * @param {Number} x y-coordinate","     * @param {Number} y x-coordinate","     * @param {Number} r radius","     * @chainable","     * @protected","     */","    /**","     * Draws an ellipse.","     *","     * @method drawEllipse","     * @param {Number} x x-coordinate","     * @param {Number} y y-coordinate","     * @param {Number} w width","     * @param {Number} h height","     * @chainable","     * @protected","     */","    /**","     * Draws a diamond.","     *","     * @method drawDiamond","     * @param {Number} x y-coordinate","     * @param {Number} y x-coordinate","     * @param {Number} width width","     * @param {Number} height height","     * @chainable","     * @protected","     */","    /**","     * Draws a wedge.","     *","     * @method drawWedge","     * @param {Number} x x-coordinate of the wedge's center point","     * @param {Number} y y-coordinate of the wedge's center point","     * @param {Number} startAngle starting angle in degrees","     * @param {Number} arc sweep of the wedge. Negative values draw clockwise.","     * @param {Number} radius radius of wedge. If [optional] yRadius is defined, then radius is the x radius.","     * @param {Number} yRadius [optional] y radius for wedge.","     * @chainable","     * @private","     */","    /**","     * Draws a line segment using the current line style from the current drawing position to the specified x and y coordinates.","     *","     * @method lineTo","     * @param {Number} point1 x-coordinate for the end point.","     * @param {Number} point2 y-coordinate for the end point.","     * @chainable","     */","    /**","     * Draws a line segment using the current line style from the current drawing position to the relative x and y coordinates.","     *","     * @method relativeLineTo","     * @param {Number} point1 x-coordinate for the end point.","     * @param {Number} point2 y-coordinate for the end point.","     * @chainable","     */","    /**","     * Moves the current drawing position to specified x and y coordinates.","     *","     * @method moveTo","     * @param {Number} x x-coordinate for the end point.","     * @param {Number} y y-coordinate for the end point.","     * @chainable","     */","    /**","     * Moves the current drawing position relative to specified x and y coordinates.","     *","     * @method relativeMoveTo","     * @param {Number} x x-coordinate for the end point.","     * @param {Number} y y-coordinate for the end point.","     * @chainable","     */","    /**","     * Completes a drawing operation.","     *","     * @method end","     * @chainable","     */","    /**","     * Clears the path.","     *","     * @method clear","     * @chainable","     */","    /**","     * Ends a fill and stroke","     *","     * @method closePath","     * @chainable","     */","/**"," *  <p>Base class for creating shapes.</p>"," *  <p>`Shape` is an abstract class and is not meant to be used directly. The following classes extend"," *  `Shape`."," *"," *  <ul>"," *      <li><a href=\"Circle.html\">`Circle`</a></li>"," *      <li><a href=\"Ellipse.html\">`Ellipse`</a></li>"," *      <li><a href=\"Rect.html\">`Rect`</a></li>"," *      <li><a href=\"Path.html\">`Path`</a></li>"," *  </ul>"," *"," * `Shape` can also be extended to create custom shape classes.</p>"," *"," * `Shape` has the following implementations based on browser capability."," *  <ul>"," *      <li><a href=\"SVGShape.html\">`SVGShape`</a></li>"," *      <li><a href=\"VMLShape.html\">`VMLShape`</a></li>"," *      <li><a href=\"CanvasShape.html\">`CanvasShape`</a></li>"," *  </ul>"," *"," * It is not necessary to interact with these classes directly. `Shape` will point to the appropriate implemention.</p>"," *"," * @class Shape"," * @constructor"," * @param {Object} cfg (optional) Attribute configs"," */","    /**","     * Init method, invoked during construction.","     * Calls `initializer` method.","     *","     * @method init","     * @protected","     */","\t/**","\t * Initializes the shape","\t *","\t * @private","\t * @method initializer","\t */","\t/**","\t * Add a class name to each node.","\t *","\t * @method addClass","\t * @param {String} className the class name to add to the node's class attribute","\t */","\t/**","\t * Removes a class name from each node.","\t *","\t * @method removeClass","\t * @param {String} className the class name to remove from the node's class attribute","\t */","\t/**","\t * Gets the current position of the node in page coordinates.","\t *","\t * @method getXY","\t * @return Array The XY position of the shape.","\t */","\t/**","\t * Set the position of the shape in page coordinates, regardless of how the node is positioned.","\t *","\t * @method setXY","\t * @param {Array} Contains x & y values for new position (coordinates are page-based)","\t */","\t/**","\t * Determines whether the node is an ancestor of another HTML element in the DOM hierarchy.","\t *","\t * @method contains","\t * @param {Shape | HTMLElement} needle The possible node or descendent","\t * @return Boolean Whether or not this shape is the needle or its ancestor.","\t */","\t/**","\t * Compares nodes to determine if they match.","\t * Node instances can be compared to each other and/or HTMLElements.","\t * @method compareTo","\t * @param {HTMLElement | Node} refNode The reference node to compare to the node.","\t * @return {Boolean} True if the nodes match, false if they do not.","\t */","\t/**","\t * Test if the supplied node matches the supplied selector.","\t *","\t * @method test","\t * @param {String} selector The CSS selector to test against.","\t * @return Boolean Wheter or not the shape matches the selector.","\t */","    /**","     * Sets the value of an attribute.","     *","     * @method set","     * @param {String|Object} name The name of the attribute. Alternatively, an object of key value pairs can","     * be passed in to set multiple attributes at once.","     * @param {Any} value The value to set the attribute to. This value is ignored if an object is received as","     * the name param.","     */","\t/**","\t * Specifies a 2d translation.","\t *","\t * @method translate","\t * @param {Number} x The value to transate on the x-axis.","\t * @param {Number} y The value to translate on the y-axis.","\t */","\t/**","\t * Translates the shape along the x-axis. When translating x and y coordinates,","\t * use the `translate` method.","\t *","\t * @method translateX","\t * @param {Number} x The value to translate.","\t */","\t/**","\t * Translates the shape along the y-axis. When translating x and y coordinates,","\t * use the `translate` method.","\t *","\t * @method translateY","\t * @param {Number} y The value to translate.","\t */","    /**","     * Skews the shape around the x-axis and y-axis.","     *","     * @method skew","     * @param {Number} x The value to skew on the x-axis.","     * @param {Number} y The value to skew on the y-axis.","     */","\t/**","\t * Skews the shape around the x-axis.","\t *","\t * @method skewX","\t * @param {Number} x x-coordinate","\t */","\t/**","\t * Skews the shape around the y-axis.","\t *","\t * @method skewY","\t * @param {Number} y y-coordinate","\t */","\t/**","\t * Rotates the shape clockwise around it transformOrigin.","\t *","\t * @method rotate","\t * @param {Number} deg The degree of the rotation.","\t */","\t/**","\t * Specifies a 2d scaling operation.","\t *","\t * @method scale","\t * @param {Number} val","\t */","\t/**","\t * Returns the bounds for a shape.","\t *","     * Calculates the a new bounding box from the original corner coordinates (base on size and position) and the transform matrix.","     * The calculated bounding box is used by the graphic instance to calculate its viewBox.","     *","\t * @method getBounds","\t * @return Object","\t */","    /**","     * Destroys the instance.","     *","     * @method destroy","     */","\t/**","\t * An array of x, y values which indicates the transformOrigin in which to rotate the shape. Valid values range between 0 and 1 representing a","\t * fraction of the shape's corresponding bounding box dimension. The default value is [0.5, 0.5].","\t *","\t * @config transformOrigin","\t * @type Array","\t */","    /**","     * <p>A string containing, in order, transform operations applied to the shape instance. The `transform` string can contain the following values:","     *","     *    <dl>","     *        <dt>rotate</dt><dd>Rotates the shape clockwise around it transformOrigin.</dd>","     *        <dt>translate</dt><dd>Specifies a 2d translation.</dd>","     *        <dt>skew</dt><dd>Skews the shape around the x-axis and y-axis.</dd>","     *        <dt>scale</dt><dd>Specifies a 2d scaling operation.</dd>","     *        <dt>translateX</dt><dd>Translates the shape along the x-axis.</dd>","     *        <dt>translateY</dt><dd>Translates the shape along the y-axis.</dd>","     *        <dt>skewX</dt><dd>Skews the shape around the x-axis.</dd>","     *        <dt>skewY</dt><dd>Skews the shape around the y-axis.</dd>","     *        <dt>matrix</dt><dd>Specifies a 2D transformation matrix comprised of the specified six values.</dd>","     *    </dl>","     * </p>","     * <p>Applying transforms through the transform attribute will reset the transform matrix and apply a new transform. The shape class also contains","     * corresponding methods for each transform that will apply the transform to the current matrix. The below code illustrates how you might use the","     * `transform` attribute to instantiate a recangle with a rotation of 45 degrees.</p>","            var myRect = new Y.Rect({","                type:\"rect\",","                width: 50,","                height: 40,","                transform: \"rotate(45)\"","            };","     * <p>The code below would apply `translate` and `rotate` to an existing shape.</p>","","        myRect.set(\"transform\", \"translate(40, 50) rotate(45)\");","\t * @config transform","     * @type String","\t */","\t/**","\t * Unique id for class instance.","\t *","\t * @config id","\t * @type String","\t */","\t/**","\t * Indicates the x position of shape.","\t *","\t * @config x","\t * @type Number","\t */","\t/**","\t * Indicates the y position of shape.","\t *","\t * @config y","\t * @type Number","\t */","\t/**","\t * Indicates the width of the shape","\t *","\t * @config width","\t * @type Number","\t */","\t/**","\t * Indicates the height of the shape","\t *","\t * @config height","\t * @type Number","\t */","\t/**","\t * Indicates whether the shape is visible.","\t *","\t * @config visible","\t * @type Boolean","\t */","\t/**","\t * Contains information about the fill of the shape.","     *  <dl>","     *      <dt>color</dt><dd>The color of the fill.</dd>","     *      <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the fill. The default value is 1.</dd>","     *      <dt>type</dt><dd>Type of fill.","     *          <dl>","     *              <dt>solid</dt><dd>Solid single color fill. (default)</dd>","     *              <dt>linear</dt><dd>Linear gradient fill.</dd>","     *              <dt>radial</dt><dd>Radial gradient fill.</dd>","     *          </dl>","     *      </dd>","     *  </dl>","     *  <p>If a `linear` or `radial` is specified as the fill type. The following additional property is used:","     *  <dl>","     *      <dt>stops</dt><dd>An array of objects containing the following properties:","     *          <dl>","     *              <dt>color</dt><dd>The color of the stop.</dd>","     *              <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the stop. The default value is 1.","     *              Note: No effect for IE 6 - 8</dd>","     *              <dt>offset</dt><dd>Number between 0 and 1 indicating where the color stop is positioned.</dd>","     *          </dl>","     *      </dd>","     *      <p>Linear gradients also have the following property:</p>","     *      <dt>rotation</dt><dd>Linear gradients flow left to right by default. The rotation property allows you to change the","     *      flow by rotation. (e.g. A rotation of 180 would make the gradient pain from right to left.)</dd>","     *      <p>Radial gradients have the following additional properties:</p>","     *      <dt>r</dt><dd>Radius of the gradient circle.</dd>","     *      <dt>fx</dt><dd>Focal point x-coordinate of the gradient.</dd>","     *      <dt>fy</dt><dd>Focal point y-coordinate of the gradient.</dd>","     *      <dt>cx</dt><dd>","     *          <p>The x-coordinate of the center of the gradient circle. Determines where the color stop begins. The default value 0.5.</p>","     *          <p><strong>Note: </strong>Currently, this property is not implemented for corresponding `CanvasShape` and","     *          `VMLShape` classes which are used on Android or IE 6 - 8.</p>","     *      </dd>","     *      <dt>cy</dt><dd>","     *          <p>The y-coordinate of the center of the gradient circle. Determines where the color stop begins. The default value 0.5.</p>","     *          <p><strong>Note: </strong>Currently, this property is not implemented for corresponding `CanvasShape` and `VMLShape`","     *          classes which are used on Android or IE 6 - 8.</p>","     *      </dd>","     *  </dl>","\t *","\t * @config fill","\t * @type Object","\t */","\t/**","\t * Contains information about the stroke of the shape.","     *  <dl>","     *      <dt>color</dt><dd>The color of the stroke.</dd>","     *      <dt>weight</dt><dd>Number that indicates the width of the stroke.</dd>","     *      <dt>opacity</dt><dd>Number between 0 and 1 that indicates the opacity of the stroke. The default value is 1.</dd>","     *      <dt>dashstyle</dt>Indicates whether to draw a dashed stroke. When set to \"none\", a solid stroke is drawn. When set","     *      to an array, the first index indicates the length of the dash. The second index indicates the length of gap.","     *      <dt>linecap</dt><dd>Specifies the linecap for the stroke. The following values can be specified:","     *          <dl>","     *              <dt>butt (default)</dt><dd>Specifies a butt linecap.</dd>","     *              <dt>square</dt><dd>Specifies a sqare linecap.</dd>","     *              <dt>round</dt><dd>Specifies a round linecap.</dd>","     *          </dl>","     *      </dd>","     *      <dt>linejoin</dt><dd>Specifies a linejoin for the stroke. The following values can be specified:","     *          <dl>","     *              <dt>round (default)</dt><dd>Specifies that the linejoin will be round.</dd>","     *              <dt>bevel</dt><dd>Specifies a bevel for the linejoin.</dd>","     *              <dt>miter limit</dt><dd>An integer specifying the miter limit of a miter linejoin. If you want to specify a linejoin","     *              of miter, you simply specify the limit as opposed to having separate miter and miter limit values.</dd>","     *          </dl>","     *      </dd>","     *  </dl>","\t *","\t * @config stroke","\t * @type Object","\t */","\t/**","\t * Dom node for the shape.","\t *","\t * @config node","\t * @type HTMLElement","\t * @readOnly","\t */","    /**","     * Represents an SVG Path string. This will be parsed and added to shape's API to represent the SVG data across all","     * implementations. Note that when using VML or SVG implementations, part of this content will be added to the DOM using","     * respective VML/SVG attributes. If your content comes from an untrusted source, you will need to ensure that no","     * malicious code is included in that content.","     *","     * @config data","     * @type String","     */","\t/**","\t * Reference to the parent graphic instance","\t *","\t * @config graphic","\t * @type Graphic","\t * @readOnly","\t */","","/**"," * <p>Creates circle shape with editable attributes.</p>"," * <p>`Circle` instances can be created using the <a href=\"Graphic.html#method_addShape\">`addShape`</a> method of the"," * <a href=\"Graphic.html\">`Graphic`</a> class. The method's `cfg` argument contains a `type` attribute. Assigning \"circle\""," * or `Y.Circle` to this attribute will create a `Circle` instance. Required attributes for instantiating a `Circle` are"," * `type` and `radius`. Optional attributes include:"," *  <ul>"," *      <li><a href=\"#attr_fill\">fill</a></li>"," *      <li><a href=\"#attr_id\">id</a></li>"," *      <li><a href=\"#attr_stroke\">stroke</a></li>"," *      <li><a href=\"#attr_transform\">transform</a></li>"," *      <li><a href=\"#attr_transformOrigin\">transformOrigin</a></li>"," *      <li><a href=\"#attr_visible\">visible</a></li>"," *      <li><a href=\"#attr_x\">x</a></li>"," *      <li><a href=\"#attr_y\">y</a></li>"," *  </ul>"," *"," * The below code creates a circle by defining the `type` attribute as \"circle\":</p>","","        var myCircle = myGraphic.addShape({","            type: \"circle\",","            radius: 10,","            fill: {","                color: \"#9aa\"","            },","            stroke: {","                weight: 1,","                color: \"#000\"","            }","        });",""," * Below, this same circle is created by defining the `type` attribute with a class reference:"," *","        var myCircle = myGraphic.addShape({","            type: Y.Circle,","            radius: 10,","            fill: {","                color: \"#9aa\"","            },","            stroke: {","                weight: 1,","                color: \"#000\"","            }","        });"," *"," * <p>`Circle` has the following implementations based on browser capability."," *  <ul>"," *      <li><a href=\"SVGCircle.html\">`SVGCircle`</a></li>"," *      <li><a href=\"VMLCircle.html\">`VMLCircle`</a></li>"," *      <li><a href=\"CanvasCircle.html\">`CanvasCircle`</a></li>"," *  </ul>"," *"," * It is not necessary to interact with these classes directly. `Circle` will point to the appropriate implemention.</p>"," *"," * @class Circle"," * @extends Shape"," * @constructor"," */","    /**","     * Radius of the circle","     *","     * @config radius","     * @type Number","     */","/**"," * <p>Creates an ellipse shape with editable attributes.</p>"," * <p>`Ellipse` instances can be created using the <a href=\"Graphic.html#method_addShape\">`addShape`</a> method of the"," * <a href=\"Graphic.html\">`Graphic`</a> class. The method's `cfg` argument contains a `type` attribute. Assigning \"ellipse\""," * or `Y.Ellipse` to this attribute will create a `Ellipse` instance. Required attributes for instantiating a `Ellipse` are"," * `type`, `width` and `height`. Optional attributes include:"," *  <ul>"," *      <li><a href=\"#attr_fill\">fill</a></li>"," *      <li><a href=\"#attr_id\">id</a></li>"," *      <li><a href=\"#attr_stroke\">stroke</a></li>"," *      <li><a href=\"#attr_transform\">transform</a></li>"," *      <li><a href=\"#attr_transformOrigin\">transformOrigin</a></li>"," *      <li><a href=\"#attr_visible\">visible</a></li>"," *      <li><a href=\"#attr_x\">x</a></li>"," *      <li><a href=\"#attr_y\">y</a></li>"," *  </ul>"," *"," * The below code creates an ellipse by defining the `type` attribute as \"ellipse\":</p>","","        var myEllipse = myGraphic.addShape({","            type: \"ellipse\",","            width: 20,","            height: 10,","            fill: {","                color: \"#9aa\"","            },","            stroke: {","                weight: 1,","                color: \"#000\"","            }","        });",""," * Below, the same ellipse is created by defining the `type` attribute with a class reference:"," *","        var myEllipse = myGraphic.addShape({","            type: Y.Ellipse,","            width: 20,","            height: 10,","            fill: {","                color: \"#9aa\"","            },","            stroke: {","                weight: 1,","                color: \"#000\"","            }","        });"," *"," * <p>`Ellipse` has the following implementations based on browser capability."," *  <ul>"," *      <li><a href=\"SVGEllipse.html\">`SVGEllipse`</a></li>"," *      <li><a href=\"VMLEllipse.html\">`VMLEllipse`</a></li>"," *      <li><a href=\"CanvasEllipse.html\">`CanvasEllipse`</a></li>"," *  </ul>"," *"," * It is not necessary to interact with these classes directly. `Ellipse` will point to the appropriate implemention.</p>"," *"," * @class Ellipse"," * @extends Shape"," * @constructor"," */","/**"," * <p>Creates an rectangle shape with editable attributes.</p>"," * <p>`Rect` instances can be created using the <a href=\"Graphic.html#method_addShape\">`addShape`</a> method of the"," * <a href=\"Graphic.html\">`Graphic`</a> class. The method's `cfg` argument contains a `type` attribute. Assigning \"rect\""," * or `Y.Rect` to this attribute will create a `Rect` instance. Required attributes for instantiating a `Rect` are `type`,"," * `width` and `height`. Optional attributes include:"," *  <ul>"," *      <li><a href=\"#attr_fill\">fill</a></li>"," *      <li><a href=\"#attr_id\">id</a></li>"," *      <li><a href=\"#attr_stroke\">stroke</a></li>"," *      <li><a href=\"#attr_transform\">transform</a></li>"," *      <li><a href=\"#attr_transformOrigin\">transformOrigin</a></li>"," *      <li><a href=\"#attr_visible\">visible</a></li>"," *      <li><a href=\"#attr_x\">x</a></li>"," *      <li><a href=\"#attr_y\">y</a></li>"," *  </ul>"," *"," * The below code creates a rectangle by defining the `type` attribute as \"rect\":</p>","","        var myRect = myGraphic.addShape({","            type: \"rect\",","            width: 20,","            height: 10,","            fill: {","                color: \"#9aa\"","            },","            stroke: {","                weight: 1,","                color: \"#000\"","            }","        });",""," * Below, the same rectangle is created by defining the `type` attribute with a class reference:"," *","        var myRect = myGraphic.addShape({","            type: Y.Rect,","            width: 20,","            height: 10,","            fill: {","                color: \"#9aa\"","            },","            stroke: {","                weight: 1,","                color: \"#000\"","            }","        });"," *"," * <p>`Rect` has the following implementations based on browser capability."," *  <ul>"," *      <li><a href=\"SVGRect.html\">`SVGRect`</a></li>"," *      <li><a href=\"VMLRect.html\">`VMLRect`</a></li>"," *      <li><a href=\"CanvasRect.html\">`CanvasRect`</a></li>"," *  </ul>"," *"," * It is not necessary to interact with these classes directly. `Rect` will point to the appropriate implemention.</p>"," *"," * @class Rect"," * @extends Shape"," * @constructor"," */","/**"," * <p>The `Path` class creates a shape through the use of drawing methods. The `Path` class has the following drawing methods available:</p>"," *  <ul>"," *      <li><a href=\"#method_clear\">`clear`</a></li>"," *      <li><a href=\"#method_curveTo\">`curveTo`</a></li>"," *      <li><a href=\"#method_drawRect\">`drawRect`</a></li>"," *      <li><a href=\"#method_drawRoundRect\">`drawRoundRect`</a></li>"," *      <li><a href=\"#method_end\">`end`</a></li>"," *      <li><a href=\"#method_lineTo\">`lineTo`</a></li>"," *      <li><a href=\"#method_moveTo\">`moveTo`</a></li>"," *      <li><a href=\"#method_quadraticCurveTo\">`quadraticCurveTo`</a></li>"," *  </ul>"," *"," *  <p>Like other shapes, `Path` elements are created using the <a href=\"Graphic.html#method_addShape\">`addShape`</a>"," *  method of the <a href=\"Graphic.html\">`Graphic`</a> class. The method's `cfg` argument contains a `type` attribute."," *  Assigning \"path\" or `Y.Path` to this attribute will create a `Path` instance. After instantiation, a series of drawing"," *  operations must be performed in order to render a shape. The below code instantiates a path element by defining the"," *  `type` attribute as \"path\":</p>","","        var myPath = myGraphic.addShape({","            type: \"path\",","            fill: {","                color: \"#9aa\"","            },","            stroke: {","                weight: 1,","                color: \"#000\"","            }","        });",""," * Below a `Path` element with the same properties is instantiated by defining the `type` attribute with a class reference:"," *","        var myPath = myGraphic.addShape({","            type: Y.Path,","            fill: {","                color: \"#9aa\"","            },","            stroke: {","                weight: 1,","                color: \"#000\"","            }","        });",""," * After instantiation, a shape or segment needs to be drawn for an element to render. After all draw operations are performed,"," * the <a href=\"#method_end\">`end`</a> method will render the shape. The code below will draw a triangle:","","        myPath.moveTo(35, 5);","        myPath.lineTo(65, 65);","        myPath.lineTo(5, 65);","        myPath.lineTo(35, 5);","        myPath.end();"," *"," * <p>`Path` has the following implementations based on browser capability."," *  <ul>"," *      <li><a href=\"SVGPath.html\">`SVGPath`</a></li>"," *      <li><a href=\"VMLPath.html\">`VMLPath`</a></li>"," *      <li><a href=\"CanvasPath.html\">`CanvasPath`</a></li>"," *  </ul>"," * It is not necessary to interact with these classes directly. `Path` will point to the appropriate implemention.</p>"," *"," * @class Path"," * @extends Shape"," * @uses Drawing"," * @constructor"," */","\t/**","\t * Indicates the path used for the node.","\t *","\t * @config path","\t * @type String","     * @readOnly","\t */","/**"," * `Graphic` acts a factory and container for shapes. You need at least one `Graphic` instance to create shapes for your application."," * <p>The code block below creates a `Graphic` instance and appends it to an HTMLElement with the id 'mygraphiccontainer'.</p>","","        var myGraphic = new Y.Graphic({render:\"#mygraphiccontainer\"});",""," * <p>Alternatively, you can add a `Graphic` instance to the DOM using the <a href=\"#method_render\">`render`</a> method.</p>","        var myGraphic = new Y.Graphic();","        myGraphic.render(\"#mygraphiccontainer\");",""," * `Graphic` has the following implementations based on browser capability."," *  <ul>"," *      <li><a href=\"SVGGraphic.html\">`SVGGraphic`</a></li>"," *      <li><a href=\"VMLGraphic.html\">`VMLGraphic`</a></li>"," *      <li><a href=\"CanvasGraphic.html\">`CanvasGraphic`</a></li>"," *  </ul>"," *"," * It is not necessary to interact with these classes directly. `Graphic` will point to the appropriate implemention.</p>"," *"," * @class Graphic"," * @constructor"," */","    /**","     * Whether or not to render the `Graphic` automatically after to a specified parent node after init. This can be a Node","     * instance or a CSS selector string.","     *","     * @config render","     * @type Node | String","     */","    /**","\t * Unique id for class instance.","\t *","\t * @config id","\t * @type String","\t */","    /**","     * Key value pairs in which a shape instance is associated with its id.","     *","     *  @config shapes","     *  @type Object","     *  @readOnly","     */","    /**","     *  Object containing size and coordinate data for the content of a Graphic in relation to the coordSpace node.","     *","     *  @config contentBounds","     *  @type Object","     *  @readOnly","     */","    /**","     *  The html element that represents to coordinate system of the Graphic instance.","     *","     *  @config node","     *  @type HTMLElement","     *  @readOnly","     */","\t/**","\t * Indicates the width of the `Graphic`.","\t *","\t * @config width","\t * @type Number","\t */","\t/**","\t * Indicates the height of the `Graphic`.","\t *","\t * @config height","\t * @type Number","\t */","    /**","     *  Determines the sizing of the Graphic.","     *","     *  <dl>","     *      <dt>sizeContentToGraphic</dt><dd>The Graphic's width and height attributes are, either explicitly set through the","     *      <code>width</code> and <code>height</code> attributes or are determined by the dimensions of the parent element. The","     *      content contained in the Graphic will be sized to fit with in the Graphic instance's dimensions. When using this","     *      setting, the <code>preserveAspectRatio</code> attribute will determine how the contents are sized.</dd>","     *      <dt>sizeGraphicToContent</dt><dd>(Also accepts a value of true) The Graphic's width and height are determined by the","     *      size and positioning of the content.</dd>","     *      <dt>false</dt><dd>The Graphic's width and height attributes are, either explicitly set through the <code>width</code>","     *      and <code>height</code> attributes or are determined by the dimensions of the parent element. The contents of the","     *      Graphic instance are not affected by this setting.</dd>","     *  </dl>","     *","     *","     *  @config autoSize","     *  @type Boolean | String","     *  @default false","     */","    /**","     * Determines how content is sized when <code>autoSize</code> is set to <code>sizeContentToGraphic</code>.","     *","     *  <dl>","     *      <dt>none<dt><dd>Do not force uniform scaling. Scale the graphic content of the given element non-uniformly if necessary","     *      such that the element's bounding box exactly matches the viewport rectangle.</dd>","     *      <dt>xMinYMin</dt><dd>Force uniform scaling position along the top left of the Graphic's node.</dd>","     *      <dt>xMidYMin</dt><dd>Force uniform scaling horizontally centered and positioned at the top of the Graphic's node.<dd>","     *      <dt>xMaxYMin</dt><dd>Force uniform scaling positioned horizontally from the right and vertically from the top.</dd>","     *      <dt>xMinYMid</dt>Force uniform scaling positioned horizontally from the left and vertically centered.</dd>","     *      <dt>xMidYMid (the default)</dt><dd>Force uniform scaling with the content centered.</dd>","     *      <dt>xMaxYMid</dt><dd>Force uniform scaling positioned horizontally from the right and vertically centered.</dd>","     *      <dt>xMinYMax</dt><dd>Force uniform scaling positioned horizontally from the left and vertically from the bottom.</dd>","     *      <dt>xMidYMax</dt><dd>Force uniform scaling horizontally centered and position vertically from the bottom.</dd>","     *      <dt>xMaxYMax</dt><dd>Force uniform scaling positioned horizontally from the right and vertically from the bottom.</dd>","     *  </dl>","     *","     * @config preserveAspectRatio","     * @type String","     * @default xMidYMid","     */","    /**","     * The contentBounds will resize to greater values but not to smaller values. (for performance)","     * When resizing the contentBounds down is desirable, set the resizeDown value to true.","     *","     * @config resizeDown","     * @type Boolean","     */","\t/**","\t * Indicates the x-coordinate for the instance.","\t *","\t * @config x","\t * @type Number","\t */","\t/**","\t * Indicates the y-coordinate for the instance.","\t *","\t * @config y","\t * @type Number","\t */","    /**","     * Indicates whether or not the instance will automatically redraw after a change is made to a shape.","     * This property will get set to false when batching operations.","     *","     * @config autoDraw","     * @type Boolean","     * @default true","     * @private","     */","\t/**","\t * Indicates whether the `Graphic` and its children are visible.","\t *","\t * @config visible","\t * @type Boolean","\t */","    /**","     * Gets the current position of the graphic instance in page coordinates.","     *","     * @method getXY","     * @return Array The XY position of the shape.","     */","    /**","     * Adds the graphics node to the dom.","     *","     * @method render","     * @param {Node|String} parentNode node in which to render the graphics node into.","     */","    /**","     * Removes all nodes.","     *","     * @method destroy","     */","    /**","     * <p>Generates a shape instance by type. The method accepts an object that contain's the shape's","     * type and attributes to be customized. For example, the code below would create a rectangle:</p>","     *","            var myRect = myGraphic.addShape({","                type: \"rect\",","                width: 40,","                height: 30,","                fill: {","                    color: \"#9aa\"","                },","                stroke: {","                    weight: 1,","                    color: \"#000\"","                }","            });","     *","     * <p>The `Graphics` module includes a few basic shapes. More information on their creation","     * can be found in each shape's documentation:","     *","     *  <ul>","     *      <li><a href=\"Circle.html\">`Circle`</a></li>","     *      <li><a href=\"Ellipse.html\">`Ellipse`</a></li>","     *      <li><a href=\"Rect.html\">`Rect`</a></li>","     *      <li><a href=\"Path.html\">`Path`</a></li>","     *  </ul>","     *","     *  The `Graphics` module also allows for the creation of custom shapes. If a custom shape","     *  has been created, it can be instantiated with the `addShape` method as well. The attributes,","     *  required and optional, would need to be defined in the custom shape.","     *","            var myCustomShape = myGraphic.addShape({","                type: Y.MyCustomShape,","                width: 50,","                height: 50,","                fill: {","                    color: \"#9aa\"","                },","                stroke: {","                    weight: 1,","                    color: \"#000\"","                }","            });","     *","     * @method addShape","     * @param {Object} cfg Object containing the shape's type and attributes.","     * @return Shape","     */","    /**","     * Removes a shape instance from from the graphic instance.","     *","     * @method removeShape","     * @param {Shape|String} shape The instance or id of the shape to be removed.","     */","    /**","     * Removes all shape instances from the dom.","     *","     * @method removeAllShapes","     */","    /**","     * Returns a shape based on the id of its dom node.","     *","     * @method getShapeById","     * @param {String} id Dom id of the shape's node attribute.","     * @return Shape","     */","\t/**","\t * Allows for creating multiple shapes in order to batch appending and redraw operations.","\t *","\t * @method batch","\t * @param {Function} method Method to execute.","\t */","","","}, 'patched-v3.20.5', {\"requires\": [\"node\", \"event-custom\", \"pluginhost\", \"matrix\", \"classnamemanager\"]});","","}());"]};
}
var __cov_SOOocKFUEuEZhA2lzJHVlA = __coverage__['build/graphics/graphics.js'];
__cov_SOOocKFUEuEZhA2lzJHVlA.s['1']++;YUI.add('graphics',function(Y,NAME){__cov_SOOocKFUEuEZhA2lzJHVlA.f['1']++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['2']++;var SETTER='setter',PluginHost=Y.Plugin.Host,VALUE='value',VALUEFN='valueFn',READONLY='readOnly',Y_LANG=Y.Lang,STR='string',WRITE_ONCE='writeOnce',GraphicBase,AttributeLite;__cov_SOOocKFUEuEZhA2lzJHVlA.s['3']++;AttributeLite=function(){__cov_SOOocKFUEuEZhA2lzJHVlA.f['2']++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['4']++;var host=this;__cov_SOOocKFUEuEZhA2lzJHVlA.s['5']++;host._ATTR_E_FACADE={};__cov_SOOocKFUEuEZhA2lzJHVlA.s['6']++;Y.EventTarget.call(this,{emitFacade:true});__cov_SOOocKFUEuEZhA2lzJHVlA.s['7']++;host._state={};__cov_SOOocKFUEuEZhA2lzJHVlA.s['8']++;host.prototype=Y.mix(AttributeLite.prototype,host.prototype);};__cov_SOOocKFUEuEZhA2lzJHVlA.s['9']++;AttributeLite.prototype={addAttrs:function(cfg){__cov_SOOocKFUEuEZhA2lzJHVlA.f['3']++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['10']++;var host=this,attrConfig=this.constructor.ATTRS,attr,i,fn,state=host._state;__cov_SOOocKFUEuEZhA2lzJHVlA.s['11']++;for(i in attrConfig){__cov_SOOocKFUEuEZhA2lzJHVlA.s['12']++;if(attrConfig.hasOwnProperty(i)){__cov_SOOocKFUEuEZhA2lzJHVlA.b['1'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['13']++;attr=attrConfig[i];__cov_SOOocKFUEuEZhA2lzJHVlA.s['14']++;if(attr.hasOwnProperty(VALUE)){__cov_SOOocKFUEuEZhA2lzJHVlA.b['2'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['15']++;state[i]=attr.value;}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['2'][1]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['16']++;if(attr.hasOwnProperty(VALUEFN)){__cov_SOOocKFUEuEZhA2lzJHVlA.b['3'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['17']++;fn=attr.valueFn;__cov_SOOocKFUEuEZhA2lzJHVlA.s['18']++;if(Y_LANG.isString(fn)){__cov_SOOocKFUEuEZhA2lzJHVlA.b['4'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['19']++;state[i]=host[fn].apply(host);}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['4'][1]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['20']++;state[i]=fn.apply(host);}}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['3'][1]++;}}}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['1'][1]++;}}__cov_SOOocKFUEuEZhA2lzJHVlA.s['21']++;host._state=state;__cov_SOOocKFUEuEZhA2lzJHVlA.s['22']++;for(i in attrConfig){__cov_SOOocKFUEuEZhA2lzJHVlA.s['23']++;if(attrConfig.hasOwnProperty(i)){__cov_SOOocKFUEuEZhA2lzJHVlA.b['5'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['24']++;attr=attrConfig[i];__cov_SOOocKFUEuEZhA2lzJHVlA.s['25']++;if((__cov_SOOocKFUEuEZhA2lzJHVlA.b['7'][0]++,attr.hasOwnProperty(READONLY))&&(__cov_SOOocKFUEuEZhA2lzJHVlA.b['7'][1]++,attr.readOnly)){__cov_SOOocKFUEuEZhA2lzJHVlA.b['6'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['26']++;continue;}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['6'][1]++;}__cov_SOOocKFUEuEZhA2lzJHVlA.s['27']++;if((__cov_SOOocKFUEuEZhA2lzJHVlA.b['9'][0]++,attr.hasOwnProperty(WRITE_ONCE))&&(__cov_SOOocKFUEuEZhA2lzJHVlA.b['9'][1]++,attr.writeOnce)){__cov_SOOocKFUEuEZhA2lzJHVlA.b['8'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['28']++;attr.readOnly=true;}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['8'][1]++;}__cov_SOOocKFUEuEZhA2lzJHVlA.s['29']++;if((__cov_SOOocKFUEuEZhA2lzJHVlA.b['11'][0]++,cfg)&&(__cov_SOOocKFUEuEZhA2lzJHVlA.b['11'][1]++,cfg.hasOwnProperty(i))){__cov_SOOocKFUEuEZhA2lzJHVlA.b['10'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['30']++;if(attr.hasOwnProperty(SETTER)){__cov_SOOocKFUEuEZhA2lzJHVlA.b['12'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['31']++;host._state[i]=attr.setter.apply(host,[cfg[i]]);}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['12'][1]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['32']++;host._state[i]=cfg[i];}}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['10'][1]++;}}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['5'][1]++;}}},get:function(attr){__cov_SOOocKFUEuEZhA2lzJHVlA.f['4']++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['33']++;var host=this,getter,attrConfig=host.constructor.ATTRS;__cov_SOOocKFUEuEZhA2lzJHVlA.s['34']++;if((__cov_SOOocKFUEuEZhA2lzJHVlA.b['14'][0]++,attrConfig)&&(__cov_SOOocKFUEuEZhA2lzJHVlA.b['14'][1]++,attrConfig[attr])){__cov_SOOocKFUEuEZhA2lzJHVlA.b['13'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['35']++;getter=attrConfig[attr].getter;__cov_SOOocKFUEuEZhA2lzJHVlA.s['36']++;if(getter){__cov_SOOocKFUEuEZhA2lzJHVlA.b['15'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['37']++;if(typeof getter===STR){__cov_SOOocKFUEuEZhA2lzJHVlA.b['16'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['38']++;return host[getter].apply(host);}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['16'][1]++;}__cov_SOOocKFUEuEZhA2lzJHVlA.s['39']++;return attrConfig[attr].getter.apply(host);}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['15'][1]++;}__cov_SOOocKFUEuEZhA2lzJHVlA.s['40']++;return host._state[attr];}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['13'][1]++;}__cov_SOOocKFUEuEZhA2lzJHVlA.s['41']++;return null;},set:function(){__cov_SOOocKFUEuEZhA2lzJHVlA.f['5']++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['42']++;var attr=arguments[0],i;__cov_SOOocKFUEuEZhA2lzJHVlA.s['43']++;if(Y_LANG.isObject(attr)){__cov_SOOocKFUEuEZhA2lzJHVlA.b['17'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['44']++;for(i in attr){__cov_SOOocKFUEuEZhA2lzJHVlA.s['45']++;if(attr.hasOwnProperty(i)){__cov_SOOocKFUEuEZhA2lzJHVlA.b['18'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['46']++;this._set(i,attr[i]);}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['18'][1]++;}}}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['17'][1]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['47']++;this._set.apply(this,arguments);}},_set:function(attr,val){__cov_SOOocKFUEuEZhA2lzJHVlA.f['6']++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['48']++;var host=this,setter,args,attrConfig=host.constructor.ATTRS;__cov_SOOocKFUEuEZhA2lzJHVlA.s['49']++;if((__cov_SOOocKFUEuEZhA2lzJHVlA.b['20'][0]++,attrConfig)&&(__cov_SOOocKFUEuEZhA2lzJHVlA.b['20'][1]++,attrConfig.hasOwnProperty(attr))){__cov_SOOocKFUEuEZhA2lzJHVlA.b['19'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['50']++;setter=attrConfig[attr].setter;__cov_SOOocKFUEuEZhA2lzJHVlA.s['51']++;if(setter){__cov_SOOocKFUEuEZhA2lzJHVlA.b['21'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['52']++;args=[val];__cov_SOOocKFUEuEZhA2lzJHVlA.s['53']++;if(typeof setter===STR){__cov_SOOocKFUEuEZhA2lzJHVlA.b['22'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['54']++;val=host[setter].apply(host,args);}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['22'][1]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['55']++;val=attrConfig[attr].setter.apply(host,args);}}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['21'][1]++;}__cov_SOOocKFUEuEZhA2lzJHVlA.s['56']++;host._state[attr]=val;}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['19'][1]++;}}};__cov_SOOocKFUEuEZhA2lzJHVlA.s['57']++;Y.mix(AttributeLite,Y.EventTarget,false,null,1);__cov_SOOocKFUEuEZhA2lzJHVlA.s['58']++;Y.AttributeLite=AttributeLite;__cov_SOOocKFUEuEZhA2lzJHVlA.s['59']++;GraphicBase=function(cfg){__cov_SOOocKFUEuEZhA2lzJHVlA.f['7']++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['60']++;var host=this,PluginHost=(__cov_SOOocKFUEuEZhA2lzJHVlA.b['23'][0]++,Y.Plugin)&&(__cov_SOOocKFUEuEZhA2lzJHVlA.b['23'][1]++,Y.Plugin.Host);__cov_SOOocKFUEuEZhA2lzJHVlA.s['61']++;if((__cov_SOOocKFUEuEZhA2lzJHVlA.b['25'][0]++,host._initPlugins)&&(__cov_SOOocKFUEuEZhA2lzJHVlA.b['25'][1]++,PluginHost)){__cov_SOOocKFUEuEZhA2lzJHVlA.b['24'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['62']++;PluginHost.call(host);}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['24'][1]++;}__cov_SOOocKFUEuEZhA2lzJHVlA.s['63']++;host.name=host.constructor.NAME;__cov_SOOocKFUEuEZhA2lzJHVlA.s['64']++;host._eventPrefix=(__cov_SOOocKFUEuEZhA2lzJHVlA.b['26'][0]++,host.constructor.EVENT_PREFIX)||(__cov_SOOocKFUEuEZhA2lzJHVlA.b['26'][1]++,host.constructor.NAME);__cov_SOOocKFUEuEZhA2lzJHVlA.s['65']++;AttributeLite.call(host);__cov_SOOocKFUEuEZhA2lzJHVlA.s['66']++;host.addAttrs(cfg);__cov_SOOocKFUEuEZhA2lzJHVlA.s['67']++;host.init.apply(this,arguments);__cov_SOOocKFUEuEZhA2lzJHVlA.s['68']++;if(host._initPlugins){__cov_SOOocKFUEuEZhA2lzJHVlA.b['27'][0]++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['69']++;host._initPlugins(cfg);}else{__cov_SOOocKFUEuEZhA2lzJHVlA.b['27'][1]++;}__cov_SOOocKFUEuEZhA2lzJHVlA.s['70']++;host.initialized=true;};__cov_SOOocKFUEuEZhA2lzJHVlA.s['71']++;GraphicBase.NAME='baseGraphic';__cov_SOOocKFUEuEZhA2lzJHVlA.s['72']++;GraphicBase.prototype={init:function(){__cov_SOOocKFUEuEZhA2lzJHVlA.f['8']++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['73']++;this.publish('init',{fireOnce:true});__cov_SOOocKFUEuEZhA2lzJHVlA.s['74']++;this.initializer.apply(this,arguments);__cov_SOOocKFUEuEZhA2lzJHVlA.s['75']++;this.fire('init',{cfg:arguments[0]});},_camelCaseConcat:function(prefix,name){__cov_SOOocKFUEuEZhA2lzJHVlA.f['9']++;__cov_SOOocKFUEuEZhA2lzJHVlA.s['76']++;return prefix+name.charAt(0).toUpperCase()+name.slice(1);}};__cov_SOOocKFUEuEZhA2lzJHVlA.s['77']++;Y.mix(GraphicBase,Y.AttributeLite,false,null,1);__cov_SOOocKFUEuEZhA2lzJHVlA.s['78']++;Y.mix(GraphicBase,PluginHost,false,null,1);__cov_SOOocKFUEuEZhA2lzJHVlA.s['79']++;GraphicBase.prototype.constructor=GraphicBase;__cov_SOOocKFUEuEZhA2lzJHVlA.s['80']++;GraphicBase.plug=PluginHost.plug;__cov_SOOocKFUEuEZhA2lzJHVlA.s['81']++;GraphicBase.unplug=PluginHost.unplug;__cov_SOOocKFUEuEZhA2lzJHVlA.s['82']++;Y.GraphicBase=GraphicBase;},'patched-v3.20.5',{'requires':['node','event-custom','pluginhost','matrix','classnamemanager']});
