if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/autocomplete-filters-accentfold/autocomplete-filters-accentfold.js']) {
   __coverage__['build/autocomplete-filters-accentfold/autocomplete-filters-accentfold.js'] = {"path":"build/autocomplete-filters-accentfold/autocomplete-filters-accentfold.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":43},"end":{"line":1,"column":62}}},"2":{"name":"(anonymous_2)","line":34,"loc":{"start":{"line":34,"column":19},"end":{"line":34,"column":45}}},"3":{"name":"(anonymous_3)","line":39,"loc":{"start":{"line":39,"column":38},"end":{"line":39,"column":56}}},"4":{"name":"(anonymous_4)","line":42,"loc":{"start":{"line":42,"column":44},"end":{"line":42,"column":59}}},"5":{"name":"(anonymous_5)","line":57,"loc":{"start":{"line":57,"column":21},"end":{"line":57,"column":47}}},"6":{"name":"(anonymous_6)","line":62,"loc":{"start":{"line":62,"column":38},"end":{"line":62,"column":56}}},"7":{"name":"(anonymous_7)","line":76,"loc":{"start":{"line":76,"column":20},"end":{"line":76,"column":46}}},"8":{"name":"(anonymous_8)","line":81,"loc":{"start":{"line":81,"column":38},"end":{"line":81,"column":56}}},"9":{"name":"(anonymous_9)","line":95,"loc":{"start":{"line":95,"column":22},"end":{"line":95,"column":48}}},"10":{"name":"(anonymous_10)","line":100,"loc":{"start":{"line":100,"column":38},"end":{"line":100,"column":56}}},"11":{"name":"(anonymous_11)","line":103,"loc":{"start":{"line":103,"column":44},"end":{"line":103,"column":65}}},"12":{"name":"(anonymous_12)","line":118,"loc":{"start":{"line":118,"column":19},"end":{"line":118,"column":45}}},"13":{"name":"(anonymous_13)","line":123,"loc":{"start":{"line":123,"column":38},"end":{"line":123,"column":56}}},"14":{"name":"(anonymous_14)","line":128,"loc":{"start":{"line":128,"column":44},"end":{"line":128,"column":60}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":136,"column":85}},"2":{"start":{"line":19,"column":0},"end":{"line":22,"column":26}},"3":{"start":{"line":24,"column":0},"end":{"line":133,"column":3}},"4":{"start":{"line":35,"column":8},"end":{"line":35,"column":39}},"5":{"start":{"line":35,"column":22},"end":{"line":35,"column":37}},"6":{"start":{"line":37,"column":8},"end":{"line":37,"column":73}},"7":{"start":{"line":39,"column":8},"end":{"line":45,"column":11}},"8":{"start":{"line":40,"column":12},"end":{"line":40,"column":52}},"9":{"start":{"line":42,"column":12},"end":{"line":44,"column":15}},"10":{"start":{"line":43,"column":16},"end":{"line":43,"column":48}},"11":{"start":{"line":58,"column":8},"end":{"line":58,"column":39}},"12":{"start":{"line":58,"column":22},"end":{"line":58,"column":37}},"13":{"start":{"line":60,"column":8},"end":{"line":60,"column":39}},"14":{"start":{"line":62,"column":8},"end":{"line":64,"column":11}},"15":{"start":{"line":63,"column":12},"end":{"line":63,"column":70}},"16":{"start":{"line":77,"column":8},"end":{"line":77,"column":39}},"17":{"start":{"line":77,"column":22},"end":{"line":77,"column":37}},"18":{"start":{"line":79,"column":8},"end":{"line":79,"column":39}},"19":{"start":{"line":81,"column":8},"end":{"line":83,"column":11}},"20":{"start":{"line":82,"column":12},"end":{"line":82,"column":69}},"21":{"start":{"line":96,"column":8},"end":{"line":96,"column":39}},"22":{"start":{"line":96,"column":22},"end":{"line":96,"column":37}},"23":{"start":{"line":98,"column":8},"end":{"line":98,"column":74}},"24":{"start":{"line":100,"column":8},"end":{"line":106,"column":11}},"25":{"start":{"line":101,"column":12},"end":{"line":101,"column":58}},"26":{"start":{"line":103,"column":12},"end":{"line":105,"column":15}},"27":{"start":{"line":104,"column":16},"end":{"line":104,"column":60}},"28":{"start":{"line":119,"column":8},"end":{"line":119,"column":39}},"29":{"start":{"line":119,"column":22},"end":{"line":119,"column":37}},"30":{"start":{"line":121,"column":8},"end":{"line":121,"column":74}},"31":{"start":{"line":123,"column":8},"end":{"line":131,"column":11}},"32":{"start":{"line":125,"column":12},"end":{"line":126,"column":51}},"33":{"start":{"line":128,"column":12},"end":{"line":130,"column":15}},"34":{"start":{"line":129,"column":16},"end":{"line":129,"column":55}}},"branchMap":{"1":{"line":35,"type":"if","locations":[{"start":{"line":35,"column":8},"end":{"line":35,"column":8}},{"start":{"line":35,"column":8},"end":{"line":35,"column":8}}]},"2":{"line":58,"type":"if","locations":[{"start":{"line":58,"column":8},"end":{"line":58,"column":8}},{"start":{"line":58,"column":8},"end":{"line":58,"column":8}}]},"3":{"line":77,"type":"if","locations":[{"start":{"line":77,"column":8},"end":{"line":77,"column":8}},{"start":{"line":77,"column":8},"end":{"line":77,"column":8}}]},"4":{"line":96,"type":"if","locations":[{"start":{"line":96,"column":8},"end":{"line":96,"column":8}},{"start":{"line":96,"column":8},"end":{"line":96,"column":8}}]},"5":{"line":119,"type":"if","locations":[{"start":{"line":119,"column":8},"end":{"line":119,"column":8}},{"start":{"line":119,"column":8},"end":{"line":119,"column":8}}]}},"code":["(function () { YUI.add('autocomplete-filters-accentfold', function (Y, NAME) {","","/**","Provides pre-built accent-folding result matching filters for AutoComplete.","","These filters are similar to the ones provided by the `autocomplete-filters`","module, but use accent-aware comparisons. For example, \"resume\" and \"résumé\"","will be considered equal when using the accent-folding filters.","","@module autocomplete","@submodule autocomplete-filters-accentfold","**/","","/**","@class AutoCompleteFilters","@static","**/","","var AccentFold = Y.Text.AccentFold,","    WordBreak  = Y.Text.WordBreak,","    YArray     = Y.Array,","    YObject    = Y.Object;","","Y.mix(Y.namespace('AutoCompleteFilters'), {","    /**","    Accent folding version of `charMatch()`.","","    @method charMatchFold","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    charMatchFold: function (query, results) {","        if (!query) { return results; }","","        var queryChars = YArray.unique(AccentFold.fold(query).split(''));","","        return YArray.filter(results, function (result) {","            var text = AccentFold.fold(result.text);","","            return YArray.every(queryChars, function (chr) {","                return text.indexOf(chr) !== -1;","            });","        });","    },","","    /**","    Accent folding version of `phraseMatch()`.","","    @method phraseMatchFold","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    phraseMatchFold: function (query, results) {","        if (!query) { return results; }","","        query = AccentFold.fold(query);","","        return YArray.filter(results, function (result) {","            return AccentFold.fold(result.text).indexOf(query) !== -1;","        });","    },","","    /**","    Accent folding version of `startsWith()`.","","    @method startsWithFold","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    startsWithFold: function (query, results) {","        if (!query) { return results; }","","        query = AccentFold.fold(query);","","        return YArray.filter(results, function (result) {","            return AccentFold.fold(result.text).indexOf(query) === 0;","        });","    },","","    /**","    Accent folding version of `subWordMatch()`.","","    @method subWordMatchFold","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    subWordMatchFold: function (query, results) {","        if (!query) { return results; }","","        var queryWords = WordBreak.getUniqueWords(AccentFold.fold(query));","","        return YArray.filter(results, function (result) {","            var resultText = AccentFold.fold(result.text);","","            return YArray.every(queryWords, function (queryWord) {","                return resultText.indexOf(queryWord) !== -1;","            });","        });","    },","","    /**","    Accent folding version of `wordMatch()`.","","    @method wordMatchFold","    @param {String} query Query to match","    @param {Array} results Results to filter","    @return {Array} Filtered results","    @static","    **/","    wordMatchFold: function (query, results) {","        if (!query) { return results; }","","        var queryWords = WordBreak.getUniqueWords(AccentFold.fold(query));","","        return YArray.filter(results, function (result) {","            // Convert resultWords array to a hash for fast lookup.","            var resultWords = YArray.hash(WordBreak.getUniqueWords(","                    AccentFold.fold(result.text)));","","            return YArray.every(queryWords, function (word) {","                return YObject.owns(resultWords, word);","            });","        });","    }","});","","","}, 'patched-v3.20.3', {\"requires\": [\"array-extras\", \"text-accentfold\", \"text-wordbreak\"]});","","}());"]};
}
var __cov_FPXCo_fR8sOM0vaP91Yuew = __coverage__['build/autocomplete-filters-accentfold/autocomplete-filters-accentfold.js'];
__cov_FPXCo_fR8sOM0vaP91Yuew.s['1']++;YUI.add('autocomplete-filters-accentfold',function(Y,NAME){__cov_FPXCo_fR8sOM0vaP91Yuew.f['1']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['2']++;var AccentFold=Y.Text.AccentFold,WordBreak=Y.Text.WordBreak,YArray=Y.Array,YObject=Y.Object;__cov_FPXCo_fR8sOM0vaP91Yuew.s['3']++;Y.mix(Y.namespace('AutoCompleteFilters'),{charMatchFold:function(query,results){__cov_FPXCo_fR8sOM0vaP91Yuew.f['2']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['4']++;if(!query){__cov_FPXCo_fR8sOM0vaP91Yuew.b['1'][0]++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['5']++;return results;}else{__cov_FPXCo_fR8sOM0vaP91Yuew.b['1'][1]++;}__cov_FPXCo_fR8sOM0vaP91Yuew.s['6']++;var queryChars=YArray.unique(AccentFold.fold(query).split(''));__cov_FPXCo_fR8sOM0vaP91Yuew.s['7']++;return YArray.filter(results,function(result){__cov_FPXCo_fR8sOM0vaP91Yuew.f['3']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['8']++;var text=AccentFold.fold(result.text);__cov_FPXCo_fR8sOM0vaP91Yuew.s['9']++;return YArray.every(queryChars,function(chr){__cov_FPXCo_fR8sOM0vaP91Yuew.f['4']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['10']++;return text.indexOf(chr)!==-1;});});},phraseMatchFold:function(query,results){__cov_FPXCo_fR8sOM0vaP91Yuew.f['5']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['11']++;if(!query){__cov_FPXCo_fR8sOM0vaP91Yuew.b['2'][0]++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['12']++;return results;}else{__cov_FPXCo_fR8sOM0vaP91Yuew.b['2'][1]++;}__cov_FPXCo_fR8sOM0vaP91Yuew.s['13']++;query=AccentFold.fold(query);__cov_FPXCo_fR8sOM0vaP91Yuew.s['14']++;return YArray.filter(results,function(result){__cov_FPXCo_fR8sOM0vaP91Yuew.f['6']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['15']++;return AccentFold.fold(result.text).indexOf(query)!==-1;});},startsWithFold:function(query,results){__cov_FPXCo_fR8sOM0vaP91Yuew.f['7']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['16']++;if(!query){__cov_FPXCo_fR8sOM0vaP91Yuew.b['3'][0]++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['17']++;return results;}else{__cov_FPXCo_fR8sOM0vaP91Yuew.b['3'][1]++;}__cov_FPXCo_fR8sOM0vaP91Yuew.s['18']++;query=AccentFold.fold(query);__cov_FPXCo_fR8sOM0vaP91Yuew.s['19']++;return YArray.filter(results,function(result){__cov_FPXCo_fR8sOM0vaP91Yuew.f['8']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['20']++;return AccentFold.fold(result.text).indexOf(query)===0;});},subWordMatchFold:function(query,results){__cov_FPXCo_fR8sOM0vaP91Yuew.f['9']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['21']++;if(!query){__cov_FPXCo_fR8sOM0vaP91Yuew.b['4'][0]++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['22']++;return results;}else{__cov_FPXCo_fR8sOM0vaP91Yuew.b['4'][1]++;}__cov_FPXCo_fR8sOM0vaP91Yuew.s['23']++;var queryWords=WordBreak.getUniqueWords(AccentFold.fold(query));__cov_FPXCo_fR8sOM0vaP91Yuew.s['24']++;return YArray.filter(results,function(result){__cov_FPXCo_fR8sOM0vaP91Yuew.f['10']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['25']++;var resultText=AccentFold.fold(result.text);__cov_FPXCo_fR8sOM0vaP91Yuew.s['26']++;return YArray.every(queryWords,function(queryWord){__cov_FPXCo_fR8sOM0vaP91Yuew.f['11']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['27']++;return resultText.indexOf(queryWord)!==-1;});});},wordMatchFold:function(query,results){__cov_FPXCo_fR8sOM0vaP91Yuew.f['12']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['28']++;if(!query){__cov_FPXCo_fR8sOM0vaP91Yuew.b['5'][0]++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['29']++;return results;}else{__cov_FPXCo_fR8sOM0vaP91Yuew.b['5'][1]++;}__cov_FPXCo_fR8sOM0vaP91Yuew.s['30']++;var queryWords=WordBreak.getUniqueWords(AccentFold.fold(query));__cov_FPXCo_fR8sOM0vaP91Yuew.s['31']++;return YArray.filter(results,function(result){__cov_FPXCo_fR8sOM0vaP91Yuew.f['13']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['32']++;var resultWords=YArray.hash(WordBreak.getUniqueWords(AccentFold.fold(result.text)));__cov_FPXCo_fR8sOM0vaP91Yuew.s['33']++;return YArray.every(queryWords,function(word){__cov_FPXCo_fR8sOM0vaP91Yuew.f['14']++;__cov_FPXCo_fR8sOM0vaP91Yuew.s['34']++;return YObject.owns(resultWords,word);});});}});},'patched-v3.20.3',{'requires':['array-extras','text-accentfold','text-wordbreak']});
