if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/jsonp-url/jsonp-url.js']) {
   __coverage__['build/jsonp-url/jsonp-url.js'] = {"path":"build/jsonp-url/jsonp-url.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":21},"end":{"line":1,"column":40}}},"2":{"name":"(anonymous_2)","line":5,"loc":{"start":{"line":5,"column":19},"end":{"line":5,"column":31}}},"3":{"name":"(anonymous_3)","line":54,"loc":{"start":{"line":54,"column":22},"end":{"line":54,"column":37}}},"4":{"name":"(anonymous_4)","line":64,"loc":{"start":{"line":64,"column":20},"end":{"line":64,"column":41}}},"5":{"name":"(anonymous_5)","line":69,"loc":{"start":{"line":69,"column":20},"end":{"line":69,"column":37}}},"6":{"name":"(anonymous_6)","line":109,"loc":{"start":{"line":109,"column":13},"end":{"line":109,"column":35}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":133,"column":41}},"2":{"start":{"line":3,"column":0},"end":{"line":5,"column":34}},"3":{"start":{"line":17,"column":0},"end":{"line":130,"column":9}},"4":{"start":{"line":55,"column":8},"end":{"line":58,"column":36}},"5":{"start":{"line":60,"column":8},"end":{"line":91,"column":9}},"6":{"start":{"line":62,"column":12},"end":{"line":74,"column":36}},"7":{"start":{"line":65,"column":24},"end":{"line":65,"column":37}},"8":{"start":{"line":66,"column":24},"end":{"line":66,"column":44}},"9":{"start":{"line":71,"column":24},"end":{"line":71,"column":55}},"10":{"start":{"line":72,"column":24},"end":{"line":72,"column":44}},"11":{"start":{"line":77,"column":12},"end":{"line":90,"column":13}},"12":{"start":{"line":78,"column":16},"end":{"line":78,"column":42}},"13":{"start":{"line":79,"column":16},"end":{"line":83,"column":17}},"14":{"start":{"line":80,"column":20},"end":{"line":82,"column":21}},"15":{"start":{"line":81,"column":24},"end":{"line":81,"column":72}},"16":{"start":{"line":87,"column":16},"end":{"line":89,"column":55}},"17":{"start":{"line":93,"column":8},"end":{"line":93,"column":32}},"18":{"start":{"line":110,"column":8},"end":{"line":111,"column":31}},"19":{"start":{"line":113,"column":8},"end":{"line":115,"column":9}},"20":{"start":{"line":114,"column":12},"end":{"line":114,"column":50}},"21":{"start":{"line":117,"column":8},"end":{"line":117,"column":61}},"22":{"start":{"line":119,"column":8},"end":{"line":127,"column":9}},"23":{"start":{"line":120,"column":12},"end":{"line":120,"column":56}},"24":{"start":{"line":122,"column":12},"end":{"line":122,"column":37}},"25":{"start":{"line":123,"column":12},"end":{"line":125,"column":13}},"26":{"start":{"line":124,"column":16},"end":{"line":124,"column":59}},"27":{"start":{"line":126,"column":12},"end":{"line":126,"column":34}}},"branchMap":{"1":{"line":60,"type":"if","locations":[{"start":{"line":60,"column":8},"end":{"line":60,"column":8}},{"start":{"line":60,"column":8},"end":{"line":60,"column":8}}]},"2":{"line":77,"type":"if","locations":[{"start":{"line":77,"column":12},"end":{"line":77,"column":12}},{"start":{"line":77,"column":12},"end":{"line":77,"column":12}}]},"3":{"line":80,"type":"if","locations":[{"start":{"line":80,"column":20},"end":{"line":80,"column":20}},{"start":{"line":80,"column":20},"end":{"line":80,"column":20}}]},"4":{"line":87,"type":"binary-expr","locations":[{"start":{"line":87,"column":27},"end":{"line":87,"column":56}},{"start":{"line":88,"column":27},"end":{"line":88,"column":45}},{"start":{"line":89,"column":27},"end":{"line":89,"column":54}}]},"5":{"line":93,"type":"binary-expr","locations":[{"start":{"line":93,"column":15},"end":{"line":93,"column":23}},{"start":{"line":93,"column":27},"end":{"line":93,"column":31}}]},"6":{"line":113,"type":"if","locations":[{"start":{"line":113,"column":8},"end":{"line":113,"column":8}},{"start":{"line":113,"column":8},"end":{"line":113,"column":8}}]},"7":{"line":119,"type":"if","locations":[{"start":{"line":119,"column":8},"end":{"line":119,"column":8}},{"start":{"line":119,"column":8},"end":{"line":119,"column":8}}]},"8":{"line":123,"type":"if","locations":[{"start":{"line":123,"column":12},"end":{"line":123,"column":12}},{"start":{"line":123,"column":12},"end":{"line":123,"column":12}}]},"9":{"line":123,"type":"binary-expr","locations":[{"start":{"line":123,"column":16},"end":{"line":123,"column":32}},{"start":{"line":123,"column":36},"end":{"line":123,"column":52}}]},"10":{"line":124,"type":"cond-expr","locations":[{"start":{"line":124,"column":49},"end":{"line":124,"column":52}},{"start":{"line":124,"column":55},"end":{"line":124,"column":58}}]}},"code":["(function () { YUI.add('jsonp-url', function (Y, NAME) {","","var JSONPRequest = Y.JSONPRequest,","    getByPath    = Y.Object.getValue,","    noop         = function () {};","","/**"," * Adds support for parsing complex callback identifiers from the jsonp url."," * This includes callback=foo[1]bar.baz[\"goo\"] as well as referencing methods"," * in the YUI instance."," *"," * @module jsonp"," * @submodule jsonp-url"," * @for JSONPRequest"," */","","Y.mix(JSONPRequest.prototype, {","    /**","     * RegExp used by the default URL formatter to insert the generated callback","     * name into the JSONP url.  Looks for a query param callback=.  If a value","     * is assigned, it will be clobbered.","     *","     * @property _pattern","     * @type RegExp","     * @default /\\bcallback=.*?(?=&|$)/i","     * @protected","     */","    _pattern: /\\bcallback=(.*?)(?=&|$)/i,","","    /**","     * Template used by the default URL formatter to add the callback function","     * name to the url.","     *","     * @property _template","     * @type String","     * @default \"callback={callback}\"","     * @protected","     */","    _template: \"callback={callback}\",","","    /**","     * <p>Parses the url for a callback named explicitly in the string.","     * Override this if the target JSONP service uses a different query","     * parameter or url format.</p>","     *","     * <p>If the callback is declared inline, the corresponding function will","     * be returned.  Otherwise null.</p>","     *","     * @method _defaultCallback","     * @param url {String} the url to search in","     * @return {Function} the callback function if found, or null","     * @protected","     */","    _defaultCallback: function (url) {","        var match = url.match(this._pattern),","            keys  = [],","            i = 0,","            locator, path, callback;","","        if (match) {","            // Strip the [\"string keys\"] and [1] array indexes","            locator = match[1]","                .replace(/\\[(['\"])(.*?)\\1\\]/g,","                    function (x, $1, $2) {","                        keys[i] = $2;","                        return '.@' + (i++);","                    })","                .replace(/\\[(\\d+)\\]/g,","                    function (x, $1) {","                        /*jslint bitwise: true */","                        keys[i] = parseInt($1, 10) | 0;","                        return '.@' + (i++);","                    })","                .replace(/^\\./, ''); // remove leading dot","","            // Validate against problematic characters.","            if (!/[^\\w\\.\\$@]/.test(locator)) {","                path = locator.split('.');","                for (i = path.length - 1; i >= 0; --i) {","                    if (path[i].charAt(0) === '@') {","                        path[i] = keys[parseInt(path[i].substr(1), 10)];","                    }","                }","","                // First look for a global function, then the Y, then try the Y","                // again from the second token (to support \"callback=Y.handler\")","                callback = getByPath(Y.config.win, path) ||","                           getByPath(Y, path) ||","                           getByPath(Y, path.slice(1));","            }","        }","","        return callback || noop;","    },","","    /**","     * URL formatter that looks for callback= in the url and appends it","     * if not present.  The supplied proxy name will be assigned to the query","     * param.  Override this method by passing a function as the","     * &quot;format&quot; property in the config object to the constructor.","     *","     * @method _format","     * @param url { String } the original url","     * @param proxy {String} the function name that will be used as a proxy to","     *      the configured callback methods.","     * @return {String} fully qualified JSONP url","     * @protected","     */","    _format: function (url, proxy) {","        var callbackRE = /\\{callback\\}/,","            callback, lastChar;","","        if (callbackRE.test(url)) {","            return url.replace(callbackRE, proxy);","        }","","        callback = this._template.replace(callbackRE, proxy);","","        if (this._pattern.test(url)) {","            return url.replace(this._pattern, callback);","        } else {","            lastChar = url.slice(-1);","            if (lastChar !== '&' && lastChar !== '?') {","                url += (url.indexOf('?') > -1) ? '&' : '?';","            }","            return url + callback;","        }","    }","","}, true);","","","}, 'patched-v3.20.2', {\"requires\": [\"jsonp\"]});","","}());"]};
}
var __cov_5w$_gf1Mn7SBKiyuo2Kxgw = __coverage__['build/jsonp-url/jsonp-url.js'];
__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['1']++;YUI.add('jsonp-url',function(Y,NAME){__cov_5w$_gf1Mn7SBKiyuo2Kxgw.f['1']++;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['2']++;var JSONPRequest=Y.JSONPRequest,getByPath=Y.Object.getValue,noop=function(){__cov_5w$_gf1Mn7SBKiyuo2Kxgw.f['2']++;};__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['3']++;Y.mix(JSONPRequest.prototype,{_pattern:/\bcallback=(.*?)(?=&|$)/i,_template:'callback={callback}',_defaultCallback:function(url){__cov_5w$_gf1Mn7SBKiyuo2Kxgw.f['3']++;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['4']++;var match=url.match(this._pattern),keys=[],i=0,locator,path,callback;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['5']++;if(match){__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['1'][0]++;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['6']++;locator=match[1].replace(/\[(['"])(.*?)\1\]/g,function(x,$1,$2){__cov_5w$_gf1Mn7SBKiyuo2Kxgw.f['4']++;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['7']++;keys[i]=$2;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['8']++;return'.@'+i++;}).replace(/\[(\d+)\]/g,function(x,$1){__cov_5w$_gf1Mn7SBKiyuo2Kxgw.f['5']++;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['9']++;keys[i]=parseInt($1,10)|0;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['10']++;return'.@'+i++;}).replace(/^\./,'');__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['11']++;if(!/[^\w\.\$@]/.test(locator)){__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['2'][0]++;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['12']++;path=locator.split('.');__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['13']++;for(i=path.length-1;i>=0;--i){__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['14']++;if(path[i].charAt(0)==='@'){__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['3'][0]++;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['15']++;path[i]=keys[parseInt(path[i].substr(1),10)];}else{__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['3'][1]++;}}__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['16']++;callback=(__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['4'][0]++,getByPath(Y.config.win,path))||(__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['4'][1]++,getByPath(Y,path))||(__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['4'][2]++,getByPath(Y,path.slice(1)));}else{__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['2'][1]++;}}else{__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['1'][1]++;}__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['17']++;return(__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['5'][0]++,callback)||(__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['5'][1]++,noop);},_format:function(url,proxy){__cov_5w$_gf1Mn7SBKiyuo2Kxgw.f['6']++;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['18']++;var callbackRE=/\{callback\}/,callback,lastChar;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['19']++;if(callbackRE.test(url)){__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['6'][0]++;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['20']++;return url.replace(callbackRE,proxy);}else{__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['6'][1]++;}__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['21']++;callback=this._template.replace(callbackRE,proxy);__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['22']++;if(this._pattern.test(url)){__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['7'][0]++;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['23']++;return url.replace(this._pattern,callback);}else{__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['7'][1]++;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['24']++;lastChar=url.slice(-1);__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['25']++;if((__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['9'][0]++,lastChar!=='&')&&(__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['9'][1]++,lastChar!=='?')){__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['8'][0]++;__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['26']++;url+=url.indexOf('?')>-1?(__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['10'][0]++,'&'):(__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['10'][1]++,'?');}else{__cov_5w$_gf1Mn7SBKiyuo2Kxgw.b['8'][1]++;}__cov_5w$_gf1Mn7SBKiyuo2Kxgw.s['27']++;return url+callback;}}},true);},'patched-v3.20.2',{'requires':['jsonp']});
