if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/dataschema-text/dataschema-text.js']) {
   __coverage__['build/dataschema-text/dataschema-text.js'] = {"path":"build/dataschema-text/dataschema-text.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0},"b":{"1":[0,0],"2":[0,0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0]},"f":{"1":0,"2":0,"3":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":27},"end":{"line":1,"column":46}}},"2":{"name":"(anonymous_2)","line":105,"loc":{"start":{"line":105,"column":15},"end":{"line":105,"column":38}}},"3":{"name":"(anonymous_3)","line":130,"loc":{"start":{"line":130,"column":23},"end":{"line":130,"column":59}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":182,"column":51}},"2":{"start":{"line":22,"column":0},"end":{"line":177,"column":6}},"3":{"start":{"line":106,"column":12},"end":{"line":107,"column":53}},"4":{"start":{"line":109,"column":12},"end":{"line":114,"column":13}},"5":{"start":{"line":111,"column":16},"end":{"line":111,"column":90}},"6":{"start":{"line":113,"column":16},"end":{"line":113,"column":72}},"7":{"start":{"line":116,"column":12},"end":{"line":116,"column":28}},"8":{"start":{"line":131,"column":12},"end":{"line":138,"column":40}},"9":{"start":{"line":141,"column":12},"end":{"line":143,"column":13}},"10":{"start":{"line":142,"column":16},"end":{"line":142,"column":64}},"11":{"start":{"line":146,"column":12},"end":{"line":146,"column":63}},"12":{"start":{"line":148,"column":12},"end":{"line":171,"column":13}},"13":{"start":{"line":149,"column":16},"end":{"line":168,"column":17}},"14":{"start":{"line":150,"column":20},"end":{"line":150,"column":32}},"15":{"start":{"line":151,"column":20},"end":{"line":151,"column":41}},"16":{"start":{"line":153,"column":20},"end":{"line":153,"column":66}},"17":{"start":{"line":155,"column":20},"end":{"line":165,"column":21}},"18":{"start":{"line":156,"column":24},"end":{"line":156,"column":42}},"19":{"start":{"line":157,"column":24},"end":{"line":157,"column":72}},"20":{"start":{"line":160,"column":24},"end":{"line":162,"column":49}},"21":{"start":{"line":164,"column":24},"end":{"line":164,"column":69}},"22":{"start":{"line":167,"column":20},"end":{"line":167,"column":40}},"23":{"start":{"line":170,"column":16},"end":{"line":170,"column":37}},"24":{"start":{"line":173,"column":12},"end":{"line":173,"column":39}},"25":{"start":{"line":175,"column":12},"end":{"line":175,"column":28}},"26":{"start":{"line":179,"column":0},"end":{"line":179,"column":57}}},"branchMap":{"1":{"line":109,"type":"if","locations":[{"start":{"line":109,"column":12},"end":{"line":109,"column":12}},{"start":{"line":109,"column":12},"end":{"line":109,"column":12}}]},"2":{"line":109,"type":"binary-expr","locations":[{"start":{"line":109,"column":16},"end":{"line":109,"column":30}},{"start":{"line":109,"column":34},"end":{"line":109,"column":40}},{"start":{"line":109,"column":44},"end":{"line":109,"column":76}}]},"3":{"line":132,"type":"binary-expr","locations":[{"start":{"line":132,"column":30},"end":{"line":132,"column":61}},{"start":{"line":133,"column":32},"end":{"line":133,"column":53}}]},"4":{"line":134,"type":"binary-expr","locations":[{"start":{"line":134,"column":30},"end":{"line":134,"column":49}},{"start":{"line":134,"column":53},"end":{"line":134,"column":55}}]},"5":{"line":141,"type":"if","locations":[{"start":{"line":141,"column":12},"end":{"line":141,"column":12}},{"start":{"line":141,"column":12},"end":{"line":141,"column":12}}]},"6":{"line":148,"type":"if","locations":[{"start":{"line":148,"column":12},"end":{"line":148,"column":12}},{"start":{"line":148,"column":12},"end":{"line":148,"column":12}}]},"7":{"line":157,"type":"cond-expr","locations":[{"start":{"line":157,"column":54},"end":{"line":157,"column":63}},{"start":{"line":157,"column":66},"end":{"line":157,"column":71}}]},"8":{"line":160,"type":"cond-expr","locations":[{"start":{"line":161,"column":36},"end":{"line":161,"column":50}},{"start":{"line":162,"column":36},"end":{"line":162,"column":48}}]}},"code":["(function () { YUI.add('dataschema-text', function (Y, NAME) {","","/**"," * Provides a DataSchema implementation which can be used to work with"," * delimited text data."," *"," * @module dataschema"," * @submodule dataschema-text"," */","","/**","Provides a DataSchema implementation which can be used to work with","delimited text data.","","See the `apply` method for usage.","","@class DataSchema.Text","@extends DataSchema.Base","@static","**/","","var Lang = Y.Lang,","    isString = Lang.isString,","    isUndef  = Lang.isUndefined,","","    SchemaText = {","","        ////////////////////////////////////////////////////////////////////////","        //","        // DataSchema.Text static methods","        //","        ////////////////////////////////////////////////////////////////////////","        /**","        Applies a schema to a string of delimited data, returning a normalized","        object with results in the `results` property. The `meta` property of","        the response object is present for consistency, but is assigned an","        empty object.  If the input data is absent or not a string, an `error`","        property will be added.","","        Use _schema.resultDelimiter_ and _schema.fieldDelimiter_ to instruct","        `apply` how to split up the string into an array of data arrays for","        processing.","","        Use _schema.resultFields_ to specify the keys in the generated result","        objects in `response.results`. The key:value pairs will be assigned","        in the order of the _schema.resultFields_ array, assuming the values","        in the data records are defined in the same order.","","        _schema.resultFields_ field identifiers are objects with the following","        properties:","","          * `key`   : <strong>(required)</strong> The property name you want","                the data value assigned to in the result object (String)","          * `parser`: A function or the name of a function on `Y.Parsers` used","                to convert the input value into a normalized type.  Parser","                functions are passed the value as input and are expected to","                return a value.","","        If no value parsing is needed, you can use just the desired property","        name string as the field identifier instead of an object (see example","        below).","","        @example","            // Process simple csv","            var schema = {","                    resultDelimiter: \"\\n\",","                    fieldDelimiter: \",\",","                    resultFields: [ 'fruit', 'color' ]","                },","                data = \"Banana,yellow\\nOrange,orange\\nEggplant,purple\";","","            var response = Y.DataSchema.Text.apply(schema, data);","","            // response.results[0] is { fruit: \"Banana\", color: \"yellow\" }","","","            // Use parsers","            schema.resultFields = [","                {","                    key: 'fruit',","                    parser: function (val) { return val.toUpperCase(); }","                },","                'color' // mix and match objects and strings","            ];","","            response = Y.DataSchema.Text.apply(schema, data);","","            // response.results[0] is { fruit: \"BANANA\", color: \"yellow\" }","","        @method apply","        @param {Object} schema Schema to apply.  Supported configuration","            properties are:","          @param {String} schema.resultDelimiter Character or character","              sequence that marks the end of one record and the start of","              another.","          @param {String} [schema.fieldDelimiter] Character or character","              sequence that marks the end of a field and the start of","              another within the same record.","          @param {Array} [schema.resultFields] Field identifiers to","              assign values in the response records. See above for details.","        @param {String} data Text data.","        @return {Object} An Object with properties `results` and `meta`","        @static","        **/","        apply: function(schema, data) {","            var data_in = data,","                data_out = { results: [], meta: {} };","","            if (isString(data) && schema && isString(schema.resultDelimiter)) {","                // Parse results data","                data_out = SchemaText._parseResults.call(this, schema, data_in, data_out);","            } else {","                data_out.error = new Error(\"Text schema parse failure\");","            }","","            return data_out;","        },","","        /**","         * Schema-parsed list of results from full data","         *","         * @method _parseResults","         * @param schema {Array} Schema to parse against.","         * @param text_in {String} Text to parse.","         * @param data_out {Object} In-progress parsed data to update.","         * @return {Object} Parsed data object.","         * @static","         * @protected","         */","        _parseResults: function(schema, text_in, data_out) {","            var resultDelim = schema.resultDelimiter,","                fieldDelim  = isString(schema.fieldDelimiter) &&","                                schema.fieldDelimiter,","                fields      = schema.resultFields || [],","                results     = [],","                parse       = Y.DataSchema.Base.parse,","                results_in, fields_in, result, item,","                field, key, value, i, j;","","            // Delete final delimiter at end of string if there","            if (text_in.slice(-resultDelim.length) === resultDelim) {","                text_in = text_in.slice(0, -resultDelim.length);","            }","","            // Split into results","            results_in = text_in.split(schema.resultDelimiter);","","            if (fieldDelim) {","                for (i = results_in.length - 1; i >= 0; --i) {","                    result = {};","                    item = results_in[i];","","                    fields_in = item.split(schema.fieldDelimiter);","","                    for (j = fields.length - 1; j >= 0; --j) {","                        field = fields[j];","                        key = (!isUndef(field.key)) ? field.key : field;","                        // FIXME: unless the key is an array index, this test","                        // for fields_in[key] is useless.","                        value = (!isUndef(fields_in[key])) ?","                                    fields_in[key] :","                                    fields_in[j];","","                        result[key] = parse.call(this, value, field);","                    }","","                    results[i] = result;","                }","            } else {","                results = results_in;","            }","","            data_out.results = results;","","            return data_out;","        }","    };","","Y.DataSchema.Text = Y.mix(SchemaText, Y.DataSchema.Base);","","","}, 'patched-v3.20.2', {\"requires\": [\"dataschema-base\"]});","","}());"]};
}
var __cov_t9Zl0HGBv1_SMaP7xxdYRQ = __coverage__['build/dataschema-text/dataschema-text.js'];
__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['1']++;YUI.add('dataschema-text',function(Y,NAME){__cov_t9Zl0HGBv1_SMaP7xxdYRQ.f['1']++;__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['2']++;var Lang=Y.Lang,isString=Lang.isString,isUndef=Lang.isUndefined,SchemaText={apply:function(schema,data){__cov_t9Zl0HGBv1_SMaP7xxdYRQ.f['2']++;__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['3']++;var data_in=data,data_out={results:[],meta:{}};__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['4']++;if((__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['2'][0]++,isString(data))&&(__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['2'][1]++,schema)&&(__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['2'][2]++,isString(schema.resultDelimiter))){__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['1'][0]++;__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['5']++;data_out=SchemaText._parseResults.call(this,schema,data_in,data_out);}else{__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['1'][1]++;__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['6']++;data_out.error=new Error('Text schema parse failure');}__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['7']++;return data_out;},_parseResults:function(schema,text_in,data_out){__cov_t9Zl0HGBv1_SMaP7xxdYRQ.f['3']++;__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['8']++;var resultDelim=schema.resultDelimiter,fieldDelim=(__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['3'][0]++,isString(schema.fieldDelimiter))&&(__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['3'][1]++,schema.fieldDelimiter),fields=(__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['4'][0]++,schema.resultFields)||(__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['4'][1]++,[]),results=[],parse=Y.DataSchema.Base.parse,results_in,fields_in,result,item,field,key,value,i,j;__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['9']++;if(text_in.slice(-resultDelim.length)===resultDelim){__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['5'][0]++;__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['10']++;text_in=text_in.slice(0,-resultDelim.length);}else{__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['5'][1]++;}__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['11']++;results_in=text_in.split(schema.resultDelimiter);__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['12']++;if(fieldDelim){__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['6'][0]++;__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['13']++;for(i=results_in.length-1;i>=0;--i){__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['14']++;result={};__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['15']++;item=results_in[i];__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['16']++;fields_in=item.split(schema.fieldDelimiter);__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['17']++;for(j=fields.length-1;j>=0;--j){__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['18']++;field=fields[j];__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['19']++;key=!isUndef(field.key)?(__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['7'][0]++,field.key):(__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['7'][1]++,field);__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['20']++;value=!isUndef(fields_in[key])?(__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['8'][0]++,fields_in[key]):(__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['8'][1]++,fields_in[j]);__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['21']++;result[key]=parse.call(this,value,field);}__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['22']++;results[i]=result;}}else{__cov_t9Zl0HGBv1_SMaP7xxdYRQ.b['6'][1]++;__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['23']++;results=results_in;}__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['24']++;data_out.results=results;__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['25']++;return data_out;}};__cov_t9Zl0HGBv1_SMaP7xxdYRQ.s['26']++;Y.DataSchema.Text=Y.mix(SchemaText,Y.DataSchema.Base);},'patched-v3.20.2',{'requires':['dataschema-base']});
