if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/button-core/button-core.js']) {
   __coverage__['build/button-core/button-core.js'] = {"path":"build/button-core/button-core.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0,"50":0,"51":0,"52":0,"53":0,"54":0,"55":0,"56":0,"57":0,"58":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":23},"end":{"line":1,"column":42}}},"2":{"name":"ButtonCore","line":20,"loc":{"start":{"line":20,"column":0},"end":{"line":20,"column":28}}},"3":{"name":"(anonymous_3)","line":49,"loc":{"start":{"line":49,"column":17},"end":{"line":49,"column":34}}},"4":{"name":"(anonymous_4)","line":61,"loc":{"start":{"line":61,"column":15},"end":{"line":61,"column":32}}},"5":{"name":"(anonymous_5)","line":75,"loc":{"start":{"line":75,"column":21},"end":{"line":75,"column":38}}},"6":{"name":"(anonymous_6)","line":85,"loc":{"start":{"line":85,"column":15},"end":{"line":85,"column":26}}},"7":{"name":"(anonymous_7)","line":102,"loc":{"start":{"line":102,"column":12},"end":{"line":102,"column":23}}},"8":{"name":"(anonymous_8)","line":111,"loc":{"start":{"line":111,"column":13},"end":{"line":111,"column":24}}},"9":{"name":"(anonymous_9)","line":121,"loc":{"start":{"line":121,"column":13},"end":{"line":121,"column":24}}},"10":{"name":"(anonymous_10)","line":138,"loc":{"start":{"line":138,"column":15},"end":{"line":138,"column":27}}},"11":{"name":"(anonymous_11)","line":151,"loc":{"start":{"line":151,"column":19},"end":{"line":151,"column":31}}},"12":{"name":"(anonymous_12)","line":169,"loc":{"start":{"line":169,"column":15},"end":{"line":169,"column":44}}},"13":{"name":"(anonymous_13)","line":190,"loc":{"start":{"line":190,"column":19},"end":{"line":190,"column":48}}},"14":{"name":"(anonymous_14)","line":215,"loc":{"start":{"line":215,"column":18},"end":{"line":215,"column":34}}},"15":{"name":"(anonymous_15)","line":343,"loc":{"start":{"line":343,"column":37},"end":{"line":343,"column":53}}},"16":{"name":"(anonymous_16)","line":358,"loc":{"start":{"line":358,"column":35},"end":{"line":358,"column":51}}},"17":{"name":"(anonymous_17)","line":375,"loc":{"start":{"line":375,"column":30},"end":{"line":375,"column":46}}},"18":{"name":"(anonymous_18)","line":391,"loc":{"start":{"line":391,"column":34},"end":{"line":391,"column":50}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":399,"column":93}},"2":{"start":{"line":9,"column":0},"end":{"line":10,"column":36}},"3":{"start":{"line":20,"column":0},"end":{"line":22,"column":1}},"4":{"start":{"line":21,"column":4},"end":{"line":21,"column":29}},"5":{"start":{"line":24,"column":0},"end":{"line":223,"column":2}},"6":{"start":{"line":50,"column":8},"end":{"line":50,"column":31}},"7":{"start":{"line":51,"column":8},"end":{"line":51,"column":37}},"8":{"start":{"line":52,"column":8},"end":{"line":52,"column":31}},"9":{"start":{"line":62,"column":8},"end":{"line":66,"column":9}},"10":{"start":{"line":63,"column":12},"end":{"line":63,"column":44}},"11":{"start":{"line":65,"column":12},"end":{"line":65,"column":54}},"12":{"start":{"line":76,"column":8},"end":{"line":76,"column":59}},"13":{"start":{"line":86,"column":8},"end":{"line":87,"column":58}},"14":{"start":{"line":90,"column":8},"end":{"line":90,"column":53}},"15":{"start":{"line":92,"column":8},"end":{"line":94,"column":9}},"16":{"start":{"line":93,"column":12},"end":{"line":93,"column":39}},"17":{"start":{"line":103,"column":8},"end":{"line":103,"column":36}},"18":{"start":{"line":112,"column":8},"end":{"line":112,"column":35}},"19":{"start":{"line":122,"column":8},"end":{"line":127,"column":9}},"20":{"start":{"line":126,"column":12},"end":{"line":126,"column":49}},"21":{"start":{"line":129,"column":8},"end":{"line":129,"column":26}},"22":{"start":{"line":139,"column":8},"end":{"line":140,"column":59}},"23":{"start":{"line":142,"column":8},"end":{"line":142,"column":21}},"24":{"start":{"line":152,"column":8},"end":{"line":153,"column":58}},"25":{"start":{"line":155,"column":8},"end":{"line":155,"column":25}},"26":{"start":{"line":170,"column":8},"end":{"line":170,"column":41}},"27":{"start":{"line":172,"column":8},"end":{"line":174,"column":9}},"28":{"start":{"line":173,"column":12},"end":{"line":173,"column":60}},"29":{"start":{"line":176,"column":8},"end":{"line":176,"column":21}},"30":{"start":{"line":191,"column":8},"end":{"line":193,"column":58}},"31":{"start":{"line":195,"column":8},"end":{"line":200,"column":9}},"32":{"start":{"line":196,"column":12},"end":{"line":196,"column":42}},"33":{"start":{"line":199,"column":12},"end":{"line":199,"column":37}},"34":{"start":{"line":202,"column":8},"end":{"line":204,"column":9}},"35":{"start":{"line":203,"column":12},"end":{"line":203,"column":56}},"36":{"start":{"line":206,"column":8},"end":{"line":206,"column":21}},"37":{"start":{"line":216,"column":8},"end":{"line":216,"column":34}},"38":{"start":{"line":218,"column":8},"end":{"line":218,"column":43}},"39":{"start":{"line":219,"column":8},"end":{"line":219,"column":65}},"40":{"start":{"line":221,"column":8},"end":{"line":221,"column":21}},"41":{"start":{"line":226,"column":0},"end":{"line":226,"column":53}},"42":{"start":{"line":236,"column":0},"end":{"line":281,"column":2}},"43":{"start":{"line":290,"column":0},"end":{"line":290,"column":27}},"44":{"start":{"line":300,"column":0},"end":{"line":305,"column":2}},"45":{"start":{"line":315,"column":0},"end":{"line":318,"column":2}},"46":{"start":{"line":328,"column":0},"end":{"line":332,"column":2}},"47":{"start":{"line":343,"column":0},"end":{"line":347,"column":2}},"48":{"start":{"line":344,"column":4},"end":{"line":344,"column":75}},"49":{"start":{"line":346,"column":4},"end":{"line":346,"column":21}},"50":{"start":{"line":358,"column":0},"end":{"line":364,"column":2}},"51":{"start":{"line":359,"column":4},"end":{"line":361,"column":71}},"52":{"start":{"line":363,"column":4},"end":{"line":363,"column":17}},"53":{"start":{"line":375,"column":0},"end":{"line":380,"column":2}},"54":{"start":{"line":376,"column":4},"end":{"line":377,"column":36}},"55":{"start":{"line":379,"column":4},"end":{"line":379,"column":17}},"56":{"start":{"line":391,"column":0},"end":{"line":393,"column":2}},"57":{"start":{"line":392,"column":4},"end":{"line":392,"column":32}},"58":{"start":{"line":396,"column":0},"end":{"line":396,"column":26}}},"branchMap":{"1":{"line":62,"type":"if","locations":[{"start":{"line":62,"column":8},"end":{"line":62,"column":8}},{"start":{"line":62,"column":8},"end":{"line":62,"column":8}}]},"2":{"line":92,"type":"if","locations":[{"start":{"line":92,"column":8},"end":{"line":92,"column":8}},{"start":{"line":92,"column":8},"end":{"line":92,"column":8}}]},"3":{"line":92,"type":"binary-expr","locations":[{"start":{"line":92,"column":12},"end":{"line":92,"column":33}},{"start":{"line":92,"column":37},"end":{"line":92,"column":57}}]},"4":{"line":122,"type":"if","locations":[{"start":{"line":122,"column":8},"end":{"line":122,"column":8}},{"start":{"line":122,"column":8},"end":{"line":122,"column":8}}]},"5":{"line":172,"type":"if","locations":[{"start":{"line":172,"column":8},"end":{"line":172,"column":8}},{"start":{"line":172,"column":8},"end":{"line":172,"column":8}}]},"6":{"line":172,"type":"binary-expr","locations":[{"start":{"line":172,"column":12},"end":{"line":172,"column":17}},{"start":{"line":172,"column":21},"end":{"line":172,"column":44}}]},"7":{"line":195,"type":"if","locations":[{"start":{"line":195,"column":8},"end":{"line":195,"column":8}},{"start":{"line":195,"column":8},"end":{"line":195,"column":8}}]},"8":{"line":202,"type":"if","locations":[{"start":{"line":202,"column":8},"end":{"line":202,"column":8}},{"start":{"line":202,"column":8},"end":{"line":202,"column":8}}]},"9":{"line":202,"type":"binary-expr","locations":[{"start":{"line":202,"column":12},"end":{"line":202,"column":17}},{"start":{"line":202,"column":21},"end":{"line":202,"column":44}}]},"10":{"line":344,"type":"binary-expr","locations":[{"start":{"line":344,"column":21},"end":{"line":344,"column":65}},{"start":{"line":344,"column":69},"end":{"line":344,"column":73}}]},"11":{"line":361,"type":"cond-expr","locations":[{"start":{"line":361,"column":53},"end":{"line":361,"column":60}},{"start":{"line":361,"column":63},"end":{"line":361,"column":69}}]}},"code":["(function () { YUI.add('button-core', function (Y, NAME) {","","/**"," * Provides an interface for working with button-like DOM nodes"," *"," * @module button-core"," * @since 3.5.0"," */","var getClassName = Y.ClassNameManager.getClassName,","    AttributeCore = Y.AttributeCore;","","/**"," * Creates a button"," *"," * @class ButtonCore"," * @uses AttributeCore"," * @param config {Object} Configuration object"," * @constructor"," */","function ButtonCore(config) {","    this.initializer(config);","}","","ButtonCore.prototype = {","","    /**","     *","     * @property TEMPLATE","     * @type {String}","     * @default <button/>","     */","    TEMPLATE: '<button/>',","","    /**","     *","     * @property constructor","     * @type {Object}","     * @default ButtonCore","     * @private","     */","    constructor: ButtonCore,","","    /**","     * @method initializer","     * @description Internal init() handler.","     * @param config {Object} Config object.","     * @private","     */","    initializer: function(config) {","        this._initNode(config);","        this._initAttributes(config);","        this._renderUI(config);","    },","","    /**","     * @method _initNode","     * @description Node initializer","     * @param config {Object} Config object.","     * @private","     */","    _initNode: function(config) {","        if (config.host) {","            this._host = Y.one(config.host);","        } else {","            this._host = Y.Node.create(this.TEMPLATE);","        }","    },","","    /**","     * @method _initAttributes","     * @description  Attribute initializer","     * @param config {Object} Config object.","     * @private","     */","    _initAttributes: function(config) {","        AttributeCore.call(this, ButtonCore.ATTRS, config);","    },","","    /**","     * @method renderUI","     * @description Renders any UI/DOM elements for Button instances","     * @param config {Object} Config object.","     * @private","     */","    _renderUI: function() {","        var node = this.getNode(),","            nodeName = node.get('nodeName').toLowerCase();","","        // Set some default node attributes","        node.addClass(ButtonCore.CLASS_NAMES.BUTTON);","","        if (nodeName !== 'button' && nodeName !== 'input') {","            node.set('role', 'button');","        }","    },","","    /**","     * @method enable","     * @description Sets the button's `disabled` DOM attribute to `false`","     * @public","     */","    enable: function() {","        this.set('disabled', false);","    },","","    /**","     * @method disable","     * @description Sets the button's `disabled` DOM attribute to `true`","     * @public","     */","    disable: function() {","        this.set('disabled', true);","    },","","    /**","     * @method getNode","     * @description Gets the button's host node","     * @return {Node} The host node instance","     * @public","     */","    getNode: function() {","        if (!this._host) {","            // If this._host doesn't exist, that means this._initNode","            // was never executed, meaning this is likely a Widget and","            // the host node should point to the boundingBox.","            this._host = this.get('boundingBox');","        }","","        return this._host;","    },","","    /**","     * @method _getLabel","     * @description Getter for a button's `label` ATTR","     * @return {String} The text label of the button","     * @private","     */","    _getLabel: function () {","        var node = this.getNode(),","            label = ButtonCore._getTextLabelFromNode(node);","","        return label;","    },","","    /**","     * @method _getLabelHTML","     * @description Getter for a button's `labelHTML` ATTR","     * @return {String} The HTML label of the button","     * @private","     */","    _getLabelHTML: function () {","        var node = this.getNode(),","            labelHTML = ButtonCore._getHTMLFromNode(node);","","        return labelHTML;","    },","","    /**","     * @method _setLabel","     * @description Setter for a button's `label` ATTR","     * @param value {String} The value to set for `label`","     * @param name {String} The name of this ATTR (`label`)","     * @param opts {Object} Additional options","     *    @param opts.src {String} A string identifying the callee.","     *        `internal` will not sync this value with the `labelHTML` ATTR","     * @return {String} The text label for the given node","     * @private","     */","    _setLabel: function (value, name, opts) {","        var label = Y.Escape.html(value);","","        if (!opts || opts.src !== 'internal') {","            this.set('labelHTML', label, {src: 'internal'});","        }","","        return label;","    },","","    /**","     * @method _setLabelHTML","     * @description Setter for a button's `labelHTML` ATTR","     * @param value {String} The value to set for `labelHTML`","     * @param name {String} The name of this ATTR (`labelHTML`)","     * @param opts {Object} Additional options","     *    @param opts.src {String} A string identifying the callee.","     *        `internal` will not sync this value with the `label` ATTR","     * @return {String} The HTML label for the given node","     * @private","     */","    _setLabelHTML: function (value, name, opts) {","        var node = this.getNode(),","            labelNode = ButtonCore._getLabelNodeFromParent(node),","            nodeName = node.get('nodeName').toLowerCase();","","        if (nodeName === 'input') {","            labelNode.set('value', value);","        }","        else {","            labelNode.setHTML(value);","        }","","        if (!opts || opts.src !== 'internal') {","            this.set('label', value, {src: 'internal'});","        }","","        return value;","    },","","    /**","     * @method _setDisabled","     * @description Setter for the `disabled` ATTR","     * @param value {boolean}","     * @private","     */","    _setDisabled: function(value) {","        var node = this.getNode();","","        node.getDOMNode().disabled = value; // avoid rerunning setter when this === node","        node.toggleClass(ButtonCore.CLASS_NAMES.DISABLED, value);","","        return value;","    }","};","","// ButtonCore inherits from AttributeCore","Y.mix(ButtonCore.prototype, AttributeCore.prototype);","","/**"," * Attribute configuration."," *"," * @property ATTRS"," * @type {Object}"," * @protected"," * @static"," */","ButtonCore.ATTRS = {","","    /**","     * The text of the button's label","     *","     * @config label","     * @type String","     */","    label: {","        setter: '_setLabel',","        getter: '_getLabel',","        lazyAdd: false","    },","","    /**","     * The HTML of the button's label","     *","     * This attribute accepts HTML and inserts it into the DOM **without**","     * sanitization.  This attribute should only be used with HTML that has","     * either been escaped (using `Y.Escape.html`), or sanitized according to","     * the requirements of your application.","     *","     * If all you need is support for text labels, please use the `label`","     * attribute instead.","     *","     * @config labelHTML","     * @type HTML","     */","    labelHTML: {","        setter: '_setLabelHTML',","        getter: '_getLabelHTML',","        lazyAdd: false","    },","","    /**","     * The button's enabled/disabled state","     *","     * @config disabled","     * @type Boolean","     */","    disabled: {","        value: false,","        setter: '_setDisabled',","        lazyAdd: false","    }","};","","/**"," * Name of this component."," *"," * @property NAME"," * @type String"," * @static"," */","ButtonCore.NAME = \"button\";","","/**"," * Array of static constants used to identify the classnames applied to DOM nodes"," *"," * @property CLASS_NAMES"," * @type {Object}"," * @public"," * @static"," */","ButtonCore.CLASS_NAMES = {","    BUTTON  : getClassName('button'),","    DISABLED: getClassName('button', 'disabled'),","    SELECTED: getClassName('button', 'selected'),","    LABEL   : getClassName('button', 'label')","};","","/**"," * Array of static constants used to for applying ARIA states"," *"," * @property ARIA_STATES"," * @type {Object}"," * @private"," * @static"," */","ButtonCore.ARIA_STATES = {","    PRESSED : 'aria-pressed',","    CHECKED : 'aria-checked'","};","","/**"," * Array of static constants used to for applying ARIA roles"," *"," * @property ARIA_ROLES"," * @type {Object}"," * @private"," * @static"," */","ButtonCore.ARIA_ROLES = {","    BUTTON  : 'button',","    CHECKBOX: 'checkbox',","    TOGGLE  : 'toggle'","};","","/**"," * Finds the label node within a button"," *"," * @method _getLabelNodeFromParent"," * @param node {Node} The parent node"," * @return {Node} The label node"," * @private"," * @static"," */","ButtonCore._getLabelNodeFromParent = function (node) {","    var labelNode = (node.one('.' + ButtonCore.CLASS_NAMES.LABEL) || node);","","    return labelNode;","};","","/**"," * Gets a text label from a node"," *"," * @method _getTextLabelFromNode"," * @param node {Node} The parent node"," * @return {String} The text label for a given node"," * @private"," * @static"," */","ButtonCore._getTextLabelFromNode = function (node) {","    var labelNode = ButtonCore._getLabelNodeFromParent(node),","        nodeName = labelNode.get('nodeName').toLowerCase(),","        label = labelNode.get(nodeName === 'input' ? 'value' : 'text');","","    return label;","};","","/**"," * A utility method that gets an HTML label from a given node"," *"," * @method _getHTMLFromNode"," * @param node {Node} The parent node"," * @return {String} The HTML label for a given node"," * @private"," * @static"," */","ButtonCore._getHTMLFromNode = function (node) {","    var labelNode = ButtonCore._getLabelNodeFromParent(node),","        label = labelNode.getHTML();","","    return label;","};","","/**"," * Gets the disabled attribute from a node"," *"," * @method _getDisabledFromNode"," * @param node {Node} The parent node"," * @return {boolean} The disabled state for a given node"," * @private"," * @static"," */","ButtonCore._getDisabledFromNode = function (node) {","    return node.get('disabled');","};","","// Export ButtonCore","Y.ButtonCore = ButtonCore;","","","}, 'patched-v3.20.2', {\"requires\": [\"attribute-core\", \"classnamemanager\", \"node-base\", \"escape\"]});","","}());"]};
}
var __cov_oaiXFrFXvCNKuifOTFqz5A = __coverage__['build/button-core/button-core.js'];
__cov_oaiXFrFXvCNKuifOTFqz5A.s['1']++;YUI.add('button-core',function(Y,NAME){__cov_oaiXFrFXvCNKuifOTFqz5A.f['1']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['2']++;var getClassName=Y.ClassNameManager.getClassName,AttributeCore=Y.AttributeCore;__cov_oaiXFrFXvCNKuifOTFqz5A.s['3']++;function ButtonCore(config){__cov_oaiXFrFXvCNKuifOTFqz5A.f['2']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['4']++;this.initializer(config);}__cov_oaiXFrFXvCNKuifOTFqz5A.s['5']++;ButtonCore.prototype={TEMPLATE:'<button/>',constructor:ButtonCore,initializer:function(config){__cov_oaiXFrFXvCNKuifOTFqz5A.f['3']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['6']++;this._initNode(config);__cov_oaiXFrFXvCNKuifOTFqz5A.s['7']++;this._initAttributes(config);__cov_oaiXFrFXvCNKuifOTFqz5A.s['8']++;this._renderUI(config);},_initNode:function(config){__cov_oaiXFrFXvCNKuifOTFqz5A.f['4']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['9']++;if(config.host){__cov_oaiXFrFXvCNKuifOTFqz5A.b['1'][0]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['10']++;this._host=Y.one(config.host);}else{__cov_oaiXFrFXvCNKuifOTFqz5A.b['1'][1]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['11']++;this._host=Y.Node.create(this.TEMPLATE);}},_initAttributes:function(config){__cov_oaiXFrFXvCNKuifOTFqz5A.f['5']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['12']++;AttributeCore.call(this,ButtonCore.ATTRS,config);},_renderUI:function(){__cov_oaiXFrFXvCNKuifOTFqz5A.f['6']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['13']++;var node=this.getNode(),nodeName=node.get('nodeName').toLowerCase();__cov_oaiXFrFXvCNKuifOTFqz5A.s['14']++;node.addClass(ButtonCore.CLASS_NAMES.BUTTON);__cov_oaiXFrFXvCNKuifOTFqz5A.s['15']++;if((__cov_oaiXFrFXvCNKuifOTFqz5A.b['3'][0]++,nodeName!=='button')&&(__cov_oaiXFrFXvCNKuifOTFqz5A.b['3'][1]++,nodeName!=='input')){__cov_oaiXFrFXvCNKuifOTFqz5A.b['2'][0]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['16']++;node.set('role','button');}else{__cov_oaiXFrFXvCNKuifOTFqz5A.b['2'][1]++;}},enable:function(){__cov_oaiXFrFXvCNKuifOTFqz5A.f['7']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['17']++;this.set('disabled',false);},disable:function(){__cov_oaiXFrFXvCNKuifOTFqz5A.f['8']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['18']++;this.set('disabled',true);},getNode:function(){__cov_oaiXFrFXvCNKuifOTFqz5A.f['9']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['19']++;if(!this._host){__cov_oaiXFrFXvCNKuifOTFqz5A.b['4'][0]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['20']++;this._host=this.get('boundingBox');}else{__cov_oaiXFrFXvCNKuifOTFqz5A.b['4'][1]++;}__cov_oaiXFrFXvCNKuifOTFqz5A.s['21']++;return this._host;},_getLabel:function(){__cov_oaiXFrFXvCNKuifOTFqz5A.f['10']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['22']++;var node=this.getNode(),label=ButtonCore._getTextLabelFromNode(node);__cov_oaiXFrFXvCNKuifOTFqz5A.s['23']++;return label;},_getLabelHTML:function(){__cov_oaiXFrFXvCNKuifOTFqz5A.f['11']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['24']++;var node=this.getNode(),labelHTML=ButtonCore._getHTMLFromNode(node);__cov_oaiXFrFXvCNKuifOTFqz5A.s['25']++;return labelHTML;},_setLabel:function(value,name,opts){__cov_oaiXFrFXvCNKuifOTFqz5A.f['12']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['26']++;var label=Y.Escape.html(value);__cov_oaiXFrFXvCNKuifOTFqz5A.s['27']++;if((__cov_oaiXFrFXvCNKuifOTFqz5A.b['6'][0]++,!opts)||(__cov_oaiXFrFXvCNKuifOTFqz5A.b['6'][1]++,opts.src!=='internal')){__cov_oaiXFrFXvCNKuifOTFqz5A.b['5'][0]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['28']++;this.set('labelHTML',label,{src:'internal'});}else{__cov_oaiXFrFXvCNKuifOTFqz5A.b['5'][1]++;}__cov_oaiXFrFXvCNKuifOTFqz5A.s['29']++;return label;},_setLabelHTML:function(value,name,opts){__cov_oaiXFrFXvCNKuifOTFqz5A.f['13']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['30']++;var node=this.getNode(),labelNode=ButtonCore._getLabelNodeFromParent(node),nodeName=node.get('nodeName').toLowerCase();__cov_oaiXFrFXvCNKuifOTFqz5A.s['31']++;if(nodeName==='input'){__cov_oaiXFrFXvCNKuifOTFqz5A.b['7'][0]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['32']++;labelNode.set('value',value);}else{__cov_oaiXFrFXvCNKuifOTFqz5A.b['7'][1]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['33']++;labelNode.setHTML(value);}__cov_oaiXFrFXvCNKuifOTFqz5A.s['34']++;if((__cov_oaiXFrFXvCNKuifOTFqz5A.b['9'][0]++,!opts)||(__cov_oaiXFrFXvCNKuifOTFqz5A.b['9'][1]++,opts.src!=='internal')){__cov_oaiXFrFXvCNKuifOTFqz5A.b['8'][0]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['35']++;this.set('label',value,{src:'internal'});}else{__cov_oaiXFrFXvCNKuifOTFqz5A.b['8'][1]++;}__cov_oaiXFrFXvCNKuifOTFqz5A.s['36']++;return value;},_setDisabled:function(value){__cov_oaiXFrFXvCNKuifOTFqz5A.f['14']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['37']++;var node=this.getNode();__cov_oaiXFrFXvCNKuifOTFqz5A.s['38']++;node.getDOMNode().disabled=value;__cov_oaiXFrFXvCNKuifOTFqz5A.s['39']++;node.toggleClass(ButtonCore.CLASS_NAMES.DISABLED,value);__cov_oaiXFrFXvCNKuifOTFqz5A.s['40']++;return value;}};__cov_oaiXFrFXvCNKuifOTFqz5A.s['41']++;Y.mix(ButtonCore.prototype,AttributeCore.prototype);__cov_oaiXFrFXvCNKuifOTFqz5A.s['42']++;ButtonCore.ATTRS={label:{setter:'_setLabel',getter:'_getLabel',lazyAdd:false},labelHTML:{setter:'_setLabelHTML',getter:'_getLabelHTML',lazyAdd:false},disabled:{value:false,setter:'_setDisabled',lazyAdd:false}};__cov_oaiXFrFXvCNKuifOTFqz5A.s['43']++;ButtonCore.NAME='button';__cov_oaiXFrFXvCNKuifOTFqz5A.s['44']++;ButtonCore.CLASS_NAMES={BUTTON:getClassName('button'),DISABLED:getClassName('button','disabled'),SELECTED:getClassName('button','selected'),LABEL:getClassName('button','label')};__cov_oaiXFrFXvCNKuifOTFqz5A.s['45']++;ButtonCore.ARIA_STATES={PRESSED:'aria-pressed',CHECKED:'aria-checked'};__cov_oaiXFrFXvCNKuifOTFqz5A.s['46']++;ButtonCore.ARIA_ROLES={BUTTON:'button',CHECKBOX:'checkbox',TOGGLE:'toggle'};__cov_oaiXFrFXvCNKuifOTFqz5A.s['47']++;ButtonCore._getLabelNodeFromParent=function(node){__cov_oaiXFrFXvCNKuifOTFqz5A.f['15']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['48']++;var labelNode=(__cov_oaiXFrFXvCNKuifOTFqz5A.b['10'][0]++,node.one('.'+ButtonCore.CLASS_NAMES.LABEL))||(__cov_oaiXFrFXvCNKuifOTFqz5A.b['10'][1]++,node);__cov_oaiXFrFXvCNKuifOTFqz5A.s['49']++;return labelNode;};__cov_oaiXFrFXvCNKuifOTFqz5A.s['50']++;ButtonCore._getTextLabelFromNode=function(node){__cov_oaiXFrFXvCNKuifOTFqz5A.f['16']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['51']++;var labelNode=ButtonCore._getLabelNodeFromParent(node),nodeName=labelNode.get('nodeName').toLowerCase(),label=labelNode.get(nodeName==='input'?(__cov_oaiXFrFXvCNKuifOTFqz5A.b['11'][0]++,'value'):(__cov_oaiXFrFXvCNKuifOTFqz5A.b['11'][1]++,'text'));__cov_oaiXFrFXvCNKuifOTFqz5A.s['52']++;return label;};__cov_oaiXFrFXvCNKuifOTFqz5A.s['53']++;ButtonCore._getHTMLFromNode=function(node){__cov_oaiXFrFXvCNKuifOTFqz5A.f['17']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['54']++;var labelNode=ButtonCore._getLabelNodeFromParent(node),label=labelNode.getHTML();__cov_oaiXFrFXvCNKuifOTFqz5A.s['55']++;return label;};__cov_oaiXFrFXvCNKuifOTFqz5A.s['56']++;ButtonCore._getDisabledFromNode=function(node){__cov_oaiXFrFXvCNKuifOTFqz5A.f['18']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['57']++;return node.get('disabled');};__cov_oaiXFrFXvCNKuifOTFqz5A.s['58']++;Y.ButtonCore=ButtonCore;},'patched-v3.20.2',{'requires':['attribute-core','classnamemanager','node-base','escape']});
