if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/event-mouseenter/event-mouseenter.js']) {
   __coverage__['build/event-mouseenter/event-mouseenter.js'] = {"path":"build/event-mouseenter/event-mouseenter.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":28},"end":{"line":1,"column":47}}},"2":{"name":"(anonymous_2)","line":32,"loc":{"start":{"line":32,"column":11},"end":{"line":32,"column":23}}},"3":{"name":"(anonymous_3)","line":38,"loc":{"start":{"line":38,"column":17},"end":{"line":38,"column":50}}},"4":{"name":"(anonymous_4)","line":48,"loc":{"start":{"line":48,"column":12},"end":{"line":48,"column":43}}},"5":{"name":"(anonymous_5)","line":62,"loc":{"start":{"line":62,"column":16},"end":{"line":62,"column":37}}},"6":{"name":"(anonymous_6)","line":66,"loc":{"start":{"line":66,"column":18},"end":{"line":66,"column":57}}},"7":{"name":"(anonymous_7)","line":82,"loc":{"start":{"line":82,"column":23},"end":{"line":82,"column":52}}},"8":{"name":"(anonymous_8)","line":117,"loc":{"start":{"line":117,"column":24},"end":{"line":117,"column":45}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":129,"column":51}},"2":{"start":{"line":29,"column":0},"end":{"line":120,"column":6}},"3":{"start":{"line":39,"column":12},"end":{"line":40,"column":57}},"4":{"start":{"line":42,"column":12},"end":{"line":45,"column":13}},"5":{"start":{"line":43,"column":16},"end":{"line":44,"column":71}},"6":{"start":{"line":49,"column":12},"end":{"line":56,"column":30}},"7":{"start":{"line":58,"column":12},"end":{"line":58,"column":66}},"8":{"start":{"line":63,"column":12},"end":{"line":63,"column":32}},"9":{"start":{"line":67,"column":12},"end":{"line":74,"column":18}},"10":{"start":{"line":76,"column":12},"end":{"line":76,"column":66}},"11":{"start":{"line":77,"column":12},"end":{"line":77,"column":43}},"12":{"start":{"line":78,"column":12},"end":{"line":78,"column":58}},"13":{"start":{"line":79,"column":12},"end":{"line":79,"column":56}},"14":{"start":{"line":83,"column":12},"end":{"line":83,"column":32}},"15":{"start":{"line":84,"column":12},"end":{"line":86,"column":13}},"16":{"start":{"line":85,"column":16},"end":{"line":85,"column":49}},"17":{"start":{"line":88,"column":12},"end":{"line":90,"column":35}},"18":{"start":{"line":92,"column":12},"end":{"line":112,"column":13}},"19":{"start":{"line":93,"column":16},"end":{"line":93,"column":55}},"20":{"start":{"line":95,"column":16},"end":{"line":111,"column":17}},"21":{"start":{"line":96,"column":20},"end":{"line":96,"column":42}},"22":{"start":{"line":97,"column":20},"end":{"line":110,"column":21}},"23":{"start":{"line":98,"column":24},"end":{"line":101,"column":25}},"24":{"start":{"line":99,"column":28},"end":{"line":99,"column":70}},"25":{"start":{"line":100,"column":28},"end":{"line":100,"column":55}},"26":{"start":{"line":102,"column":24},"end":{"line":102,"column":52}},"27":{"start":{"line":105,"column":24},"end":{"line":105,"column":46}},"28":{"start":{"line":107,"column":24},"end":{"line":109,"column":25}},"29":{"start":{"line":108,"column":28},"end":{"line":108,"column":34}},"30":{"start":{"line":114,"column":12},"end":{"line":114,"column":23}},"31":{"start":{"line":118,"column":12},"end":{"line":118,"column":32}},"32":{"start":{"line":122,"column":0},"end":{"line":122,"column":43}},"33":{"start":{"line":123,"column":0},"end":{"line":126,"column":10}}},"branchMap":{"1":{"line":40,"type":"binary-expr","locations":[{"start":{"line":40,"column":26},"end":{"line":40,"column":41}},{"start":{"line":40,"column":45},"end":{"line":40,"column":56}}]},"2":{"line":42,"type":"if","locations":[{"start":{"line":42,"column":12},"end":{"line":42,"column":12}},{"start":{"line":42,"column":12},"end":{"line":42,"column":12}}]},"3":{"line":42,"type":"binary-expr","locations":[{"start":{"line":42,"column":16},"end":{"line":42,"column":30}},{"start":{"line":42,"column":34},"end":{"line":42,"column":56}}]},"4":{"line":84,"type":"if","locations":[{"start":{"line":84,"column":12},"end":{"line":84,"column":12}},{"start":{"line":84,"column":12},"end":{"line":84,"column":12}}]},"5":{"line":89,"type":"binary-expr","locations":[{"start":{"line":89,"column":26},"end":{"line":89,"column":47}},{"start":{"line":89,"column":51},"end":{"line":89,"column":76}}]},"6":{"line":92,"type":"if","locations":[{"start":{"line":92,"column":12},"end":{"line":92,"column":12}},{"start":{"line":92,"column":12},"end":{"line":92,"column":12}}]},"7":{"line":97,"type":"if","locations":[{"start":{"line":97,"column":20},"end":{"line":97,"column":20}},{"start":{"line":97,"column":20},"end":{"line":97,"column":20}}]},"8":{"line":98,"type":"if","locations":[{"start":{"line":98,"column":24},"end":{"line":98,"column":24}},{"start":{"line":98,"column":24},"end":{"line":98,"column":24}}]},"9":{"line":107,"type":"if","locations":[{"start":{"line":107,"column":24},"end":{"line":107,"column":24}},{"start":{"line":107,"column":24},"end":{"line":107,"column":24}}]}},"code":["(function () { YUI.add('event-mouseenter', function (Y, NAME) {","","/**"," * <p>Adds subscription and delegation support for mouseenter and mouseleave"," * events.  Unlike mouseover and mouseout, these events aren't fired from child"," * elements of a subscribed node.</p>"," *"," * <p>This avoids receiving three mouseover notifications from a setup like</p>"," *"," * <pre><code>div#container > p > a[href]</code></pre>"," *"," * <p>where</p>"," *"," * <pre><code>Y.one('#container').on('mouseover', callback)</code></pre>"," *"," * <p>When the mouse moves over the link, one mouseover event is fired from"," * #container, then when the mouse moves over the p, another mouseover event is"," * fired and bubbles to #container, causing a second notification, and finally"," * when the mouse moves over the link, a third mouseover event is fired and"," * bubbles to #container for a third notification.</p>"," *"," * <p>By contrast, using mouseenter instead of mouseover, the callback would be"," * executed only once when the mouse moves over #container.</p>"," *"," * @module event"," * @submodule event-mouseenter"," */","","var domEventProxies = Y.Env.evt.dom_wrappers,","    contains = Y.DOM.contains,","    toArray = Y.Array,","    noop = function () {},","","    config = {","        proxyType: \"mouseover\",","        relProperty: \"fromElement\",","","        _notify: function (e, property, notifier) {","            var el = this._node,","                related = e.relatedTarget || e[property];","","            if (el !== related && !contains(el, related)) {","                notifier.fire(new Y.DOMEventFacade(e, el,","                    domEventProxies['event:' + Y.stamp(el) + e.type]));","            }","        },","","        on: function (node, sub, notifier) {","            var el = Y.Node.getDOMNode(node),","                args = [","                    this.proxyType,","                    this._notify,","                    el,","                    null,","                    this.relProperty,","                    notifier];","","            sub.handle = Y.Event._attach(args, { facade: false });","            // node.on(this.proxyType, notify, null, notifier);","        },","","        detach: function (node, sub) {","            sub.handle.detach();","        },","","        delegate: function (node, sub, notifier, filter) {","            var el = Y.Node.getDOMNode(node),","                args = [","                    this.proxyType,","                    noop,","                    el,","                    null,","                    notifier","                ];","","            sub.handle = Y.Event._attach(args, { facade: false });","            sub.handle.sub.filter = filter;","            sub.handle.sub.relProperty = this.relProperty;","            sub.handle.sub._notify = this._filterNotify;","        },","","        _filterNotify: function (thisObj, args, ce) {","            args = args.slice();","            if (this.args) {","                args.push.apply(args, this.args);","            }","","            var currentTarget = Y.delegate._applyFilter(this.filter, args, ce),","                related = args[0].relatedTarget || args[0][this.relProperty],","                e, i, len, ret, ct;","","            if (currentTarget) {","                currentTarget = toArray(currentTarget);","","                for (i = 0, len = currentTarget.length && (!e || !e.stopped); i < len; ++i) {","                    ct = currentTarget[0];","                    if (!contains(ct, related)) {","                        if (!e) {","                            e = new Y.DOMEventFacade(args[0], ct, ce);","                            e.container = Y.one(ce.el);","                        }","                        e.currentTarget = Y.one(ct);","","                        // TODO: where is notifier? args? this.notifier?","                        ret = args[1].fire(e);","","                        if (ret === false) {","                            break;","                        }","                    }","                }","            }","","            return ret;","        },","","        detachDelegate: function (node, sub) {","            sub.handle.detach();","        }","    };","","Y.Event.define(\"mouseenter\", config, true);","Y.Event.define(\"mouseleave\", Y.merge(config, {","    proxyType: \"mouseout\",","    relProperty: \"toElement\"","}), true);","","","}, 'patched-v3.20.1', {\"requires\": [\"event-synthetic\"]});","","}());"]};
}
var __cov_xKe$WXy2ZyOUJ$T7G8VSqQ = __coverage__['build/event-mouseenter/event-mouseenter.js'];
__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['1']++;YUI.add('event-mouseenter',function(Y,NAME){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.f['1']++;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['2']++;var domEventProxies=Y.Env.evt.dom_wrappers,contains=Y.DOM.contains,toArray=Y.Array,noop=function(){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.f['2']++;},config={proxyType:'mouseover',relProperty:'fromElement',_notify:function(e,property,notifier){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.f['3']++;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['3']++;var el=this._node,related=(__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['1'][0]++,e.relatedTarget)||(__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['1'][1]++,e[property]);__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['4']++;if((__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['3'][0]++,el!==related)&&(__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['3'][1]++,!contains(el,related))){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['2'][0]++;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['5']++;notifier.fire(new Y.DOMEventFacade(e,el,domEventProxies['event:'+Y.stamp(el)+e.type]));}else{__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['2'][1]++;}},on:function(node,sub,notifier){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.f['4']++;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['6']++;var el=Y.Node.getDOMNode(node),args=[this.proxyType,this._notify,el,null,this.relProperty,notifier];__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['7']++;sub.handle=Y.Event._attach(args,{facade:false});},detach:function(node,sub){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.f['5']++;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['8']++;sub.handle.detach();},delegate:function(node,sub,notifier,filter){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.f['6']++;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['9']++;var el=Y.Node.getDOMNode(node),args=[this.proxyType,noop,el,null,notifier];__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['10']++;sub.handle=Y.Event._attach(args,{facade:false});__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['11']++;sub.handle.sub.filter=filter;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['12']++;sub.handle.sub.relProperty=this.relProperty;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['13']++;sub.handle.sub._notify=this._filterNotify;},_filterNotify:function(thisObj,args,ce){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.f['7']++;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['14']++;args=args.slice();__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['15']++;if(this.args){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['4'][0]++;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['16']++;args.push.apply(args,this.args);}else{__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['4'][1]++;}__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['17']++;var currentTarget=Y.delegate._applyFilter(this.filter,args,ce),related=(__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['5'][0]++,args[0].relatedTarget)||(__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['5'][1]++,args[0][this.relProperty]),e,i,len,ret,ct;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['18']++;if(currentTarget){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['6'][0]++;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['19']++;currentTarget=toArray(currentTarget);__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['20']++;for(i=0,len=currentTarget.length&&(!e||!e.stopped);i<len;++i){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['21']++;ct=currentTarget[0];__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['22']++;if(!contains(ct,related)){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['7'][0]++;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['23']++;if(!e){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['8'][0]++;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['24']++;e=new Y.DOMEventFacade(args[0],ct,ce);__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['25']++;e.container=Y.one(ce.el);}else{__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['8'][1]++;}__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['26']++;e.currentTarget=Y.one(ct);__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['27']++;ret=args[1].fire(e);__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['28']++;if(ret===false){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['9'][0]++;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['29']++;break;}else{__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['9'][1]++;}}else{__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['7'][1]++;}}}else{__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.b['6'][1]++;}__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['30']++;return ret;},detachDelegate:function(node,sub){__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.f['8']++;__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['31']++;sub.handle.detach();}};__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['32']++;Y.Event.define('mouseenter',config,true);__cov_xKe$WXy2ZyOUJ$T7G8VSqQ.s['33']++;Y.Event.define('mouseleave',Y.merge(config,{proxyType:'mouseout',relProperty:'toElement'}),true);},'patched-v3.20.1',{'requires':['event-synthetic']});
