if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/aui-form-builder-field-toolbar/aui-form-builder-field-toolbar.js']) {
   __coverage__['build/aui-form-builder-field-toolbar/aui-form-builder-field-toolbar.js'] = {"path":"build/aui-form-builder-field-toolbar/aui-form-builder-field-toolbar.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":42},"end":{"line":1,"column":61}}},"2":{"name":"(anonymous_2)","line":43,"loc":{"start":{"line":43,"column":17},"end":{"line":43,"column":28}}},"3":{"name":"(anonymous_3)","line":77,"loc":{"start":{"line":77,"column":16},"end":{"line":77,"column":27}}},"4":{"name":"(anonymous_4)","line":87,"loc":{"start":{"line":87,"column":17},"end":{"line":87,"column":33}}},"5":{"name":"(anonymous_5)","line":100,"loc":{"start":{"line":100,"column":11},"end":{"line":100,"column":22}}},"6":{"name":"(anonymous_6)","line":111,"loc":{"start":{"line":111,"column":13},"end":{"line":111,"column":32}}},"7":{"name":"(anonymous_7)","line":120,"loc":{"start":{"line":120,"column":10},"end":{"line":120,"column":21}}},"8":{"name":"(anonymous_8)","line":129,"loc":{"start":{"line":129,"column":12},"end":{"line":129,"column":23}}},"9":{"name":"(anonymous_9)","line":140,"loc":{"start":{"line":140,"column":23},"end":{"line":140,"column":34}}},"10":{"name":"(anonymous_10)","line":152,"loc":{"start":{"line":152,"column":24},"end":{"line":152,"column":40}}},"11":{"name":"(anonymous_11)","line":164,"loc":{"start":{"line":164,"column":23},"end":{"line":164,"column":39}}},"12":{"name":"(anonymous_12)","line":177,"loc":{"start":{"line":177,"column":19},"end":{"line":177,"column":36}}},"13":{"name":"(anonymous_13)","line":191,"loc":{"start":{"line":191,"column":24},"end":{"line":191,"column":41}}},"14":{"name":"(anonymous_14)","line":205,"loc":{"start":{"line":205,"column":24},"end":{"line":205,"column":36}}},"15":{"name":"(anonymous_15)","line":216,"loc":{"start":{"line":216,"column":18},"end":{"line":216,"column":34}}},"16":{"name":"(anonymous_16)","line":233,"loc":{"start":{"line":233,"column":20},"end":{"line":233,"column":31}}},"17":{"name":"(anonymous_17)","line":244,"loc":{"start":{"line":244,"column":17},"end":{"line":244,"column":33}}},"18":{"name":"(anonymous_18)","line":300,"loc":{"start":{"line":300,"column":21},"end":{"line":300,"column":32}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":368,"column":107}},"2":{"start":{"line":10,"column":0},"end":{"line":17,"column":89}},"3":{"start":{"line":28,"column":0},"end":{"line":311,"column":3}},"4":{"start":{"line":44,"column":8},"end":{"line":44,"column":72}},"5":{"start":{"line":46,"column":8},"end":{"line":46,"column":56}},"6":{"start":{"line":48,"column":8},"end":{"line":52,"column":10}},"7":{"start":{"line":54,"column":8},"end":{"line":65,"column":9}},"8":{"start":{"line":55,"column":12},"end":{"line":55,"column":65}},"9":{"start":{"line":56,"column":12},"end":{"line":58,"column":14}},"10":{"start":{"line":61,"column":12},"end":{"line":64,"column":14}},"11":{"start":{"line":67,"column":8},"end":{"line":67,"column":44}},"12":{"start":{"line":78,"column":8},"end":{"line":78,"column":57}},"13":{"start":{"line":88,"column":8},"end":{"line":88,"column":84}},"14":{"start":{"line":90,"column":8},"end":{"line":92,"column":11}},"15":{"start":{"line":101,"column":8},"end":{"line":101,"column":42}},"16":{"start":{"line":112,"column":8},"end":{"line":112,"column":43}},"17":{"start":{"line":121,"column":8},"end":{"line":121,"column":39}},"18":{"start":{"line":130,"column":8},"end":{"line":130,"column":31}},"19":{"start":{"line":131,"column":8},"end":{"line":131,"column":21}},"20":{"start":{"line":141,"column":8},"end":{"line":141,"column":44}},"21":{"start":{"line":153,"column":8},"end":{"line":153,"column":87}},"22":{"start":{"line":165,"column":8},"end":{"line":165,"column":91}},"23":{"start":{"line":167,"column":8},"end":{"line":167,"column":40}},"24":{"start":{"line":178,"column":8},"end":{"line":178,"column":92}},"25":{"start":{"line":180,"column":8},"end":{"line":180,"column":32}},"26":{"start":{"line":181,"column":8},"end":{"line":181,"column":20}},"27":{"start":{"line":192,"column":8},"end":{"line":192,"column":51}},"28":{"start":{"line":194,"column":8},"end":{"line":196,"column":9}},"29":{"start":{"line":195,"column":12},"end":{"line":195,"column":36}},"30":{"start":{"line":206,"column":8},"end":{"line":206,"column":22}},"31":{"start":{"line":217,"column":8},"end":{"line":219,"column":49}},"32":{"start":{"line":221,"column":8},"end":{"line":221,"column":21}},"33":{"start":{"line":222,"column":8},"end":{"line":224,"column":9}},"34":{"start":{"line":223,"column":12},"end":{"line":223,"column":63}},"35":{"start":{"line":234,"column":8},"end":{"line":234,"column":20}},"36":{"start":{"line":245,"column":8},"end":{"line":246,"column":67}},"37":{"start":{"line":248,"column":8},"end":{"line":248,"column":26}},"38":{"start":{"line":249,"column":8},"end":{"line":254,"column":9}},"39":{"start":{"line":250,"column":12},"end":{"line":253,"column":17}},"40":{"start":{"line":301,"column":16},"end":{"line":307,"column":18}},"41":{"start":{"line":319,"column":0},"end":{"line":322,"column":2}},"42":{"start":{"line":330,"column":0},"end":{"line":333,"column":2}},"43":{"start":{"line":341,"column":0},"end":{"line":344,"column":2}},"44":{"start":{"line":352,"column":0},"end":{"line":355,"column":2}},"45":{"start":{"line":363,"column":0},"end":{"line":365,"column":2}}},"branchMap":{"1":{"line":54,"type":"if","locations":[{"start":{"line":54,"column":8},"end":{"line":54,"column":8}},{"start":{"line":54,"column":8},"end":{"line":54,"column":8}}]},"2":{"line":194,"type":"if","locations":[{"start":{"line":194,"column":8},"end":{"line":194,"column":8}},{"start":{"line":194,"column":8},"end":{"line":194,"column":8}}]},"3":{"line":222,"type":"if","locations":[{"start":{"line":222,"column":8},"end":{"line":222,"column":8}},{"start":{"line":222,"column":8},"end":{"line":222,"column":8}}]},"4":{"line":251,"type":"binary-expr","locations":[{"start":{"line":251,"column":29},"end":{"line":251,"column":49}},{"start":{"line":251,"column":53},"end":{"line":251,"column":55}}]}},"code":["(function () { YUI.add('aui-form-builder-field-toolbar', function (A, NAME) {","","/**"," * The Form Builder Field Toolbar Component"," *"," * @module aui-form-builder"," * @submodule aui-form-builder-field-toolbar"," */","","var CSS_FIELD = A.getClassName('form', 'builder', 'field'),","    CSS_FIELD_CONTENT = A.getClassName('form', 'builder', 'field', 'content'),","    CSS_FIELD_CONTENT_TOOLBAR = A.getClassName('form', 'builder', 'field', 'content', 'toolbar'),","    CSS_TOOLBAR = A.getClassName('form', 'builder', 'field', 'toolbar'),","    CSS_TOOLBAR_CONTAINER = A.getClassName('form', 'builder', 'field', 'toolbar', 'container'),","    CSS_TOOLBAR_ITEM = A.getClassName('form', 'builder', 'field', 'toolbar', 'item'),","    CSS_TOOLBAR_ITEMS = A.getClassName('form', 'builder', 'field', 'toolbar', 'items'),","    CSS_TOOLBAR_TOGGLE = A.getClassName('form', 'builder', 'field', 'toolbar', 'toggle');","","/**"," * A base class for `A.FormBuilderFieldToolbar`."," *"," * @class A.FormBuilderFieldToolbar"," * @extends A.Base"," * @param {Object} config Object literal specifying widget configuration"," *     properties."," * @constructor"," */","A.FormBuilderFieldToolbar = A.Base.create('form-builder-field-toolbar', A.Base, [], {","    TPL_TOOLBAR: '<div class=\"' + CSS_TOOLBAR + '\">' +","        '<button type=\"button\" class=\"btn btn-default ' + CSS_TOOLBAR_TOGGLE + '\">' +","        '<span class=\"glyphicon glyphicon-cog\"></span></button>' +","        '<div class=\"btn-group ' + CSS_TOOLBAR_ITEMS + '\"></div></div>',","    TPL_TOOLBAR_ITEM: '<button type=\"button\" class=\"btn btn-default ' + CSS_TOOLBAR_ITEM + ' {buttonClass}\">' +","        '<span class=\"{iconClass}\"></span></button>',","","    /**","     * Construction logic executed during the `A.FormBuilderFieldToolbar`","     * instantiation. Lifecycle.","     *","     * @method initializer","     * @protected","     */","    initializer: function() {","        var fieldsContainer = this.get('formBuilder').get('contentBox');","","        this._toolbar = A.Node.create(this.TPL_TOOLBAR);","","        this._eventHandles = [","            this.after('itemsChange', this._afterItemsChange),","            this._toolbar.delegate('click', this._onToggleClick, '.' + CSS_TOOLBAR_TOGGLE, this),","            this._toolbar.delegate('click', this._onItemClick, '.' + CSS_TOOLBAR_ITEM, this)","        ];","","        if (A.UA.mobile) {","            this._toolbar.one('.' + CSS_TOOLBAR_TOGGLE).remove();","            this._eventHandles.push(","                fieldsContainer.delegate('click', this._onFieldClick, '.' + CSS_FIELD_CONTENT, this)","            );","        }","        else {","            this._eventHandles.push(","                fieldsContainer.delegate('mouseenter', this._onFieldMouseEnter, '.' + CSS_FIELD_CONTENT_TOOLBAR, this),","                fieldsContainer.delegate('mouseleave', this._onFieldMouseLeave, '.' + CSS_FIELD_CONTENT_TOOLBAR, this)","            );","        }","","        this._uiSetItems(this.get('items'));","    },","","    /**","     * Destructor lifecycle implementation for the `A.FormBuilderFieldToolbar` class.","     * Lifecycle.","     *","     * @method destructor","     * @protected","     */","    destructor: function() {","        (new A.EventHandle(this._eventHandles)).detach();","    },","","    /**","     * Adds the toolbar for the given field.","     *","     * @method addForField","     * @param {A.FormBuilderFieldBase} field","     */","    addForField: function(field) {","        field.get('content').one('.' + CSS_TOOLBAR_CONTAINER).append(this._toolbar);","","        this.fire('onToolbarHasAddedToField', {","            colNode: field.get('content').ancestor('.col')","        });","    },","","    /**","     * Closes the toolbar.","     *","     * @method close","     */","    close: function() {","        this._toolbar.removeClass('open');","    },","","    /**","     * Finds one toolbar's item using the selector.","     *","     * @method getItem","     * @param {String} selector","     * @return {Node}","     */","    getItem: function(selector) {","        return this._toolbar.one(selector);","    },","","    /**","     * Opens the toolbar","     *","     * @method open","     */","    open: function() {","        this._toolbar.addClass('open');","    },","","    /**","     * Removes the toolbar from the DOM.","     *","     * @method remove","     */","    remove: function() {","        this._toolbar.remove();","        this.close();","    },","","    /**","     * Fired after the `items` attribute is changed.","     *","     * @method _afterItemsChange","     * @protected","     */","    _afterItemsChange: function() {","        this._uiSetItems(this.get('items'));","    },","","    /**","     * Gets the form builder field from the event's target node.","     *","     * @method _getFieldFromEvent","     * @param {EventFacade} event","     * @return {A.FormBuilderFieldBase}","     * @protected","     */","    _getFieldFromEvent: function(event) {","        return event.currentTarget.ancestor('.' + CSS_FIELD).getData('field-instance');","    },","","    /**","     * Gets the item object that represents the event's target node.","     *","     * @method _getItemFromEvent","     * @param {EventFacade} event","     * @return {Object}","     * @protected","     */","    _getItemFromEvent: function(event) {","        var index = this._toolbar.all('.' + CSS_TOOLBAR_ITEM).indexOf(event.currentTarget);","","        return this.get('items')[index];","    },","","    /**","     * Fired when a field is clicked.","     *","     * @method _onFieldClick","     * @param {EventFacade} event","     * @protected","     */","    _onFieldClick: function (event) {","        var field = event.currentTarget.ancestor('.' + CSS_FIELD).getData('field-instance');","","        this.addForField(field);","        this.open();","    },","","    /**","     * Fires when mouse enters on field.","     *","     * @method _onFieldMouseEnter","     * @param {EventFacade} event","     * @protected","     */","    _onFieldMouseEnter: function (event) {","        var field = this._getFieldFromEvent(event);","","        if (!this.get('disabled')) {","            this.addForField(field);","        }","    },","","    /**","     * Fires when mouse leaves the field.","     *","     * @method _onFieldMouseLeave","     * @protected","     */","    _onFieldMouseLeave: function () {","        this.remove();","    },","","    /**","     * Fired when one of the toolbar items is clicked.","     *","     * @method _onItemClick","     * @param {EventFacade} event","     * @protected","     */","    _onItemClick: function(event) {","        var field = this._getFieldFromEvent(event),","            formBuilder = this.get('formBuilder'),","            item = this._getItemFromEvent(event);","","        this.close();","        if (item.handler) {","            formBuilder[item.handler].call(formBuilder, field);","        }","    },","","    /**","     * Fired when the toolbar's toggle is clicked.","     *","     * @method _onToggleClick","     * @protected","     */","    _onToggleClick: function() {","        this.open();","    },","","    /**","     * Updates the UI according to the value of the `items` attribute.","     *","     * @method _uiSetItems","     * @param {Array} items","     * @protected","     */","    _uiSetItems: function(items) {","        var i,","            itemsNode = this._toolbar.one('.' + CSS_TOOLBAR_ITEMS);","","        itemsNode.empty();","        for (i = 0; i < items.length; i++) {","            itemsNode.append(A.Node.create(A.Lang.sub(this.TPL_TOOLBAR_ITEM, {","                buttonClass: items[i].buttonClass || '',","                iconClass: items[i].iconClass","            })));","        }","    }","}, {","    /**","     * Static property used to define the default attribute","     * configuration for the `A.FormBuilderFieldToolbar`.","     *","     * @property ATTRS","     * @type Object","     * @static","     */","    ATTRS: {","        /**","         * Attribute that prevents users interact with the toolbar","         *","         * @attribute disabled","         * @type Boolean","         */","        disabled: {","            validator: A.Lang.isBoolean,","            value: false","        },","","        /**","         * The form builder instance that this toolbar will be used with.","         *","         * @attribute formBuilder","         * @type A.FormBuilder","         */","        formBuilder: {","            writeOnce: 'initOnly'","        },","","        /**","         * The items that should show up in the field toolbar. Each item should be","         * represented by an object with the following keys:","         * handler - (Optional) If present, the name of a function from the form","         *   builder to be called when this item is clicked.","         * iconClass: The icon css class that should be used by this item.","         *","         * @attribute items","         * @default []","         * @type Array","         */","        items: {","            validator: A.Lang.isArray,","            valueFn: function() {","                return [","                    A.FormBuilderFieldToolbar.ITEM_ADD_NESTED,","                    A.FormBuilderFieldToolbar.ITEM_EDIT,","                    A.FormBuilderFieldToolbar.ITEM_MOVE,","                    A.FormBuilderFieldToolbar.ITEM_REMOVE,","                    A.FormBuilderFieldToolbar.ITEM_CLOSE","                ];","            }","        }","    }","});","","/**"," * Pre built item for adding a nested field."," *"," * @type {Object}"," * @static"," */","A.FormBuilderFieldToolbar.ITEM_ADD_NESTED = {","    handler: 'addNestedField',","    iconClass: 'glyphicon glyphicon-plus'","};","","/**"," * Pre built item for editing a field."," *"," * @type {Object}"," * @static"," */","A.FormBuilderFieldToolbar.ITEM_EDIT = {","    handler: 'editField',","    iconClass: 'glyphicon glyphicon-wrench'","};","","/**"," * Pre built item for moving a field."," *"," * @type {Object}"," * @static"," */","A.FormBuilderFieldToolbar.ITEM_MOVE = {","    buttonClass: 'layout-builder-move-cut-button layout-builder-move-cut-col-button',","    iconClass: 'glyphicon glyphicon-move'","};","","/**"," * Pre built item for removing a field."," *"," * @type {Object}"," * @static"," */","A.FormBuilderFieldToolbar.ITEM_REMOVE = {","    handler: 'removeField',","    iconClass: 'glyphicon glyphicon-trash'","};","","/**"," * Pre built item for closing the toolbar."," *"," * @type {Object}"," * @static"," */","A.FormBuilderFieldToolbar.ITEM_CLOSE = {","    iconClass: 'glyphicon glyphicon-remove'","};","","","}, '3.1.0-deprecated.117', {\"requires\": [\"aui-classnamemanager\", \"base\", \"node-base\"], \"skinnable\": true});","","}());"]};
}
var __cov_Z_XSOh0DcsviBbHZ2P9taQ = __coverage__['build/aui-form-builder-field-toolbar/aui-form-builder-field-toolbar.js'];
__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['1']++;YUI.add('aui-form-builder-field-toolbar',function(A,NAME){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['1']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['2']++;var CSS_FIELD=A.getClassName('form','builder','field'),CSS_FIELD_CONTENT=A.getClassName('form','builder','field','content'),CSS_FIELD_CONTENT_TOOLBAR=A.getClassName('form','builder','field','content','toolbar'),CSS_TOOLBAR=A.getClassName('form','builder','field','toolbar'),CSS_TOOLBAR_CONTAINER=A.getClassName('form','builder','field','toolbar','container'),CSS_TOOLBAR_ITEM=A.getClassName('form','builder','field','toolbar','item'),CSS_TOOLBAR_ITEMS=A.getClassName('form','builder','field','toolbar','items'),CSS_TOOLBAR_TOGGLE=A.getClassName('form','builder','field','toolbar','toggle');__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['3']++;A.FormBuilderFieldToolbar=A.Base.create('form-builder-field-toolbar',A.Base,[],{TPL_TOOLBAR:'<div class="'+CSS_TOOLBAR+'">'+'<button type="button" class="btn btn-default '+CSS_TOOLBAR_TOGGLE+'">'+'<span class="glyphicon glyphicon-cog"></span></button>'+'<div class="btn-group '+CSS_TOOLBAR_ITEMS+'"></div></div>',TPL_TOOLBAR_ITEM:'<button type="button" class="btn btn-default '+CSS_TOOLBAR_ITEM+' {buttonClass}">'+'<span class="{iconClass}"></span></button>',initializer:function(){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['2']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['4']++;var fieldsContainer=this.get('formBuilder').get('contentBox');__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['5']++;this._toolbar=A.Node.create(this.TPL_TOOLBAR);__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['6']++;this._eventHandles=[this.after('itemsChange',this._afterItemsChange),this._toolbar.delegate('click',this._onToggleClick,'.'+CSS_TOOLBAR_TOGGLE,this),this._toolbar.delegate('click',this._onItemClick,'.'+CSS_TOOLBAR_ITEM,this)];__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['7']++;if(A.UA.mobile){__cov_Z_XSOh0DcsviBbHZ2P9taQ.b['1'][0]++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['8']++;this._toolbar.one('.'+CSS_TOOLBAR_TOGGLE).remove();__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['9']++;this._eventHandles.push(fieldsContainer.delegate('click',this._onFieldClick,'.'+CSS_FIELD_CONTENT,this));}else{__cov_Z_XSOh0DcsviBbHZ2P9taQ.b['1'][1]++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['10']++;this._eventHandles.push(fieldsContainer.delegate('mouseenter',this._onFieldMouseEnter,'.'+CSS_FIELD_CONTENT_TOOLBAR,this),fieldsContainer.delegate('mouseleave',this._onFieldMouseLeave,'.'+CSS_FIELD_CONTENT_TOOLBAR,this));}__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['11']++;this._uiSetItems(this.get('items'));},destructor:function(){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['3']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['12']++;new A.EventHandle(this._eventHandles).detach();},addForField:function(field){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['4']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['13']++;field.get('content').one('.'+CSS_TOOLBAR_CONTAINER).append(this._toolbar);__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['14']++;this.fire('onToolbarHasAddedToField',{colNode:field.get('content').ancestor('.col')});},close:function(){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['5']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['15']++;this._toolbar.removeClass('open');},getItem:function(selector){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['6']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['16']++;return this._toolbar.one(selector);},open:function(){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['7']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['17']++;this._toolbar.addClass('open');},remove:function(){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['8']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['18']++;this._toolbar.remove();__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['19']++;this.close();},_afterItemsChange:function(){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['9']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['20']++;this._uiSetItems(this.get('items'));},_getFieldFromEvent:function(event){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['10']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['21']++;return event.currentTarget.ancestor('.'+CSS_FIELD).getData('field-instance');},_getItemFromEvent:function(event){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['11']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['22']++;var index=this._toolbar.all('.'+CSS_TOOLBAR_ITEM).indexOf(event.currentTarget);__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['23']++;return this.get('items')[index];},_onFieldClick:function(event){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['12']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['24']++;var field=event.currentTarget.ancestor('.'+CSS_FIELD).getData('field-instance');__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['25']++;this.addForField(field);__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['26']++;this.open();},_onFieldMouseEnter:function(event){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['13']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['27']++;var field=this._getFieldFromEvent(event);__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['28']++;if(!this.get('disabled')){__cov_Z_XSOh0DcsviBbHZ2P9taQ.b['2'][0]++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['29']++;this.addForField(field);}else{__cov_Z_XSOh0DcsviBbHZ2P9taQ.b['2'][1]++;}},_onFieldMouseLeave:function(){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['14']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['30']++;this.remove();},_onItemClick:function(event){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['15']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['31']++;var field=this._getFieldFromEvent(event),formBuilder=this.get('formBuilder'),item=this._getItemFromEvent(event);__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['32']++;this.close();__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['33']++;if(item.handler){__cov_Z_XSOh0DcsviBbHZ2P9taQ.b['3'][0]++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['34']++;formBuilder[item.handler].call(formBuilder,field);}else{__cov_Z_XSOh0DcsviBbHZ2P9taQ.b['3'][1]++;}},_onToggleClick:function(){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['16']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['35']++;this.open();},_uiSetItems:function(items){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['17']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['36']++;var i,itemsNode=this._toolbar.one('.'+CSS_TOOLBAR_ITEMS);__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['37']++;itemsNode.empty();__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['38']++;for(i=0;i<items.length;i++){__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['39']++;itemsNode.append(A.Node.create(A.Lang.sub(this.TPL_TOOLBAR_ITEM,{buttonClass:(__cov_Z_XSOh0DcsviBbHZ2P9taQ.b['4'][0]++,items[i].buttonClass)||(__cov_Z_XSOh0DcsviBbHZ2P9taQ.b['4'][1]++,''),iconClass:items[i].iconClass})));}}},{ATTRS:{disabled:{validator:A.Lang.isBoolean,value:false},formBuilder:{writeOnce:'initOnly'},items:{validator:A.Lang.isArray,valueFn:function(){__cov_Z_XSOh0DcsviBbHZ2P9taQ.f['18']++;__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['40']++;return[A.FormBuilderFieldToolbar.ITEM_ADD_NESTED,A.FormBuilderFieldToolbar.ITEM_EDIT,A.FormBuilderFieldToolbar.ITEM_MOVE,A.FormBuilderFieldToolbar.ITEM_REMOVE,A.FormBuilderFieldToolbar.ITEM_CLOSE];}}}});__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['41']++;A.FormBuilderFieldToolbar.ITEM_ADD_NESTED={handler:'addNestedField',iconClass:'glyphicon glyphicon-plus'};__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['42']++;A.FormBuilderFieldToolbar.ITEM_EDIT={handler:'editField',iconClass:'glyphicon glyphicon-wrench'};__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['43']++;A.FormBuilderFieldToolbar.ITEM_MOVE={buttonClass:'layout-builder-move-cut-button layout-builder-move-cut-col-button',iconClass:'glyphicon glyphicon-move'};__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['44']++;A.FormBuilderFieldToolbar.ITEM_REMOVE={handler:'removeField',iconClass:'glyphicon glyphicon-trash'};__cov_Z_XSOh0DcsviBbHZ2P9taQ.s['45']++;A.FormBuilderFieldToolbar.ITEM_CLOSE={iconClass:'glyphicon glyphicon-remove'};},'3.1.0-deprecated.117',{'requires':['aui-classnamemanager','base','node-base'],'skinnable':true});
