if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/aui-affix/aui-affix.js']) {
   __coverage__['build/aui-affix/aui-affix.js'] = {"path":"build/aui-affix/aui-affix.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":21},"end":{"line":1,"column":40}}},"2":{"name":"(anonymous_2)","line":46,"loc":{"start":{"line":46,"column":17},"end":{"line":46,"column":28}}},"3":{"name":"(anonymous_3)","line":73,"loc":{"start":{"line":73,"column":16},"end":{"line":73,"column":27}}},"4":{"name":"(anonymous_4)","line":82,"loc":{"start":{"line":82,"column":13},"end":{"line":82,"column":24}}},"5":{"name":"(anonymous_5)","line":109,"loc":{"start":{"line":109,"column":24},"end":{"line":109,"column":35}}},"6":{"name":"(anonymous_6)","line":119,"loc":{"start":{"line":119,"column":23},"end":{"line":119,"column":34}}},"7":{"name":"(anonymous_7)","line":129,"loc":{"start":{"line":129,"column":17},"end":{"line":129,"column":28}}},"8":{"name":"(anonymous_8)","line":139,"loc":{"start":{"line":139,"column":20},"end":{"line":139,"column":31}}},"9":{"name":"(anonymous_9)","line":150,"loc":{"start":{"line":150,"column":16},"end":{"line":150,"column":30}}},"10":{"name":"(anonymous_10)","line":164,"loc":{"start":{"line":164,"column":23},"end":{"line":164,"column":42}}},"11":{"name":"(anonymous_11)","line":176,"loc":{"start":{"line":176,"column":15},"end":{"line":176,"column":26}}},"12":{"name":"(anonymous_12)","line":187,"loc":{"start":{"line":187,"column":20},"end":{"line":187,"column":39}}},"13":{"name":"(anonymous_13)","line":201,"loc":{"start":{"line":201,"column":21},"end":{"line":201,"column":35}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":269,"column":78}},"2":{"start":{"line":9,"column":0},"end":{"line":9,"column":23}},"3":{"start":{"line":24,"column":0},"end":{"line":266,"column":3}},"4":{"start":{"line":47,"column":8},"end":{"line":57,"column":11}},"5":{"start":{"line":59,"column":8},"end":{"line":62,"column":11}},"6":{"start":{"line":64,"column":8},"end":{"line":64,"column":23}},"7":{"start":{"line":65,"column":8},"end":{"line":65,"column":74}},"8":{"start":{"line":74,"column":8},"end":{"line":74,"column":35}},"9":{"start":{"line":83,"column":8},"end":{"line":86,"column":25}},"10":{"start":{"line":88,"column":8},"end":{"line":91,"column":9}},"11":{"start":{"line":89,"column":12},"end":{"line":89,"column":55}},"12":{"start":{"line":90,"column":12},"end":{"line":90,"column":19}},"13":{"start":{"line":93,"column":8},"end":{"line":93,"column":56}},"14":{"start":{"line":95,"column":8},"end":{"line":98,"column":9}},"15":{"start":{"line":96,"column":12},"end":{"line":96,"column":58}},"16":{"start":{"line":97,"column":12},"end":{"line":97,"column":19}},"17":{"start":{"line":100,"column":8},"end":{"line":100,"column":55}},"18":{"start":{"line":110,"column":8},"end":{"line":110,"column":23}},"19":{"start":{"line":120,"column":8},"end":{"line":120,"column":51}},"20":{"start":{"line":130,"column":8},"end":{"line":130,"column":52}},"21":{"start":{"line":140,"column":8},"end":{"line":140,"column":48}},"22":{"start":{"line":151,"column":8},"end":{"line":153,"column":9}},"23":{"start":{"line":152,"column":12},"end":{"line":152,"column":33}},"24":{"start":{"line":154,"column":8},"end":{"line":154,"column":19}},"25":{"start":{"line":165,"column":8},"end":{"line":167,"column":9}},"26":{"start":{"line":166,"column":12},"end":{"line":166,"column":32}},"27":{"start":{"line":177,"column":8},"end":{"line":177,"column":23}},"28":{"start":{"line":188,"column":8},"end":{"line":188,"column":40}},"29":{"start":{"line":189,"column":8},"end":{"line":189,"column":91}},"30":{"start":{"line":190,"column":8},"end":{"line":190,"column":93}},"31":{"start":{"line":191,"column":8},"end":{"line":191,"column":85}},"32":{"start":{"line":192,"column":8},"end":{"line":192,"column":38}},"33":{"start":{"line":202,"column":8},"end":{"line":204,"column":9}},"34":{"start":{"line":203,"column":12},"end":{"line":203,"column":33}},"35":{"start":{"line":206,"column":8},"end":{"line":208,"column":47}}},"branchMap":{"1":{"line":88,"type":"if","locations":[{"start":{"line":88,"column":8},"end":{"line":88,"column":8}},{"start":{"line":88,"column":8},"end":{"line":88,"column":8}}]},"2":{"line":88,"type":"binary-expr","locations":[{"start":{"line":88,"column":13},"end":{"line":88,"column":27}},{"start":{"line":88,"column":33},"end":{"line":88,"column":53}}]},"3":{"line":95,"type":"if","locations":[{"start":{"line":95,"column":8},"end":{"line":95,"column":8}},{"start":{"line":95,"column":8},"end":{"line":95,"column":8}}]},"4":{"line":95,"type":"binary-expr","locations":[{"start":{"line":95,"column":13},"end":{"line":95,"column":30}},{"start":{"line":95,"column":36},"end":{"line":95,"column":113}}]},"5":{"line":151,"type":"if","locations":[{"start":{"line":151,"column":8},"end":{"line":151,"column":8}},{"start":{"line":151,"column":8},"end":{"line":151,"column":8}}]},"6":{"line":165,"type":"if","locations":[{"start":{"line":165,"column":8},"end":{"line":165,"column":8}},{"start":{"line":165,"column":8},"end":{"line":165,"column":8}}]},"7":{"line":202,"type":"if","locations":[{"start":{"line":202,"column":8},"end":{"line":202,"column":8}},{"start":{"line":202,"column":8},"end":{"line":202,"column":8}}]},"8":{"line":206,"type":"binary-expr","locations":[{"start":{"line":206,"column":15},"end":{"line":206,"column":35}},{"start":{"line":207,"column":12},"end":{"line":207,"column":34}},{"start":{"line":208,"column":13},"end":{"line":208,"column":45}}]}},"code":["(function () { YUI.add('aui-affix', function (A, NAME) {","","/**"," * The Affix Component"," *"," * @module aui-affix"," */","","var win = A.config.win;","","/**"," * A base class for Affix."," *"," * Check the [live demo](http://alloyui.com/examples/affix/)."," *"," * @class A.Affix"," * @extends Base"," * @param {Object} config Object literal specifying scrollspy configuration"," *     properties."," * @constructor"," * @include http://alloyui.com/examples/affix/basic-markup.html"," * @include http://alloyui.com/examples/affix/basic.js"," */","A.Affix = A.Base.create('affix', A.Base, [], {","    /**","     * Holds the scroll event handle.","     *","     * @type {Node}","     * @private","     */","    _eventHandle: null,","","    /**","     * Holds the last event (bottom, default, top).","     * @type {String}","     * @private","     */","    _lastPosition: null,","","    /**","     * Constructor for the Affix component.","     *","     * @method initializer","     * @protected","     */","    initializer: function() {","        this.publish({","            bottom: {","                defaultFn: this._defAffixBottomFn","            },","            'default': {","                defaultFn: this._defAffixFn","            },","            top: {","                defaultFn: this._defAffixTopFn","            }","        });","","        this.after({","            offsetBottomChange: this._afterOffsetChange,","            offsetTopChange: this._afterOffsetChange","        });","","        this.refresh();","        this._eventHandle = A.one(win).on('scroll', this._onScroll, this);","    },","","    /**","     * Destructor for the Affix component","     * @method destructor","     * @private","     */","    destructor: function() {","        this._eventHandle.detach();","    },","","    /**","     * Refreshes the affix component to its current state.","     *","     * @method refresh","     */","    refresh: function() {","        var scrollY = A.DOM.docScrollY(),","            offsetBottom = this.get('offsetBottom'),","            offsetTop = this.get('offsetTop'),","            targetRegion;","","        if ((offsetTop >= 0) && (offsetTop >= scrollY)) {","            this._handleAffixEvent(A.Affix.EVENTS.TOP);","            return;","        }","","        targetRegion = this.get('target').get('region');","","        if ((offsetBottom >= 0) && ((A.DOM.docHeight() - A.DOM.winHeight() - offsetBottom) <= targetRegion.bottom)) {","            this._handleAffixEvent(A.Affix.EVENTS.BOTTOM);","            return;","        }","","        this._handleAffixEvent(A.Affix.EVENTS.DEFAULT);","    },","","    /**","     * Call the refresh method after changing the offset","     *","     * @method  _afterOffsetChange","     * @private","     */","    _afterOffsetChange: function() {","        this.refresh();","    },","","    /**","     * Affix bottom position syncing callback function.","     *","     * @method _defAffixBottomFn","     * @private","     */","    _defAffixBottomFn: function() {","        this._syncClassesUI(A.Affix.EVENTS.BOTTOM);","    },","","    /**","     * Affix default position syncing callback function.","     *","     * @method _defAffixFn","     * @private","     */","    _defAffixFn: function() {","        this._syncClassesUI(A.Affix.EVENTS.DEFAULT);","    },","","    /**","     * Affix top position syncing callback function.","     *","     * @method _defAffixTopFn","     * @private","     */","    _defAffixTopFn: function() {","        this._syncClassesUI(A.Affix.EVENTS.TOP);","    },","","    /**","     * Get the `offset` attribute.","     *","     * @method _getOffset","     * @param {Number | Number.NEGATIVE_INFINITY} val","     * @protected","     */","    _getOffset: function(val) {","        if (A.Lang.isFunction(val)) {","            val = val.call(this);","        }","        return val;","    },","","    /**","     * Safeguard function for firing the affix change event only when necessary.","     *","     * @method _handleAffixEvent","     * @param {String} Position value, could be 'bottom', 'default' or 'top'.","     * @private","     */","    _handleAffixEvent: function(position) {","        if (position !== this._lastPosition) {","            this.fire(position);","        }","    },","","    /**","     * Scroll event listener function.","     *","     * @method _onScroll","     * @private","     */","    _onScroll: function() {","        this.refresh();","    },","","    /**","     * Sync the target element class based on the affix positioning.","     *","     * @method _syncClassesUI","     * @param {String} Position value, could be 'bottom', 'default' or 'top'.","     * @private","     */","    _syncClassesUI: function(position) {","        var target = this.get('target');","        target.toggleClass(A.Affix.CSS_CLASSES.BOTTOM, position === A.Affix.EVENTS.BOTTOM);","        target.toggleClass(A.Affix.CSS_CLASSES.DEFAULT, position === A.Affix.EVENTS.DEFAULT);","        target.toggleClass(A.Affix.CSS_CLASSES.TOP, position === A.Affix.EVENTS.TOP);","        this._lastPosition = position;","    },","","    /**","     * Validate the offset type.","     *","     * @method _validateOffset","     * @param  {Function | Number | Number.NEGATIVE_INFINITY} val","     */","    _validateOffset: function(val) {","        if (A.Lang.isFunction(val)) {","            val = val.call(this);","        }","","        return A.Lang.isNumber(val) ||","            A.Lang.isFunction(val) ||","            (val === Number.NEGATIVE_INFINITY);","    }","}, {","    ATTRS: {","        /**","         * Defines the bottom offset.","         *","         * @attribute offsetBottom","         * @type {Function | Number}","         */","        offsetBottom: {","            getter: '_getOffset',","            validator: '_validateOffset',","            value: Number.NEGATIVE_INFINITY","        },","","        /**","         * Defines the top offset.","         *","         * @attribute offsetTop","         * @type {Function | Number}","         */","        offsetTop: {","            getter: '_getOffset',","            validator: '_validateOffset',","            value: Number.NEGATIVE_INFINITY","        },","","        /**","         * Defines the target element.","         *","         * @attribute target","         * @type {Node | String}","         */","        target: {","            setter: A.one","        }","    },","    /**","     * Map of events containing `BOTTOM`, `DEFAULT` or `TOP` keys.","     *","     * @type {Object}","     */","    EVENTS: {","        BOTTOM: 'bottom',","        DEFAULT: 'default',","        TOP: 'top'","    },","    /**","     * Map of class names containing `BOTTOM`, `DEFAULT` or `TOP` keys.","     *","     * @type {Object}","     */","    CSS_CLASSES: {","        BOTTOM: A.getClassName('affix', 'bottom'),","        DEFAULT: A.getClassName('affix'),","        TOP: A.getClassName('affix', 'top')","    }","});","","","}, '3.1.0-deprecated.117', {\"requires\": [\"base\", \"node-screen\", \"aui-node\"]});","","}());"]};
}
var __cov_7Ay7l5B5Uy$4ChYP2DxOGA = __coverage__['build/aui-affix/aui-affix.js'];
__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['1']++;YUI.add('aui-affix',function(A,NAME){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.f['1']++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['2']++;var win=A.config.win;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['3']++;A.Affix=A.Base.create('affix',A.Base,[],{_eventHandle:null,_lastPosition:null,initializer:function(){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.f['2']++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['4']++;this.publish({bottom:{defaultFn:this._defAffixBottomFn},'default':{defaultFn:this._defAffixFn},top:{defaultFn:this._defAffixTopFn}});__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['5']++;this.after({offsetBottomChange:this._afterOffsetChange,offsetTopChange:this._afterOffsetChange});__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['6']++;this.refresh();__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['7']++;this._eventHandle=A.one(win).on('scroll',this._onScroll,this);},destructor:function(){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.f['3']++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['8']++;this._eventHandle.detach();},refresh:function(){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.f['4']++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['9']++;var scrollY=A.DOM.docScrollY(),offsetBottom=this.get('offsetBottom'),offsetTop=this.get('offsetTop'),targetRegion;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['10']++;if((__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['2'][0]++,offsetTop>=0)&&(__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['2'][1]++,offsetTop>=scrollY)){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['1'][0]++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['11']++;this._handleAffixEvent(A.Affix.EVENTS.TOP);__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['12']++;return;}else{__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['1'][1]++;}__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['13']++;targetRegion=this.get('target').get('region');__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['14']++;if((__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['4'][0]++,offsetBottom>=0)&&(__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['4'][1]++,A.DOM.docHeight()-A.DOM.winHeight()-offsetBottom<=targetRegion.bottom)){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['3'][0]++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['15']++;this._handleAffixEvent(A.Affix.EVENTS.BOTTOM);__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['16']++;return;}else{__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['3'][1]++;}__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['17']++;this._handleAffixEvent(A.Affix.EVENTS.DEFAULT);},_afterOffsetChange:function(){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.f['5']++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['18']++;this.refresh();},_defAffixBottomFn:function(){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.f['6']++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['19']++;this._syncClassesUI(A.Affix.EVENTS.BOTTOM);},_defAffixFn:function(){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.f['7']++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['20']++;this._syncClassesUI(A.Affix.EVENTS.DEFAULT);},_defAffixTopFn:function(){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.f['8']++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['21']++;this._syncClassesUI(A.Affix.EVENTS.TOP);},_getOffset:function(val){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.f['9']++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['22']++;if(A.Lang.isFunction(val)){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['5'][0]++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['23']++;val=val.call(this);}else{__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['5'][1]++;}__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['24']++;return val;},_handleAffixEvent:function(position){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.f['10']++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['25']++;if(position!==this._lastPosition){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['6'][0]++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['26']++;this.fire(position);}else{__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['6'][1]++;}},_onScroll:function(){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.f['11']++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['27']++;this.refresh();},_syncClassesUI:function(position){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.f['12']++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['28']++;var target=this.get('target');__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['29']++;target.toggleClass(A.Affix.CSS_CLASSES.BOTTOM,position===A.Affix.EVENTS.BOTTOM);__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['30']++;target.toggleClass(A.Affix.CSS_CLASSES.DEFAULT,position===A.Affix.EVENTS.DEFAULT);__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['31']++;target.toggleClass(A.Affix.CSS_CLASSES.TOP,position===A.Affix.EVENTS.TOP);__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['32']++;this._lastPosition=position;},_validateOffset:function(val){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.f['13']++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['33']++;if(A.Lang.isFunction(val)){__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['7'][0]++;__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['34']++;val=val.call(this);}else{__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['7'][1]++;}__cov_7Ay7l5B5Uy$4ChYP2DxOGA.s['35']++;return(__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['8'][0]++,A.Lang.isNumber(val))||(__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['8'][1]++,A.Lang.isFunction(val))||(__cov_7Ay7l5B5Uy$4ChYP2DxOGA.b['8'][2]++,val===Number.NEGATIVE_INFINITY);}},{ATTRS:{offsetBottom:{getter:'_getOffset',validator:'_validateOffset',value:Number.NEGATIVE_INFINITY},offsetTop:{getter:'_getOffset',validator:'_validateOffset',value:Number.NEGATIVE_INFINITY},target:{setter:A.one}},EVENTS:{BOTTOM:'bottom',DEFAULT:'default',TOP:'top'},CSS_CLASSES:{BOTTOM:A.getClassName('affix','bottom'),DEFAULT:A.getClassName('affix'),TOP:A.getClassName('affix','top')}});},'3.1.0-deprecated.117',{'requires':['base','node-screen','aui-node']});
