if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/node-event-simulate/node-event-simulate.js']) {
   __coverage__['build/node-event-simulate/node-event-simulate.js'] = {"path":"build/node-event-simulate/node-event-simulate.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0},"b":{},"f":{"1":0,"2":0,"3":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":31},"end":{"line":1,"column":50}}},"2":{"name":"(anonymous_2)","line":16,"loc":{"start":{"line":16,"column":28},"end":{"line":16,"column":53}}},"3":{"name":"(anonymous_3)","line":181,"loc":{"start":{"line":181,"column":35},"end":{"line":181,"column":64}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":187,"column":83}},"2":{"start":{"line":16,"column":0},"end":{"line":19,"column":2}},"3":{"start":{"line":18,"column":4},"end":{"line":18,"column":61}},"4":{"start":{"line":181,"column":0},"end":{"line":184,"column":2}},"5":{"start":{"line":183,"column":4},"end":{"line":183,"column":53}}},"branchMap":{},"code":["(function () { YUI.add('node-event-simulate', function (Y, NAME) {","","/**"," * Adds functionality to simulate events."," * @module node"," * @submodule node-event-simulate"," */","","/**"," * Simulates an event on the node."," * @param {String} type The type of event (i.e., \"click\")."," * @param {Object} options (Optional) Extra options to copy onto the event object."," * @for Node"," * @method simulate"," */","Y.Node.prototype.simulate = function (type, options) {","","    Y.Event.simulate(Y.Node.getDOMNode(this), type, options);","};","","/**"," * Simulates the higher user level gesture of the given name on this node."," * This method generates a set of low level touch events(Apple specific gesture"," * events as well for the iOS platforms) asynchronously. Note that gesture"," * simulation is relying on `Y.Event.simulate()` method to generate"," * the touch events under the hood. The `Y.Event.simulate()` method"," * itself is a synchronous method."," *"," * Supported gestures are `tap`, `doubletap`, `press`, `move`, `flick`, `pinch`"," * and `rotate`."," *"," * The `pinch` gesture is used to simulate the pinching and spreading of two"," * fingers. During a pinch simulation, rotation is also possible. Essentially"," * `pinch` and `rotate` simulations share the same base implementation to allow"," * both pinching and rotation at the same time. The only difference is `pinch`"," * requires `start` and `end` option properties while `rotate` requires `rotation`"," * option property."," *"," * The `pinch` and `rotate` gestures can be described as placing 2 fingers along a"," * circle. Pinching and spreading can be described by start and end circles while"," * rotation occurs on a single circle. If the radius of the start circle is greater"," * than the end circle, the gesture becomes a pinch, otherwise it is a spread spread."," *"," * @example"," *"," *     var node = Y.one(\"#target\");"," *"," *     // double tap example"," *     node.simulateGesture(\"doubletap\", function() {"," *         // my callback function"," *     });"," *"," *     // flick example from the center of the node, move 50 pixels down for 50ms)"," *     node.simulateGesture(\"flick\", {"," *         axis: y,"," *         distance: -100"," *         duration: 50"," *     }, function() {"," *         // my callback function"," *     });"," *"," *     // simulate rotating a node 75 degrees counter-clockwise"," *     node.simulateGesture(\"rotate\", {"," *         rotation: -75"," *     });"," *"," *     // simulate a pinch and a rotation at the same time."," *     // fingers start on a circle of radius 100 px, placed at top/bottom"," *     // fingers end on a circle of radius 50px, placed at right/left"," *     node.simulateGesture(\"pinch\", {"," *         r1: 100,"," *         r2: 50,"," *         start: 0"," *         rotation: 90"," *     });"," *"," * @method simulateGesture"," * @param {String} name The name of the supported gesture to simulate. The"," *      supported gesture name is one of \"tap\", \"doubletap\", \"press\", \"move\","," *      \"flick\", \"pinch\" and \"rotate\"."," * @param {Object} [options] Extra options used to define the gesture behavior:"," *"," *      Valid options properties for the `tap` gesture:"," *"," *      @param {Array} [options.point] (Optional) Indicates the [x,y] coordinates"," *        where the tap should be simulated. Default is the center of the node"," *        element."," *      @param {Number} [options.hold=10] (Optional) The hold time in milliseconds."," *        This is the time between `touchstart` and `touchend` event generation."," *      @param {Number} [options.times=1] (Optional) Indicates the number of taps."," *      @param {Number} [options.delay=10] (Optional) The number of milliseconds"," *        before the next tap simulation happens. This is valid only when `times`"," *        is more than 1."," *"," *      Valid options properties for the `doubletap` gesture:"," *"," *      @param {Array} [options.point] (Optional) Indicates the [x,y] coordinates"," *        where the doubletap should be simulated. Default is the center of the"," *        node element."," *"," *      Valid options properties for the `press` gesture:"," *"," *      @param {Array} [options.point] (Optional) Indicates the [x,y] coordinates"," *        where the press should be simulated. Default is the center of the node"," *        element."," *      @param {Number} [options.hold=3000] (Optional) The hold time in milliseconds."," *        This is the time between `touchstart` and `touchend` event generation."," *        Default is 3000ms (3 seconds)."," *"," *      Valid options properties for the `move` gesture:"," *"," *      @param {Object} [options.path] (Optional) Indicates the path of the finger"," *        movement. It's an object with three optional properties: `point`,"," *        `xdist` and  `ydist`."," *        @param {Array} [options.path.point] A starting point of the gesture."," *          Default is the center of the node element."," *        @param {Number} [options.path.xdist=200] A distance to move in pixels"," *          along the X axis. A negative distance value indicates moving left."," *        @param {Number} [options.path.ydist=0] A distance to move in pixels"," *          along the Y axis. A negative distance value indicates moving up."," *      @param {Number} [options.duration=1000] (Optional) The duration of the"," *        gesture in milliseconds."," *"," *      Valid options properties for the `flick` gesture:"," *"," *      @param {Array} [options.point] (Optional) Indicates the [x, y] coordinates"," *        where the flick should be simulated. Default is the center of the"," *        node element."," *      @param {String} [options.axis='x'] (Optional) Valid values are either"," *        \"x\" or \"y\". Indicates axis to move along. The flick can move to one of"," *        4 directions(left, right, up and down)."," *      @param {Number} [options.distance=200] (Optional) Distance to move in pixels"," *      @param {Number} [options.duration=1000] (Optional) The duration of the"," *        gesture in milliseconds. User given value could be automatically"," *        adjusted by the framework if it is below the minimum velocity to be"," *        a flick gesture."," *"," *      Valid options properties for the `pinch` gesture:"," *"," *      @param {Array} [options.center] (Optional) The center of the circle where"," *        two fingers are placed. Default is the center of the node element."," *      @param {Number} [options.r1] (Required) Pixel radius of the start circle"," *        where 2 fingers will be on when the gesture starts. The circles are"," *        centered at the center of the element."," *      @param {Number} [options.r2] (Required) Pixel radius of the end circle"," *        when this gesture ends."," *      @param {Number} [options.duration=1000] (Optional) The duration of the"," *        gesture in milliseconds."," *      @param {Number} [options.start=0] (Optional) Starting degree of the first"," *        finger. The value is relative to the path of the north. Default is 0"," *        (i.e., 12:00 on a clock)."," *      @param {Number} [options.rotation=0] (Optional) Degrees to rotate from"," *        the starting degree. A negative value means rotation to the"," *        counter-clockwise direction."," *"," *      Valid options properties for the `rotate` gesture:"," *"," *      @param {Array} [options.center] (Optional) The center of the circle where"," *        two fingers are placed. Default is the center of the node element."," *      @param {Number} [options.r1] (Optional) Pixel radius of the start circle"," *        where 2 fingers will be on when the gesture starts. The circles are"," *        centered at the center of the element. Default is a fourth of the node"," *        element width or height, whichever is smaller."," *      @param {Number} [options.r2] (Optional) Pixel radius of the end circle"," *        when this gesture ends. Default is a fourth of the node element width or"," *        height, whichever is smaller."," *      @param {Number} [options.duration=1000] (Optional) The duration of the"," *        gesture in milliseconds."," *      @param {Number} [options.start=0] (Optional) Starting degree of the first"," *        finger. The value is relative to the path of the north. Default is 0"," *        (i.e., 12:00 on a clock)."," *      @param {Number} [options.rotation] (Required) Degrees to rotate from"," *        the starting degree. A negative value means rotation to the"," *        counter-clockwise direction."," *"," * @param {Function} [cb] The callback to execute when the asynchronouse gesture"," *      simulation is completed."," *      @param {Error} cb.err An error object if the simulation is failed."," * @for Node"," */","Y.Node.prototype.simulateGesture = function (name, options, cb) {","","    Y.Event.simulateGesture(this, name, options, cb);","};","","","}, 'patched-v3.19.1', {\"requires\": [\"node-base\", \"event-simulate\", \"gesture-simulate\"]});","","}());"]};
}
var __cov_ghUrkaeEPJzSfU8Btpy5$g = __coverage__['build/node-event-simulate/node-event-simulate.js'];
__cov_ghUrkaeEPJzSfU8Btpy5$g.s['1']++;YUI.add('node-event-simulate',function(Y,NAME){__cov_ghUrkaeEPJzSfU8Btpy5$g.f['1']++;__cov_ghUrkaeEPJzSfU8Btpy5$g.s['2']++;Y.Node.prototype.simulate=function(type,options){__cov_ghUrkaeEPJzSfU8Btpy5$g.f['2']++;__cov_ghUrkaeEPJzSfU8Btpy5$g.s['3']++;Y.Event.simulate(Y.Node.getDOMNode(this),type,options);};__cov_ghUrkaeEPJzSfU8Btpy5$g.s['4']++;Y.Node.prototype.simulateGesture=function(name,options,cb){__cov_ghUrkaeEPJzSfU8Btpy5$g.f['3']++;__cov_ghUrkaeEPJzSfU8Btpy5$g.s['5']++;Y.Event.simulateGesture(this,name,options,cb);};},'patched-v3.19.1',{'requires':['node-base','event-simulate','gesture-simulate']});
