if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/matrix/matrix.js']) {
   __coverage__['build/matrix/matrix.js'] = {"path":"build/matrix/matrix.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0,"50":0,"51":0,"52":0,"53":0,"54":0,"55":0,"56":0,"57":0,"58":0,"59":0,"60":0,"61":0,"62":0,"63":0,"64":0,"65":0,"66":0,"67":0,"68":0,"69":0,"70":0,"71":0,"72":0,"73":0,"74":0,"75":0,"76":0,"77":0,"78":0,"79":0,"80":0,"81":0,"82":0,"83":0,"84":0,"85":0,"86":0,"87":0,"88":0,"89":0,"90":0,"91":0,"92":0,"93":0,"94":0,"95":0,"96":0,"97":0,"98":0,"99":0,"100":0,"101":0,"102":0,"103":0,"104":0,"105":0,"106":0,"107":0,"108":0,"109":0,"110":0,"111":0,"112":0,"113":0,"114":0,"115":0,"116":0,"117":0,"118":0,"119":0,"120":0,"121":0,"122":0,"123":0,"124":0,"125":0,"126":0,"127":0,"128":0,"129":0,"130":0,"131":0,"132":0,"133":0,"134":0,"135":0,"136":0,"137":0,"138":0,"139":0,"140":0,"141":0,"142":0,"143":0,"144":0,"145":0,"146":0,"147":0,"148":0,"149":0,"150":0,"151":0,"152":0,"153":0,"154":0,"155":0,"156":0,"157":0,"158":0,"159":0,"160":0,"161":0,"162":0,"163":0,"164":0,"165":0,"166":0,"167":0,"168":0,"169":0,"170":0,"171":0,"172":0,"173":0,"174":0,"175":0,"176":0,"177":0,"178":0,"179":0,"180":0,"181":0,"182":0,"183":0,"184":0,"185":0,"186":0,"187":0,"188":0,"189":0,"190":0,"191":0,"192":0,"193":0,"194":0,"195":0,"196":0,"197":0,"198":0,"199":0,"200":0,"201":0,"202":0,"203":0,"204":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0],"13":[0,0],"14":[0,0],"15":[0,0,0,0,0,0],"16":[0,0],"17":[0,0],"18":[0,0],"19":[0,0],"20":[0,0],"21":[0,0],"22":[0,0],"23":[0,0],"24":[0,0],"25":[0,0],"26":[0,0],"27":[0,0],"28":[0,0],"29":[0,0],"30":[0,0],"31":[0,0],"32":[0,0],"33":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":18},"end":{"line":1,"column":37}}},"2":{"name":"(anonymous_2)","line":25,"loc":{"start":{"line":25,"column":16},"end":{"line":25,"column":30}}},"3":{"name":"(anonymous_3)","line":36,"loc":{"start":{"line":36,"column":17},"end":{"line":36,"column":31}}},"4":{"name":"(anonymous_4)","line":48,"loc":{"start":{"line":48,"column":17},"end":{"line":48,"column":31}}},"5":{"name":"(anonymous_5)","line":60,"loc":{"start":{"line":60,"column":19},"end":{"line":60,"column":33}}},"6":{"name":"(anonymous_6)","line":82,"loc":{"start":{"line":82,"column":33},"end":{"line":83,"column":8}}},"7":{"name":"(anonymous_7)","line":106,"loc":{"start":{"line":106,"column":24},"end":{"line":107,"column":8}}},"8":{"name":"(anonymous_8)","line":146,"loc":{"start":{"line":146,"column":17},"end":{"line":147,"column":8}}},"9":{"name":"(anonymous_9)","line":193,"loc":{"start":{"line":193,"column":24},"end":{"line":194,"column":8}}},"10":{"name":"(anonymous_10)","line":215,"loc":{"start":{"line":215,"column":19},"end":{"line":216,"column":8}}},"11":{"name":"(anonymous_11)","line":241,"loc":{"start":{"line":241,"column":19},"end":{"line":242,"column":8}}},"12":{"name":"(anonymous_12)","line":273,"loc":{"start":{"line":273,"column":14},"end":{"line":274,"column":8}}},"13":{"name":"(anonymous_13)","line":286,"loc":{"start":{"line":286,"column":29},"end":{"line":287,"column":8}}},"14":{"name":"(anonymous_14)","line":312,"loc":{"start":{"line":312,"column":19},"end":{"line":313,"column":8}}},"15":{"name":"(anonymous_15)","line":360,"loc":{"start":{"line":360,"column":27},"end":{"line":360,"column":47}}},"16":{"name":"(anonymous_16)","line":398,"loc":{"start":{"line":398,"column":35},"end":{"line":398,"column":55}}},"17":{"name":"(anonymous_17)","line":433,"loc":{"start":{"line":433,"column":34},"end":{"line":434,"column":8}}},"18":{"name":"(anonymous_18)","line":484,"loc":{"start":{"line":484,"column":13},"end":{"line":484,"column":30}}},"19":{"name":"(anonymous_19)","line":508,"loc":{"start":{"line":508,"column":14},"end":{"line":508,"column":43}}},"20":{"name":"(anonymous_20)","line":532,"loc":{"start":{"line":532,"column":18},"end":{"line":532,"column":32}}},"21":{"name":"(anonymous_21)","line":553,"loc":{"start":{"line":553,"column":23},"end":{"line":553,"column":37}}},"22":{"name":"(anonymous_22)","line":591,"loc":{"start":{"line":591,"column":12},"end":{"line":591,"column":26}}},"23":{"name":"(anonymous_23)","line":603,"loc":{"start":{"line":603,"column":10},"end":{"line":603,"column":27}}},"24":{"name":"(anonymous_24)","line":625,"loc":{"start":{"line":625,"column":11},"end":{"line":625,"column":26}}},"25":{"name":"(anonymous_25)","line":637,"loc":{"start":{"line":637,"column":10},"end":{"line":637,"column":25}}},"26":{"name":"(anonymous_26)","line":660,"loc":{"start":{"line":660,"column":11},"end":{"line":660,"column":23}}},"27":{"name":"(anonymous_27)","line":671,"loc":{"start":{"line":671,"column":11},"end":{"line":671,"column":23}}},"28":{"name":"(anonymous_28)","line":682,"loc":{"start":{"line":682,"column":15},"end":{"line":682,"column":26}}},"29":{"name":"(anonymous_29)","line":700,"loc":{"start":{"line":700,"column":18},"end":{"line":700,"column":29}}},"30":{"name":"(anonymous_30)","line":721,"loc":{"start":{"line":721,"column":13},"end":{"line":721,"column":27}}},"31":{"name":"(anonymous_31)","line":733,"loc":{"start":{"line":733,"column":13},"end":{"line":733,"column":27}}},"32":{"name":"(anonymous_32)","line":738,"loc":{"start":{"line":738,"column":15},"end":{"line":738,"column":29}}},"33":{"name":"(anonymous_33)","line":754,"loc":{"start":{"line":754,"column":12},"end":{"line":754,"column":32}}},"34":{"name":"(anonymous_34)","line":769,"loc":{"start":{"line":769,"column":15},"end":{"line":769,"column":30}}},"35":{"name":"(anonymous_35)","line":782,"loc":{"start":{"line":782,"column":16},"end":{"line":782,"column":28}}},"36":{"name":"(anonymous_36)","line":793,"loc":{"start":{"line":793,"column":16},"end":{"line":793,"column":28}}},"37":{"name":"(anonymous_37)","line":805,"loc":{"start":{"line":805,"column":14},"end":{"line":805,"column":25}}},"38":{"name":"(anonymous_38)","line":830,"loc":{"start":{"line":830,"column":20},"end":{"line":831,"column":4}}},"39":{"name":"(anonymous_39)","line":852,"loc":{"start":{"line":852,"column":20},"end":{"line":853,"column":4}}},"40":{"name":"(anonymous_40)","line":890,"loc":{"start":{"line":890,"column":20},"end":{"line":891,"column":4}}},"41":{"name":"(anonymous_41)","line":901,"loc":{"start":{"line":901,"column":13},"end":{"line":902,"column":4}}},"42":{"name":"(anonymous_42)","line":912,"loc":{"start":{"line":912,"column":15},"end":{"line":913,"column":4}}},"43":{"name":"(anonymous_43)","line":923,"loc":{"start":{"line":923,"column":15},"end":{"line":924,"column":4}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":932,"column":44}},"2":{"start":{"line":10,"column":0},"end":{"line":472,"column":2}},"3":{"start":{"line":26,"column":12},"end":{"line":26,"column":78}},"4":{"start":{"line":27,"column":12},"end":{"line":27,"column":23}},"5":{"start":{"line":37,"column":12},"end":{"line":37,"column":44}},"6":{"start":{"line":38,"column":12},"end":{"line":38,"column":23}},"7":{"start":{"line":49,"column":12},"end":{"line":49,"column":44}},"8":{"start":{"line":50,"column":12},"end":{"line":50,"column":23}},"9":{"start":{"line":61,"column":12},"end":{"line":65,"column":13}},"10":{"start":{"line":62,"column":16},"end":{"line":62,"column":38}},"11":{"start":{"line":64,"column":16},"end":{"line":64,"column":58}},"12":{"start":{"line":67,"column":12},"end":{"line":67,"column":23}},"13":{"start":{"line":84,"column":12},"end":{"line":88,"column":18}},"14":{"start":{"line":89,"column":12},"end":{"line":89,"column":31}},"15":{"start":{"line":108,"column":12},"end":{"line":111,"column":27}},"16":{"start":{"line":113,"column":12},"end":{"line":116,"column":13}},"17":{"start":{"line":115,"column":16},"end":{"line":115,"column":81}},"18":{"start":{"line":117,"column":12},"end":{"line":128,"column":13}},"19":{"start":{"line":119,"column":16},"end":{"line":119,"column":42}},"20":{"start":{"line":120,"column":16},"end":{"line":127,"column":17}},"21":{"start":{"line":122,"column":20},"end":{"line":122,"column":110}},"22":{"start":{"line":126,"column":20},"end":{"line":126,"column":110}},"23":{"start":{"line":129,"column":12},"end":{"line":129,"column":31}},"24":{"start":{"line":148,"column":12},"end":{"line":155,"column":27}},"25":{"start":{"line":156,"column":12},"end":{"line":181,"column":13}},"26":{"start":{"line":158,"column":16},"end":{"line":158,"column":88}},"27":{"start":{"line":159,"column":16},"end":{"line":162,"column":18}},"28":{"start":{"line":166,"column":16},"end":{"line":166,"column":64}},"29":{"start":{"line":167,"column":16},"end":{"line":179,"column":17}},"30":{"start":{"line":169,"column":20},"end":{"line":169,"column":36}},"31":{"start":{"line":170,"column":20},"end":{"line":178,"column":21}},"32":{"start":{"line":172,"column":24},"end":{"line":172,"column":67}},"33":{"start":{"line":173,"column":24},"end":{"line":173,"column":73}},"34":{"start":{"line":174,"column":24},"end":{"line":177,"column":25}},"35":{"start":{"line":176,"column":28},"end":{"line":176,"column":48}},"36":{"start":{"line":180,"column":16},"end":{"line":180,"column":76}},"37":{"start":{"line":182,"column":12},"end":{"line":182,"column":27}},"38":{"start":{"line":195,"column":12},"end":{"line":197,"column":36}},"39":{"start":{"line":198,"column":12},"end":{"line":204,"column":13}},"40":{"start":{"line":200,"column":16},"end":{"line":203,"column":17}},"41":{"start":{"line":202,"column":20},"end":{"line":202,"column":80}},"42":{"start":{"line":205,"column":12},"end":{"line":205,"column":26}},"43":{"start":{"line":217,"column":12},"end":{"line":220,"column":31}},"44":{"start":{"line":221,"column":12},"end":{"line":228,"column":13}},"45":{"start":{"line":223,"column":16},"end":{"line":223,"column":34}},"46":{"start":{"line":224,"column":16},"end":{"line":227,"column":17}},"47":{"start":{"line":226,"column":20},"end":{"line":226,"column":52}},"48":{"start":{"line":229,"column":12},"end":{"line":229,"column":29}},"49":{"start":{"line":243,"column":12},"end":{"line":247,"column":23}},"50":{"start":{"line":248,"column":12},"end":{"line":262,"column":13}},"51":{"start":{"line":250,"column":16},"end":{"line":261,"column":17}},"52":{"start":{"line":252,"column":20},"end":{"line":252,"column":32}},"53":{"start":{"line":253,"column":20},"end":{"line":259,"column":21}},"54":{"start":{"line":255,"column":24},"end":{"line":258,"column":25}},"55":{"start":{"line":257,"column":28},"end":{"line":257,"column":54}},"56":{"start":{"line":260,"column":20},"end":{"line":260,"column":40}},"57":{"start":{"line":263,"column":12},"end":{"line":263,"column":26}},"58":{"start":{"line":275,"column":12},"end":{"line":275,"column":53}},"59":{"start":{"line":288,"column":12},"end":{"line":292,"column":27}},"60":{"start":{"line":293,"column":12},"end":{"line":301,"column":13}},"61":{"start":{"line":295,"column":16},"end":{"line":295,"column":31}},"62":{"start":{"line":296,"column":16},"end":{"line":299,"column":17}},"63":{"start":{"line":298,"column":20},"end":{"line":298,"column":59}},"64":{"start":{"line":300,"column":16},"end":{"line":300,"column":40}},"65":{"start":{"line":302,"column":12},"end":{"line":302,"column":27}},"66":{"start":{"line":314,"column":12},"end":{"line":323,"column":22}},"67":{"start":{"line":324,"column":12},"end":{"line":327,"column":13}},"68":{"start":{"line":326,"column":16},"end":{"line":326,"column":29}},"69":{"start":{"line":329,"column":12},"end":{"line":329,"column":61}},"70":{"start":{"line":331,"column":12},"end":{"line":331,"column":20}},"71":{"start":{"line":332,"column":12},"end":{"line":332,"column":20}},"72":{"start":{"line":333,"column":12},"end":{"line":333,"column":53}},"73":{"start":{"line":334,"column":12},"end":{"line":334,"column":27}},"74":{"start":{"line":335,"column":12},"end":{"line":335,"column":27}},"75":{"start":{"line":337,"column":12},"end":{"line":337,"column":61}},"76":{"start":{"line":339,"column":12},"end":{"line":339,"column":20}},"77":{"start":{"line":340,"column":12},"end":{"line":340,"column":20}},"78":{"start":{"line":341,"column":12},"end":{"line":341,"column":23}},"79":{"start":{"line":342,"column":12},"end":{"line":342,"column":76}},"80":{"start":{"line":343,"column":12},"end":{"line":343,"column":99}},"81":{"start":{"line":345,"column":12},"end":{"line":350,"column":14}},"82":{"start":{"line":361,"column":12},"end":{"line":366,"column":54}},"83":{"start":{"line":368,"column":12},"end":{"line":388,"column":13}},"84":{"start":{"line":369,"column":16},"end":{"line":387,"column":17}},"85":{"start":{"line":371,"column":20},"end":{"line":371,"column":43}},"86":{"start":{"line":372,"column":20},"end":{"line":372,"column":39}},"87":{"start":{"line":373,"column":20},"end":{"line":373,"column":42}},"88":{"start":{"line":375,"column":21},"end":{"line":387,"column":17}},"89":{"start":{"line":377,"column":20},"end":{"line":377,"column":43}},"90":{"start":{"line":378,"column":20},"end":{"line":382,"column":23}},"91":{"start":{"line":383,"column":20},"end":{"line":383,"column":47}},"92":{"start":{"line":384,"column":20},"end":{"line":384,"column":47}},"93":{"start":{"line":385,"column":20},"end":{"line":385,"column":47}},"94":{"start":{"line":386,"column":20},"end":{"line":386,"column":47}},"95":{"start":{"line":389,"column":12},"end":{"line":389,"column":30}},"96":{"start":{"line":399,"column":12},"end":{"line":399,"column":21}},"97":{"start":{"line":400,"column":12},"end":{"line":420,"column":13}},"98":{"start":{"line":403,"column":20},"end":{"line":403,"column":45}},"99":{"start":{"line":404,"column":16},"end":{"line":404,"column":22}},"100":{"start":{"line":406,"column":20},"end":{"line":406,"column":45}},"101":{"start":{"line":407,"column":16},"end":{"line":407,"column":22}},"102":{"start":{"line":409,"column":20},"end":{"line":409,"column":42}},"103":{"start":{"line":410,"column":16},"end":{"line":410,"column":22}},"104":{"start":{"line":412,"column":20},"end":{"line":412,"column":42}},"105":{"start":{"line":413,"column":16},"end":{"line":413,"column":22}},"106":{"start":{"line":415,"column":20},"end":{"line":415,"column":45}},"107":{"start":{"line":416,"column":16},"end":{"line":416,"column":22}},"108":{"start":{"line":418,"column":20},"end":{"line":418,"column":42}},"109":{"start":{"line":419,"column":16},"end":{"line":419,"column":22}},"110":{"start":{"line":421,"column":12},"end":{"line":421,"column":24}},"111":{"start":{"line":435,"column":12},"end":{"line":438,"column":39}},"112":{"start":{"line":439,"column":12},"end":{"line":449,"column":13}},"113":{"start":{"line":441,"column":16},"end":{"line":448,"column":17}},"114":{"start":{"line":443,"column":20},"end":{"line":447,"column":21}},"115":{"start":{"line":445,"column":24},"end":{"line":445,"column":40}},"116":{"start":{"line":446,"column":24},"end":{"line":446,"column":30}},"117":{"start":{"line":450,"column":12},"end":{"line":450,"column":27}},"118":{"start":{"line":474,"column":0},"end":{"line":474,"column":26}},"119":{"start":{"line":484,"column":0},"end":{"line":486,"column":2}},"120":{"start":{"line":485,"column":4},"end":{"line":485,"column":22}},"121":{"start":{"line":488,"column":0},"end":{"line":927,"column":2}},"122":{"start":{"line":509,"column":8},"end":{"line":515,"column":66}},"123":{"start":{"line":517,"column":8},"end":{"line":517,"column":41}},"124":{"start":{"line":518,"column":8},"end":{"line":518,"column":41}},"125":{"start":{"line":519,"column":8},"end":{"line":519,"column":41}},"126":{"start":{"line":520,"column":8},"end":{"line":520,"column":41}},"127":{"start":{"line":521,"column":8},"end":{"line":521,"column":43}},"128":{"start":{"line":522,"column":8},"end":{"line":522,"column":43}},"129":{"start":{"line":523,"column":8},"end":{"line":523,"column":20}},"130":{"start":{"line":533,"column":8},"end":{"line":535,"column":14}},"131":{"start":{"line":537,"column":8},"end":{"line":537,"column":49}},"132":{"start":{"line":538,"column":8},"end":{"line":543,"column":9}},"133":{"start":{"line":539,"column":12},"end":{"line":542,"column":13}},"134":{"start":{"line":540,"column":16},"end":{"line":540,"column":39}},"135":{"start":{"line":541,"column":16},"end":{"line":541,"column":45}},"136":{"start":{"line":554,"column":8},"end":{"line":557,"column":14}},"137":{"start":{"line":559,"column":8},"end":{"line":559,"column":49}},"138":{"start":{"line":560,"column":8},"end":{"line":566,"column":9}},"139":{"start":{"line":561,"column":12},"end":{"line":565,"column":13}},"140":{"start":{"line":562,"column":16},"end":{"line":562,"column":39}},"141":{"start":{"line":563,"column":16},"end":{"line":563,"column":35}},"142":{"start":{"line":564,"column":16},"end":{"line":564,"column":38}},"143":{"start":{"line":567,"column":8},"end":{"line":567,"column":26}},"144":{"start":{"line":592,"column":8},"end":{"line":592,"column":62}},"145":{"start":{"line":593,"column":8},"end":{"line":593,"column":19}},"146":{"start":{"line":604,"column":8},"end":{"line":605,"column":17}},"147":{"start":{"line":607,"column":8},"end":{"line":607,"column":30}},"148":{"start":{"line":609,"column":8},"end":{"line":614,"column":9}},"149":{"start":{"line":610,"column":12},"end":{"line":613,"column":13}},"150":{"start":{"line":612,"column":16},"end":{"line":612,"column":78}},"151":{"start":{"line":616,"column":8},"end":{"line":616,"column":30}},"152":{"start":{"line":626,"column":8},"end":{"line":626,"column":40}},"153":{"start":{"line":627,"column":8},"end":{"line":627,"column":20}},"154":{"start":{"line":638,"column":8},"end":{"line":638,"column":19}},"155":{"start":{"line":639,"column":8},"end":{"line":639,"column":19}},"156":{"start":{"line":641,"column":8},"end":{"line":644,"column":9}},"157":{"start":{"line":642,"column":12},"end":{"line":642,"column":44}},"158":{"start":{"line":646,"column":8},"end":{"line":648,"column":9}},"159":{"start":{"line":647,"column":12},"end":{"line":647,"column":44}},"160":{"start":{"line":650,"column":8},"end":{"line":650,"column":40}},"161":{"start":{"line":651,"column":8},"end":{"line":651,"column":20}},"162":{"start":{"line":661,"column":8},"end":{"line":661,"column":21}},"163":{"start":{"line":662,"column":8},"end":{"line":662,"column":20}},"164":{"start":{"line":672,"column":8},"end":{"line":672,"column":27}},"165":{"start":{"line":673,"column":8},"end":{"line":673,"column":20}},"166":{"start":{"line":683,"column":8},"end":{"line":690,"column":36}},"167":{"start":{"line":691,"column":8},"end":{"line":691,"column":20}},"168":{"start":{"line":701,"column":8},"end":{"line":702,"column":63}},"169":{"start":{"line":703,"column":8},"end":{"line":707,"column":50}},"170":{"start":{"line":709,"column":8},"end":{"line":709,"column":19}},"171":{"start":{"line":711,"column":8},"end":{"line":711,"column":20}},"172":{"start":{"line":722,"column":8},"end":{"line":722,"column":40}},"173":{"start":{"line":723,"column":8},"end":{"line":723,"column":19}},"174":{"start":{"line":734,"column":8},"end":{"line":734,"column":40}},"175":{"start":{"line":735,"column":8},"end":{"line":735,"column":19}},"176":{"start":{"line":739,"column":8},"end":{"line":743,"column":9}},"177":{"start":{"line":740,"column":12},"end":{"line":740,"column":34}},"178":{"start":{"line":742,"column":12},"end":{"line":742,"column":48}},"179":{"start":{"line":745,"column":8},"end":{"line":745,"column":19}},"180":{"start":{"line":755,"column":8},"end":{"line":757,"column":32}},"181":{"start":{"line":758,"column":8},"end":{"line":758,"column":52}},"182":{"start":{"line":759,"column":8},"end":{"line":759,"column":20}},"183":{"start":{"line":770,"column":8},"end":{"line":770,"column":31}},"184":{"start":{"line":771,"column":8},"end":{"line":771,"column":31}},"185":{"start":{"line":772,"column":8},"end":{"line":772,"column":40}},"186":{"start":{"line":773,"column":8},"end":{"line":773,"column":20}},"187":{"start":{"line":783,"column":8},"end":{"line":783,"column":26}},"188":{"start":{"line":784,"column":8},"end":{"line":784,"column":20}},"189":{"start":{"line":794,"column":8},"end":{"line":794,"column":32}},"190":{"start":{"line":795,"column":8},"end":{"line":795,"column":20}},"191":{"start":{"line":806,"column":8},"end":{"line":808,"column":17}},"192":{"start":{"line":810,"column":8},"end":{"line":814,"column":9}},"193":{"start":{"line":811,"column":12},"end":{"line":813,"column":13}},"194":{"start":{"line":812,"column":16},"end":{"line":812,"column":44}},"195":{"start":{"line":815,"column":8},"end":{"line":815,"column":20}},"196":{"start":{"line":832,"column":8},"end":{"line":837,"column":14}},"197":{"start":{"line":838,"column":8},"end":{"line":838,"column":27}},"198":{"start":{"line":854,"column":8},"end":{"line":875,"column":47}},"199":{"start":{"line":876,"column":8},"end":{"line":881,"column":10}},"200":{"start":{"line":892,"column":8},"end":{"line":892,"column":66}},"201":{"start":{"line":903,"column":8},"end":{"line":903,"column":59}},"202":{"start":{"line":914,"column":8},"end":{"line":914,"column":61}},"203":{"start":{"line":925,"column":8},"end":{"line":925,"column":61}},"204":{"start":{"line":929,"column":0},"end":{"line":929,"column":18}}},"branchMap":{"1":{"line":61,"type":"if","locations":[{"start":{"line":61,"column":12},"end":{"line":61,"column":12}},{"start":{"line":61,"column":12},"end":{"line":61,"column":12}}]},"2":{"line":61,"type":"binary-expr","locations":[{"start":{"line":61,"column":16},"end":{"line":61,"column":39}},{"start":{"line":61,"column":43},"end":{"line":61,"column":66}}]},"3":{"line":113,"type":"if","locations":[{"start":{"line":113,"column":12},"end":{"line":113,"column":12}},{"start":{"line":113,"column":12},"end":{"line":113,"column":12}}]},"4":{"line":120,"type":"if","locations":[{"start":{"line":120,"column":16},"end":{"line":120,"column":16}},{"start":{"line":120,"column":16},"end":{"line":120,"column":16}}]},"5":{"line":120,"type":"binary-expr","locations":[{"start":{"line":120,"column":19},"end":{"line":120,"column":30}},{"start":{"line":120,"column":34},"end":{"line":120,"column":41}}]},"6":{"line":156,"type":"if","locations":[{"start":{"line":156,"column":12},"end":{"line":156,"column":12}},{"start":{"line":156,"column":12},"end":{"line":156,"column":12}}]},"7":{"line":174,"type":"if","locations":[{"start":{"line":174,"column":24},"end":{"line":174,"column":24}},{"start":{"line":174,"column":24},"end":{"line":174,"column":24}}]},"8":{"line":174,"type":"binary-expr","locations":[{"start":{"line":174,"column":27},"end":{"line":174,"column":44}},{"start":{"line":174,"column":48},"end":{"line":174,"column":61}}]},"9":{"line":250,"type":"if","locations":[{"start":{"line":250,"column":16},"end":{"line":250,"column":16}},{"start":{"line":250,"column":16},"end":{"line":250,"column":16}}]},"10":{"line":255,"type":"if","locations":[{"start":{"line":255,"column":24},"end":{"line":255,"column":24}},{"start":{"line":255,"column":24},"end":{"line":255,"column":24}}]},"11":{"line":275,"type":"cond-expr","locations":[{"start":{"line":275,"column":31},"end":{"line":275,"column":32}},{"start":{"line":275,"column":35},"end":{"line":275,"column":52}}]},"12":{"line":324,"type":"if","locations":[{"start":{"line":324,"column":12},"end":{"line":324,"column":12}},{"start":{"line":324,"column":12},"end":{"line":324,"column":12}}]},"13":{"line":369,"type":"if","locations":[{"start":{"line":369,"column":16},"end":{"line":369,"column":16}},{"start":{"line":369,"column":16},"end":{"line":369,"column":16}}]},"14":{"line":375,"type":"if","locations":[{"start":{"line":375,"column":21},"end":{"line":375,"column":21}},{"start":{"line":375,"column":21},"end":{"line":375,"column":21}}]},"15":{"line":400,"type":"switch","locations":[{"start":{"line":402,"column":16},"end":{"line":404,"column":22}},{"start":{"line":405,"column":16},"end":{"line":407,"column":22}},{"start":{"line":408,"column":16},"end":{"line":410,"column":22}},{"start":{"line":411,"column":16},"end":{"line":413,"column":22}},{"start":{"line":414,"column":16},"end":{"line":416,"column":22}},{"start":{"line":417,"column":16},"end":{"line":419,"column":22}}]},"16":{"line":439,"type":"if","locations":[{"start":{"line":439,"column":12},"end":{"line":439,"column":12}},{"start":{"line":439,"column":12},"end":{"line":439,"column":12}}]},"17":{"line":443,"type":"if","locations":[{"start":{"line":443,"column":20},"end":{"line":443,"column":20}},{"start":{"line":443,"column":20},"end":{"line":443,"column":20}}]},"18":{"line":539,"type":"if","locations":[{"start":{"line":539,"column":12},"end":{"line":539,"column":12}},{"start":{"line":539,"column":12},"end":{"line":539,"column":12}}]},"19":{"line":561,"type":"if","locations":[{"start":{"line":561,"column":12},"end":{"line":561,"column":12}},{"start":{"line":561,"column":12},"end":{"line":561,"column":12}}]},"20":{"line":607,"type":"binary-expr","locations":[{"start":{"line":607,"column":17},"end":{"line":607,"column":23}},{"start":{"line":607,"column":27},"end":{"line":607,"column":29}}]},"21":{"line":610,"type":"if","locations":[{"start":{"line":610,"column":12},"end":{"line":610,"column":12}},{"start":{"line":610,"column":12},"end":{"line":610,"column":12}}]},"22":{"line":612,"type":"cond-expr","locations":[{"start":{"line":612,"column":48},"end":{"line":612,"column":60}},{"start":{"line":612,"column":63},"end":{"line":612,"column":77}}]},"23":{"line":638,"type":"binary-expr","locations":[{"start":{"line":638,"column":12},"end":{"line":638,"column":13}},{"start":{"line":638,"column":17},"end":{"line":638,"column":18}}]},"24":{"line":639,"type":"binary-expr","locations":[{"start":{"line":639,"column":12},"end":{"line":639,"column":13}},{"start":{"line":639,"column":17},"end":{"line":639,"column":18}}]},"25":{"line":641,"type":"if","locations":[{"start":{"line":641,"column":8},"end":{"line":641,"column":8}},{"start":{"line":641,"column":8},"end":{"line":641,"column":8}}]},"26":{"line":646,"type":"if","locations":[{"start":{"line":646,"column":8},"end":{"line":646,"column":8}},{"start":{"line":646,"column":8},"end":{"line":646,"column":8}}]},"27":{"line":739,"type":"if","locations":[{"start":{"line":739,"column":8},"end":{"line":739,"column":8}},{"start":{"line":739,"column":8},"end":{"line":739,"column":8}}]},"28":{"line":739,"type":"binary-expr","locations":[{"start":{"line":739,"column":12},"end":{"line":739,"column":35}},{"start":{"line":739,"column":39},"end":{"line":739,"column":62}}]},"29":{"line":770,"type":"binary-expr","locations":[{"start":{"line":770,"column":12},"end":{"line":770,"column":25}},{"start":{"line":770,"column":29},"end":{"line":770,"column":30}}]},"30":{"line":771,"type":"binary-expr","locations":[{"start":{"line":771,"column":12},"end":{"line":771,"column":25}},{"start":{"line":771,"column":29},"end":{"line":771,"column":30}}]},"31":{"line":811,"type":"if","locations":[{"start":{"line":811,"column":12},"end":{"line":811,"column":12}},{"start":{"line":811,"column":12},"end":{"line":811,"column":12}}]},"32":{"line":854,"type":"cond-expr","locations":[{"start":{"line":854,"column":31},"end":{"line":854,"column":32}},{"start":{"line":854,"column":35},"end":{"line":854,"column":36}}]},"33":{"line":855,"type":"cond-expr","locations":[{"start":{"line":855,"column":30},"end":{"line":855,"column":31}},{"start":{"line":855,"column":34},"end":{"line":855,"column":35}}]}},"code":["(function () { YUI.add('matrix', function (Y, NAME) {","","/**"," * Matrix utilities."," *"," * @class MatrixUtil"," * @module matrix"," **/","","var MatrixUtil = {","        /**","         * Used as value for the _rounding method.","         *","         * @property _rounder","         * @private","         */","        _rounder: 100000,","","        /**","         * Rounds values","         *","         * @method _round","         * @private","         */","        _round: function(val) {","            val = Math.round(val * MatrixUtil._rounder) / MatrixUtil._rounder;","            return val;","        },","        /**","         * Converts a radian value to a degree.","         *","         * @method rad2deg","         * @param {Number} rad Radian value to be converted.","         * @return Number","         */","        rad2deg: function(rad) {","            var deg = rad * (180 / Math.PI);","            return deg;","        },","","        /**","         * Converts a degree value to a radian.","         *","         * @method deg2rad","         * @param {Number} deg Degree value to be converted to radian.","         * @return Number","         */","        deg2rad: function(deg) {","            var rad = deg * (Math.PI / 180);","            return rad;","        },","","        /**","         * Converts an angle to a radian","         *","         * @method angle2rad","         * @param {Objecxt} val Value to be converted to radian.","         * @return Number","         */","        angle2rad: function(val) {","            if (typeof val === 'string' && val.indexOf('rad') > -1) {","                val = parseFloat(val);","            } else { // default to deg","                val = MatrixUtil.deg2rad(parseFloat(val));","            }","","            return val;","        },","","        /**","         * Converts a transform object to an array of column vectors.","         *","         * /                                             \\","         * | matrix[0][0]   matrix[1][0]    matrix[2][0] |","         * | matrix[0][1]   matrix[1][1]    matrix[2][1] |","         * | matrix[0][2]   matrix[1][2]    matrix[2][2] |","         * \\                                             /","         *","         * @method getnxn","         * @return Array","         */","        convertTransformToArray: function(matrix)","        {","            var matrixArray = [","                    [matrix.a, matrix.c, matrix.dx],","                    [matrix.b, matrix.d, matrix.dy],","                    [0, 0, 1]","                ];","            return matrixArray;","        },","","        /**","         * Returns the determinant of a given matrix.","         *","         * /                                             \\","         * | matrix[0][0]   matrix[1][0]    matrix[2][0] |","         * | matrix[0][1]   matrix[1][1]    matrix[2][1] |","         * | matrix[0][2]   matrix[1][2]    matrix[2][2] |","         * | matrix[0][3]   matrix[1][3]    matrix[2][3] |","         * \\                                             /","         *","         * @method getDeterminant","         * @param {Array} matrix An nxn matrix represented an array of vector (column) arrays. Each vector array has index for each row.","         * @return Number","         */","        getDeterminant: function(matrix)","        {","            var determinant = 0,","                len = matrix.length,","                i = 0,","                multiplier;","","            if(len == 2)","            {","                return matrix[0][0] * matrix[1][1] - matrix[0][1] * matrix[1][0];","            }","            for(; i < len; ++i)","            {","                multiplier = matrix[i][0];","                if(i % 2 === 0 || i === 0)","                {","                    determinant += multiplier * MatrixUtil.getDeterminant(MatrixUtil.getMinors(matrix, i, 0));","                }","                else","                {","                    determinant -= multiplier * MatrixUtil.getDeterminant(MatrixUtil.getMinors(matrix, i, 0));","                }","            }","            return determinant;","        },","","        /**","         * Returns the inverse of a matrix","         *","         * @method inverse","         * @param Array matrix An array representing an nxn matrix","         * @return Array","         *","         * /                                             \\","         * | matrix[0][0]   matrix[1][0]    matrix[2][0] |","         * | matrix[0][1]   matrix[1][1]    matrix[2][1] |","         * | matrix[0][2]   matrix[1][2]    matrix[2][2] |","         * | matrix[0][3]   matrix[1][3]    matrix[2][3] |","         * \\                                             /","         */","        inverse: function(matrix)","        {","            var determinant = 0,","                len = matrix.length,","                i = 0,","                j,","                inverse,","                adjunct = [],","                //vector representing 2x2 matrix","                minor = [];","            if(len === 2)","            {","                determinant = matrix[0][0] * matrix[1][1] - matrix[0][1] * matrix[1][0];","                inverse = [","                    [matrix[1][1] * determinant, -matrix[1][0] * determinant],","                    [-matrix[0][1] * determinant, matrix[0][0] * determinant]","                ];","            }","            else","            {","                determinant = MatrixUtil.getDeterminant(matrix);","                for(; i < len; ++i)","                {","                    adjunct[i] = [];","                    for(j = 0; j < len; ++j)","                    {","                        minor = MatrixUtil.getMinors(matrix, j, i);","                        adjunct[i][j] = MatrixUtil.getDeterminant(minor);","                        if((i + j) % 2 !== 0 && (i + j) !== 0)","                        {","                            adjunct[i][j] *= -1;","                        }","                    }","                }","                inverse = MatrixUtil.scalarMultiply(adjunct, 1/determinant);","            }","            return inverse;","        },","","        /**","         * Multiplies a matrix by a numeric value.","         *","         * @method scalarMultiply","         * @param {Array} matrix The matrix to be altered.","         * @param {Number} multiplier The number to multiply against the matrix.","         * @return Array","         */","        scalarMultiply: function(matrix, multiplier)","        {","            var i = 0,","                j,","                len = matrix.length;","            for(; i < len; ++i)","            {","                for(j = 0; j < len; ++j)","                {","                    matrix[i][j] = MatrixUtil._round(matrix[i][j] * multiplier);","                }","            }","            return matrix;","        },","","        /**","         * Returns the transpose for an nxn matrix.","         *","         * @method transpose","         * @param matrix An nxn matrix represented by an array of vector arrays.","         * @return Array","         */","        transpose: function(matrix)","        {","            var len = matrix.length,","                i = 0,","                j = 0,","                transpose = [];","            for(; i < len; ++i)","            {","                transpose[i] = [];","                for(j = 0; j < len; ++j)","                {","                    transpose[i].push(matrix[j][i]);","                }","            }","            return transpose;","        },","","        /**","         * Returns a matrix of minors based on a matrix, column index and row index.","         *","         * @method getMinors","         * @param {Array} matrix The matrix from which to extract the matrix of minors.","         * @param {Number} columnIndex A zero-based index representing the specified column to exclude.","         * @param {Number} rowIndex A zero-based index represeenting the specified row to exclude.","         * @return Array","         */","        getMinors: function(matrix, columnIndex, rowIndex)","        {","            var minors = [],","                len = matrix.length,","                i = 0,","                j,","                column;","            for(; i < len; ++i)","            {","                if(i !== columnIndex)","                {","                    column = [];","                    for(j = 0; j < len; ++j)","                    {","                        if(j !== rowIndex)","                        {","                            column.push(matrix[i][j]);","                        }","                    }","                    minors.push(column);","                }","            }","            return minors;","        },","","        /**","         * Returns the sign of value","         *","         * @method sign","         * @param {Number} val value to be interpreted","         * @return Number","         */","        sign: function(val)","        {","            return val === 0 ? 1 : val/Math.abs(val);","        },","","        /**","         * Multiplies a vector and a matrix","         *","         * @method vectorMatrixProduct","         * @param {Array} vector Array representing a column vector","         * @param {Array} matrix Array representing an nxn matrix","         * @return Array","         */","        vectorMatrixProduct: function(vector, matrix)","        {","            var i,","                j,","                len = vector.length,","                product = [],","                rowProduct;","            for(i = 0; i < len; ++i)","            {","                rowProduct = 0;","                for(j = 0; j < len; ++j)","                {","                    rowProduct += vector[i] * matrix[i][j];","                }","                product[i] = rowProduct;","            }","            return product;","        },","","        /**","         * Breaks up a 2d transform matrix into a series of transform operations.","         *","         * @method decompose","         * @param {Array} matrix A 3x3 multidimensional array","         * @return Array","         */","        decompose: function(matrix)","        {","            var a = parseFloat(matrix[0][0]),","                b = parseFloat(matrix[1][0]),","                c = parseFloat(matrix[0][1]),","                d = parseFloat(matrix[1][1]),","                dx = parseFloat(matrix[0][2]),","                dy = parseFloat(matrix[1][2]),","                rotate,","                sx,","                sy,","                shear;","            if((a * d - b * c) === 0)","            {","                return false;","            }","            //get length of vector(ab)","            sx = MatrixUtil._round(Math.sqrt(a * a + b * b));","            //normalize components of vector(ab)","            a /= sx;","            b /= sx;","            shear = MatrixUtil._round(a * c + b * d);","            c -= a * shear;","            d -= b * shear;","            //get length of vector(cd)","            sy = MatrixUtil._round(Math.sqrt(c * c + d * d));","            //normalize components of vector(cd)","            c /= sy;","            d /= sy;","            shear /=sy;","            shear = MatrixUtil._round(MatrixUtil.rad2deg(Math.atan(shear)));","            rotate = MatrixUtil._round(MatrixUtil.rad2deg(Math.atan2(matrix[1][0], matrix[0][0])));","","            return [","                [\"translate\", dx, dy],","                [\"rotate\", rotate],","                [\"skewX\", shear],","                [\"scale\", sx, sy]","            ];","        },","","        /**","         * Parses a transform string and returns an array of transform arrays.","         *","         * @method getTransformArray","         * @param {String} val A transform string","         * @return Array","         */","        getTransformArray: function(transform) {","            var re = /\\s*([a-z]*)\\(([\\w,\\.,\\-,\\s]*)\\)/gi,","                transforms = [],","                args,","                m,","                decomp,","                methods = MatrixUtil.transformMethods;","","            while ((m = re.exec(transform))) {","                if (methods.hasOwnProperty(m[1]))","                {","                    args = m[2].split(',');","                    args.unshift(m[1]);","                    transforms.push(args);","                }","                else if(m[1] == \"matrix\")","                {","                    args = m[2].split(',');","                    decomp = MatrixUtil.decompose([","                        [args[0], args[2], args[4]],","                        [args[1], args[3], args[5]],","                        [0, 0, 1]","                    ]);","                    transforms.push(decomp[0]);","                    transforms.push(decomp[1]);","                    transforms.push(decomp[2]);","                    transforms.push(decomp[3]);","                }","            }","            return transforms;","        },","","        /**","         * Returns an array of transform arrays representing transform functions and arguments.","         *","         * @method getTransformFunctionArray","         * @return Array","         */","        getTransformFunctionArray: function(transform) {","            var list;","            switch(transform)","            {","                case \"skew\" :","                    list = [transform, 0, 0];","                break;","                case \"scale\" :","                    list = [transform, 1, 1];","                break;","                case \"scaleX\" :","                    list = [transform, 1];","                break;","                case \"scaleY\" :","                    list = [transform, 1];","                break;","                case \"translate\" :","                    list = [transform, 0, 0];","                break;","                default :","                    list = [transform, 0];","                break;","            }","            return list;","        },","","        /**","         * Compares to arrays or transform functions to ensure both contain the same functions in the same","         * order.","         *","         * @method compareTransformSequence","         * @param {Array} list1 Array to compare","         * @param {Array} list2 Array to compare","         * @return Boolean","         */","        compareTransformSequence: function(list1, list2)","        {","            var i = 0,","                len = list1.length,","                len2 = list2.length,","                isEqual = len === len2;","            if(isEqual)","            {","                for(; i < len; ++i)","                {","                    if(list1[i][0] != list2[i][0])","                    {","                        isEqual = false;","                        break;","                    }","                }","            }","            return isEqual;","        },","","        /**","         * Mapping of possible transform method names.","         *","         * @property transformMethods","         * @type Object","         */","        transformMethods: {","            rotate: \"rotate\",","            skew: \"skew\",","            skewX: \"skewX\",","            skewY: \"skewY\",","            translate: \"translate\",","            translateX: \"translateX\",","            translateY: \"tranlsateY\",","            scale: \"scale\",","            scaleX: \"scaleX\",","            scaleY: \"scaleY\"","        }","","};","","Y.MatrixUtil = MatrixUtil;","","/**"," * Matrix is a class that allows for the manipulation of a transform matrix."," * This class is a work in progress."," *"," * @class Matrix"," * @constructor"," * @module matrix"," */","var Matrix = function(config) {","    this.init(config);","};","","Matrix.prototype = {","    /**","     * Used as value for the _rounding method.","     *","     * @property _rounder","     * @private","     */","    _rounder: 100000,","","    /**","     * Updates the matrix.","     *","     * @method multiple","     * @param {Number} a","     * @param {Number} b","     * @param {Number} c","     * @param {Number} d","     * @param {Number} dx","     * @param {Number} dy","     */","    multiply: function(a, b, c, d, dx, dy) {","        var matrix = this,","            matrix_a = matrix.a * a + matrix.c * b,","            matrix_b = matrix.b * a + matrix.d * b,","            matrix_c = matrix.a * c + matrix.c * d,","            matrix_d = matrix.b * c + matrix.d * d,","            matrix_dx = matrix.a * dx + matrix.c * dy + matrix.dx,","            matrix_dy = matrix.b * dx + matrix.d * dy + matrix.dy;","","        matrix.a = this._round(matrix_a);","        matrix.b = this._round(matrix_b);","        matrix.c = this._round(matrix_c);","        matrix.d = this._round(matrix_d);","        matrix.dx = this._round(matrix_dx);","        matrix.dy = this._round(matrix_dy);","        return this;","    },","","    /**","     * Parses a string and updates the matrix.","     *","     * @method applyCSSText","     * @param {String} val A css transform string","     */","    applyCSSText: function(val) {","        var re = /\\s*([a-z]*)\\(([\\w,\\.,\\-,\\s]*)\\)/gi,","            args,","            m;","","        val = val.replace(/matrix/g, \"multiply\");","        while ((m = re.exec(val))) {","            if (typeof this[m[1]] === 'function') {","                args = m[2].split(',');","                this[m[1]].apply(this, args);","            }","        }","    },","","    /**","     * Parses a string and returns an array of transform arrays.","     *","     * @method getTransformArray","     * @param {String} val A css transform string","     * @return Array","     */","    getTransformArray: function(val) {","        var re = /\\s*([a-z]*)\\(([\\w,\\.,\\-,\\s]*)\\)/gi,","            transforms = [],","            args,","            m;","","        val = val.replace(/matrix/g, \"multiply\");","        while ((m = re.exec(val))) {","            if (typeof this[m[1]] === 'function') {","                args = m[2].split(',');","                args.unshift(m[1]);","                transforms.push(args);","            }","        }","        return transforms;","    },","","    /**","     * Default values for the matrix","     *","     * @property _defaults","     * @private","     */","    _defaults: {","        a: 1,","        b: 0,","        c: 0,","        d: 1,","        dx: 0,","        dy: 0","    },","","    /**","     * Rounds values","     *","     * @method _round","     * @private","     */","    _round: function(val) {","        val = Math.round(val * this._rounder) / this._rounder;","        return val;","    },","","    /**","     * Initializes a matrix.","     *","     * @method init","     * @param {Object} config Specified key value pairs for matrix properties. If a property is not explicitly defined in the config argument,","     * the default value will be used.","     */","    init: function(config) {","        var defaults = this._defaults,","            prop;","","        config = config || {};","","        for (prop in defaults) {","            if(defaults.hasOwnProperty(prop))","            {","                this[prop] = (prop in config) ? config[prop] : defaults[prop];","            }","        }","","        this._config = config;","    },","","    /**","     * Applies a scale transform","     *","     * @method scale","     * @param {Number} val","     */","    scale: function(x, y) {","        this.multiply(x, 0, 0, y, 0, 0);","        return this;","    },","","    /**","     * Applies a skew transformation.","     *","     * @method skew","     * @param {Number} x The value to skew on the x-axis.","     * @param {Number} y The value to skew on the y-axis.","     */","    skew: function(x, y) {","        x = x || 0;","        y = y || 0;","","        if (x !== undefined) { // null or undef","            x = Math.tan(this.angle2rad(x));","","        }","","        if (y !== undefined) { // null or undef","            y = Math.tan(this.angle2rad(y));","        }","","        this.multiply(1, y, x, 1, 0, 0);","        return this;","    },","","    /**","     * Applies a skew to the x-coordinate","     *","     * @method skewX","     * @param {Number} x x-coordinate","     */","    skewX: function(x) {","        this.skew(x);","        return this;","    },","","    /**","     * Applies a skew to the y-coordinate","     *","     * @method skewY","     * @param {Number} y y-coordinate","     */","    skewY: function(y) {","        this.skew(null, y);","        return this;","    },","","    /**","     * Returns a string of text that can be used to populate a the css transform property of an element.","     *","     * @method toCSSText","     * @return String","     */","    toCSSText: function() {","        var matrix = this,","            text = 'matrix(' +","                    matrix.a + ',' +","                    matrix.b + ',' +","                    matrix.c + ',' +","                    matrix.d + ',' +","                    matrix.dx + ',' +","                    matrix.dy + ')';","        return text;","    },","","    /**","     * Returns a string that can be used to populate the css filter property of an element.","     *","     * @method toFilterText","     * @return String","     */","    toFilterText: function() {","        var matrix = this,","            text = 'progid:DXImageTransform.Microsoft.Matrix(';","        text +=     'M11=' + matrix.a + ',' +","                    'M21=' + matrix.b + ',' +","                    'M12=' + matrix.c + ',' +","                    'M22=' + matrix.d + ',' +","                    'sizingMethod=\"auto expand\")';","","        text += '';","","        return text;","    },","","    /**","     * Converts a radian value to a degree.","     *","     * @method rad2deg","     * @param {Number} rad Radian value to be converted.","     * @return Number","     */","    rad2deg: function(rad) {","        var deg = rad * (180 / Math.PI);","        return deg;","    },","","    /**","     * Converts a degree value to a radian.","     *","     * @method deg2rad","     * @param {Number} deg Degree value to be converted to radian.","     * @return Number","     */","    deg2rad: function(deg) {","        var rad = deg * (Math.PI / 180);","        return rad;","    },","","    angle2rad: function(val) {","        if (typeof val === 'string' && val.indexOf('rad') > -1) {","            val = parseFloat(val);","        } else { // default to deg","            val = this.deg2rad(parseFloat(val));","        }","","        return val;","    },","","    /**","     * Applies a rotate transform.","     *","     * @method rotate","     * @param {Number} deg The degree of the rotation.","     */","    rotate: function(deg, x, y) {","        var rad = this.angle2rad(deg),","            sin = Math.sin(rad),","            cos = Math.cos(rad);","        this.multiply(cos, sin, 0 - sin, cos, 0, 0);","        return this;","    },","","    /**","     * Applies translate transformation.","     *","     * @method translate","     * @param {Number} x The value to transate on the x-axis.","     * @param {Number} y The value to translate on the y-axis.","     */","    translate: function(x, y) {","        x = parseFloat(x) || 0;","        y = parseFloat(y) || 0;","        this.multiply(1, 0, 0, 1, x, y);","        return this;","    },","","    /**","     * Applies a translate to the x-coordinate","     *","     * @method translateX","     * @param {Number} x x-coordinate","     */","    translateX: function(x) {","        this.translate(x);","        return this;","    },","","    /**","     * Applies a translate to the y-coordinate","     *","     * @method translateY","     * @param {Number} y y-coordinate","     */","    translateY: function(y) {","        this.translate(null, y);","        return this;","    },","","","    /**","     * Returns an identity matrix.","     *","     * @method identity","     * @return Object","     */","    identity: function() {","        var config = this._config,","            defaults = this._defaults,","            prop;","","        for (prop in config) {","            if (prop in defaults) {","                this[prop] = defaults[prop];","            }","        }","        return this;","    },","","    /**","     * Returns a 3x3 Matrix array","     *","     * /                                             \\","     * | matrix[0][0]   matrix[1][0]    matrix[2][0] |","     * | matrix[0][1]   matrix[1][1]    matrix[2][1] |","     * | matrix[0][2]   matrix[1][2]    matrix[2][2] |","     * \\                                             /","     *","     * @method getMatrixArray","     * @return Array","     */","    getMatrixArray: function()","    {","        var matrix = this,","            matrixArray = [","                [matrix.a, matrix.c, matrix.dx],","                [matrix.b, matrix.d, matrix.dy],","                [0, 0, 1]","            ];","        return matrixArray;","    },","","    /**","     * Returns the left, top, right and bottom coordinates for a transformed","     * item.","     *","     * @method getContentRect","     * @param {Number} width The width of the item.","     * @param {Number} height The height of the item.","     * @param {Number} x The x-coordinate of the item.","     * @param {Number} y The y-coordinate of the item.","     * @return Object","     */","    getContentRect: function(width, height, x, y)","    {","        var left = !isNaN(x) ? x : 0,","            top = !isNaN(y) ? y : 0,","            right = left + width,","            bottom = top + height,","            matrix = this,","            a = matrix.a,","            b = matrix.b,","            c = matrix.c,","            d = matrix.d,","            dx = matrix.dx,","            dy = matrix.dy,","            x1 = (a * left + c * top + dx),","            y1 = (b * left + d * top + dy),","            //[x2, y2]","            x2 = (a * right + c * top + dx),","            y2 = (b * right + d * top + dy),","            //[x3, y3]","            x3 = (a * left + c * bottom + dx),","            y3 = (b * left + d * bottom + dy),","            //[x4, y4]","            x4 = (a * right + c * bottom + dx),","            y4 = (b * right + d * bottom + dy);","        return {","            left: Math.min(x3, Math.min(x1, Math.min(x2, x4))),","            right: Math.max(x3, Math.max(x1, Math.max(x2, x4))),","            top: Math.min(y2, Math.min(y4, Math.min(y3, y1))),","            bottom: Math.max(y2, Math.max(y4, Math.max(y3, y1)))","        };","    },","","    /**","     * Returns the determinant of the matrix.","     *","     * @method getDeterminant","     * @return Number","     */","    getDeterminant: function()","    {","        return Y.MatrixUtil.getDeterminant(this.getMatrixArray());","    },","","    /**","     * Returns the inverse (in array form) of the matrix.","     *","     * @method inverse","     * @return Array","     */","    inverse: function()","    {","        return Y.MatrixUtil.inverse(this.getMatrixArray());","    },","","    /**","     * Returns the transpose of the matrix","     *","     * @method transpose","     * @return Array","     */","    transpose: function()","    {","        return Y.MatrixUtil.transpose(this.getMatrixArray());","    },","","    /**","     * Returns an array of transform commands that represent the matrix.","     *","     * @method decompose","     * @return Array","     */","    decompose: function()","    {","        return Y.MatrixUtil.decompose(this.getMatrixArray());","    }","};","","Y.Matrix = Matrix;","","","}, 'patched-v3.19.1', {\"requires\": [\"yui-base\"]});","","}());"]};
}
var __cov__xLIe8a_nBv4uYmJp5qLog = __coverage__['build/matrix/matrix.js'];
__cov__xLIe8a_nBv4uYmJp5qLog.s['1']++;YUI.add('matrix',function(Y,NAME){__cov__xLIe8a_nBv4uYmJp5qLog.f['1']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['2']++;var MatrixUtil={_rounder:100000,_round:function(val){__cov__xLIe8a_nBv4uYmJp5qLog.f['2']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['3']++;val=Math.round(val*MatrixUtil._rounder)/MatrixUtil._rounder;__cov__xLIe8a_nBv4uYmJp5qLog.s['4']++;return val;},rad2deg:function(rad){__cov__xLIe8a_nBv4uYmJp5qLog.f['3']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['5']++;var deg=rad*(180/Math.PI);__cov__xLIe8a_nBv4uYmJp5qLog.s['6']++;return deg;},deg2rad:function(deg){__cov__xLIe8a_nBv4uYmJp5qLog.f['4']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['7']++;var rad=deg*(Math.PI/180);__cov__xLIe8a_nBv4uYmJp5qLog.s['8']++;return rad;},angle2rad:function(val){__cov__xLIe8a_nBv4uYmJp5qLog.f['5']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['9']++;if((__cov__xLIe8a_nBv4uYmJp5qLog.b['2'][0]++,typeof val==='string')&&(__cov__xLIe8a_nBv4uYmJp5qLog.b['2'][1]++,val.indexOf('rad')>-1)){__cov__xLIe8a_nBv4uYmJp5qLog.b['1'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['10']++;val=parseFloat(val);}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['1'][1]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['11']++;val=MatrixUtil.deg2rad(parseFloat(val));}__cov__xLIe8a_nBv4uYmJp5qLog.s['12']++;return val;},convertTransformToArray:function(matrix){__cov__xLIe8a_nBv4uYmJp5qLog.f['6']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['13']++;var matrixArray=[[matrix.a,matrix.c,matrix.dx],[matrix.b,matrix.d,matrix.dy],[0,0,1]];__cov__xLIe8a_nBv4uYmJp5qLog.s['14']++;return matrixArray;},getDeterminant:function(matrix){__cov__xLIe8a_nBv4uYmJp5qLog.f['7']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['15']++;var determinant=0,len=matrix.length,i=0,multiplier;__cov__xLIe8a_nBv4uYmJp5qLog.s['16']++;if(len==2){__cov__xLIe8a_nBv4uYmJp5qLog.b['3'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['17']++;return matrix[0][0]*matrix[1][1]-matrix[0][1]*matrix[1][0];}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['3'][1]++;}__cov__xLIe8a_nBv4uYmJp5qLog.s['18']++;for(;i<len;++i){__cov__xLIe8a_nBv4uYmJp5qLog.s['19']++;multiplier=matrix[i][0];__cov__xLIe8a_nBv4uYmJp5qLog.s['20']++;if((__cov__xLIe8a_nBv4uYmJp5qLog.b['5'][0]++,i%2===0)||(__cov__xLIe8a_nBv4uYmJp5qLog.b['5'][1]++,i===0)){__cov__xLIe8a_nBv4uYmJp5qLog.b['4'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['21']++;determinant+=multiplier*MatrixUtil.getDeterminant(MatrixUtil.getMinors(matrix,i,0));}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['4'][1]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['22']++;determinant-=multiplier*MatrixUtil.getDeterminant(MatrixUtil.getMinors(matrix,i,0));}}__cov__xLIe8a_nBv4uYmJp5qLog.s['23']++;return determinant;},inverse:function(matrix){__cov__xLIe8a_nBv4uYmJp5qLog.f['8']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['24']++;var determinant=0,len=matrix.length,i=0,j,inverse,adjunct=[],minor=[];__cov__xLIe8a_nBv4uYmJp5qLog.s['25']++;if(len===2){__cov__xLIe8a_nBv4uYmJp5qLog.b['6'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['26']++;determinant=matrix[0][0]*matrix[1][1]-matrix[0][1]*matrix[1][0];__cov__xLIe8a_nBv4uYmJp5qLog.s['27']++;inverse=[[matrix[1][1]*determinant,-matrix[1][0]*determinant],[-matrix[0][1]*determinant,matrix[0][0]*determinant]];}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['6'][1]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['28']++;determinant=MatrixUtil.getDeterminant(matrix);__cov__xLIe8a_nBv4uYmJp5qLog.s['29']++;for(;i<len;++i){__cov__xLIe8a_nBv4uYmJp5qLog.s['30']++;adjunct[i]=[];__cov__xLIe8a_nBv4uYmJp5qLog.s['31']++;for(j=0;j<len;++j){__cov__xLIe8a_nBv4uYmJp5qLog.s['32']++;minor=MatrixUtil.getMinors(matrix,j,i);__cov__xLIe8a_nBv4uYmJp5qLog.s['33']++;adjunct[i][j]=MatrixUtil.getDeterminant(minor);__cov__xLIe8a_nBv4uYmJp5qLog.s['34']++;if((__cov__xLIe8a_nBv4uYmJp5qLog.b['8'][0]++,(i+j)%2!==0)&&(__cov__xLIe8a_nBv4uYmJp5qLog.b['8'][1]++,i+j!==0)){__cov__xLIe8a_nBv4uYmJp5qLog.b['7'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['35']++;adjunct[i][j]*=-1;}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['7'][1]++;}}}__cov__xLIe8a_nBv4uYmJp5qLog.s['36']++;inverse=MatrixUtil.scalarMultiply(adjunct,1/determinant);}__cov__xLIe8a_nBv4uYmJp5qLog.s['37']++;return inverse;},scalarMultiply:function(matrix,multiplier){__cov__xLIe8a_nBv4uYmJp5qLog.f['9']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['38']++;var i=0,j,len=matrix.length;__cov__xLIe8a_nBv4uYmJp5qLog.s['39']++;for(;i<len;++i){__cov__xLIe8a_nBv4uYmJp5qLog.s['40']++;for(j=0;j<len;++j){__cov__xLIe8a_nBv4uYmJp5qLog.s['41']++;matrix[i][j]=MatrixUtil._round(matrix[i][j]*multiplier);}}__cov__xLIe8a_nBv4uYmJp5qLog.s['42']++;return matrix;},transpose:function(matrix){__cov__xLIe8a_nBv4uYmJp5qLog.f['10']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['43']++;var len=matrix.length,i=0,j=0,transpose=[];__cov__xLIe8a_nBv4uYmJp5qLog.s['44']++;for(;i<len;++i){__cov__xLIe8a_nBv4uYmJp5qLog.s['45']++;transpose[i]=[];__cov__xLIe8a_nBv4uYmJp5qLog.s['46']++;for(j=0;j<len;++j){__cov__xLIe8a_nBv4uYmJp5qLog.s['47']++;transpose[i].push(matrix[j][i]);}}__cov__xLIe8a_nBv4uYmJp5qLog.s['48']++;return transpose;},getMinors:function(matrix,columnIndex,rowIndex){__cov__xLIe8a_nBv4uYmJp5qLog.f['11']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['49']++;var minors=[],len=matrix.length,i=0,j,column;__cov__xLIe8a_nBv4uYmJp5qLog.s['50']++;for(;i<len;++i){__cov__xLIe8a_nBv4uYmJp5qLog.s['51']++;if(i!==columnIndex){__cov__xLIe8a_nBv4uYmJp5qLog.b['9'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['52']++;column=[];__cov__xLIe8a_nBv4uYmJp5qLog.s['53']++;for(j=0;j<len;++j){__cov__xLIe8a_nBv4uYmJp5qLog.s['54']++;if(j!==rowIndex){__cov__xLIe8a_nBv4uYmJp5qLog.b['10'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['55']++;column.push(matrix[i][j]);}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['10'][1]++;}}__cov__xLIe8a_nBv4uYmJp5qLog.s['56']++;minors.push(column);}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['9'][1]++;}}__cov__xLIe8a_nBv4uYmJp5qLog.s['57']++;return minors;},sign:function(val){__cov__xLIe8a_nBv4uYmJp5qLog.f['12']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['58']++;return val===0?(__cov__xLIe8a_nBv4uYmJp5qLog.b['11'][0]++,1):(__cov__xLIe8a_nBv4uYmJp5qLog.b['11'][1]++,val/Math.abs(val));},vectorMatrixProduct:function(vector,matrix){__cov__xLIe8a_nBv4uYmJp5qLog.f['13']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['59']++;var i,j,len=vector.length,product=[],rowProduct;__cov__xLIe8a_nBv4uYmJp5qLog.s['60']++;for(i=0;i<len;++i){__cov__xLIe8a_nBv4uYmJp5qLog.s['61']++;rowProduct=0;__cov__xLIe8a_nBv4uYmJp5qLog.s['62']++;for(j=0;j<len;++j){__cov__xLIe8a_nBv4uYmJp5qLog.s['63']++;rowProduct+=vector[i]*matrix[i][j];}__cov__xLIe8a_nBv4uYmJp5qLog.s['64']++;product[i]=rowProduct;}__cov__xLIe8a_nBv4uYmJp5qLog.s['65']++;return product;},decompose:function(matrix){__cov__xLIe8a_nBv4uYmJp5qLog.f['14']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['66']++;var a=parseFloat(matrix[0][0]),b=parseFloat(matrix[1][0]),c=parseFloat(matrix[0][1]),d=parseFloat(matrix[1][1]),dx=parseFloat(matrix[0][2]),dy=parseFloat(matrix[1][2]),rotate,sx,sy,shear;__cov__xLIe8a_nBv4uYmJp5qLog.s['67']++;if(a*d-b*c===0){__cov__xLIe8a_nBv4uYmJp5qLog.b['12'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['68']++;return false;}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['12'][1]++;}__cov__xLIe8a_nBv4uYmJp5qLog.s['69']++;sx=MatrixUtil._round(Math.sqrt(a*a+b*b));__cov__xLIe8a_nBv4uYmJp5qLog.s['70']++;a/=sx;__cov__xLIe8a_nBv4uYmJp5qLog.s['71']++;b/=sx;__cov__xLIe8a_nBv4uYmJp5qLog.s['72']++;shear=MatrixUtil._round(a*c+b*d);__cov__xLIe8a_nBv4uYmJp5qLog.s['73']++;c-=a*shear;__cov__xLIe8a_nBv4uYmJp5qLog.s['74']++;d-=b*shear;__cov__xLIe8a_nBv4uYmJp5qLog.s['75']++;sy=MatrixUtil._round(Math.sqrt(c*c+d*d));__cov__xLIe8a_nBv4uYmJp5qLog.s['76']++;c/=sy;__cov__xLIe8a_nBv4uYmJp5qLog.s['77']++;d/=sy;__cov__xLIe8a_nBv4uYmJp5qLog.s['78']++;shear/=sy;__cov__xLIe8a_nBv4uYmJp5qLog.s['79']++;shear=MatrixUtil._round(MatrixUtil.rad2deg(Math.atan(shear)));__cov__xLIe8a_nBv4uYmJp5qLog.s['80']++;rotate=MatrixUtil._round(MatrixUtil.rad2deg(Math.atan2(matrix[1][0],matrix[0][0])));__cov__xLIe8a_nBv4uYmJp5qLog.s['81']++;return[['translate',dx,dy],['rotate',rotate],['skewX',shear],['scale',sx,sy]];},getTransformArray:function(transform){__cov__xLIe8a_nBv4uYmJp5qLog.f['15']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['82']++;var re=/\s*([a-z]*)\(([\w,\.,\-,\s]*)\)/gi,transforms=[],args,m,decomp,methods=MatrixUtil.transformMethods;__cov__xLIe8a_nBv4uYmJp5qLog.s['83']++;while(m=re.exec(transform)){__cov__xLIe8a_nBv4uYmJp5qLog.s['84']++;if(methods.hasOwnProperty(m[1])){__cov__xLIe8a_nBv4uYmJp5qLog.b['13'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['85']++;args=m[2].split(',');__cov__xLIe8a_nBv4uYmJp5qLog.s['86']++;args.unshift(m[1]);__cov__xLIe8a_nBv4uYmJp5qLog.s['87']++;transforms.push(args);}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['13'][1]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['88']++;if(m[1]=='matrix'){__cov__xLIe8a_nBv4uYmJp5qLog.b['14'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['89']++;args=m[2].split(',');__cov__xLIe8a_nBv4uYmJp5qLog.s['90']++;decomp=MatrixUtil.decompose([[args[0],args[2],args[4]],[args[1],args[3],args[5]],[0,0,1]]);__cov__xLIe8a_nBv4uYmJp5qLog.s['91']++;transforms.push(decomp[0]);__cov__xLIe8a_nBv4uYmJp5qLog.s['92']++;transforms.push(decomp[1]);__cov__xLIe8a_nBv4uYmJp5qLog.s['93']++;transforms.push(decomp[2]);__cov__xLIe8a_nBv4uYmJp5qLog.s['94']++;transforms.push(decomp[3]);}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['14'][1]++;}}}__cov__xLIe8a_nBv4uYmJp5qLog.s['95']++;return transforms;},getTransformFunctionArray:function(transform){__cov__xLIe8a_nBv4uYmJp5qLog.f['16']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['96']++;var list;__cov__xLIe8a_nBv4uYmJp5qLog.s['97']++;switch(transform){case'skew':__cov__xLIe8a_nBv4uYmJp5qLog.b['15'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['98']++;list=[transform,0,0];__cov__xLIe8a_nBv4uYmJp5qLog.s['99']++;break;case'scale':__cov__xLIe8a_nBv4uYmJp5qLog.b['15'][1]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['100']++;list=[transform,1,1];__cov__xLIe8a_nBv4uYmJp5qLog.s['101']++;break;case'scaleX':__cov__xLIe8a_nBv4uYmJp5qLog.b['15'][2]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['102']++;list=[transform,1];__cov__xLIe8a_nBv4uYmJp5qLog.s['103']++;break;case'scaleY':__cov__xLIe8a_nBv4uYmJp5qLog.b['15'][3]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['104']++;list=[transform,1];__cov__xLIe8a_nBv4uYmJp5qLog.s['105']++;break;case'translate':__cov__xLIe8a_nBv4uYmJp5qLog.b['15'][4]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['106']++;list=[transform,0,0];__cov__xLIe8a_nBv4uYmJp5qLog.s['107']++;break;default:__cov__xLIe8a_nBv4uYmJp5qLog.b['15'][5]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['108']++;list=[transform,0];__cov__xLIe8a_nBv4uYmJp5qLog.s['109']++;break;}__cov__xLIe8a_nBv4uYmJp5qLog.s['110']++;return list;},compareTransformSequence:function(list1,list2){__cov__xLIe8a_nBv4uYmJp5qLog.f['17']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['111']++;var i=0,len=list1.length,len2=list2.length,isEqual=len===len2;__cov__xLIe8a_nBv4uYmJp5qLog.s['112']++;if(isEqual){__cov__xLIe8a_nBv4uYmJp5qLog.b['16'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['113']++;for(;i<len;++i){__cov__xLIe8a_nBv4uYmJp5qLog.s['114']++;if(list1[i][0]!=list2[i][0]){__cov__xLIe8a_nBv4uYmJp5qLog.b['17'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['115']++;isEqual=false;__cov__xLIe8a_nBv4uYmJp5qLog.s['116']++;break;}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['17'][1]++;}}}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['16'][1]++;}__cov__xLIe8a_nBv4uYmJp5qLog.s['117']++;return isEqual;},transformMethods:{rotate:'rotate',skew:'skew',skewX:'skewX',skewY:'skewY',translate:'translate',translateX:'translateX',translateY:'tranlsateY',scale:'scale',scaleX:'scaleX',scaleY:'scaleY'}};__cov__xLIe8a_nBv4uYmJp5qLog.s['118']++;Y.MatrixUtil=MatrixUtil;__cov__xLIe8a_nBv4uYmJp5qLog.s['119']++;var Matrix=function(config){__cov__xLIe8a_nBv4uYmJp5qLog.f['18']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['120']++;this.init(config);};__cov__xLIe8a_nBv4uYmJp5qLog.s['121']++;Matrix.prototype={_rounder:100000,multiply:function(a,b,c,d,dx,dy){__cov__xLIe8a_nBv4uYmJp5qLog.f['19']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['122']++;var matrix=this,matrix_a=matrix.a*a+matrix.c*b,matrix_b=matrix.b*a+matrix.d*b,matrix_c=matrix.a*c+matrix.c*d,matrix_d=matrix.b*c+matrix.d*d,matrix_dx=matrix.a*dx+matrix.c*dy+matrix.dx,matrix_dy=matrix.b*dx+matrix.d*dy+matrix.dy;__cov__xLIe8a_nBv4uYmJp5qLog.s['123']++;matrix.a=this._round(matrix_a);__cov__xLIe8a_nBv4uYmJp5qLog.s['124']++;matrix.b=this._round(matrix_b);__cov__xLIe8a_nBv4uYmJp5qLog.s['125']++;matrix.c=this._round(matrix_c);__cov__xLIe8a_nBv4uYmJp5qLog.s['126']++;matrix.d=this._round(matrix_d);__cov__xLIe8a_nBv4uYmJp5qLog.s['127']++;matrix.dx=this._round(matrix_dx);__cov__xLIe8a_nBv4uYmJp5qLog.s['128']++;matrix.dy=this._round(matrix_dy);__cov__xLIe8a_nBv4uYmJp5qLog.s['129']++;return this;},applyCSSText:function(val){__cov__xLIe8a_nBv4uYmJp5qLog.f['20']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['130']++;var re=/\s*([a-z]*)\(([\w,\.,\-,\s]*)\)/gi,args,m;__cov__xLIe8a_nBv4uYmJp5qLog.s['131']++;val=val.replace(/matrix/g,'multiply');__cov__xLIe8a_nBv4uYmJp5qLog.s['132']++;while(m=re.exec(val)){__cov__xLIe8a_nBv4uYmJp5qLog.s['133']++;if(typeof this[m[1]]==='function'){__cov__xLIe8a_nBv4uYmJp5qLog.b['18'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['134']++;args=m[2].split(',');__cov__xLIe8a_nBv4uYmJp5qLog.s['135']++;this[m[1]].apply(this,args);}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['18'][1]++;}}},getTransformArray:function(val){__cov__xLIe8a_nBv4uYmJp5qLog.f['21']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['136']++;var re=/\s*([a-z]*)\(([\w,\.,\-,\s]*)\)/gi,transforms=[],args,m;__cov__xLIe8a_nBv4uYmJp5qLog.s['137']++;val=val.replace(/matrix/g,'multiply');__cov__xLIe8a_nBv4uYmJp5qLog.s['138']++;while(m=re.exec(val)){__cov__xLIe8a_nBv4uYmJp5qLog.s['139']++;if(typeof this[m[1]]==='function'){__cov__xLIe8a_nBv4uYmJp5qLog.b['19'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['140']++;args=m[2].split(',');__cov__xLIe8a_nBv4uYmJp5qLog.s['141']++;args.unshift(m[1]);__cov__xLIe8a_nBv4uYmJp5qLog.s['142']++;transforms.push(args);}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['19'][1]++;}}__cov__xLIe8a_nBv4uYmJp5qLog.s['143']++;return transforms;},_defaults:{a:1,b:0,c:0,d:1,dx:0,dy:0},_round:function(val){__cov__xLIe8a_nBv4uYmJp5qLog.f['22']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['144']++;val=Math.round(val*this._rounder)/this._rounder;__cov__xLIe8a_nBv4uYmJp5qLog.s['145']++;return val;},init:function(config){__cov__xLIe8a_nBv4uYmJp5qLog.f['23']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['146']++;var defaults=this._defaults,prop;__cov__xLIe8a_nBv4uYmJp5qLog.s['147']++;config=(__cov__xLIe8a_nBv4uYmJp5qLog.b['20'][0]++,config)||(__cov__xLIe8a_nBv4uYmJp5qLog.b['20'][1]++,{});__cov__xLIe8a_nBv4uYmJp5qLog.s['148']++;for(prop in defaults){__cov__xLIe8a_nBv4uYmJp5qLog.s['149']++;if(defaults.hasOwnProperty(prop)){__cov__xLIe8a_nBv4uYmJp5qLog.b['21'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['150']++;this[prop]=prop in config?(__cov__xLIe8a_nBv4uYmJp5qLog.b['22'][0]++,config[prop]):(__cov__xLIe8a_nBv4uYmJp5qLog.b['22'][1]++,defaults[prop]);}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['21'][1]++;}}__cov__xLIe8a_nBv4uYmJp5qLog.s['151']++;this._config=config;},scale:function(x,y){__cov__xLIe8a_nBv4uYmJp5qLog.f['24']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['152']++;this.multiply(x,0,0,y,0,0);__cov__xLIe8a_nBv4uYmJp5qLog.s['153']++;return this;},skew:function(x,y){__cov__xLIe8a_nBv4uYmJp5qLog.f['25']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['154']++;x=(__cov__xLIe8a_nBv4uYmJp5qLog.b['23'][0]++,x)||(__cov__xLIe8a_nBv4uYmJp5qLog.b['23'][1]++,0);__cov__xLIe8a_nBv4uYmJp5qLog.s['155']++;y=(__cov__xLIe8a_nBv4uYmJp5qLog.b['24'][0]++,y)||(__cov__xLIe8a_nBv4uYmJp5qLog.b['24'][1]++,0);__cov__xLIe8a_nBv4uYmJp5qLog.s['156']++;if(x!==undefined){__cov__xLIe8a_nBv4uYmJp5qLog.b['25'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['157']++;x=Math.tan(this.angle2rad(x));}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['25'][1]++;}__cov__xLIe8a_nBv4uYmJp5qLog.s['158']++;if(y!==undefined){__cov__xLIe8a_nBv4uYmJp5qLog.b['26'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['159']++;y=Math.tan(this.angle2rad(y));}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['26'][1]++;}__cov__xLIe8a_nBv4uYmJp5qLog.s['160']++;this.multiply(1,y,x,1,0,0);__cov__xLIe8a_nBv4uYmJp5qLog.s['161']++;return this;},skewX:function(x){__cov__xLIe8a_nBv4uYmJp5qLog.f['26']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['162']++;this.skew(x);__cov__xLIe8a_nBv4uYmJp5qLog.s['163']++;return this;},skewY:function(y){__cov__xLIe8a_nBv4uYmJp5qLog.f['27']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['164']++;this.skew(null,y);__cov__xLIe8a_nBv4uYmJp5qLog.s['165']++;return this;},toCSSText:function(){__cov__xLIe8a_nBv4uYmJp5qLog.f['28']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['166']++;var matrix=this,text='matrix('+matrix.a+','+matrix.b+','+matrix.c+','+matrix.d+','+matrix.dx+','+matrix.dy+')';__cov__xLIe8a_nBv4uYmJp5qLog.s['167']++;return text;},toFilterText:function(){__cov__xLIe8a_nBv4uYmJp5qLog.f['29']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['168']++;var matrix=this,text='progid:DXImageTransform.Microsoft.Matrix(';__cov__xLIe8a_nBv4uYmJp5qLog.s['169']++;text+='M11='+matrix.a+','+'M21='+matrix.b+','+'M12='+matrix.c+','+'M22='+matrix.d+','+'sizingMethod="auto expand")';__cov__xLIe8a_nBv4uYmJp5qLog.s['170']++;text+='';__cov__xLIe8a_nBv4uYmJp5qLog.s['171']++;return text;},rad2deg:function(rad){__cov__xLIe8a_nBv4uYmJp5qLog.f['30']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['172']++;var deg=rad*(180/Math.PI);__cov__xLIe8a_nBv4uYmJp5qLog.s['173']++;return deg;},deg2rad:function(deg){__cov__xLIe8a_nBv4uYmJp5qLog.f['31']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['174']++;var rad=deg*(Math.PI/180);__cov__xLIe8a_nBv4uYmJp5qLog.s['175']++;return rad;},angle2rad:function(val){__cov__xLIe8a_nBv4uYmJp5qLog.f['32']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['176']++;if((__cov__xLIe8a_nBv4uYmJp5qLog.b['28'][0]++,typeof val==='string')&&(__cov__xLIe8a_nBv4uYmJp5qLog.b['28'][1]++,val.indexOf('rad')>-1)){__cov__xLIe8a_nBv4uYmJp5qLog.b['27'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['177']++;val=parseFloat(val);}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['27'][1]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['178']++;val=this.deg2rad(parseFloat(val));}__cov__xLIe8a_nBv4uYmJp5qLog.s['179']++;return val;},rotate:function(deg,x,y){__cov__xLIe8a_nBv4uYmJp5qLog.f['33']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['180']++;var rad=this.angle2rad(deg),sin=Math.sin(rad),cos=Math.cos(rad);__cov__xLIe8a_nBv4uYmJp5qLog.s['181']++;this.multiply(cos,sin,0-sin,cos,0,0);__cov__xLIe8a_nBv4uYmJp5qLog.s['182']++;return this;},translate:function(x,y){__cov__xLIe8a_nBv4uYmJp5qLog.f['34']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['183']++;x=(__cov__xLIe8a_nBv4uYmJp5qLog.b['29'][0]++,parseFloat(x))||(__cov__xLIe8a_nBv4uYmJp5qLog.b['29'][1]++,0);__cov__xLIe8a_nBv4uYmJp5qLog.s['184']++;y=(__cov__xLIe8a_nBv4uYmJp5qLog.b['30'][0]++,parseFloat(y))||(__cov__xLIe8a_nBv4uYmJp5qLog.b['30'][1]++,0);__cov__xLIe8a_nBv4uYmJp5qLog.s['185']++;this.multiply(1,0,0,1,x,y);__cov__xLIe8a_nBv4uYmJp5qLog.s['186']++;return this;},translateX:function(x){__cov__xLIe8a_nBv4uYmJp5qLog.f['35']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['187']++;this.translate(x);__cov__xLIe8a_nBv4uYmJp5qLog.s['188']++;return this;},translateY:function(y){__cov__xLIe8a_nBv4uYmJp5qLog.f['36']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['189']++;this.translate(null,y);__cov__xLIe8a_nBv4uYmJp5qLog.s['190']++;return this;},identity:function(){__cov__xLIe8a_nBv4uYmJp5qLog.f['37']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['191']++;var config=this._config,defaults=this._defaults,prop;__cov__xLIe8a_nBv4uYmJp5qLog.s['192']++;for(prop in config){__cov__xLIe8a_nBv4uYmJp5qLog.s['193']++;if(prop in defaults){__cov__xLIe8a_nBv4uYmJp5qLog.b['31'][0]++;__cov__xLIe8a_nBv4uYmJp5qLog.s['194']++;this[prop]=defaults[prop];}else{__cov__xLIe8a_nBv4uYmJp5qLog.b['31'][1]++;}}__cov__xLIe8a_nBv4uYmJp5qLog.s['195']++;return this;},getMatrixArray:function(){__cov__xLIe8a_nBv4uYmJp5qLog.f['38']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['196']++;var matrix=this,matrixArray=[[matrix.a,matrix.c,matrix.dx],[matrix.b,matrix.d,matrix.dy],[0,0,1]];__cov__xLIe8a_nBv4uYmJp5qLog.s['197']++;return matrixArray;},getContentRect:function(width,height,x,y){__cov__xLIe8a_nBv4uYmJp5qLog.f['39']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['198']++;var left=!isNaN(x)?(__cov__xLIe8a_nBv4uYmJp5qLog.b['32'][0]++,x):(__cov__xLIe8a_nBv4uYmJp5qLog.b['32'][1]++,0),top=!isNaN(y)?(__cov__xLIe8a_nBv4uYmJp5qLog.b['33'][0]++,y):(__cov__xLIe8a_nBv4uYmJp5qLog.b['33'][1]++,0),right=left+width,bottom=top+height,matrix=this,a=matrix.a,b=matrix.b,c=matrix.c,d=matrix.d,dx=matrix.dx,dy=matrix.dy,x1=a*left+c*top+dx,y1=b*left+d*top+dy,x2=a*right+c*top+dx,y2=b*right+d*top+dy,x3=a*left+c*bottom+dx,y3=b*left+d*bottom+dy,x4=a*right+c*bottom+dx,y4=b*right+d*bottom+dy;__cov__xLIe8a_nBv4uYmJp5qLog.s['199']++;return{left:Math.min(x3,Math.min(x1,Math.min(x2,x4))),right:Math.max(x3,Math.max(x1,Math.max(x2,x4))),top:Math.min(y2,Math.min(y4,Math.min(y3,y1))),bottom:Math.max(y2,Math.max(y4,Math.max(y3,y1)))};},getDeterminant:function(){__cov__xLIe8a_nBv4uYmJp5qLog.f['40']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['200']++;return Y.MatrixUtil.getDeterminant(this.getMatrixArray());},inverse:function(){__cov__xLIe8a_nBv4uYmJp5qLog.f['41']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['201']++;return Y.MatrixUtil.inverse(this.getMatrixArray());},transpose:function(){__cov__xLIe8a_nBv4uYmJp5qLog.f['42']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['202']++;return Y.MatrixUtil.transpose(this.getMatrixArray());},decompose:function(){__cov__xLIe8a_nBv4uYmJp5qLog.f['43']++;__cov__xLIe8a_nBv4uYmJp5qLog.s['203']++;return Y.MatrixUtil.decompose(this.getMatrixArray());}};__cov__xLIe8a_nBv4uYmJp5qLog.s['204']++;Y.Matrix=Matrix;},'patched-v3.19.1',{'requires':['yui-base']});
