if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/datatype-number-parse/datatype-number-parse.js']) {
   __coverage__['build/datatype-number-parse/datatype-number-parse.js'] = {"path":"build/datatype-number-parse/datatype-number-parse.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":33},"end":{"line":1,"column":52}}},"2":{"name":"(anonymous_2)","line":30,"loc":{"start":{"line":30,"column":27},"end":{"line":30,"column":73}}},"3":{"name":"(anonymous_3)","line":49,"loc":{"start":{"line":49,"column":15},"end":{"line":49,"column":30}}},"4":{"name":"(anonymous_4)","line":74,"loc":{"start":{"line":74,"column":11},"end":{"line":74,"column":34}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":104,"column":42}},"2":{"start":{"line":11,"column":0},"end":{"line":12,"column":20}},"3":{"start":{"line":14,"column":0},"end":{"line":96,"column":3}},"4":{"start":{"line":31,"column":8},"end":{"line":32,"column":18}},"5":{"start":{"line":34,"column":8},"end":{"line":36,"column":9}},"6":{"start":{"line":35,"column":12},"end":{"line":35,"column":65}},"7":{"start":{"line":37,"column":8},"end":{"line":39,"column":9}},"8":{"start":{"line":38,"column":12},"end":{"line":38,"column":65}},"9":{"start":{"line":40,"column":8},"end":{"line":42,"column":9}},"10":{"start":{"line":41,"column":12},"end":{"line":41,"column":56}},"11":{"start":{"line":44,"column":8},"end":{"line":44,"column":67}},"12":{"start":{"line":46,"column":8},"end":{"line":48,"column":9}},"13":{"start":{"line":47,"column":12},"end":{"line":47,"column":27}},"14":{"start":{"line":49,"column":8},"end":{"line":53,"column":10}},"15":{"start":{"line":50,"column":12},"end":{"line":50,"column":41}},"16":{"start":{"line":52,"column":12},"end":{"line":52,"column":61}},"17":{"start":{"line":75,"column":8},"end":{"line":75,"column":19}},"18":{"start":{"line":77,"column":8},"end":{"line":81,"column":9}},"19":{"start":{"line":78,"column":12},"end":{"line":78,"column":121}},"20":{"start":{"line":80,"column":12},"end":{"line":80,"column":32}},"21":{"start":{"line":83,"column":8},"end":{"line":85,"column":9}},"22":{"start":{"line":84,"column":12},"end":{"line":84,"column":25}},"23":{"start":{"line":88,"column":8},"end":{"line":90,"column":9}},"24":{"start":{"line":89,"column":12},"end":{"line":89,"column":24}},"25":{"start":{"line":94,"column":8},"end":{"line":94,"column":20}},"26":{"start":{"line":99,"column":0},"end":{"line":99,"column":47}},"27":{"start":{"line":100,"column":0},"end":{"line":100,"column":24}},"28":{"start":{"line":101,"column":0},"end":{"line":101,"column":29}}},"branchMap":{"1":{"line":34,"type":"if","locations":[{"start":{"line":34,"column":8},"end":{"line":34,"column":8}},{"start":{"line":34,"column":8},"end":{"line":34,"column":8}}]},"2":{"line":37,"type":"if","locations":[{"start":{"line":37,"column":8},"end":{"line":37,"column":8}},{"start":{"line":37,"column":8},"end":{"line":37,"column":8}}]},"3":{"line":40,"type":"if","locations":[{"start":{"line":40,"column":8},"end":{"line":40,"column":8}},{"start":{"line":40,"column":8},"end":{"line":40,"column":8}}]},"4":{"line":46,"type":"if","locations":[{"start":{"line":46,"column":8},"end":{"line":46,"column":8}},{"start":{"line":46,"column":8},"end":{"line":46,"column":8}}]},"5":{"line":52,"type":"cond-expr","locations":[{"start":{"line":52,"column":29},"end":{"line":52,"column":54}},{"start":{"line":52,"column":57},"end":{"line":52,"column":60}}]},"6":{"line":77,"type":"if","locations":[{"start":{"line":77,"column":8},"end":{"line":77,"column":8}},{"start":{"line":77,"column":8},"end":{"line":77,"column":8}}]},"7":{"line":77,"type":"binary-expr","locations":[{"start":{"line":77,"column":12},"end":{"line":77,"column":18}},{"start":{"line":77,"column":22},"end":{"line":77,"column":46}}]},"8":{"line":83,"type":"if","locations":[{"start":{"line":83,"column":8},"end":{"line":83,"column":8}},{"start":{"line":83,"column":8},"end":{"line":83,"column":8}}]},"9":{"line":83,"type":"binary-expr","locations":[{"start":{"line":83,"column":12},"end":{"line":83,"column":36}},{"start":{"line":83,"column":40},"end":{"line":83,"column":64}}]},"10":{"line":88,"type":"if","locations":[{"start":{"line":88,"column":8},"end":{"line":88,"column":8}},{"start":{"line":88,"column":8},"end":{"line":88,"column":8}}]},"11":{"line":88,"type":"binary-expr","locations":[{"start":{"line":88,"column":12},"end":{"line":88,"column":36}},{"start":{"line":88,"column":40},"end":{"line":88,"column":55}}]}},"code":["(function () { YUI.add('datatype-number-parse', function (Y, NAME) {","","/**"," * Parse number submodule."," *"," * @module datatype-number"," * @submodule datatype-number-parse"," * @for Number"," */","","var safe = Y.Escape.regex,","    SPACES = '\\\\s*';","","Y.mix(Y.namespace(\"Number\"), {","    /**","     * Returns a parsing function for the given configuration.","     * It uses `Y.cached` so it expects the format spec separated into","     * individual values.","     * The method further uses closure to put together and save the","     * regular expresssion just once in the outer function.","     *","     * @method _buildParser","     * @param [prefix] {String} Prefix string to be stripped out.","     * @param [suffix] {String} Suffix string to be stripped out.","     * @param [separator] {String} Thousands separator to be stripped out.","     * @param [decimal] {String} Decimal separator to be replaced by a dot.","     * @return {Function} Parsing function.","     * @private","     */","    _buildParser: Y.cached(function (prefix, suffix, separator, decimal) {","        var regexBits = [],","            regex;","","        if (prefix) {","            regexBits.push('^' + SPACES + safe(prefix) + SPACES);","        }","        if (suffix) {","            regexBits.push(SPACES + safe(suffix) + SPACES + '$');","        }","        if (separator) {","            regexBits.push(safe(separator) + '(?=\\\\d)');","        }","","        regex = new RegExp('(?:' + regexBits.join('|') + ')', 'g');","","        if (decimal === '.') {","            decimal = null;","        }","        return function (val) {","            val = val.replace(regex, '');","","            return decimal ? val.replace(decimal, '.') : val;","        };","    }),","    /**","     * Converts data to type Number.","     * If a `config` argument is used, it will strip the `data` of the prefix,","     * the suffix and the thousands separator, if any of them are found,","     * replace the decimal separator by a dot and parse the resulting string.","     * Extra whitespace around the prefix and suffix will be ignored.","     *","     * @method parse","     * @param data {String | Number | Boolean} Data to convert. The following","     * values return as null: null, undefined, NaN, \"\".","     * @param [config] {Object} Optional configuration values, same as for [Y.Date.format](#method_format).","     * @param [config.prefix] {String} String to be removed from the start, like a currency designator \"$\"","     * @param [config.decimalPlaces] {Number} Ignored, it is accepted only for compatibility with [Y.Date.format](#method_format).","     * @param [config.decimalSeparator] {String} Decimal separator.","     * @param [config.thousandsSeparator] {String} Thousands separator.","     * @param [config.suffix] {String} String to be removed from the end of the number, like \" items\".","     * @return {Number} A number, or null.","     */","","    parse: function(data, config) {","        var parser;","","        if (config && typeof data === 'string') {","            parser = this._buildParser(config.prefix, config.suffix, config.thousandsSeparator, config.decimalSeparator);","","            data = parser(data);","        }","","        if (typeof data === 'string' && Y.Lang.trim(data) !== '') {","            data = +data;","        }","","        // catch NaN and ±Infinity","        if (typeof data !== 'number' || !isFinite(data)) {","            data = null;","        }","","        // on the same line to get stripped for raw/min.js by build system","","        return data;","    }","});","","// Add Parsers shortcut","Y.namespace(\"Parsers\").number = Y.Number.parse;","Y.namespace(\"DataType\");","Y.DataType.Number = Y.Number;","","","}, 'patched-v3.19.1', {\"requires\": [\"escape\"]});","","}());"]};
}
var __cov_vDl8Yyxj8O_PBviOOEdjQQ = __coverage__['build/datatype-number-parse/datatype-number-parse.js'];
__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['1']++;YUI.add('datatype-number-parse',function(Y,NAME){__cov_vDl8Yyxj8O_PBviOOEdjQQ.f['1']++;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['2']++;var safe=Y.Escape.regex,SPACES='\\s*';__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['3']++;Y.mix(Y.namespace('Number'),{_buildParser:Y.cached(function(prefix,suffix,separator,decimal){__cov_vDl8Yyxj8O_PBviOOEdjQQ.f['2']++;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['4']++;var regexBits=[],regex;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['5']++;if(prefix){__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['1'][0]++;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['6']++;regexBits.push('^'+SPACES+safe(prefix)+SPACES);}else{__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['1'][1]++;}__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['7']++;if(suffix){__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['2'][0]++;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['8']++;regexBits.push(SPACES+safe(suffix)+SPACES+'$');}else{__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['2'][1]++;}__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['9']++;if(separator){__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['3'][0]++;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['10']++;regexBits.push(safe(separator)+'(?=\\d)');}else{__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['3'][1]++;}__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['11']++;regex=new RegExp('(?:'+regexBits.join('|')+')','g');__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['12']++;if(decimal==='.'){__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['4'][0]++;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['13']++;decimal=null;}else{__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['4'][1]++;}__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['14']++;return function(val){__cov_vDl8Yyxj8O_PBviOOEdjQQ.f['3']++;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['15']++;val=val.replace(regex,'');__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['16']++;return decimal?(__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['5'][0]++,val.replace(decimal,'.')):(__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['5'][1]++,val);};}),parse:function(data,config){__cov_vDl8Yyxj8O_PBviOOEdjQQ.f['4']++;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['17']++;var parser;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['18']++;if((__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['7'][0]++,config)&&(__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['7'][1]++,typeof data==='string')){__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['6'][0]++;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['19']++;parser=this._buildParser(config.prefix,config.suffix,config.thousandsSeparator,config.decimalSeparator);__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['20']++;data=parser(data);}else{__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['6'][1]++;}__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['21']++;if((__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['9'][0]++,typeof data==='string')&&(__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['9'][1]++,Y.Lang.trim(data)!=='')){__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['8'][0]++;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['22']++;data=+data;}else{__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['8'][1]++;}__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['23']++;if((__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['11'][0]++,typeof data!=='number')||(__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['11'][1]++,!isFinite(data))){__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['10'][0]++;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['24']++;data=null;}else{__cov_vDl8Yyxj8O_PBviOOEdjQQ.b['10'][1]++;}__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['25']++;return data;}});__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['26']++;Y.namespace('Parsers').number=Y.Number.parse;__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['27']++;Y.namespace('DataType');__cov_vDl8Yyxj8O_PBviOOEdjQQ.s['28']++;Y.DataType.Number=Y.Number;},'patched-v3.19.1',{'requires':['escape']});
