/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal.cxf;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.jax.rs.whiteboard.ApplicationClasses;
import org.apache.aries.jax.rs.whiteboard.internal.AriesJaxrsServiceRuntime;
import org.apache.aries.jax.rs.whiteboard.internal.ServiceReferenceRegistry;
import org.apache.aries.jax.rs.whiteboard.internal.Whiteboard;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.ComparableResourceComparator;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.PromiseAwareJAXRSInvoker;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.PrototypeServiceReferenceResourceProvider;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.ServiceReferenceFilterProviderInfo;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.ServiceReferenceProviderInfoComparator;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.ServiceReferenceResourceProvider;
import org.apache.aries.jax.rs.whiteboard.internal.introspection.Proxies;
import org.apache.aries.jax.rs.whiteboard.internal.utils.ServiceTuple;
import org.apache.aries.jax.rs.whiteboard.internal.utils.Utils;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.ext.ResourceContextProvider;
import org.apache.cxf.jaxrs.impl.ConfigurableImpl;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.provider.ServerConfigurableFactory;
import org.apache.cxf.jaxrs.sse.SseContextProvider;
import org.apache.cxf.jaxrs.sse.SseEventSinkContextProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.invoker.Invoker;

public class CxfJaxrsServiceRegistrator {
    private ArrayList<ServiceTuple<?>> _erroredProviders;
    private ArrayList<ResourceProvider> _erroredServices;
    private final ServiceTuple<Application> _applicationTuple;
    private final Bus _bus;
    private final Collection<ServiceTuple<?>> _providers;
    private final Collection<ResourceProvider> _services = new ArrayList<ResourceProvider>();
    private volatile boolean _enabled = false;
    private JAXRSServerFactoryBean _jaxRsServerFactoryBean;
    private Map<String, Object> _properties;
    private AriesJaxrsServiceRuntime _ariesJaxrsServiceRuntime;
    private ServiceReferenceRegistry _serviceReferenceRegistry;
    private Server _server;

    public Map<String, ?> getProperties() {
        return this._properties;
    }

    public CxfJaxrsServiceRegistrator(Bus bus, ServiceTuple<Application> applicationTuple, Map<String, ?> properties, AriesJaxrsServiceRuntime ariesJaxrsServiceRuntime) {
        this._bus = bus;
        this._applicationTuple = applicationTuple;
        this._properties = Collections.unmodifiableMap(new HashMap(properties));
        this._ariesJaxrsServiceRuntime = ariesJaxrsServiceRuntime;
        Comparator<ServiceTuple> comparing = Comparator.comparing(ServiceTuple::getCachingServiceReference);
        this._providers = new TreeSet<ServiceTuple>(comparing);
        this._erroredProviders = new ArrayList();
        this._erroredServices = new ArrayList();
        this._serviceReferenceRegistry = new ServiceReferenceRegistry();
    }

    public synchronized void add(ResourceProvider resourceProvider) {
        this._services.add(resourceProvider);
        try {
            this.rewire();
        }
        catch (Exception e) {
            this.remove(resourceProvider);
            throw e;
        }
    }

    public synchronized void addProvider(ServiceTuple<?> tuple) {
        this._providers.add(tuple);
        try {
            this.rewire();
        }
        catch (Exception e) {
            this.removeProvider(tuple);
            throw e;
        }
    }

    public void enable() {
        this._enabled = true;
        try {
            this.rewire();
        }
        catch (Exception e) {
            ArrayList providers = new ArrayList();
            ArrayList<ResourceProvider> services = new ArrayList<ResourceProvider>();
            for (ServiceTuple<?> provider : this._providers) {
                providers.add(provider);
                try {
                    this.doRewire(providers, services);
                }
                catch (Exception ex) {
                    providers.remove(provider);
                    this._erroredProviders.add(provider);
                }
            }
            for (ResourceProvider service : this._services) {
                services.add(service);
                try {
                    this.doRewire(providers, services);
                }
                catch (Exception ex) {
                    services.remove(service);
                    this._erroredServices.add(service);
                }
            }
            this._enabled = false;
            for (ServiceTuple<?> erroredProvider : this._erroredProviders) {
                CachingServiceReference<?> cachingServiceReference = erroredProvider.getCachingServiceReference();
                this._providers.remove(erroredProvider);
                this._ariesJaxrsServiceRuntime.addErroredExtension(cachingServiceReference);
                this._serviceReferenceRegistry.unregister(cachingServiceReference);
            }
            for (ResourceProvider erroredService : this._erroredServices) {
                this._services.remove(erroredService);
                this._ariesJaxrsServiceRuntime.addErroredEndpoint(((ServiceReferenceResourceProvider)erroredService).getImmutableServiceReference());
            }
            this._enabled = true;
            this.rewire();
        }
    }

    public void close() {
        if (!this._enabled) {
            return;
        }
        this._enabled = false;
        if (this._server != null) {
            this._server.destroy();
        }
        if (this._bus != null) {
            this._bus.shutdown(false);
        }
    }

    public <T> T createEndpoint(Application app, Class<T> endpointType) {
        JAXRSServerFactoryBean bean = new JAXRSServerFactoryBean();
        Set singletons = app.getSingletons();
        if (!singletons.isEmpty() && singletons.stream().map(Object::getClass).count() < (long)singletons.size()) {
            throw new IllegalArgumentException("More than one instance of the same singleton class is available: " + singletons);
        }
        ArrayList resourceClasses = new ArrayList();
        ArrayList<Object> providers = new ArrayList<Object>();
        ArrayList<Feature> features = new ArrayList<Feature>();
        HashMap map = new HashMap();
        for (Class cls : app.getClasses()) {
            if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers())) continue;
            if (this.isProvider(cls)) {
                providers.add(ResourceUtils.createProviderInstance((Class)cls));
                continue;
            }
            if (Feature.class.isAssignableFrom(cls)) {
                features.add(ResourceUtils.createFeatureInstance(cls.asSubclass(Feature.class)));
                continue;
            }
            resourceClasses.add(cls);
            map.put(cls, new PerRequestResourceProvider(cls));
        }
        for (Object o : singletons) {
            if (this.isProvider(o.getClass())) {
                providers.add(o);
                continue;
            }
            if (o instanceof Feature) {
                features.add((Feature)o);
                continue;
            }
            Class<?> clazz = Proxies.unwrap(o.getClass());
            resourceClasses.add(clazz);
            map.put(clazz, new SingletonResourceProvider(o));
        }
        String address = "/";
        bean.setAddress(address);
        bean.setStaticSubresourceResolution(false);
        bean.setResourceClasses(resourceClasses);
        bean.setProviders(providers);
        bean.getFeatures().addAll(features);
        for (Map.Entry entry : map.entrySet()) {
            bean.setResourceProvider((Class)entry.getKey(), (ResourceProvider)entry.getValue());
        }
        Map appProps = app.getProperties();
        if (appProps != null) {
            bean.getProperties(true).putAll(appProps);
        }
        bean.setApplication(app);
        if (this._bus != null) {
            bean.setBus(this._bus);
        }
        if (JAXRSServerFactoryBean.class.isAssignableFrom(endpointType)) {
            return endpointType.cast(bean);
        }
        bean.setApplication(app);
        bean.setStart(false);
        Server server = bean.create();
        return endpointType.cast(server);
    }

    private boolean isProvider(Class<?> cls) {
        return cls.isAnnotationPresent(Provider.class) || Whiteboard.SUPPORTED_EXTENSION_INTERFACES.values().stream().anyMatch(it -> it.isAssignableFrom(cls));
    }

    public Bus getBus() {
        return this._bus;
    }

    public Iterable<Class<?>> getStaticResourceClasses() {
        if (this._jaxRsServerFactoryBean == null) {
            return Collections.emptyList();
        }
        JAXRSServiceFactoryBean serviceFactory = this._jaxRsServerFactoryBean.getServiceFactory();
        List classResourceInfo = serviceFactory.getClassResourceInfo();
        ArrayList classes = new ArrayList();
        for (ClassResourceInfo resourceInfo : classResourceInfo) {
            ResourceProvider resourceProvider;
            if (resourceInfo == null || (resourceProvider = resourceInfo.getResourceProvider()) != null && ServiceReferenceResourceProvider.class.isAssignableFrom(resourceProvider.getClass())) continue;
            classes.add(resourceInfo.getResourceClass());
        }
        return classes;
    }

    public void registerExtension(CachingServiceReference<?> serviceReference) {
        this._serviceReferenceRegistry.register(serviceReference);
    }

    public synchronized void remove(ResourceProvider resourceProvider) {
        if (this._erroredServices.remove(resourceProvider)) {
            this._ariesJaxrsServiceRuntime.removeErroredEndpoint(((ServiceReferenceResourceProvider)resourceProvider).getImmutableServiceReference());
        }
        this._services.remove(resourceProvider);
        this.rewire();
    }

    public synchronized void removeProvider(ServiceTuple<?> tuple) {
        if (this._erroredProviders.remove(tuple)) {
            this._ariesJaxrsServiceRuntime.removeErroredExtension(tuple.getCachingServiceReference());
        }
        this._providers.remove(tuple);
        this.rewire();
    }

    public synchronized void rewire() {
        this.doRewire(this._providers, this._services);
    }

    public void unregisterExtension(CachingServiceReference<?> serviceReference) {
        this._serviceReferenceRegistry.unregister(serviceReference);
    }

    public OSGi<CachingServiceReference<?>> waitForExtension(String extensionDependency) {
        return this._serviceReferenceRegistry.waitFor(extensionDependency);
    }

    private synchronized void doRewire(Collection<ServiceTuple<?>> providers, Collection<ResourceProvider> services) {
        Application application;
        if (!this._enabled) {
            return;
        }
        if (!this._applicationTuple.isAvailable()) {
            this._applicationTuple.dispose();
            return;
        }
        if (this._server != null) {
            this._server.destroy();
            this._applicationTuple.refresh();
            for (ServiceTuple<?> provider : providers) {
                provider.refresh();
            }
        }
        if ((application = this._applicationTuple.getService()) == null) {
            return;
        }
        if (this._services.isEmpty() && application.getSingletons().isEmpty() && application.getClasses().isEmpty()) {
            return;
        }
        this._jaxRsServerFactoryBean = this.createEndpoint(application, JAXRSServerFactoryBean.class);
        this._jaxRsServerFactoryBean.setInvoker((Invoker)new PromiseAwareJAXRSInvoker());
        this._jaxRsServerFactoryBean.setBus(this._bus);
        this._bus.setExtension(context -> {
            ConfigurableImpl configurable = new ConfigurableImpl((Configurable)context, RuntimeType.SERVER);
            configurable.property("osgi.jaxrs.application.serviceProperties", this._properties);
            return configurable;
        }, ServerConfigurableFactory.class);
        this._jaxRsServerFactoryBean.setStart(false);
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (ServiceTuple<?> provider : providers) {
            Object service;
            CachingServiceReference<?> cachingServiceReference = provider.getCachingServiceReference();
            if (!provider.isAvailable() || (service = provider.getService()) == null) continue;
            if (service instanceof jakarta.ws.rs.core.Feature || service instanceof DynamicFeature) {
                this._jaxRsServerFactoryBean.setProvider(service);
                continue;
            }
            if (service instanceof Feature) {
                features.add((Feature)service);
                continue;
            }
            Class realClass = ClassHelper.getRealClass((Bus)this.getBus(), service);
            Class[] interfaces = (Class[])Arrays.stream(Utils.canonicalize(cachingServiceReference.getProperty("objectClass"))).filter(Whiteboard.SUPPORTED_EXTENSION_INTERFACES::containsKey).map(Whiteboard.SUPPORTED_EXTENSION_INTERFACES::get).toArray(Class[]::new);
            Map<Class<?>, Integer> classesWithPriorities = Arrays.stream(interfaces).collect(Collectors.toMap(c -> c, __ -> AnnotationUtils.getBindingPriority((Class)realClass)));
            this._jaxRsServerFactoryBean.setProvider(new ServiceReferenceFilterProviderInfo(cachingServiceReference, realClass, realClass, service, this.getBus(), CxfJaxrsServiceRegistrator.getFilterNameBindings(this.getBus(), service), false, classesWithPriorities));
        }
        this._jaxRsServerFactoryBean.setProvider((Object)new SseEventSinkContextProvider());
        this._jaxRsServerFactoryBean.setProvider((Object)new SseContextProvider());
        this._jaxRsServerFactoryBean.setProvider((Object)new ContextProvider<ApplicationClasses>(){

            public ApplicationClasses createContext(Message message) {
                return () -> Stream.concat(StreamSupport.stream(CxfJaxrsServiceRegistrator.this.getStaticResourceClasses().spliterator(), false), CxfJaxrsServiceRegistrator.this._services.stream().map(ResourceProvider::getResourceClass)).collect(Collectors.toSet());
            }
        });
        if (!features.isEmpty()) {
            features.addAll(this._jaxRsServerFactoryBean.getFeatures());
            this._jaxRsServerFactoryBean.setFeatures(features);
        }
        for (ResourceProvider resourceProvider : services) {
            PrototypeServiceReferenceResourceProvider provider;
            if (resourceProvider instanceof PrototypeServiceReferenceResourceProvider && !(provider = (PrototypeServiceReferenceResourceProvider)resourceProvider).isAvailable()) continue;
            this._jaxRsServerFactoryBean.setResourceProvider(resourceProvider);
        }
        if (this._jaxRsServerFactoryBean.getResourceClasses().isEmpty()) {
            return;
        }
        ComparableResourceComparator comparableResourceComparator = new ComparableResourceComparator();
        this._jaxRsServerFactoryBean.setResourceComparator((ResourceComparator)comparableResourceComparator);
        ProviderFactory.ProviderInfoClassComparator providerInfoClassComparator = new ProviderFactory.ProviderInfoClassComparator(Object.class);
        this._jaxRsServerFactoryBean.setProviderComparator((Comparator)new ServiceReferenceProviderInfoComparator(providerInfoClassComparator));
        this._server = this._jaxRsServerFactoryBean.create();
        Endpoint endpoint = this._server.getEndpoint();
        ApplicationInfo applicationInfo = (ApplicationInfo)endpoint.get((Object)Application.class.getName());
        applicationInfo.setOverridingProps((Map)new HashMap<String, Object>(){
            {
                this.put("osgi.jaxrs.application.serviceProperties", CxfJaxrsServiceRegistrator.this._properties);
            }
        });
        endpoint.put((Object)"org.apache.cxf.jaxrs.resource.context.provider", (Object)this.createResourceContextProvider(this._jaxRsServerFactoryBean.getServiceFactory()));
        this._server.start();
    }

    private ResourceContextProvider createResourceContextProvider(JAXRSServiceFactoryBean jaxrsServiceFactoryBean) {
        ComparableResourceComparator comparableResourceComparator = new ComparableResourceComparator();
        List classResourceInfos = jaxrsServiceFactoryBean.getClassResourceInfo().stream().sorted((cri1, cri2) -> comparableResourceComparator.compare((ClassResourceInfo)cri1, (ClassResourceInfo)cri2, null)).collect(Collectors.toList());
        HashMap<Class, ResourceProvider> map = new HashMap<Class, ResourceProvider>();
        for (ClassResourceInfo classResourceInfo : classResourceInfos) {
            map.put(classResourceInfo.getResourceClass(), classResourceInfo.getResourceProvider());
        }
        return map::get;
    }

    private static Set<String> getFilterNameBindings(Bus bus, Object provider) {
        Class pClass = ClassHelper.getRealClass((Bus)bus, (Object)provider);
        Set<String> names = AnnotationUtils.getNameBindings((Annotation[])pClass.getAnnotations());
        if (names.isEmpty()) {
            names = Collections.singleton("org.apache.cxf.filter.binding");
        }
        return names;
    }
}

